/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.IsguiUtility;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.gui.client.KeyboardBuffer;
import com.iscobol.gui.client.LocalFontCmp;
import com.iscobol.gui.client.LocalImage;
import com.iscobol.preview.Preview;
import com.iscobol.preview.PreviewDialog;
import com.iscobol.preview.PreviewDialogSettings;
import com.iscobol.rts.File;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.AttrTable;
import com.iscobol.rts.print.AutoHeaderFooter;
import com.iscobol.rts.print.CustomMediaSizeName;
import com.iscobol.rts.print.DrawGraph;
import com.iscobol.rts.print.PDF;
import com.iscobol.rts.print.Page;
import com.iscobol.rts.print.PrintAt;
import com.iscobol.rts.print.PrintBitmap;
import com.iscobol.rts.print.PrintBytes;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.rts.print.PrintNewLine;
import com.iscobol.rts.print.PrintString;
import com.iscobol.rts.print.RemotePrintCommand;
import com.iscobol.rts.print.SetBackground;
import com.iscobol.rts.print.SetBoxShade;
import com.iscobol.rts.print.SetColor;
import com.iscobol.rts.print.SetCursor;
import com.iscobol.rts.print.SetDataColumns;
import com.iscobol.rts.print.SetFont;
import com.iscobol.rts.print.SetGraphBrush;
import com.iscobol.rts.print.SetGraphPen;
import com.iscobol.rts.print.SetLinesPerPage;
import com.iscobol.rts.print.SetNewPage;
import com.iscobol.rts.print.SetPageColumns;
import com.iscobol.types.CobolVar;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.font.TransformAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.PrintRequestAttribute;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.Size2DSyntax;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterURI;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.swing.ImageIcon;

public class SpoolPrinter
extends OutputStream
implements RuntimeErrorsNumbers,
Printable {
    public static final float FONT_DEFAULT_HEIGHT = 12.0f;
    public static final float FONT_DEFAULT_ADVANCE = 7.0f;
    public static final int MU_DEFAULT = 0;
    public static final int MU_CELLS = 1;
    public static final int MU_INCHES = 2;
    public static final int MU_CENTIMETERS = 3;
    public static final int MU_PIXELS = 4;
    public static final int MU_CELLS_ABS = 5;
    public static final int MU_INCHES_ABS = 6;
    public static final int MU_CENTIMETERS_ABS = 7;
    public static final float MARGIN_TOP_DEF_CM = 0.0f;
    public static final float MARGIN_BOTTOM_DEF_CM = 0.0f;
    public static final float MARGIN_LEFT_DEF_CM = 0.0f;
    public static final float MARGIN_RIGHT_DEF_CM = 0.0f;
    public static final float MARGIN_CMxINCH = 2.54f;
    public static final float DOTxINCH = 72.0f;
    public static final float DOTxCM = 28.346457f;
    public static final int OR_DEFAULT = 0;
    public static final int OR_PORTRAIT = 1;
    public static final int OR_LANDSCAPE = 2;
    public static final int OR_REVERSE_PORTRAIT = 3;
    public static final int OR_REVERSE_LANDSCAPE = 4;
    public static final int QU_UNKNOWN = 0;
    public static final int QU_HIGH = -1;
    public static final int QU_MEDIUM = -2;
    public static final int QU_LOW = -3;
    public static final int QU_DRAFT = -4;
    public static final int CO_UNKNOWN = -1;
    public static final int CO_MONOCHROME = 0;
    public static final int CO_COLOR = 1;
    public static final int CL_UNCOLLATED = 0;
    public static final int CL_COLLATED = 1;
    public static final int CAPSIDX_HOR_SIZE = 0;
    public static final int CAPSIDX_VER_SIZE = 1;
    public static final int CAPSIDX_HOR_OFFS = 2;
    public static final int CAPSIDX_VER_OFFS = 3;
    public static final int CAPSIDX_HOR_RES_DPI = 4;
    public static final int CAPSIDX_VER_RES_DPI = 5;
    public static final int CAPSIDX_CURR_UNITS = 6;
    public static final int CAPSIDX_MY_SIZE = 7;
    public static final int DUPLEX_UNSET = 0;
    public static final int DUPLEX_SIMPLEX = 1;
    public static final int DUPLEX_VERTICAL = 2;
    public static final int DUPLEX_HORIZONTAL = 3;
    static final char eolCh = '\n';
    static final char eopCh = '\f';
    static final String searchpreviewname = "print-preview";
    private static final String DUMMY_PRINT_CANCELED = "$Dummy print canceled$";
    private static final Class win32mt;
    private static final int javaMajorVersion;
    private static final MediaTray[] mediaTrays;
    private static final MediaSizeName[] mediaSizes;
    private static Setting staticSetting;
    private static PreviewDialogSettings prDialogSettings;
    private static final String jobName = "Iscobol job";
    private static StreamPrintServiceFactory sps;
    private final byte defaultTxtAlign = (byte)2;
    protected Events events;
    protected Setting setting;
    private MediaSize customPdfMediaSize;
    private boolean rmCompat;
    private byte nextTxtAlign = (byte)2;
    private double leftMargin;
    private double topMargin;
    private double rightMargin;
    private double bottomMargin;
    private boolean preview;
    private boolean direct;
    private boolean pdf;
    private boolean binary;
    private String fileName;
    private boolean openFileChooser;
    private java.io.File tmpFile;
    private Writer out;
    private OutputStream binOut;
    private PrintCommandList allCommands;
    private Vector pages;
    private String[] header;
    private String[] footer;
    private Font headerFooterFont;
    private AutoHeaderFooter aHeadFoot;
    private String reportName;
    PrintRequestAttributeSet aset = new HashPrintRequestAttributeSet();
    private PrintRequestAttributeSet asetSave;
    PrintService[] services;
    private Font currFont;
    AttrTable genericAttrs = new AttrTable();
    private int numLines = -1;
    private boolean printed;
    private boolean jobCancelled;
    protected AbstractGuiFactoryImpl gf;
    Vector<RemotePrintCommand> notYetExecutedCommands = new Vector();

    public static void main(String[] stringArray) {
        System.out.println(mediaSizes[70]);
        System.out.println(mediaTrays[13]);
    }

    private static MediaTray getWinMediaTray(String string) {
        if (win32mt != null) {
            try {
                Field field = win32mt.getDeclaredField(string);
                field.setAccessible(true);
                return (MediaTray)field.get(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public static SpoolPrinter get(GuiFactory guiFactory) {
        if (staticSetting == null) {
            staticSetting = new Setting();
        }
        SpoolPrinter spoolPrinter = new SpoolPrinter(guiFactory, staticSetting.copy());
        spoolPrinter.init();
        if (prDialogSettings.getTitle() == null) {
            SpoolPrinter.setDialogTitle(((AbstractGuiFactoryImpl)guiFactory).getCsProperty().get("iscobol.print.preview.title", null));
        }
        if (prDialogSettings.getIconImage() == null) {
            AbstractGuiFactoryImpl abstractGuiFactoryImpl = (AbstractGuiFactoryImpl)guiFactory;
            LocalImage localImage = abstractGuiFactoryImpl.getPrintPreviewIconImage();
            if (localImage != null && localImage.getImage() != null) {
                prDialogSettings.setIconImage(localImage.getImage());
            } else if (abstractGuiFactoryImpl.getIcon() != null) {
                prDialogSettings.setIconImage(abstractGuiFactoryImpl.getIcon());
            } else {
                prDialogSettings.setIconImage(null);
            }
        }
        return spoolPrinter;
    }

    public static SpoolPrinter get(GuiFactory guiFactory, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) {
        return SpoolPrinter.get(guiFactory, bl, bl2, bl3, string, bl4, null);
    }

    public static SpoolPrinter get(GuiFactory guiFactory, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, Events events) {
        SpoolPrinter spoolPrinter = SpoolPrinter.get(guiFactory);
        if ("PRINTER?".equalsIgnoreCase(string)) {
            spoolPrinter.rmCompat = true;
        }
        spoolPrinter.events = events;
        spoolPrinter.setAttrs(bl, bl2, bl3, string, bl4);
        return spoolPrinter;
    }

    protected SpoolPrinter(GuiFactory guiFactory) {
        this(guiFactory, null);
    }

    private SpoolPrinter(GuiFactory guiFactory, Setting setting) {
        this.gf = (AbstractGuiFactoryImpl)guiFactory;
        this.setDefaultFont();
        this.allCommands = new PrintCommandList(guiFactory);
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
        if (setting != null) {
            this.setting = setting;
        } else {
            setting = (Setting)IscobolSystem.get(Setting.class);
            if (setting == null) {
                this.setting = new Setting();
                IscobolSystem.set(Setting.class, this.setting);
            } else {
                this.setting = setting;
            }
        }
    }

    private void setDefaultFont() {
        String string;
        if (this.gf != null && (string = this.gf.getCsProperty().get("iscobol.print.default_font", null)) != null) {
            Object[] objectArray = IsguiUtility.parseFontString(string);
            this.currFont = new Font((String)objectArray[0], (int)((Integer)objectArray[1]), 12).deriveFont(((Float)objectArray[2]).floatValue());
        } else {
            this.currFont = Font.decode(null);
        }
    }

    public AbstractGuiFactoryImpl getGuiFactory() {
        return this.gf;
    }

    public void setAttrs(SpoolPrinter spoolPrinter) {
        this.notYetExecutedCommands.addAll(spoolPrinter.notYetExecutedCommands);
        this.setting = spoolPrinter.setting.copy();
        this.nextTxtAlign = spoolPrinter.nextTxtAlign;
        this.leftMargin = spoolPrinter.leftMargin;
        this.rightMargin = spoolPrinter.rightMargin;
        this.topMargin = spoolPrinter.topMargin;
        this.bottomMargin = spoolPrinter.bottomMargin;
        this.currFont = spoolPrinter.currFont;
        this.customPdfMediaSize = spoolPrinter.customPdfMediaSize;
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
        this.aset = new HashPrintRequestAttributeSet(spoolPrinter.aset);
        this.genericAttrs = new AttrTable(spoolPrinter.genericAttrs);
        this.numLines = spoolPrinter.numLines;
        if (this.numLines >= 0) {
            this.addCommand(new SetLinesPerPage((GuiFactory)this.gf, this.numLines));
        }
    }

    protected void setAttrs(boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) {
        this.preview = bl;
        this.direct = bl2;
        this.pdf = bl3;
        this.binary = bl4;
        this.setFileName(string);
    }

    private void setFileName(String string) {
        if (string == null || string.length() == 0) {
            this.openFileChooser = false;
            this.fileName = "iscobolPrint.pdf";
        } else if (string.charAt(0) == '@') {
            this.openFileChooser = true;
            this.fileName = string.substring(1).trim();
        } else {
            this.openFileChooser = false;
            this.fileName = string;
        }
    }

    public void reset() {
        this.aset = new HashPrintRequestAttributeSet();
        this.setting.currOrientation = OrientationRequested.PORTRAIT;
        this.setting.currMediaSizeName = SpoolPrinter.getDefaultLocaleMediaSizeName();
        this.setting.currQuality = null;
        this.setting.currentPrinter = null;
        this.customPdfMediaSize = null;
        this.init();
    }

    protected void init() {
        this.aset.add(this.setting.currOrientation);
        this.aset.add(new Copies(1));
        this.aset.add(new JobName(jobName, null));
        if (this.setting.currMediaSizeName != null) {
            this.aset.add(this.setting.currMediaSizeName);
        }
        this.setMargins(0.0, 0.0, 0.0, 0.0, 3);
        if (this.setting.currQuality != null) {
            this.aset.add(this.setting.currQuality);
        }
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        this.setting.currentPrinter = null;
        this.setGraphPen(0, 1.0, null);
    }

    protected PrintService getDefaultPrinter() {
        PrintService printService = SpoolPrinter.lookupDefaultPrintService();
        if (printService == null && this.services != null && this.services.length > 0) {
            printService = this.services[0];
        }
        return printService;
    }

    public void updatePrinters() {
        this.services = PrintServiceLookup.lookupPrintServices(null, null);
        if (this.setting.currentPrinter != null) {
            int n2;
            for (n2 = 0; n2 < this.services.length && this.setting.currentPrinter != this.services[n2]; ++n2) {
            }
            if (n2 == this.services.length) {
                this.setting.currentPrinter = null;
            }
        }
    }

    static PrintService lookupDefaultPrintService() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        try {
            printerJob.setPrintable(null);
            return printerJob.getPrintService();
        }
        catch (Exception exception) {
            return PrintServiceLookup.lookupDefaultPrintService();
        }
    }

    private void fakePrint(PrinterJob printerJob, Printable printable) {
        PrintService printService;
        if (sps == null) {
            StreamPrintServiceFactory[] streamPrintServiceFactoryArray = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(DocFlavor.SERVICE_FORMATTED.PAGEABLE, "application/postscript");
            if (streamPrintServiceFactoryArray != null && streamPrintServiceFactoryArray.length > 0) {
                sps = streamPrintServiceFactoryArray[0];
                printService = sps.getPrintService(new ByteArrayOutputStream());
            } else {
                printService = this.getCurrPrintService();
            }
        } else {
            printService = sps.getPrintService(new ByteArrayOutputStream());
        }
        printerJob.setPrintable(printable);
        try {
            SpoolPrinter.setPrintService(printerJob, printService);
            printerJob.print(this.aset);
        }
        catch (PrinterException printerException) {
            if (printerException.getMessage().indexOf(DUMMY_PRINT_CANCELED) < 0) {
                printerException.printStackTrace();
            }
        }
        catch (RuntimeException runtimeException) {
            Throwable throwable = runtimeException.getCause();
            if (throwable instanceof PrinterException) {
                if (throwable.getMessage().indexOf(DUMMY_PRINT_CANCELED) < 0) {
                    throwable.printStackTrace();
                }
            }
            throw runtimeException;
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.printAndClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IOException printAndClose() {
        IOException iOException = null;
        this.numLines = -1;
        if (this.direct) {
            this.closeDirect();
        } else {
            try {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                printerJob.setPrintable(this);
                Preview preview = null;
                if (!(this.jobCancelled || this.preview && !(preview = this.printPreview()).isDoPrint())) {
                    if (this.pdf) {
                        this.printPDF();
                    } else if (preview != null && preview.isDoPdf()) {
                        this.printPDF(preview.getFilename());
                    } else {
                        PrintService printService = this.getCurrPrintService();
                        if (printService != null) {
                            SpoolPrinter.setPrintService(printerJob, printService);
                            printerJob.print(this.aset);
                        }
                    }
                }
            }
            catch (PrinterException printerException) {
                iOException = new IOException("" + printerException);
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
            finally {
                this.printed = true;
                this.pages = null;
                this.allCommands.finalize();
                this.allCommands = new PrintCommandList(this.gf);
            }
            this.restorePrintRequestAttributeSet();
        }
        return iOException;
    }

    private static void setPrintService(PrinterJob printerJob, PrintService printService) {
        try {
            printerJob.setPrintService(printService);
        }
        catch (PrinterException printerException) {
            // empty catch block
        }
    }

    protected void addCommand(PrintCommand printCommand) {
        this.allCommands.addItem(printCommand);
    }

    private void newLine() {
        this.addCommand(new PrintNewLine(this.gf));
    }

    public void newPage() {
        this.addCommand(new SetNewPage(this.gf));
    }

    public void textOut(byte[] byArray, int n2, int n3) {
        if (this.direct) {
            this.writeDirect(byArray);
        } else {
            this.addCommand(new PrintBytes(this.gf, byArray, n2, n3, this.rmCompat ? (byte)this.nextTxtAlign : (byte)2));
            this.nextTxtAlign = (byte)2;
        }
    }

    public void printAt(String string, float f2, float f3, float f4, boolean bl, char c2, byte by, boolean bl2) {
        if (this.direct) {
            this.writeDirect(string.toCharArray());
        } else {
            this.addCommand(new PrintAt(this.gf, string, f2, f3, f4, bl, c2, by, bl2));
        }
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        if (this.direct) {
            this.writeDirect(byArray, n2, n3);
        } else {
            char[] cArray = new char[n3];
            for (int i2 = 0; i2 < n3; ++i2) {
                cArray[i2] = (char)byArray[i2];
            }
            this.write(cArray, n2, n3);
        }
    }

    public void write(byte by) {
        if (this.direct) {
            this.writeDirect(by);
        } else {
            this.write(new byte[]{by}, 0, 1);
        }
    }

    @Override
    public void write(int n2) {
        if (this.direct) {
            this.writeDirect(n2);
        } else {
            this.write(new char[]{(char)n2}, 0, 1);
        }
    }

    @Override
    public void write(byte[] byArray) {
        if (this.direct) {
            this.writeDirect(byArray);
        } else {
            this.write(byArray, 0, byArray.length);
        }
    }

    public void write(char[] cArray) {
        if (this.direct) {
            this.writeDirect(cArray);
        } else {
            this.write(cArray, 0, cArray.length);
        }
    }

    public void write(char[] cArray, int n2, int n3) {
        if (this.direct) {
            this.writeDirect(cArray, n2, n3);
        } else {
            byte by = this.rmCompat ? (byte)3 : 2;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = n2 + n3;
            while (n2 < n4) {
                switch (cArray[n2]) {
                    case '\n': {
                        if (stringBuffer.length() > 0) {
                            this.addCommand(new PrintString((GuiFactory)this.gf, stringBuffer.toString(), by));
                            stringBuffer = new StringBuffer();
                        }
                        this.newLine();
                        break;
                    }
                    case '\f': {
                        if (stringBuffer.length() > 0) {
                            this.addCommand(new PrintString((GuiFactory)this.gf, stringBuffer.toString(), by));
                            stringBuffer = new StringBuffer();
                        }
                        this.newPage();
                        break;
                    }
                    default: {
                        stringBuffer.append(cArray[n2]);
                    }
                }
                ++n2;
            }
            if (stringBuffer.length() > 0) {
                this.addCommand(new PrintString((GuiFactory)this.gf, stringBuffer.toString(), by));
            }
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.direct) {
            char[] cArray = new String(byArray, n2, n3, CobolVar.encoding).toCharArray();
            this.writeDirect(cArray, 0, cArray.length);
        } else {
            byte[] byArray2;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte by = this.rmCompat ? (byte)3 : 2;
            int n4 = n2 + n3;
            while (n2 < n4) {
                switch (byArray[n2]) {
                    case 10: {
                        if (byteArrayOutputStream.size() > 0) {
                            byArray2 = byteArrayOutputStream.toByteArray();
                            this.addCommand(new PrintBytes(this.gf, byArray2, 0, byArray2.length, by));
                            byteArrayOutputStream.close();
                            byteArrayOutputStream = new ByteArrayOutputStream();
                        }
                        this.newLine();
                        break;
                    }
                    case 12: {
                        if (byteArrayOutputStream.size() > 0) {
                            byArray2 = byteArrayOutputStream.toByteArray();
                            this.addCommand(new PrintBytes(this.gf, byArray2, 0, byArray2.length, by));
                            byteArrayOutputStream.close();
                            byteArrayOutputStream = new ByteArrayOutputStream();
                        }
                        this.newPage();
                        break;
                    }
                    default: {
                        byteArrayOutputStream.write(byArray[n2]);
                    }
                }
                ++n2;
            }
            if (byteArrayOutputStream.size() > 0) {
                byArray2 = byteArrayOutputStream.toByteArray();
                this.addCommand(new PrintBytes(this.gf, byArray2, 0, byArray2.length, by));
            }
            byteArrayOutputStream.close();
        }
    }

    public double[] setup(double d2, double d3, double d4, double d5) throws IOException {
        double[] dArray = new double[]{};
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.aset.get(MediaPrintableArea.class);
        this.aset.add(this.getMediaPrintableArea(this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE));
        boolean bl = this.setup();
        if (bl) {
            Attribute attribute = this.aset.get(MediaPrintableArea.class);
            if (!(attribute instanceof MediaPrintableArea)) {
                return dArray;
            }
            MediaPrintableArea mediaPrintableArea2 = (MediaPrintableArea)attribute;
            Size2DSyntax size2DSyntax = this.getMediaSize();
            attribute = this.aset.get(OrientationRequested.class);
            if (!(attribute instanceof OrientationRequested)) {
                return dArray;
            }
            boolean bl2 = attribute != OrientationRequested.LANDSCAPE && attribute != OrientationRequested.REVERSE_LANDSCAPE;
            float f2 = size2DSyntax.getX(25400);
            float f3 = size2DSyntax.getY(25400);
            float f4 = mediaPrintableArea2.getX(25400);
            float f5 = mediaPrintableArea2.getY(25400);
            float f6 = mediaPrintableArea2.getWidth(25400);
            float f7 = mediaPrintableArea2.getHeight(25400);
            dArray = new double[]{(double)bl2, bl2 ? (double)f2 : (double)f3, bl2 ? (double)f3 : (double)f2, f5, f3 - f5 - f7, f4, f2 - f6 - f4};
            this.setMargins(this.aset);
        } else if (mediaPrintableArea != null) {
            this.aset.add(mediaPrintableArea);
        }
        return dArray;
    }

    public boolean setup() {
        KeyboardBuffer.setBufferOff();
        boolean bl = false;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        SpoolPrinter.setPrintService(printerJob, this.getDefaultPrinter());
        boolean bl2 = printerJob.printDialog(this.aset);
        KeyboardBuffer.setBufferOn();
        Media media = (Media)this.aset.get(Media.class);
        if (media != null && media instanceof MediaSizeName) {
            this.setting.currMediaSizeName = (MediaSizeName)media;
        }
        if (bl2) {
            this.setting.currentPrinter = printerJob.getPrintService();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void setMargins(PrintRequestAttributeSet printRequestAttributeSet) {
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        Size2DSyntax size2DSyntax = this.getMediaSize();
        float f2 = size2DSyntax.getX(25400);
        float f3 = size2DSyntax.getY(25400);
        float f4 = mediaPrintableArea.getX(25400);
        float f5 = mediaPrintableArea.getY(25400);
        float f6 = mediaPrintableArea.getWidth(25400);
        float f7 = mediaPrintableArea.getHeight(25400);
        float f8 = f2 - f6 - f4;
        float f9 = f3 - f7 - f5;
        if (printRequestAttributeSet.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE) {
            this.setMargins(f4, f8, f9, f5, 2);
        } else {
            this.setMargins(f5, f9, f4, f8, 2);
        }
    }

    private int[] getMaxResolution() {
        int[] nArray;
        PrintService printService = this.getCurrPrintService();
        PrinterResolution[] printerResolutionArray = printService != null ? (PrinterResolution[])printService.getSupportedAttributeValues(PrinterResolution.class, null, null) : null;
        if (printerResolutionArray != null && printerResolutionArray.length > 0) {
            nArray = printerResolutionArray[0].getResolution(100);
            int n2 = nArray[0] * nArray[1];
            for (int i2 = 1; i2 < printerResolutionArray.length; ++i2) {
                int[] nArray2 = printerResolutionArray[i2].getResolution(100);
                if (nArray2[0] * nArray2[1] <= n2) continue;
                nArray = nArray2;
                n2 = nArray2[0] * nArray2[1];
            }
        } else {
            nArray = new int[]{600, 600};
        }
        return nArray;
    }

    public int[] getCurrPrinterCapabilities() {
        int[] nArray = new int[7];
        nArray[6] = this.setting.currUnits;
        PrintService printService = this.getCurrPrintService();
        if (printService != null) {
            MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])printService.getSupportedAttributeValues(MediaPrintableArea.class, null, null);
            if (mediaPrintableAreaArray != null) {
                double d2 = 0.0;
                for (int i2 = 0; i2 < mediaPrintableAreaArray.length; ++i2) {
                    float f2;
                    float f3;
                    if (mediaPrintableAreaArray[i2] == null || !((double)((f3 = mediaPrintableAreaArray[i2].getWidth(1000)) * (f2 = mediaPrintableAreaArray[i2].getHeight(1000))) > d2)) continue;
                    nArray[0] = (int)f3;
                    nArray[1] = (int)f2;
                    nArray[2] = (int)mediaPrintableAreaArray[i2].getX(1000);
                    nArray[3] = (int)mediaPrintableAreaArray[i2].getY(1000);
                    d2 = f3 * f2;
                }
            }
            int[] nArray2 = this.getMaxResolution();
            nArray[4] = nArray2[0];
            nArray[5] = nArray2[1];
        }
        return nArray;
    }

    public int getNoPrinters() {
        if (this.services != null) {
            return this.services.length;
        }
        return 0;
    }

    public int getCurrPrinter() {
        PrintService printService = this.getCurrPrintService();
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            if (!this.services[i2].equals(printService)) continue;
            return i2;
        }
        return -1;
    }

    public PrintService getCurrPrintService() {
        return this.setting.currentPrinter != null ? this.setting.currentPrinter : this.getDefaultPrinter();
    }

    public int getPrinterNumber(String string) {
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            if (!this.services[i2].getName().equals(string)) continue;
            return i2;
        }
        return -1;
    }

    public boolean setPrinter(int n2) {
        if (n2 >= 0 && n2 < this.services.length) {
            this.setting.currentPrinter = this.services[n2];
            this.numLines = -1;
            return true;
        }
        return false;
    }

    public boolean setPrinter(String string) {
        return this.setPrinter(this.getPrinterNumber(string));
    }

    public void setOrientation(int n2) {
        switch (n2) {
            case 1: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.PORTRAIT);
                break;
            }
            case 2: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.LANDSCAPE);
                break;
            }
            case 3: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.REVERSE_PORTRAIT);
                break;
            }
            case 4: {
                this.aset.add(this.setting.currOrientation = OrientationRequested.REVERSE_LANDSCAPE);
            }
        }
    }

    public int getOrientation() {
        if (this.setting.currOrientation == OrientationRequested.LANDSCAPE) {
            return 2;
        }
        if (this.setting.currOrientation == OrientationRequested.REVERSE_LANDSCAPE) {
            return 4;
        }
        if (this.setting.currOrientation == OrientationRequested.REVERSE_PORTRAIT) {
            return 3;
        }
        return 1;
    }

    public void setQuality(int n2) {
        switch (n2) {
            case -1: {
                this.aset.add(this.setting.currQuality = PrintQuality.HIGH);
                break;
            }
            case -2: {
                this.aset.add(this.setting.currQuality = PrintQuality.NORMAL);
                break;
            }
            case -4: 
            case -3: {
                this.aset.add(this.setting.currQuality = PrintQuality.DRAFT);
            }
        }
    }

    public int getQuality() {
        PrintQuality printQuality = (PrintQuality)this.aset.get(PrintQuality.class);
        if (printQuality == PrintQuality.HIGH) {
            return -1;
        }
        if (printQuality == PrintQuality.NORMAL) {
            return -2;
        }
        if (printQuality == PrintQuality.DRAFT) {
            return -4;
        }
        return 0;
    }

    public String getPrinterName(int n2) {
        if (n2 >= 0 && this.services != null && n2 < this.services.length) {
            return this.services[n2].getName();
        }
        return "";
    }

    public String getPrinterURI(int n2) {
        PrinterURI printerURI;
        if (n2 >= 0 && this.services != null && n2 < this.services.length && (printerURI = this.services[n2].getAttribute(PrinterURI.class)) != null) {
            return ((Object)printerURI).toString();
        }
        return "";
    }

    public int getColorSupport(int n2) {
        ColorSupported colorSupported;
        if (n2 >= 0 && this.services != null && n2 < this.services.length && (colorSupported = this.services[n2].getAttribute(ColorSupported.class)) != null) {
            if (colorSupported == ColorSupported.SUPPORTED) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    public void setChromaticity(int n2) {
        switch (n2) {
            case 1: {
                this.aset.add(Chromaticity.COLOR);
                break;
            }
            case 0: {
                this.aset.add(Chromaticity.MONOCHROME);
            }
        }
    }

    public int getChromaticity() {
        Chromaticity chromaticity = (Chromaticity)this.aset.get(Chromaticity.class);
        if (chromaticity == Chromaticity.COLOR) {
            return 1;
        }
        if (chromaticity == Chromaticity.MONOCHROME) {
            return 0;
        }
        return -1;
    }

    public int getCurrOrientation() {
        this.setting.currOrientation = (OrientationRequested)this.aset.get(OrientationRequested.class);
        if (this.setting.currOrientation != null) {
            if (this.setting.currOrientation == OrientationRequested.PORTRAIT) {
                return 1;
            }
            if (this.setting.currOrientation == OrientationRequested.LANDSCAPE) {
                return 2;
            }
            if (this.setting.currOrientation == OrientationRequested.REVERSE_PORTRAIT) {
                return 3;
            }
            if (this.setting.currOrientation == OrientationRequested.REVERSE_LANDSCAPE) {
                return 4;
            }
            return 0;
        }
        return 0;
    }

    public void setCollate(int n2) {
        switch (n2) {
            case 1: {
                this.aset.add(SheetCollate.COLLATED);
                break;
            }
            case 0: {
                this.aset.add(SheetCollate.UNCOLLATED);
            }
        }
    }

    public int getCollate() {
        SheetCollate sheetCollate = (SheetCollate)this.aset.get(SheetCollate.class);
        if (sheetCollate != null && SheetCollate.COLLATED.equals(sheetCollate)) {
            return 1;
        }
        return 0;
    }

    public int getCurrCopies() {
        Copies copies = (Copies)this.aset.get(Copies.class);
        if (copies != null) {
            return copies.getValue();
        }
        return 0;
    }

    public void setCurrCopies(int n2) {
        this.aset.add(new Copies(n2 > 0 ? n2 : 1));
    }

    public boolean hasDuplexPrinting() {
        PrintService printService = this.getCurrPrintService();
        return printService != null && (printService.isAttributeValueSupported(Sides.DUPLEX, null, null) || printService.isAttributeValueSupported(Sides.TUMBLE, null, null));
    }

    public void setDuplexPrinting(int n2) {
        switch (n2) {
            case 1: {
                this.aset.add(Sides.ONE_SIDED);
                break;
            }
            case 2: {
                this.aset.add(Sides.DUPLEX);
                break;
            }
            case 3: {
                this.aset.add(Sides.TUMBLE);
            }
        }
    }

    public int getDuplexPrinting() {
        Attribute attribute = this.aset.get(Sides.class);
        if (attribute == Sides.DUPLEX) {
            return 2;
        }
        if (attribute == Sides.TUMBLE) {
            return 3;
        }
        if (attribute == Sides.ONE_SIDED) {
            return 1;
        }
        return 0;
    }

    public boolean isPrinterDefault(int n2) {
        boolean bl;
        try {
            bl = this.getDefaultPrinter().equals(this.services[n2]);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    protected Font getFont(Map map) {
        if (javaMajorVersion >= 21 && "Courier".equals(map.get(TextAttribute.FAMILY))) {
            map.put(TextAttribute.FAMILY, "Monospaced");
        }
        return new Font(map);
    }

    protected Font getFont(int n2) {
        Object object = this.gf.getClient().getId(n2);
        if (object instanceof LocalFontCmp) {
            return ((LocalFontCmp)object).getFont();
        }
        return null;
    }

    public Hashtable getFontMetrics(Hashtable hashtable) {
        Font font = hashtable != null ? this.getFont(FontAttribute.convertToTextAttributes(hashtable)) : this.currFont;
        Hashtable hashtable2 = FontAttribute.convertFromTextAttributes(font.getAttributes());
        if (hashtable2.get(FontAttribute.FAMILY) == null) {
            hashtable2.put(FontAttribute.FAMILY, font.getFamily());
        }
        if (hashtable2.get(FontAttribute.SIZE) == null) {
            hashtable2.put(FontAttribute.SIZE, new Float(font.getSize()));
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Printable printable = (graphics, pageFormat, n2) -> {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setFont(font);
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            if (fontMetrics.charWidth('W') == fontMetrics.charWidth('i')) {
                hashtable2.put(FontAttribute.PITCHFIXED, FontAttribute.PITCHFIXED_ON);
            }
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout("xxxxxxxxxx", graphics2D.getFont(), fontRenderContext);
            hashtable2.put(FontAttribute.ASCENT, new Float(textLayout.getAscent()));
            hashtable2.put(FontAttribute.DESCENT, new Float(textLayout.getDescent()));
            hashtable2.put(FontAttribute.LEADING, new Float(textLayout.getLeading()));
            hashtable2.put(FontAttribute.AVEWIDTH, new Float(textLayout.getAdvance() / 10.0f));
            hashtable2.put(FontAttribute.MAXWIDTH, new Float(fontMetrics.getMaxAdvance()));
            printerJob.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(printerJob, printable);
        return hashtable2;
    }

    public void setPitch(char c2, float f2) {
        switch (c2) {
            case 'c': 
            case 'e': 
            case 'n': {
                break;
            }
            default: {
                return;
            }
        }
        if (this.currFont == null) {
            this.setDefaultFont();
        }
        Map<TextAttribute, ?> map = this.currFont.getAttributes();
        switch (c2) {
            case 'n': {
                map.remove(TextAttribute.TRANSFORM);
                break;
            }
            case 'c': {
                if (f2 <= 0.0f) {
                    f2 = 1.65f;
                }
                if (f2 == 1.0f) break;
                Object obj = map.get(TextAttribute.TRANSFORM);
                AffineTransform affineTransform = obj instanceof TransformAttribute ? ((TransformAttribute)obj).getTransform() : (obj instanceof AffineTransform ? (AffineTransform)obj : new AffineTransform());
                affineTransform.scale(1.0f / f2, 1.0f / f2);
                map.put(TextAttribute.TRANSFORM, affineTransform);
                break;
            }
            case 'e': {
                if (f2 <= 0.0f) {
                    f2 = 2.0f;
                }
                if (f2 == 1.0f) break;
                Object obj = map.get(TextAttribute.TRANSFORM);
                AffineTransform affineTransform = obj instanceof TransformAttribute ? ((TransformAttribute)obj).getTransform() : (obj instanceof AffineTransform ? (AffineTransform)obj : new AffineTransform());
                affineTransform.scale(f2, f2);
                map.put(TextAttribute.TRANSFORM, affineTransform);
            }
        }
        this.currFont = this.getFont(map);
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setFont(Map map) {
        if (map == null) {
            this.setDefaultFont();
        } else {
            this.currFont = this.getFont(map);
        }
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setFont(int n2) {
        this.setFont(this.getFont(n2));
    }

    protected void setFont(Font font) {
        if (font == null) {
            this.setDefaultFont();
        } else {
            this.currFont = font;
        }
        this.addCommand(new SetFont((GuiFactory)this.gf, this.allCommands.locHandles, this.currFont));
    }

    public void setColor(int n2, int n3, int n4, int n5) {
        this.addCommand(new SetColor((GuiFactory)this.gf, new Color(n2, n3, n4, n5)));
    }

    public void setBackground(int n2, int n3, int n4, int n5) {
        if (n2 == 255 && n3 == 255 && n4 == 255 || n5 == 0) {
            this.addCommand(new SetBackground((GuiFactory)this.gf, (Color)null));
        } else {
            this.addCommand(new SetBackground((GuiFactory)this.gf, new Color(n2, n3, n4, n5)));
        }
    }

    public void setLinesPerPage(int n2) {
        if (n2 == 0) {
            this.numLines = -1;
            this.getPageLayout(null);
            n2 = this.numLines;
        } else {
            this.numLines = n2;
        }
        this.addCommand(new SetLinesPerPage((GuiFactory)this.gf, n2));
    }

    public void printBitmap(int n2, double d2, double d3, int n3, double d4, double d5, int n4) {
        Object object = this.gf.getClient().getId(n2);
        this.printBitmap(object instanceof LocalImage ? ((LocalImage)object).getImage() : null, d2, d3, n3, d4, d5, n4);
    }

    protected void printBitmap(Image image, double d2, double d3, int n2, double d4, double d5, int n3) {
        if (image != null) {
            boolean bl = false;
            boolean bl2 = false;
            if (n2 == 0) {
                n2 = this.setting.currUnits;
            }
            switch (n2) {
                case 2: {
                    d2 *= 72.0;
                    d3 *= 72.0;
                    break;
                }
                case 3: {
                    d2 *= 28.34645652770996;
                    d3 *= 28.34645652770996;
                    break;
                }
                case 1: {
                    bl = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("printBitmap:Type " + n2 + " not supported!");
                }
            }
            if (n3 == 0) {
                n3 = this.setting.currUnits;
            }
            switch (n3) {
                case 2: {
                    d5 *= 72.0;
                    d4 *= 72.0;
                    break;
                }
                case 3: {
                    d5 *= 28.34645652770996;
                    d4 *= 28.34645652770996;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    if (d5 == 0.0 || d4 == 0.0) break;
                    System.err.println("printBitmap:Type " + n3 + " not supported!");
                }
            }
            this.addCommand(new PrintBitmap(this.gf, this.allCommands.locHandles, image, d2, d3, bl, d4, d5, bl2));
        }
    }

    public void drawGraph(int n2, double d2, double d3, double d4, double d5, int n3, String string) {
        boolean bl = false;
        if (n3 == 0) {
            n3 = this.setting.currUnits;
        }
        switch (n3) {
            case 2: {
                d2 *= 72.0;
                d3 *= 72.0;
                d4 *= 72.0;
                d5 *= 72.0;
                break;
            }
            case 6: {
                d2 = d2 * 72.0 - this.leftMargin;
                d3 = d3 * 72.0 - this.topMargin;
                d4 = d4 * 72.0 - this.leftMargin;
                d5 = d5 * 72.0 - this.topMargin;
                break;
            }
            case 3: {
                d2 *= 28.34645652770996;
                d3 *= 28.34645652770996;
                d4 *= 28.34645652770996;
                d5 *= 28.34645652770996;
                break;
            }
            case 7: {
                d2 = d2 * 28.34645652770996 - this.leftMargin;
                d3 = d3 * 28.34645652770996 - this.topMargin;
                d4 = d4 * 28.34645652770996 - this.leftMargin;
                d5 = d5 * 28.34645652770996 - this.topMargin;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 4: {
                break;
            }
            default: {
                System.err.println("drawGraph:Type " + n3 + " not supported!");
            }
        }
        this.addCommand(new DrawGraph(this.gf, n2, d2, d3, d4, d5, bl, string));
    }

    public void setCursor(double d2, double d3, double[] dArray, double[] dArray2, int n2, int n3, byte by) {
        boolean bl;
        boolean bl2 = false;
        this.nextTxtAlign = by == 0 ? (byte)2 : (byte)(by == 0 ? 2 : (int)by);
        if (n2 == 0) {
            n2 = this.setting.currUnits;
        }
        switch (n2) {
            case 2: {
                d2 *= 72.0;
                d3 *= 72.0;
                break;
            }
            case 6: {
                d2 = d2 * 72.0 - this.leftMargin;
                d3 = d3 * 72.0 - this.topMargin;
                break;
            }
            case 3: {
                d2 *= 28.34645652770996;
                d3 *= 28.34645652770996;
                break;
            }
            case 7: {
                d2 = d2 * 28.34645652770996 - this.leftMargin;
                d3 = d3 * 28.34645652770996 - this.topMargin;
                break;
            }
            case 1: {
                bl2 = true;
                break;
            }
            case 4: {
                break;
            }
            default: {
                System.err.println("setCursor:Type " + n2 + " not supported!");
            }
        }
        if (n3 == 0) {
            SetCursor setCursor = new SetCursor(this.gf, d2, d3, bl2);
            this.addCommand(setCursor);
            dArray[0] = setCursor.getPrevX();
            dArray2[0] = setCursor.getPrevY();
            bl = setCursor.getPrevCells();
        } else {
            dArray[0] = SetCursor.getLastX();
            dArray2[0] = SetCursor.getLastY();
            bl = SetCursor.getLastCells();
        }
        if (!(bl2 | bl)) {
            switch (n2) {
                case 2: {
                    dArray[0] = dArray[0] / 72.0;
                    dArray2[0] = dArray2[0] / 72.0;
                    break;
                }
                case 6: {
                    dArray[0] = dArray[0] / 72.0 + this.leftMargin;
                    dArray2[0] = dArray2[0] / 72.0 + this.topMargin;
                    break;
                }
                case 3: {
                    dArray[0] = dArray[0] / 28.34645652770996 + this.leftMargin;
                    dArray2[0] = dArray2[0] / 28.34645652770996 + this.topMargin;
                    break;
                }
                case 1: {
                    bl2 = true;
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    System.err.println("setCursor2:Type " + n2 + " not supported!");
                }
            }
        }
    }

    public void setGraphPenPt(int n2, double d2, Color color) {
        this.addCommand(new SetGraphPen(this.gf, n2, d2, color));
    }

    public void setGraphPen(int n2, double d2, Color color) {
        int[] nArray = this.getMaxResolution();
        d2 = d2 * 72.0 / Math.sqrt(nArray[0] * nArray[1]);
        this.setGraphPenPt(n2, d2, color);
    }

    public void setGraphBrush(int n2, Color color) {
        this.addCommand(new SetGraphBrush(this.gf, n2, color));
    }

    public void setBoxShade(Color color) {
        this.addCommand(new SetBoxShade((GuiFactory)this.gf, color));
    }

    public void setDataColumns(int[] nArray) {
        SetDataColumns setDataColumns = new SetDataColumns(this.gf, this.allCommands.classDataCols, nArray);
        this.addCommand(setDataColumns);
        this.allCommands.classDataCols = setDataColumns.getCols();
    }

    public void setPageColumn(boolean bl, double d2, double d3, double d4, int n2, int n3, char c2, boolean bl2) {
        this.setPageColumn(bl, d2, d3, d4, this.getFont(n2), n3, c2, bl2);
    }

    protected void setPageColumn(boolean bl, double d2, double d3, double d4, Font font, int n2, char c2, boolean bl2) {
        SetPageColumns setPageColumns = new SetPageColumns(this.gf, this.allCommands.locHandles, this.allCommands.classPageCols, bl, d2, d3, d4, font, n2, c2, bl2);
        this.addCommand(setPageColumns);
        this.allCommands.classPageCols = setPageColumns.getCols();
    }

    public void clearPageColumn() {
        this.addCommand(new SetPageColumns(this.gf));
        this.allCommands.classPageCols = null;
    }

    public Point getPageLayout(Map map) {
        Font font = map != null ? this.getFont(map) : this.currFont;
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        Point point = new Point();
        PageFormat[] pageFormatArray = new PageFormat[]{this.buildPageFormat()};
        Printable printable = (graphics, pageFormat, n2) -> {
            if (pageFormatArray[0] == null) {
                pageFormatArray[0] = (PageFormat)pageFormat.clone();
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
            TextLayout textLayout = new TextLayout("0", font == null ? graphics2D.getFont() : font, fontRenderContext);
            float f2 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
            float f3 = textLayout.getAdvance();
            point.y = (int)(pageFormatArray[0].getImageableHeight() / (double)f2);
            point.x = (int)(pageFormatArray[0].getImageableWidth() / (double)f3);
            printerJob.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(printerJob, printable);
        if (this.numLines >= 0) {
            point.y = this.numLines;
        }
        return point;
    }

    public void setMargins(double d2, double d3, double d4, double d5, int n2) {
        Size2DSyntax size2DSyntax = this.getMediaSize();
        if (size2DSyntax == null) {
            System.err.println("MediaSize missing!");
            return;
        }
        MediaPrintableArea mediaPrintableArea = null;
        if (n2 == 0) {
            n2 = this.setting.currUnits;
        }
        switch (n2) {
            case 4: {
                int[] nArray = this.getMaxResolution();
                if (d2 > 0.0) {
                    d2 /= (double)nArray[1];
                }
                if (d3 > 0.0) {
                    d3 /= (double)nArray[1];
                }
                if (d4 > 0.0) {
                    d4 /= (double)nArray[0];
                }
                if (d5 > 0.0) {
                    d5 /= (double)nArray[0];
                }
            }
            case 2: {
                if (d2 == 0.0) {
                    d2 = 0.0;
                } else if (d2 < 0.0) {
                    d2 = this.topMargin / 72.0;
                }
                if (d3 == 0.0) {
                    d3 = 0.0;
                } else if (d3 < 0.0) {
                    d3 = this.bottomMargin / 72.0;
                }
                if (d4 == 0.0) {
                    d4 = 0.0;
                } else if (d4 < 0.0) {
                    d4 = this.leftMargin / 72.0;
                }
                if (d5 == 0.0) {
                    d5 = 0.0;
                } else if (d5 < 0.0) {
                    d5 = this.rightMargin / 72.0;
                }
                mediaPrintableArea = this.isReportPreview() ? new MediaPrintableArea(0.0f, 0.0f, size2DSyntax.getX(25400), size2DSyntax.getY(25400), 25400) : new MediaPrintableArea((float)d4, (float)d2, (float)((double)size2DSyntax.getX(25400) - d4 - d5), (float)((double)size2DSyntax.getY(25400) - d2 - d3), 25400);
                this.leftMargin = d4 * 72.0;
                this.topMargin = d2 * 72.0;
                this.rightMargin = d5 * 72.0;
                this.bottomMargin = d3 * 72.0;
                break;
            }
            case 3: {
                if (d2 == 0.0) {
                    d2 = 0.0;
                } else if (d2 < 0.0) {
                    d2 = this.topMargin / 28.34645652770996;
                }
                if (d3 == 0.0) {
                    d3 = 0.0;
                } else if (d3 < 0.0) {
                    d3 = this.bottomMargin / 28.34645652770996;
                }
                if (d4 == 0.0) {
                    d4 = 0.0;
                } else if (d4 < 0.0) {
                    d4 = this.leftMargin / 28.34645652770996;
                }
                if (d5 == 0.0) {
                    d5 = 0.0;
                } else if (d5 < 0.0) {
                    d5 = this.rightMargin / 28.34645652770996;
                }
                mediaPrintableArea = this.isReportPreview() ? new MediaPrintableArea(0.0f, 0.0f, size2DSyntax.getX(1000), size2DSyntax.getY(1000), 1000) : new MediaPrintableArea((float)(d4 * 10.0), (float)(d2 * 10.0), (float)((double)size2DSyntax.getX(1000) - (d4 + d5) * 10.0), (float)((double)size2DSyntax.getY(1000) - (d2 + d3) * 10.0), 1000);
                this.leftMargin = d4 * 28.34645652770996;
                this.topMargin = d2 * 28.34645652770996;
                this.rightMargin = d5 * 28.34645652770996;
                this.bottomMargin = d3 * 28.34645652770996;
                break;
            }
            case 0: {
                this.setMargins(0.0, 0.0, 0.0, 0.0, 3);
                break;
            }
            default: {
                System.err.println("setMargins:Type " + n2 + " not supported!");
            }
        }
        if (mediaPrintableArea != null) {
            this.aset.add(mediaPrintableArea);
        }
    }

    public boolean isReportPreview() {
        return this.events != null;
    }

    public double[] getMargins(int n2) {
        double[] dArray = new double[4];
        switch (n2) {
            case 2: {
                dArray[0] = this.topMargin / 72.0;
                dArray[1] = this.bottomMargin / 72.0;
                dArray[2] = this.leftMargin / 72.0;
                dArray[3] = this.rightMargin / 72.0;
                break;
            }
            case 3: {
                dArray[0] = this.topMargin / 28.34645652770996;
                dArray[1] = this.bottomMargin / 28.34645652770996;
                dArray[2] = this.leftMargin / 28.34645652770996;
                dArray[3] = this.rightMargin / 28.34645652770996;
                break;
            }
            case 4: {
                dArray[0] = this.topMargin;
                dArray[1] = this.bottomMargin;
                dArray[2] = this.leftMargin;
                dArray[3] = this.rightMargin;
                break;
            }
            default: {
                System.err.println("getMargins:Type " + n2 + " not supported!");
            }
        }
        return dArray;
    }

    public void setDefaultUnits(int n2) {
        switch (n2) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.setting.currUnits = n2;
            }
        }
    }

    public void setJobName(String string, String string2) {
        String string3;
        if (string != null && (string3 = string.trim()).length() > 0) {
            this.aset.add(new JobName(string3, null));
            if (string2 != null && string2.length() > 0) {
                char c2 = Character.toUpperCase(string2.charAt(0));
                if (c2 == 'P') {
                    this.pdf = true;
                    this.preview = false;
                    this.setFileName(string3);
                } else if (c2 == 'V') {
                    this.preview = true;
                    this.pdf = false;
                    this.setFileName(string3);
                } else if (c2 == 'S') {
                    this.preview = false;
                    this.pdf = false;
                    this.setFileName("PRINTER?");
                }
            }
        } else {
            this.aset.add(new JobName(jobName, null));
        }
    }

    public String getJobName() {
        JobName jobName = (JobName)this.aset.get(JobName.class);
        if (jobName != null) {
            return jobName.getValue();
        }
        return jobName;
    }

    public boolean setMediaSize(int n2) {
        if (n2 <= 0 || n2 >= mediaSizes.length || mediaSizes[n2] == null) {
            return false;
        }
        this.setting.currMediaSizeName = SpoolPrinter.mediaSizes[n2];
        this.customPdfMediaSize = null;
        this.aset.add(this.setting.currMediaSizeName);
        this.setMargins(this.topMargin / 72.0, this.bottomMargin / 72.0, this.leftMargin / 72.0, this.rightMargin / 72.0, 2);
        return true;
    }

    public boolean setCustomMediaSize(float f2, float f3, int n2) {
        Object object;
        int n3;
        switch (n2) {
            case 2: {
                n3 = 25400;
                break;
            }
            case 3: {
                f2 *= 10.0f;
                f3 *= 10.0f;
                n3 = 1000;
                break;
            }
            default: {
                return false;
            }
        }
        MediaSizeName mediaSizeName = null;
        PrintService printService = this.getCurrPrintService();
        if (printService != null && (object = printService.getSupportedAttributeValues(Media.class, null, null)) instanceof Media[]) {
            for (Media media : (Media[])object) {
                MediaSize mediaSize;
                if (!(media instanceof MediaSizeName) || (mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)media)).getX(n3) != f2 || mediaSize.getY(n3) != f3) continue;
                mediaSizeName = (MediaSizeName)media;
                break;
            }
        }
        if (mediaSizeName != null) {
            this.setMediaSize(mediaSizeName);
            this.setMargins(this.topMargin / 72.0, this.bottomMargin / 72.0, this.leftMargin / 72.0, this.rightMargin / 72.0, 2);
            return true;
        }
        if (f2 <= f3) {
            this.customPdfMediaSize = new MediaSize(f2, f3, n3);
        }
        return false;
    }

    public void setCurrPrinter(PrintService printService) {
        this.setting.currentPrinter = printService;
    }

    public void setMediaSize(MediaSizeName mediaSizeName) {
        this.setting.currMediaSizeName = mediaSizeName;
        this.aset.add(this.setting.currMediaSizeName);
        this.customPdfMediaSize = null;
    }

    public int getCurrMediaSize() {
        if (this.setting.currMediaSizeName != null) {
            for (int i2 = 0; i2 < mediaSizes.length; ++i2) {
                if (this.setting.currMediaSizeName != mediaSizes[i2]) continue;
                return i2;
            }
        }
        return -1;
    }

    public Size2DSyntax getCurrMediaSize2D() {
        if (this.setting.currMediaSizeName != null) {
            return MediaSize.getMediaSizeForName(this.setting.currMediaSizeName);
        }
        return null;
    }

    private int getMediaSize(MediaSizeName mediaSizeName) {
        int n2;
        for (n2 = mediaSizes.length - 1; n2 > 0 && mediaSizeName != mediaSizes[n2]; --n2) {
        }
        return n2;
    }

    private MediaTray getMediaTray(int n2) {
        if (n2 > 0) {
            Object[] objectArray;
            if (n2 < mediaTrays.length && mediaTrays[n2] != null) {
                return mediaTrays[n2];
            }
            PrintService printService = this.getCurrPrintService();
            if (printService != null && (objectArray = (Object[])printService.getSupportedAttributeValues(Media.class, null, null)) != null) {
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    MediaTray mediaTray;
                    if (!(objectArray[i2] instanceof MediaTray) || this.getDeviceMediaTray(mediaTray = (MediaTray)objectArray[i2]) != n2) continue;
                    return mediaTray;
                }
            }
        }
        return null;
    }

    private int getMediaTray(MediaTray mediaTray) {
        for (int i2 = 0; i2 < mediaTrays.length; ++i2) {
            if (mediaTray != mediaTrays[i2]) continue;
            return i2;
        }
        return this.getDeviceMediaTray(mediaTray);
    }

    private int getDeviceMediaTray(MediaTray mediaTray) {
        try {
            if (win32mt != null && win32mt.isAssignableFrom(mediaTray.getClass())) {
                return (Integer)win32mt.getField("winID").get(mediaTray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mediaTray.getValue();
    }

    public int[][] getMedia4Printer(String string) {
        Object[] objectArray;
        int n2 = this.getPrinterNumber(string);
        Object object = null;
        if (n2 >= 0 && (objectArray = (Object[])this.services[n2].getSupportedAttributeValues(Media.class, null, null)) != null) {
            int n3;
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = new Vector<Object>();
            for (n3 = 0; n3 < objectArray.length; ++n3) {
                if (objectArray[n3] instanceof MediaSizeName) {
                    vector.add(objectArray[n3]);
                    continue;
                }
                if (!(objectArray[n3] instanceof MediaTray)) continue;
                vector2.add(objectArray[n3]);
            }
            object = new int[2][];
            object[0] = new int[vector.size()];
            object[1] = new int[vector2.size()];
            for (n3 = vector.size() - 1; n3 >= 0; --n3) {
                object[0][n3] = this.getMediaSize((MediaSizeName)vector.elementAt(n3));
            }
            for (n3 = vector2.size() - 1; n3 >= 0; --n3) {
                object[1][n3] = this.getMediaTray((MediaTray)vector2.elementAt(n3));
            }
        }
        return object;
    }

    public boolean setMediaTray(int n2) {
        this.setting.currMediaTray = this.getMediaTray(n2);
        if (this.setting.currMediaTray != null) {
            this.aset.add(this.setting.currMediaTray);
            return true;
        }
        return false;
    }

    public int getMediaTray() {
        MediaTray mediaTray = (MediaTray)this.aset.get(MediaTray.class);
        if (mediaTray == null) {
            for (Attribute attribute : this.aset.toArray()) {
                if (!(attribute instanceof MediaTray)) continue;
                mediaTray = (MediaTray)attribute;
                break;
            }
        }
        if (mediaTray == null) {
            for (Attribute attribute : this.aset.toArray()) {
                if (!(attribute instanceof PrintRequestAttribute)) continue;
                try {
                    mediaTray = (MediaTray)attribute.getClass().getMethod("getMedia", new Class[0]).invoke((Object)attribute, new Object[0]);
                    if (mediaTray == null) continue;
                    break;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return this.getMediaTray(mediaTray);
    }

    public void setAttribute(String string, String string2) {
        this.genericAttrs.put(string, string2);
    }

    public boolean hasPrinted() {
        return this.printed;
    }

    public void cancelJob() {
        this.jobCancelled = true;
    }

    public void buildPages(Graphics2D graphics2D, PageFormat pageFormat) {
        this.buildPages(graphics2D, pageFormat, false);
    }

    public void buildPages(Graphics2D graphics2D, PageFormat pageFormat, boolean bl) {
        PrintContext printContext = new PrintContext(new Point2D.Float(0.0f, 0.0f), graphics2D.getFont(), graphics2D.getFontRenderContext(), new Color(0, 0, 0));
        Page page = new Page(printContext, this.allCommands);
        this.pages = new Vector();
        boolean bl2 = true;
        long l2 = 0L;
        PrintCommand printCommand = this.allCommands.getFirst();
        while (printCommand != null) {
            boolean bl3;
            boolean bl4 = bl3 = bl ? printCommand.print(printContext, graphics2D, pageFormat) : printCommand.testPrint(printContext, graphics2D, pageFormat);
            if (bl3) {
                page.addItem(l2);
                bl2 = bl2 && (printCommand instanceof SetNewPage || printCommand instanceof SetPageColumns);
            } else {
                this.pages.addElement(page);
                printContext.pen = new Point2D.Float(0.0f, 0.0f);
                page = new Page(printContext, this.allCommands);
                bl2 = true;
                if (printCommand.addMeToPage()) {
                    if (bl) {
                        printCommand.print(printContext, graphics2D, pageFormat);
                    } else {
                        printCommand.testPrint(printContext, graphics2D, pageFormat);
                    }
                    page.addItem(l2);
                    bl2 = printCommand instanceof SetNewPage || printCommand instanceof SetPageColumns;
                }
            }
            l2 = this.allCommands.getNextIdx();
            printCommand = this.allCommands.getNext();
        }
        if (!bl2) {
            this.pages.addElement(page);
        }
        if (this.header != null || this.footer != null) {
            this.aHeadFoot = new AutoHeaderFooter(this.header, this.footer, this.getPageCount(), this.reportName, this.headerFooterFont);
        }
    }

    private Paper setReportMargins(PageFormat pageFormat) {
        if (this.isReportPreview()) {
            Paper paper = pageFormat.getPaper();
            Size2DSyntax size2DSyntax = this.getMediaSize();
            float f2 = size2DSyntax.getX(25400) * 72.0f;
            float f3 = size2DSyntax.getY(25400) * 72.0f;
            Paper paper2 = new Paper();
            if (this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE) {
                paper2.setSize(f2, f3);
                paper2.setImageableArea(this.topMargin, this.rightMargin, (double)f2 - this.topMargin - this.bottomMargin, (double)f3 - this.leftMargin - this.rightMargin);
            } else {
                paper2.setSize(f2, f3);
                paper2.setImageableArea(this.leftMargin, this.topMargin, (double)f2 - this.leftMargin - this.rightMargin, (double)f3 - this.topMargin - this.bottomMargin);
            }
            pageFormat.setPaper(paper2);
            return paper;
        }
        return null;
    }

    private PageFormat getReportPreviewPageFormat(PageFormat pageFormat) {
        Size2DSyntax size2DSyntax = this.getMediaSize();
        float f2 = size2DSyntax.getX(25400) * 72.0f;
        float f3 = size2DSyntax.getY(25400) * 72.0f;
        Paper paper = new Paper();
        paper.setSize(f2, f3);
        paper.setImageableArea(0.0, 0.0, f2, f3);
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    private void adjustHFMargins() {
        if (this.isReportPreview() && this.aHeadFoot != null) {
            Size2DSyntax size2DSyntax = this.getMediaSize();
            float f2 = size2DSyntax.getX(25400) * 72.0f;
            float f3 = size2DSyntax.getY(25400) * 72.0f;
            Paper paper = new Paper();
            paper.setSize(f2, f3);
            paper.setImageableArea(0.0, 0.0, f2, f3);
            PageFormat pageFormat = new PageFormat();
            pageFormat.setPaper(paper);
            PrinterJob printerJob = PrinterJob.getPrinterJob();
            PrintService printService = this.getCurrPrintService();
            if (printService != null) {
                SpoolPrinter.setPrintService(printerJob, printService);
            }
            pageFormat = printerJob.validatePage(pageFormat);
            this.aHeadFoot.imgArea = this.aset.get(OrientationRequested.class) == OrientationRequested.LANDSCAPE ? new Rectangle2D.Double(this.leftMargin - pageFormat.getImageableX(), this.topMargin - pageFormat.getImageableY(), pageFormat.getImageableHeight(), pageFormat.getImageableWidth()) : new Rectangle2D.Double(this.leftMargin - pageFormat.getImageableX(), this.topMargin - pageFormat.getImageableY(), pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        }
    }

    public MediaPrintableArea getMediaPrintableArea(boolean bl) {
        Size2DSyntax size2DSyntax = this.getMediaSize();
        float f2 = (float)(this.topMargin / 72.0);
        float f3 = (float)(this.bottomMargin / 72.0);
        float f4 = (float)(this.rightMargin / 72.0);
        float f5 = (float)(this.leftMargin / 72.0);
        if (bl) {
            return new MediaPrintableArea(f2, f4, size2DSyntax.getX(25400) - f2 - f3, size2DSyntax.getY(25400) - f5 - f4, 25400);
        }
        return new MediaPrintableArea(f5, f2, size2DSyntax.getX(25400) - f5 - f4, size2DSyntax.getY(25400) - f2 - f3, 25400);
    }

    private Size2DSyntax getMediaSize() {
        Object object;
        PrintService printService;
        MediaSize mediaSize = this.setting.currMediaSizeName == null ? ((printService = this.getCurrPrintService()) != null && (object = printService.getDefaultAttributeValue(Media.class)) instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)object) : new MediaSize(210, 297, 1000)) : MediaSize.getMediaSizeForName(this.setting.currMediaSizeName);
        return mediaSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n2) {
        try {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paper paper = this.setReportMargins(pageFormat);
            try {
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                if (this.pages == null) {
                    this.buildPages(graphics2D, pageFormat);
                }
                Page page = null;
                try {
                    page = (Page)this.pages.elementAt(n2);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                if (page == null) {
                    int n3 = 1;
                    return n3;
                }
                this.adjustHFMargins();
                page.print(graphics2D, pageFormat, this.aHeadFoot, n2 + 1);
                int n4 = 0;
                return n4;
            }
            finally {
                if (paper != null) {
                    pageFormat.setPaper(paper);
                }
            }
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
            throw runtimeException;
        }
    }

    public int getPageCount() {
        return this.pages != null ? this.pages.size() : 0;
    }

    public void clearPages() {
        this.pages = null;
    }

    private PageFormat buildPageFormat() {
        Attribute attribute = this.aset.get(Media.class);
        if (!(attribute instanceof MediaSizeName)) {
            return null;
        }
        MediaSize mediaSize = MediaSize.getMediaSizeForName((MediaSizeName)attribute);
        if (mediaSize == null) {
            return null;
        }
        Paper paper = new Paper();
        paper.setSize((double)mediaSize.getX(25400) * 72.0, (double)mediaSize.getY(25400) * 72.0);
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)this.aset.get(MediaPrintableArea.class);
        paper.setImageableArea((double)mediaPrintableArea.getX(25400) * 72.0, (double)mediaPrintableArea.getY(25400) * 72.0, (double)mediaPrintableArea.getWidth(25400) * 72.0, (double)mediaPrintableArea.getHeight(25400) * 72.0);
        PageFormat pageFormat = new PageFormat();
        OrientationRequested orientationRequested = (OrientationRequested)this.aset.get(OrientationRequested.class);
        if (orientationRequested == null || orientationRequested == OrientationRequested.PORTRAIT) {
            pageFormat.setOrientation(1);
        } else {
            pageFormat.setOrientation(0);
        }
        pageFormat.setPaper(paper);
        return pageFormat;
    }

    public PageFormat getPageFormat(PrinterJob printerJob) {
        PageFormat[] pageFormatArray = new PageFormat[]{this.buildPageFormat()};
        Printable printable = (graphics, pageFormat, n2) -> {
            if (pageFormatArray[0] == null) {
                pageFormatArray[0] = (PageFormat)pageFormat.clone();
            }
            if (this.pages == null) {
                this.buildPages((Graphics2D)graphics, pageFormatArray[0]);
            }
            printerJob.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(printerJob, printable);
        if (this.isReportPreview()) {
            return this.getReportPreviewPageFormat(pageFormatArray[0]);
        }
        return pageFormatArray[0];
    }

    public void setPreview(boolean bl) {
        this.preview = bl;
    }

    public void setPDF(boolean bl) {
        this.pdf = bl;
    }

    private static String[] breakHeaderFooter(String string) {
        String[] stringArray;
        if (string != null && string.length() > 0) {
            int n2;
            ArrayList<String> arrayList = new ArrayList<String>();
            block3: while ((n2 = string.indexOf(38)) >= 0) {
                if (n2 > 0) {
                    arrayList.add(string.substring(0, n2));
                    string = string.substring(n2);
                }
                switch (string.length()) {
                    case 1: 
                    case 2: {
                        arrayList.add(string);
                        string = "";
                        continue block3;
                    }
                }
                arrayList.add(string.substring(0, 2));
                string = string.substring(2);
            }
            if (string.length() > 0) {
                arrayList.add(string);
            }
            stringArray = new String[arrayList.size()];
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                stringArray[i2] = arrayList.get(i2).toString();
            }
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    public void setHeaderFooter(String string, String string2, int n2) {
        this.setHeaderFooter(string, string2, this.getFont(n2));
    }

    protected void setHeaderFooter(String string, String string2, Font font) {
        if (string != null) {
            this.header = SpoolPrinter.breakHeaderFooter(string);
        }
        if (string2 != null) {
            this.footer = SpoolPrinter.breakHeaderFooter(string2);
        }
        this.headerFooterFont = font;
    }

    public void setReportName(String string) {
        this.reportName = string;
    }

    public String getReportName() {
        return this.reportName;
    }

    private Preview printPreview() {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = this.getPageFormat(printerJob);
        printerJob.setPrintable(this);
        if (this.pages != null) {
            KeyboardBuffer.setBufferOff();
            PreviewDialog previewDialog = Preview.previewDialog(this, pageFormat, this.pages.size(), this.fileName, prDialogSettings, this.events);
            prDialogSettings.setAntialiasing(previewDialog.getAntialiasing());
            prDialogSettings.setScale(previewDialog.getScale());
            prDialogSettings.setMaximized(previewDialog.isMaximized());
            prDialogSettings.setBounds(previewDialog.getRestoreBounds());
            KeyboardBuffer.setBufferOn();
            return previewDialog.getPreview();
        }
        return null;
    }

    private boolean printPDF() throws PrinterException, IOException {
        String string = this.fileName;
        if (this.openFileChooser) {
            String string2 = null;
            String string3 = File.getcwd();
            if (string != null && string.length() > 0) {
                java.io.File file = new java.io.File(string);
                if (file.isDirectory()) {
                    if (file.exists()) {
                        string3 = string;
                    }
                } else {
                    java.io.File file2 = file.getParentFile();
                    if (file2 != null && file2.exists()) {
                        string3 = file.getParent();
                    }
                    string2 = file.getName();
                }
            }
            KeyboardBuffer.setBufferOff();
            string = Preview.openSaveDialog(null, "pdf", "Portable Document Format (*.pdf)", string3, string2);
            KeyboardBuffer.setBufferOn();
            if (string == null) {
                return false;
            }
        }
        return this.printPDF(string);
    }

    public boolean printPDF(String string) throws PrinterException, IOException {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat[] pageFormatArray = new PageFormat[]{this.buildPageFormat()};
        Printable printable = (graphics, pageFormat, n2) -> {
            if (pageFormatArray[0] == null) {
                pageFormatArray[0] = (PageFormat)pageFormat.clone();
            }
            if (this.pages == null) {
                this.buildPages((Graphics2D)graphics, pageFormatArray[0]);
            }
            printerJob.cancel();
            throw new PrinterException(DUMMY_PRINT_CANCELED);
        };
        this.fakePrint(printerJob, printable);
        if (this.pages != null) {
            printerJob.setPrintable(this);
            PDF pDF = new PDF(this, pageFormatArray[0], printerJob, string, this.pages.size());
            return pDF.doPrint(this.aset, this.genericAttrs, this.customPdfMediaSize);
        }
        return false;
    }

    private void checkTmpFile() {
        if (this.binary) {
            if (this.binOut == null) {
                try {
                    this.tmpFile = java.io.File.createTempFile("prt", ".prt");
                    this.tmpFile.deleteOnExit();
                    this.binOut = new FileOutputStream(this.tmpFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IscobolRuntimeException(8, fileNotFoundException.toString());
                }
                catch (IOException iOException) {
                    throw new IscobolRuntimeException(8, iOException.toString());
                }
            }
        } else if (this.out == null) {
            try {
                this.tmpFile = java.io.File.createTempFile("prt", ".prt");
                this.tmpFile.deleteOnExit();
                this.out = new FileWriter(this.tmpFile);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IscobolRuntimeException(8, fileNotFoundException.toString());
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, iOException.toString());
            }
        }
    }

    private void closeDirect() {
        if (this.out != null || this.binOut != null) {
            try {
                if (this.out != null) {
                    this.out.close();
                } else {
                    this.binOut.close();
                }
                PrintService printService = this.getCurrPrintService();
                if (printService != null) {
                    DocPrintJob docPrintJob = printService.createPrintJob();
                    FileInputStream fileInputStream = new FileInputStream(this.tmpFile);
                    DocFlavor.INPUT_STREAM iNPUT_STREAM = DocFlavor.INPUT_STREAM.AUTOSENSE;
                    SimpleDoc simpleDoc = new SimpleDoc(fileInputStream, iNPUT_STREAM, null);
                    docPrintJob.print(simpleDoc, new HashPrintRequestAttributeSet());
                    if (this.tmpFile != null) {
                        this.tmpFile.delete();
                        this.tmpFile = null;
                    }
                    this.out = null;
                    this.binOut = null;
                }
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, iOException.toString());
            }
            catch (PrintException printException) {
                printException.printStackTrace();
            }
        }
    }

    public void flushDirect() {
        this.checkTmpFile();
        try {
            if (this.binary) {
                this.binOut.flush();
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(char[] cArray) {
        this.checkTmpFile();
        try {
            this.out.write(cArray);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(char[] cArray, int n2, int n3) {
        this.checkTmpFile();
        try {
            this.out.write(cArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(int n2) {
        this.checkTmpFile();
        try {
            this.out.write(n2);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(byte[] byArray) {
        this.checkTmpFile();
        try {
            this.binOut.write(byArray);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(byte[] byArray, int n2, int n3) {
        this.checkTmpFile();
        try {
            this.binOut.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void writeDirect(byte by) {
        this.checkTmpFile();
        try {
            this.binOut.write(by);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public static String getDialogTitle() {
        return prDialogSettings.getTitle();
    }

    public static void setDialogTitle(String string) {
        if (string == null) {
            string = "Print Preview";
        }
        prDialogSettings.setTitle(string);
    }

    public static boolean isPreviewAliasing() {
        return SpoolPrinter.isPreviewAntialiasing();
    }

    public static void setPreviewAliasing(boolean bl) {
        SpoolPrinter.setPreviewAntialiasing(bl);
    }

    public static boolean isPreviewAntialiasing() {
        return prDialogSettings.isAntialiasing();
    }

    public static void setPreviewAntialiasing(boolean bl) {
        prDialogSettings.setAntialiasing(bl);
    }

    public static boolean isPreviewMaximized() {
        return prDialogSettings.isMaximized();
    }

    public static void setPreviewMaximized(boolean bl) {
        prDialogSettings.setMaximized(bl);
    }

    public static double getPreviewScale() {
        return prDialogSettings.getScale();
    }

    public static void setPreviewScale(double d2) {
        prDialogSettings.setScale(d2);
    }

    public static void setPreviewSize(int n2, int n3) {
        Rectangle rectangle = prDialogSettings.getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setSize(n2, n3);
        prDialogSettings.setBounds(rectangle);
    }

    public static Dimension getPreviewSize() {
        Rectangle rectangle = prDialogSettings.getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle.getSize();
    }

    public static void setPreviewLocation(int n2, int n3) {
        Rectangle rectangle = prDialogSettings.getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.setLocation(n2, n3);
        prDialogSettings.setBounds(rectangle);
    }

    public static Point getPreviewLocation() {
        Rectangle rectangle = prDialogSettings.getBounds();
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        return rectangle.getLocation();
    }

    public static boolean isShowPrintButton() {
        return prDialogSettings.getShowPrintButton();
    }

    public static void setShowPrintButton(boolean bl) {
        prDialogSettings.setShowPrintButton(bl);
    }

    public static boolean isShowPrintSetupButton() {
        return prDialogSettings.getShowPrintSetupButton();
    }

    public static void setShowPrintSetupButton(boolean bl) {
        prDialogSettings.setShowPrintSetupButton(bl);
    }

    public static boolean isShowSaveButton() {
        return prDialogSettings.getShowSaveButton();
    }

    public static void setShowSaveButton(boolean bl) {
        prDialogSettings.setShowSaveButton(bl);
    }

    public static boolean isShowThumbnailsButton() {
        return prDialogSettings.getShowThumbnailsButton();
    }

    public static void setShowThumbnailsButton(boolean bl) {
        prDialogSettings.setShowThumbnailsButton(bl);
    }

    public static boolean isShowThumbnails() {
        return prDialogSettings.getShowThumbnails();
    }

    public static void setShowThumbnails(boolean bl) {
        prDialogSettings.setShowThumbnails(bl);
    }

    public static boolean isShowExportMenu() {
        return prDialogSettings.isShowExportMenu();
    }

    public static void setShowExportMenu(boolean bl) {
        prDialogSettings.setShowExportMenu(bl);
    }

    public PrintRequestAttributeSet getPrintRequestAttributeSet() {
        return this.aset;
    }

    public void setSavedPrintRequestAttributeSet(PrintRequestAttributeSet printRequestAttributeSet) {
        if (this.asetSave == null) {
            this.asetSave = printRequestAttributeSet;
        }
    }

    public void restorePrintRequestAttributeSet() {
        if (this.asetSave != null) {
            this.aset = this.asetSave;
            this.asetSave = null;
        }
    }

    public static ImageIcon getImageIcon() {
        return prDialogSettings.getIconImage() != null ? new ImageIcon(prDialogSettings.getIconImage()) : null;
    }

    public static void setImageIcon(ImageIcon imageIcon) {
        prDialogSettings.setIconImage(imageIcon != null ? imageIcon.getImage() : null);
    }

    public static boolean isShowPrintDialog() {
        return prDialogSettings.getShowPrintDialog();
    }

    public static boolean isCloseWindowAfterPrint() {
        return prDialogSettings.isCloseWindowAfterPrint();
    }

    public static void setCloseWindowAfterPrint(boolean bl) {
        prDialogSettings.setCloseWindowAfterPrint(bl);
    }

    public static boolean isCloseWindowAfterPrintPdf() {
        return prDialogSettings.isCloseWindowAfterPrintPdf();
    }

    public static void setCloseWindowAfterPrintPdf(boolean bl) {
        prDialogSettings.setCloseWindowAfterPrintPdf(bl);
    }

    public static String getSaveDefaultDirectory() {
        return prDialogSettings.getSaveDefaultDirectory();
    }

    public static void setSaveDefaultDirectory(String string) {
        prDialogSettings.setSaveDefaultDirectory(string);
    }

    public static String getSaveDefaultFilename() {
        return prDialogSettings.getSaveDefaultFilename();
    }

    public static void setSaveDefaultFilename(String string) {
        prDialogSettings.setSaveDefaultFilename(string);
    }

    public static Color getPrintableAreaBoxColor() {
        return prDialogSettings.getPrintableAreaBoxColor();
    }

    public static void setPrintableAreaBoxColor(Color color) {
        prDialogSettings.setPrintableAreaBoxColor(color);
    }

    public static void setShowPrintDialog(boolean bl) {
        prDialogSettings.setShowPrintDialog(bl);
    }

    public static void addMenu(String string, String string2, ImageIcon imageIcon, int n2) {
        prDialogSettings.addMenu(string, string2, imageIcon, n2);
    }

    public static void removeMenu(String string) {
        prDialogSettings.removeMenu(string);
    }

    static MediaSizeName getDefaultLocaleMediaSizeName() {
        String string = System.getProperty("iscobol.resource.country", System.getProperty("user.country"));
        if (Locale.US.getCountry().equals(string) || Locale.CANADA.getCountry().equals(string)) {
            return MediaSizeName.NA_LETTER;
        }
        return MediaSizeName.ISO_A4;
    }

    public boolean isSearchKeyEvent(int n2, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = false;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            bl4 = this.gf.getRemoteVirtualKeyboard().isSearchKey(n2, bl, bl2, bl3, searchpreviewname);
        }
        return bl4;
    }

    public int[] getSearchChars() {
        int[] nArray = null;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            nArray = this.gf.getRemoteVirtualKeyboard().getSearchChars(searchpreviewname);
        }
        return nArray;
    }

    public int[] getSearchMasks() {
        int[] nArray = null;
        if (this.gf != null && this.gf.getRemoteVirtualKeyboard() != null) {
            nArray = this.gf.getRemoteVirtualKeyboard().getSearchMasks(searchpreviewname);
        }
        return nArray;
    }

    static {
        int n2;
        Class<?> clazz;
        try {
            clazz = Class.forName("sun.print.Win32MediaTray");
            RtsUtil.openModule(clazz, SpoolPrinter.class, "sun.print");
        }
        catch (Throwable throwable) {
            clazz = null;
        }
        win32mt = clazz;
        try {
            n2 = Integer.parseInt(System.getProperty("java.version").split("\\.")[0]);
        }
        catch (Exception exception) {
            n2 = 0;
        }
        javaMajorVersion = n2;
        mediaTrays = new MediaTray[]{null, MediaTray.TOP, MediaTray.BOTTOM, MediaTray.MIDDLE, MediaTray.MANUAL, MediaTray.ENVELOPE, SpoolPrinter.getWinMediaTray("ENVELOPE_MANUAL"), SpoolPrinter.getWinMediaTray("AUTO"), SpoolPrinter.getWinMediaTray("TRACTOR"), SpoolPrinter.getWinMediaTray("SMALL_FORMAT"), SpoolPrinter.getWinMediaTray("LARGE_FORMAT"), MediaTray.LARGE_CAPACITY, MediaTray.SIDE, MediaTray.MAIN, null, SpoolPrinter.getWinMediaTray("FORMSOURCE")};
        mediaSizes = new MediaSizeName[]{null, MediaSizeName.NA_LETTER, new CustomMediaSizeName("Letter Small", 8.5f, 11.0f, 25400), MediaSizeName.TABLOID, MediaSizeName.LEDGER, MediaSizeName.NA_LEGAL, new CustomMediaSizeName("Statement 5 1/2 x 8 1/2 in", 5.5f, 8.5f, 25400), MediaSizeName.EXECUTIVE, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, new CustomMediaSizeName("A4 Small", 210, 297, 1000), MediaSizeName.ISO_A5, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.NA_10X14_ENVELOPE, new CustomMediaSizeName("11x17 in", 11, 17, 25400), new CustomMediaSizeName("Note 8 1/2 x 11 in", 8.5f, 11.0f, 25400), MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, new CustomMediaSizeName("Envelope DL 110 x 220mm", 110, 220, 1000), MediaSizeName.ISO_C5, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C6, new CustomMediaSizeName("Envelope C65 114 x 229 mm", 114, 229, 1000), MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, new CustomMediaSizeName("US Std Fanfold 14 7/8 x 11 in", 7.8f, 11.0f, 25400), new CustomMediaSizeName("German Std Fanfold 8 1/2 x 12 in", 8.5f, 12.0f, 25400), new CustomMediaSizeName("German Legal Fanfold 8 1/2 x 13 in", 8.5f, 13.0f, 25400), new CustomMediaSizeName("B4 (ISO)", 250, 353, 1000), MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.NA_9X11_ENVELOPE, new CustomMediaSizeName("10 x 11 in", 10.0f, 11.0f, 25400), new CustomMediaSizeName("15 x 11 in", 11, 15, 25400), new CustomMediaSizeName("Envelope Invite 220 x 220 mm", 220, 220, 1000), null, null, new CustomMediaSizeName("US Letter Extra 9 1/2 x 12 in", 9.5f, 12.0f, 25400), new CustomMediaSizeName("US Legal Extra 9 1/2 x 15 in", 9.5f, 15.0f, 25400), new CustomMediaSizeName("US Tabloid Extra 11.69 x 18 in", 11.69f, 18.0f, 25400), new CustomMediaSizeName("A4 Extra 9.27 x 12.69 in ", 9.27f, 12.69f, 25400), new CustomMediaSizeName("Letter Transverse 8 1/2 x 11 in", 8.5f, 11.0f, 25400), new CustomMediaSizeName("A4 Transverse 210 x 297 mm", 210, 297, 1000), new CustomMediaSizeName("Letter Extra Transverse 9 1/2 x 12 in", 9.5f, 12.0f, 25400), new CustomMediaSizeName("SuperA/SuperA/A4 227 x 356 mm", 227, 356, 1000), new CustomMediaSizeName("SuperB/SuperB/A3 305 x 487 mm", 305, 487, 1000), new CustomMediaSizeName("US Letter Plus 8.5 x 12.69 in", 8.5f, 12.69f, 25400), new CustomMediaSizeName("A4 Plus 210 x 330 mm", 210, 330, 1000), new CustomMediaSizeName("A5 Transverse 148 x 210 mm", 148, 210, 1000), new CustomMediaSizeName("B5 (JIS) Transverse 182 x 257 mm", 182, 257, 1000), new CustomMediaSizeName("A3 Extra 322 x 445 mm", 322, 445, 1000), new CustomMediaSizeName("A5 Extra 174 x 235 mm", 174, 235, 1000), new CustomMediaSizeName("B5 (ISO) Extra 201 x 276 mm", 201, 276, 1000), MediaSizeName.ISO_A2, new CustomMediaSizeName("A3 Transverse 297 x 420 mm", 297, 420, 1000), new CustomMediaSizeName("A3 Extra Transverse 322 x 445 mm", 322, 445, 1000), MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.ISO_A6, null};
        prDialogSettings = new PreviewDialogSettings();
    }

    protected static class Setting {
        protected PrintService currentPrinter;
        private OrientationRequested currOrientation = OrientationRequested.PORTRAIT;
        private PrintQuality currQuality = null;
        private MediaSizeName currMediaSizeName = SpoolPrinter.getDefaultLocaleMediaSizeName();
        private MediaTray currMediaTray;
        private int currUnits = 2;

        protected Setting() {
        }

        Setting copy() {
            Setting setting = new Setting();
            setting.currentPrinter = this.currentPrinter;
            setting.currOrientation = this.currOrientation;
            setting.currQuality = this.currQuality;
            setting.currMediaSizeName = this.currMediaSizeName;
            setting.currMediaTray = this.currMediaTray;
            setting.currUnits = this.currUnits;
            return setting;
        }
    }
}

