/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.SpoolPrinter;
import java.awt.Point;
import java.awt.print.Printable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.ServiceUI;
import javax.print.SimpleDoc;
import javax.print.event.PrintJobAttributeEvent;
import javax.print.event.PrintJobAttributeListener;

public class SpoolPrinterDirect
extends SpoolPrinter
implements RuntimeErrorsNumbers,
Printable {
    private DocFlavor format;
    private File file;
    private OutputStream out;
    private InputStream inp;

    public SpoolPrinterDirect(AbstractGuiFactoryImpl abstractGuiFactoryImpl) {
        super(abstractGuiFactoryImpl);
    }

    @Override
    protected void init() {
        this.format = DocFlavor.INPUT_STREAM.AUTOSENSE;
        this.services = PrintServiceLookup.lookupPrintServices(this.format, this.aset);
        this.setting.currentPrinter = null;
        try {
            this.file = File.createTempFile("prt", ".prt");
            this.file.deleteOnExit();
            this.out = new FileOutputStream(this.file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new IscobolRuntimeException(8, fileNotFoundException.toString());
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    @Override
    public boolean setup() {
        boolean bl;
        PrintService printService = ServiceUI.printDialog(null, 0, 0, this.services, this.getCurrPrintService(), this.format, this.aset);
        if (printService != null) {
            this.setting.currentPrinter = printService;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public void setFont(Hashtable hashtable) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setFont(int n2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public Point getPageLayout(Hashtable hashtable) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setMargins(double d2, double d3, double d4, double d5, int n2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setColor(int n2, int n3, int n4) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void printBitmap(byte[] byArray, double d2, double d3, double d4, double d5, int n2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void drawGraph(int n2, double d2, double d3, double d4, double d5, int n3) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setGraphPen(int n2, double d2, int n3, int n4, int n5) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setGraphBrush(int n2, int n3, int n4, int n5) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setDataColumns(int[] nArray) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setPageColumn(boolean bl, double d2, double d3, double d4, int n2, int n3, char c2, boolean bl2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void clearPageColumn() {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    public void setCursor(double d2, double d3, double[] dArray, double[] dArray2, int n2, int n3) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setOrientation(int n2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public void setQuality(int n2) {
        throw new IscobolRuntimeException(4, "SPOOLER-DIRECT");
    }

    @Override
    public boolean setPrinter(String string) {
        for (int i2 = 0; i2 < this.services.length; ++i2) {
            if (!this.services[i2].getName().equals(string)) continue;
            this.setting.currentPrinter = this.services[i2];
            return true;
        }
        return false;
    }

    @Override
    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    @Override
    public void write(char[] cArray) {
    }

    @Override
    public void write(char[] cArray, int n2, int n3) {
        this.write(new String(cArray), n2, n3);
    }

    @Override
    public void write(int n2) {
    }

    public void write(String string) {
        try {
            this.out.write(string.getBytes());
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    public void write(String string, int n2, int n3) {
        try {
            this.out.write(string.getBytes(), n2, n3);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
    }

    @Override
    public void close() {
        try {
            this.out.close();
            PrintService printService = this.getCurrPrintService();
            if (printService != null) {
                DocPrintJob docPrintJob = printService.createPrintJob();
                docPrintJob.addPrintJobAttributeListener(new PrintJobAttributeListener(){

                    @Override
                    public void attributeUpdate(PrintJobAttributeEvent printJobAttributeEvent) {
                        System.out.println(printJobAttributeEvent);
                    }
                }, null);
                this.inp = new FileInputStream(this.file);
                SimpleDoc simpleDoc = new SimpleDoc(this.inp, this.format, null);
                docPrintJob.print(simpleDoc, this.aset);
                if (this.file != null) {
                    this.file.delete();
                }
            }
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(8, iOException.toString());
        }
        catch (PrintException printException) {
            printException.printStackTrace();
        }
    }
}

