/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.print.LocalSpoolPrinter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class SpoolPrinterList {
    private int prog;
    private Map<Integer, LocalSpoolPrinter> spoolPrinters = new HashMap<Integer, LocalSpoolPrinter>();
    private Stack<LocalSpoolPrinter> spoolPrinterStack = new Stack();
    private Stack<LocalSpoolPrinter> ssSpoolPrinterStack = new Stack();
    private boolean serverSide;

    public static SpoolPrinterList get() {
        SpoolPrinterList spoolPrinterList = (SpoolPrinterList)IscobolSystem.get(SpoolPrinterList.class);
        if (spoolPrinterList == null) {
            spoolPrinterList = new SpoolPrinterList();
            IscobolSystem.set(SpoolPrinterList.class, spoolPrinterList);
        }
        return spoolPrinterList;
    }

    public boolean isServerSide() {
        return this.serverSide;
    }

    public void setServerSide(boolean bl) {
        this.serverSide = bl;
    }

    public void setCurrentSpoolPrinter(LocalSpoolPrinter localSpoolPrinter) throws IOException {
        if (localSpoolPrinter != null) {
            if (localSpoolPrinter.isServerSide()) {
                if (this.ssSpoolPrinterStack.contains(localSpoolPrinter)) {
                    this.ssSpoolPrinterStack.remove(localSpoolPrinter);
                }
                this.ssSpoolPrinterStack.push(localSpoolPrinter);
            } else {
                if (this.spoolPrinterStack.contains(localSpoolPrinter)) {
                    this.spoolPrinterStack.remove(localSpoolPrinter);
                }
                this.spoolPrinterStack.push(localSpoolPrinter);
            }
        } else {
            this.spoolPrinterStack.clear();
            this.ssSpoolPrinterStack.clear();
        }
    }

    public LocalSpoolPrinter getCurrentSpoolPrinter() throws IOException {
        if (this.serverSide) {
            if (this.ssSpoolPrinterStack.isEmpty()) {
                this.newSpoolPrinter(0);
            }
            return this.ssSpoolPrinterStack.peek();
        }
        if (this.spoolPrinterStack.isEmpty()) {
            this.newSpoolPrinter(0);
        }
        return this.spoolPrinterStack.peek();
    }

    public LocalSpoolPrinter newSpoolPrinter() throws IOException {
        return this.newSpoolPrinter(++this.prog);
    }

    private LocalSpoolPrinter newSpoolPrinter(int n2) throws IOException {
        LocalSpoolPrinter localSpoolPrinter = null;
        if (this.serverSide) {
            if (!this.ssSpoolPrinterStack.isEmpty()) {
                localSpoolPrinter = this.ssSpoolPrinterStack.peek();
            }
        } else if (!this.spoolPrinterStack.isEmpty()) {
            localSpoolPrinter = this.spoolPrinterStack.peek();
        }
        LocalSpoolPrinter localSpoolPrinter2 = new LocalSpoolPrinter(n2, this.serverSide, localSpoolPrinter);
        this.spoolPrinters.put(n2, localSpoolPrinter2);
        if (this.serverSide) {
            this.ssSpoolPrinterStack.push(localSpoolPrinter2);
        } else {
            this.spoolPrinterStack.push(localSpoolPrinter2);
        }
        return localSpoolPrinter2;
    }

    public LocalSpoolPrinter newSpoolPrinter(boolean bl, boolean bl2, boolean bl3, String string, boolean bl4) throws IOException {
        return this.newSpoolPrinter(bl, bl2, bl3, string, bl4, null);
    }

    public LocalSpoolPrinter newSpoolPrinter(boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, Events events) throws IOException {
        String string2;
        LocalSpoolPrinter localSpoolPrinter = null;
        if (this.serverSide) {
            if (!this.ssSpoolPrinterStack.isEmpty()) {
                localSpoolPrinter = this.ssSpoolPrinterStack.peek();
            }
        } else if (!this.spoolPrinterStack.isEmpty()) {
            localSpoolPrinter = this.spoolPrinterStack.peek();
        }
        if ((string2 = Config.a("iscobol.print.default_font", null)) != null) {
            ScreenUtility.getGuiFactory().setProperty("iscobol.print.default_font", string2);
        }
        LocalSpoolPrinter localSpoolPrinter2 = new LocalSpoolPrinter(++this.prog, bl, bl2, bl3, string, bl4, events, this.serverSide, localSpoolPrinter);
        this.spoolPrinters.put(this.prog, localSpoolPrinter2);
        if (this.serverSide) {
            this.ssSpoolPrinterStack.push(localSpoolPrinter2);
        } else {
            this.spoolPrinterStack.push(localSpoolPrinter2);
        }
        return localSpoolPrinter2;
    }

    public LocalSpoolPrinter getSpoolPrinter(int n2) {
        return this.spoolPrinters.get(n2);
    }

    public LocalSpoolPrinter removeSpoolPrinter(int n2) throws IOException {
        LocalSpoolPrinter localSpoolPrinter = this.spoolPrinters.remove(n2);
        if (localSpoolPrinter != null) {
            if (localSpoolPrinter.isServerSide()) {
                this.ssSpoolPrinterStack.remove(localSpoolPrinter);
            } else {
                this.spoolPrinterStack.remove(localSpoolPrinter);
            }
        }
        return localSpoolPrinter;
    }
}

