/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.rts.CallManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.IDumpCreator;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolStackTraceElement;
import com.iscobol.rts.Version;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import java.lang.reflect.Field;
import java.util.Date;

public class DumpCreator
implements IDumpCreator {
    private StringBuffer dumpInfo;

    @Override
    public void dump(IscobolStackTraceElement[] iscobolStackTraceElementArray) {
        if (!Config.b(".exception.dump", false)) {
            return;
        }
        CallManager callManager = Factory.getCalls();
        String string = System.getProperty("line.separator", "\n");
        this.dumpInfo = new StringBuffer();
        this.dumpInfo.append("=== Dump created: ");
        this.dumpInfo.append(new Date());
        this.dumpInfo.append(string);
        if (iscobolStackTraceElementArray == null || iscobolStackTraceElementArray.length <= 0) {
            this.dumpInfo.append("!!! NO INFORMATION AVAILABLE !");
            this.dumpInfo.append(string);
            return;
        }
        Class clazz = iscobolStackTraceElementArray[0].clazz;
        Object object = callManager.get(iscobolStackTraceElementArray[0].declaringClass);
        this.dumpInfo.append("=== Program: ");
        this.dumpInfo.append(clazz.getName());
        if (object instanceof IscobolClass) {
            this.dumpInfo.append(", compiled: ");
            this.dumpInfo.append(((IscobolClass)object).iscobolVersion());
            this.dumpInfo.append(", requires: ");
            this.dumpInfo.append(((IscobolClass)object).iscobolRequired());
        }
        this.dumpInfo.append(string);
        this.dumpInfo.append("=== Command line arguments: ");
        String[] stringArray = Factory.get().gArgs;
        if (stringArray != null) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                this.dumpInfo.append(stringArray[i2]);
                this.dumpInfo.append(' ');
            }
        }
        this.dumpInfo.append(string);
        this.dumpInfo.append("=== isCOBOL Version: ");
        this.dumpInfo.append(Version.getVersion());
        this.dumpInfo.append(string);
        this.dumpInfo.append("=== Java version: ");
        this.dumpInfo.append(System.getProperty("java.version"));
        this.dumpInfo.append(" ");
        this.dumpInfo.append(System.getProperty("java.vendor"));
        this.dumpInfo.append(string);
        this.dumpInfo.append("=== Current loaded programs ===");
        this.dumpInfo.append(string);
        for (String fieldArray : callManager.keySet()) {
            this.dumpInfo.append(" ");
            this.dumpInfo.append(fieldArray);
            this.dumpInfo.append(string);
        }
        this.dumpInfo.append("=== Memory dump ===");
        this.dumpInfo.append(string);
        if (object != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!CobolVar.class.isAssignableFrom(fieldArray[i2].getType())) continue;
                try {
                    fieldArray[i2].setAccessible(true);
                    CobolVar cobolVar = (CobolVar)fieldArray[i2].get(object);
                    if (cobolVar.isFinal() || cobolVar.getParent() != null) continue;
                    try {
                        cobolVar.dump(this.dumpInfo, string);
                    }
                    catch (Throwable illegalAccessException) {
                        System.out.println("" + fieldArray[i2].getName() + "," + illegalAccessException);
                    }
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    this.dumpInfo.append(fieldArray[i2].getName());
                    this.dumpInfo.append("(informations unavailable)");
                    this.dumpInfo.append(string);
                }
            }
        }
    }

    @Override
    public String getDumpInfo() {
        return this.dumpInfo != null ? this.dumpInfo.toString() : null;
    }
}

