/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.as.ClientInfo;
import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LayoutExceptionCobol;
import com.iscobol.rts_n.DumpCreator;
import com.iscobol.rts_n.Factory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class ErrorBox {
    public static final String DUMP_EXT = ".ads.log";

    public static void show(Throwable throwable) {
        LayoutExceptionCobol layoutExceptionCobol = new LayoutExceptionCobol(throwable, new DumpCreator());
        if (!Factory.errorShow(layoutExceptionCobol)) {
            ErrorBox.showDirect(layoutExceptionCobol, true);
        }
    }

    public static void showDirect(Throwable throwable) {
        ErrorBox.showDirect(new LayoutExceptionCobol(throwable, new DumpCreator()), true);
    }

    public static void showDirect(LayoutExceptionCobol layoutExceptionCobol, boolean bl) {
        int n2;
        StringWriter stringWriter = new StringWriter();
        layoutExceptionCobol.printStackTrace(new PrintWriter(stringWriter));
        String string = layoutExceptionCobol.getLocalizedMessage();
        if (string == null || string.length() == 0) {
            string = layoutExceptionCobol.getClass().getName() + " caught!";
        }
        if ((n2 = Config.a(".exception.message", ".exception_message", -1)) == -1) {
            n2 = Config.a(".display_message", 0);
        }
        switch (n2) {
            case 0: {
                GuiFactory guiFactory = ScreenUtility.getGuiFactory();
                DisplayWindow displayWindow = ScrFactory.getGUIEnviroment().getGlobActiveWindow();
                try {
                    guiFactory.showError(string, stringWriter.getBuffer().toString(), displayWindow != null && !displayWindow.isDestroyed() ? displayWindow.getTheObjectId() : -1);
                }
                catch (IOException iOException) {}
                break;
            }
            case 1: {
                System.out.println(stringWriter.getBuffer().toString());
                break;
            }
            default: {
                System.err.println(stringWriter.getBuffer().toString());
                break;
            }
            case 3: {
                ClientInfo clientInfo = (ClientInfo)IscobolSystem.get(ClientInfo.class);
                ErrorBox.dumpfile(layoutExceptionCobol.getName(), clientInfo != null ? clientInfo.getHostAddress() : null, clientInfo != null ? clientInfo.getUserName() : null, stringWriter.getBuffer().toString());
            }
        }
        Factory.stopRun(255, bl);
    }

    public static void dumpfile(String string, String string2) {
        ErrorBox.dumpfile(string, null, null, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dumpfile(String string, String string2, String string3, String string4) {
        PrintWriter printWriter = null;
        String string5 = Config.a("iscobol.exception.dumpfile", null);
        if (string5 != null && (string5 = string5.trim()).length() > 0) {
            boolean bl = false;
            if (string5.charAt(0) == '+') {
                bl = true;
                if ((string5 = string5.substring(1)).length() == 0) {
                    string5 = string;
                }
            }
            try {
                int n2;
                String string6;
                if (string5.indexOf("%p") >= 0) {
                    string5 = string5.replace("%p", string);
                }
                GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                if (string5.indexOf("%d") >= 0) {
                    string6 = "" + gregorianCalendar.get(1);
                    n2 = gregorianCalendar.get(2) + 1;
                    if (n2 < 10) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    n2 = gregorianCalendar.get(5);
                    if (n2 < 10) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    string5 = string5.replace("%d", string6);
                }
                if (string5.indexOf("%t") >= 0) {
                    string6 = "";
                    n2 = gregorianCalendar.get(11);
                    if (n2 < 10) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    n2 = gregorianCalendar.get(12);
                    if (n2 < 10) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    n2 = gregorianCalendar.get(13);
                    if (n2 < 10) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    n2 = gregorianCalendar.get(14);
                    if (n2 < 10) {
                        string6 = string6 + "00";
                    } else if (n2 < 100) {
                        string6 = string6 + "0";
                    }
                    string6 = string6 + n2;
                    string5 = string5.replace("%t", string6);
                }
                if (string5.indexOf("%u") >= 0) {
                    if (string3 == null) {
                        string3 = System.getProperty("user.name");
                    }
                    string5 = string5.replace("%u", string3);
                }
                if (string5.indexOf("%h") >= 0) {
                    if (string2 == null) {
                        try {
                            string2 = InetAddress.getLocalHost().getHostAddress();
                            string5 = string5.replace("%h", string2);
                        }
                        catch (UnknownHostException unknownHostException) {}
                    } else {
                        string5 = string5.replace("%h", string2);
                    }
                }
                printWriter = new PrintWriter(new FileOutputStream(string5, bl));
                printWriter.print(string4);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        } else {
            string = Config.a(".exception.prefix", "") + string;
            try {
                for (int i2 = 0; i2 >= 0; ++i2) {
                    string5 = i2 < 10 ? string + "000" + i2 + DUMP_EXT : (i2 < 100 ? string + "00" + i2 + DUMP_EXT : (i2 < 1000 ? string + "0" + i2 + DUMP_EXT : string + i2 + DUMP_EXT));
                    File file = new File(string5);
                    if (!file.createNewFile()) continue;
                    printWriter = new PrintWriter(new FileOutputStream(file));
                    printWriter.print(string4);
                    return;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (printWriter != null) {
                    printWriter.close();
                }
            }
        }
    }
}

