/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.CallManager;
import com.iscobol.rts.Config;
import com.iscobol.rts.IEsqlCursor;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.EsqlHostVar;
import com.iscobol.rts_n.EsqlPrepare;
import com.iscobol.rts_n.EsqlRuntime;
import com.iscobol.rts_n.Factory;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.ObjectVar;
import com.iscobol.types_n.PicNativeDouble;
import com.iscobol.types_n.PicNativeFloat;
import com.iscobol.types_n.PicX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.Vector;
import java.util.function.Consumer;

public class EsqlCursor
implements IEsqlCursor {
    public static final int SQL_FETCH_NEXT = 1;
    public static final int SQL_FETCH_FIRST = 2;
    public static final int SQL_FETCH_LAST = 3;
    public static final int SQL_FETCH_PRIOR = 4;
    public static final int SQL_FETCH_ABSOLUTE = 5;
    public static final int SQL_FETCH_RELATIVE = 6;
    public static final int SQL_FETCH_OK = 0;
    public static final int SQL_FETCH_TRUNC = 1;
    public static final int SQL_FETCH_NOTFOUND = -1;
    public static final int TRIM_NONE = -1;
    public static final int TRIM_ALL = 0;
    public static final int TRIM_LEAVE1 = 1;
    public static final int TRIM_ALL2 = 2;
    String name;
    Object owner;
    private String query;
    private EsqlPrepare prep;
    protected ResultSet hstmt;
    private Vector params = new Vector();
    private Vector bindCols = new Vector();
    public Vector db2BindCols = new Vector();
    public Vector rowsetCols = new Vector();
    public CobolVar descr;
    private boolean statNoData;
    private boolean call;
    private boolean cursorOutEnd;
    private boolean rowset;
    private int rowCount;
    private int type;
    private int holdability;
    private boolean updt;
    private boolean nullResult;
    private PreparedStatement tmpStmt;
    private SQLWarning warnings;
    private String prepName = "";
    private final Integer withReturn;
    int handle;
    private Consumer<ResultSet> rsListener;
    private final Logger log = LoggerFactory.get(2048);

    public EsqlCursor(String string, int n2, Object object, Object object2) {
        this.name = string;
        this.type = n2;
        this.owner = object;
        if (object2 == Boolean.TRUE) {
            object2 = Integer.MAX_VALUE;
        }
        if (!(object2 instanceof Integer)) {
            object2 = 0;
        }
        this.withReturn = (Integer)object2;
        this.handle = UserHandles.ssetId(this);
        if (this.withReturn > 0) {
            String string2 = com.iscobol.rts.Factory.getd((boolean)true).getTdd().activeCalls.peekName();
            CallManager callManager = Factory.getCalls();
            callManager.putEsqlCursor(string2, this);
        }
    }

    @Override
    public void setResultSetListener(Consumer<ResultSet> consumer) {
        this.rsListener = consumer;
    }

    @Override
    public Integer getWithReturn() {
        return this.withReturn;
    }

    public int getHoldability() {
        return this.holdability;
    }

    public int getType() {
        return this.type;
    }

    public String getQuery() {
        if (this.prep != null) {
            return this.prep.getQuery();
        }
        return this.query;
    }

    public boolean is(String string, Object object) {
        return object == this.owner && this.name.equals(string);
    }

    private void init() throws SQLException {
        this.nullResult = false;
        this.cursorOutEnd = false;
        this.warnings = null;
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: before close RS " + this.hstmt);
            }
            this.hstmt.close();
            this.setResultSet(null);
        }
        if (this.tmpStmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: before close PS " + this.tmpStmt);
            }
            this.tmpStmt.close();
            this.tmpStmt = null;
        }
    }

    protected void setResultSet(ResultSet resultSet) {
        this.hstmt = resultSet;
        if (this.rsListener != null) {
            this.rsListener.accept(this.hstmt);
        }
    }

    public void close() throws SQLException {
        if (this.log != null) {
            this.log.info("Developers log: EsqlCursor: in close RS " + this.hstmt);
        }
        this.init();
        this.query = null;
        UserHandles.free(this.handle);
        this.handle = 0;
    }

    public boolean isCursorOutEnd() {
        return this.cursorOutEnd;
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public boolean isCall() {
        return this.call;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public void setPrepare(EsqlPrepare esqlPrepare) {
        if (esqlPrepare == null && this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlCursor: before close RS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.prep = esqlPrepare;
        this.query = null;
        this.cursorOutEnd = false;
        this.statNoData = esqlPrepare.isStatNoData();
    }

    public void setQuery(String string) {
        this.prep = null;
        this.statNoData = EsqlRuntime.isStatNoData(string);
        this.call = EsqlRuntime.isCall(string);
        this.query = string;
    }

    void setType(int n2) {
        this.type = n2;
    }

    void setHoldability(int n2) {
        this.holdability = n2;
    }

    void setUpdatable() {
        this.updt = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean open(Connection connection) throws SQLException {
        boolean bl = false;
        try {
            this.init();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (this.prep == null && this.query != null) {
            if (this.rowset) {
                this.type = 1004;
            }
            this.tmpStmt = EsqlRuntime.getStatement(connection, this.query, this.type, this.holdability, this.updt);
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: after open PS " + this.tmpStmt);
            }
            if (Config.a(".jdbc.fetch_size", 0) != 0) {
                this.tmpStmt.setFetchSize(Config.a(".jdbc.fetch_size", 0));
            }
            this.setParams(this.tmpStmt);
            this.callExecuteHook(this.query, this.tmpStmt);
            this.rowCount = 0;
            this.setResultSet(null);
            try {
                bl = this.tmpStmt.execute();
                if (bl) {
                    this.setResultSet(this.tmpStmt.getResultSet());
                    if (this.log != null) {
                        this.log.info("Developers log: EsqlCursor: after open RS " + this.hstmt);
                    }
                } else {
                    this.rowCount = this.tmpStmt.getUpdateCount();
                }
                this.warnings = this.tmpStmt.getWarnings();
                if (!(this.tmpStmt instanceof CallableStatement)) return bl;
                EsqlRuntime.fillHostVars((CallableStatement)this.tmpStmt, this.params);
                this.nullResult = EsqlRuntime.searchNullWithoutInd(this.params);
                return bl;
            }
            finally {
                try {
                    if (this.hstmt == null) {
                        if (this.log != null) {
                            this.log.info("Developers log: EsqlCursor: before close PS " + this.tmpStmt);
                        }
                        this.tmpStmt.close();
                        this.tmpStmt = null;
                    }
                }
                catch (SQLException sQLException) {}
            }
        }
        if (this.prep != null && this.query == null) {
            this.prep.setParams(this);
            this.setResultSet(this.prep.exec(this.type, this.holdability, this));
            if (this.log != null) {
                this.log.info("Developers log: EsqlCursor: after open RS " + this.hstmt);
            }
            this.rowCount = this.prep.getRowCount();
            if (this.hstmt == null) return false;
            return true;
        }
        EsqlRuntime.esqlError(3, ": Cursor open");
        return bl;
    }

    public boolean updateHostVars() throws SQLException {
        boolean bl = true;
        int n2 = this.rowsetCols.size();
        for (int i2 = 1; i2 < n2; ++i2) {
            EsqlHostVar esqlHostVar = (EsqlHostVar)this.rowsetCols.get(i2);
            if (esqlHostVar == null) continue;
            esqlHostVar.updateVar(i2, this.hstmt);
        }
        return bl;
    }

    void callExecuteHook(String string, Statement statement) {
        EsqlRuntime esqlRuntime = EsqlRuntime.get();
        if (esqlRuntime.hasExecuteHook()) {
            esqlRuntime.callExecuteHook(string, statement, this.params);
        }
    }

    public void bindCol(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        for (int i2 = this.bindCols.size(); i2 <= n3; ++i2) {
            this.bindCols.add(null);
        }
        this.bindCols.set(n3, new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2));
    }

    public void updCol(CobolVar cobolVar, String string, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        int n4;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": UPDATE ROWSET");
        }
        ResultSetMetaData resultSetMetaData = this.hstmt.getMetaData();
        for (n4 = 1; n4 <= resultSetMetaData.getColumnCount() && !string.equalsIgnoreCase(resultSetMetaData.getColumnName(n4)); ++n4) {
        }
        if (n4 > resultSetMetaData.getColumnCount()) {
            EsqlRuntime.esqlError(4, ": UPDATE ROWSET " + string);
        }
        for (int i2 = this.rowsetCols.size(); i2 <= n4; ++i2) {
            this.rowsetCols.add(null);
        }
        this.rowsetCols.set(n4, new EsqlHostVar(cobolVar, n2, n4, numericVar, numericVar2));
    }

    public void setParam(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) throws SQLException {
        this.setParam(cobolVar, n2, n3, numericVar, numericVar2, string, (short)-1);
    }

    public void setParam(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, short s2) throws SQLException {
        for (int i2 = this.params.size(); i2 <= n3; ++i2) {
            this.params.add(null);
        }
        this.params.set(n3, new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2, string, s2));
    }

    private boolean fillHostVars() throws SQLException {
        EsqlHostVar esqlHostVar;
        boolean bl = false;
        int n2 = this.bindCols.size();
        for (int i2 = 1; i2 < n2 && (esqlHostVar = (EsqlHostVar)this.bindCols.get(i2)) != null; ++i2) {
            bl |= esqlHostVar.toVar(i2, this.hstmt);
        }
        return bl;
    }

    public void setParams(PreparedStatement preparedStatement) throws SQLException {
        EsqlRuntime.setParams(preparedStatement, this.params);
    }

    public int fetch(int n2, boolean bl, int n3) throws SQLException {
        int n4;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": Fetch");
        }
        this.warnings = null;
        switch (n2) {
            default: {
                n4 = this.hstmt.next() ? 0 : -1;
                break;
            }
            case 2: {
                n4 = this.hstmt.first() ? 0 : -1;
                break;
            }
            case 3: {
                n4 = this.hstmt.last() ? 0 : -1;
                break;
            }
            case 4: {
                n4 = this.hstmt.previous() ? 0 : -1;
                break;
            }
            case 5: {
                n4 = this.hstmt.absolute(n3) ? 0 : -1;
                break;
            }
            case 6: {
                n4 = this.hstmt.relative(n3) ? 0 : -1;
            }
        }
        this.warnings = this.hstmt.getWarnings();
        if (n4 == 0 && bl) {
            int n5 = n4 = this.fillHostVars() ? 1 : 0;
        }
        if (n4 == 0) {
            ++this.rowCount;
        }
        this.nullResult = EsqlRuntime.searchNullWithoutInd(this.bindCols);
        if (n4 == -1) {
            this.cursorOutEnd = true;
        }
        return n4;
    }

    public int startRowset(int n2, boolean bl) throws SQLException {
        int n3 = 0;
        if (this.hstmt == null) {
            EsqlRuntime.esqlError(3, ": Fetch");
        }
        this.warnings = null;
        if (bl) {
            this.hstmt.absolute(n2);
        } else {
            this.hstmt.relative(n2);
        }
        return n3;
    }

    public int getHandle() {
        return this.handle;
    }

    public void updateCol(CobolVar cobolVar, String string, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        int n4 = Config.a(".jdbc.kept_spaces", 1);
        if (cobolVar instanceof PicNativeFloat) {
            this.hstmt.updateFloat(string, ((PicNativeFloat)cobolVar).tofloat());
        } else if (cobolVar instanceof PicNativeDouble) {
            this.hstmt.updateDouble(string, ((PicNativeDouble)cobolVar).todouble());
        } else if (cobolVar instanceof ObjectVar) {
            Object object = ((ObjectVar)cobolVar).getId();
            if (object != null) {
                if (object instanceof byte[]) {
                    this.hstmt.updateObject(string, (Object)((byte[])object));
                } else {
                    this.hstmt.updateObject(string, object);
                }
            } else {
                this.hstmt.updateNull(string);
            }
        } else if (cobolVar instanceof NumericVar) {
            this.hstmt.updateBigDecimal(string, ((NumericVar)cobolVar).num().bigDecimalValue());
        } else if (cobolVar instanceof PicX && cobolVar.isSqlBinary()) {
            int n5 = cobolVar.length();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(cobolVar.getMemory().toByteArray(cobolVar.getOffset(), n5), 0, n5);
            this.hstmt.updateBinaryStream(string, (InputStream)byteArrayInputStream, n5);
        } else {
            switch (n4) {
                case -1: {
                    if (numericVar2 != null && numericVar2.toint() < cobolVar.toString().length()) {
                        this.hstmt.updateString(string, cobolVar.toString().substring(0, numericVar2.toint()));
                        break;
                    }
                    this.hstmt.updateString(string, cobolVar.toString());
                    break;
                }
                case 0: 
                case 2: {
                    if (numericVar2 != null && numericVar2.toint() < EsqlCursor.rtrim(cobolVar, 0, n4).length()) {
                        this.hstmt.updateString(string, EsqlCursor.rtrim(cobolVar, 0, n4).substring(0, numericVar2.toint()));
                        break;
                    }
                    this.hstmt.updateString(string, EsqlCursor.rtrim(cobolVar, 0, n4));
                    break;
                }
                default: {
                    if (numericVar2 != null && numericVar2.toint() < EsqlCursor.rtrim(cobolVar, 1, n4).length()) {
                        this.hstmt.updateString(string, EsqlCursor.rtrim(cobolVar, 1, n4).substring(0, numericVar2.toint()));
                        break;
                    }
                    this.hstmt.updateString(string, EsqlCursor.rtrim(cobolVar, 1, n4));
                }
            }
        }
    }

    public void updateColDb2Reg(String string, String string2, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        int n4 = Config.a(".jdbc.kept_spaces", 1);
        if (this.hstmt == null) {
            throw new SQLException("Current null ", "99999");
        }
        this.hstmt.updateString(string2, string);
    }

    private static String rtrim(CobolVar cobolVar, int n2, int n3) {
        int n4;
        char[] cArray = cobolVar.toString().toCharArray();
        for (n4 = cArray.length - 1; n4 >= n2 && !(n3 == 2 ? cArray[n4] > ' ' : cArray[n4] > ' ' || cArray[n4] == '\u0000'); --n4) {
        }
        return new String(cArray, 0, n4 + 1);
    }

    public void updateRow() throws SQLException {
        this.hstmt.updateRow();
    }

    public void updateNull(String string) throws SQLException {
        this.hstmt.updateNull(string);
    }

    public void deleteRow() throws SQLException {
        this.hstmt.deleteRow();
    }

    public boolean next() throws SQLException {
        return this.hstmt.next();
    }

    public boolean absolute(int n2) throws SQLException {
        return this.hstmt.absolute(n2);
    }

    public void beforeFirst() throws SQLException {
        this.hstmt.beforeFirst();
    }

    public int getRow() throws SQLException {
        return this.hstmt.getRow();
    }

    public boolean hasNullResult() {
        return this.nullResult;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public String getQueryLog() {
        String string = "";
        string = this.prep != null ? this.prep.getQuery() : this.query;
        if (this.params.size() > 0) {
            int n2 = Config.a(".jdbc.kept_spaces", 1);
            string = string + " trimType[" + n2 + "] using[";
            for (int i2 = 1; i2 < this.params.size(); ++i2) {
                if (i2 > 1) {
                    string = string + ", ";
                }
                if (this.params.get(i2) != null) {
                    if (n2 == -1) {
                        string = string + "'" + ((EsqlHostVar)this.params.get(i2)).getVar().toString() + "'";
                        continue;
                    }
                    string = string + "'" + EsqlHostVar.rtrim(((EsqlHostVar)this.params.get(i2)).getVar(), n2, n2) + "'";
                    continue;
                }
                string = string + "null";
            }
        }
        return string;
    }

    public void searchCallExc() throws SQLException {
        if (this.tmpStmt != null && this.call) {
            while (this.tmpStmt.getMoreResults()) {
                if (this.log == null) continue;
                this.log.info("Developers log: EsqlPrepare in while moreResult " + this.hstmt + " call=" + this.call);
            }
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare moreResult " + this.hstmt + " call=" + this.call);
            }
        }
    }

    public EsqlPrepare getPrep() {
        return this.prep;
    }

    public ResultSet getResultSet() {
        return this.hstmt;
    }

    public void setRowset(boolean bl) {
        this.rowset = bl;
    }

    public boolean isRowset() {
        return this.rowset;
    }

    public void setPrepName(String string) {
        this.prepName = string;
    }

    public String getPrepName() {
        return this.prepName;
    }
}

