/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts_n.EsqlCursorHndl;
import com.iscobol.rts_n.EsqlRuntime;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.ObjectVar;
import com.iscobol.types_n.PicNativeDouble;
import com.iscobol.types_n.PicNativeFloat;
import com.iscobol.types_n.PicX;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;

public class EsqlHostVar {
    final Logger log = LoggerFactory.get(256);
    private static final String objNoColToGet = "columnNotEnought";
    public static final int HVT_UNKNOWN = 0;
    public static final int HVT_CSTRING = 1;
    public static final int HVT_SHORT = 2;
    public static final int HVT_LONG = 3;
    public static final int HVT_FLOAT = 4;
    public static final int HVT_DOUBLE = 5;
    public static final int HVT_CHARNUM = 6;
    public static final int HVT_COBALPHA = 7;
    public static final int HVT_PACKED = 8;
    public static final int HVT_BINARY = 9;
    public static final int TRIM_NONE = -1;
    public static final int TRIM_ALL = 0;
    public static final int TRIM_LEAVE1 = 1;
    public static final int TRIM_ALL2 = 2;
    public static final int MODE_IO_NONE = -1;
    public static final int MODE_IO_IN = 1;
    public static final int MODE_IO_OUT = 2;
    public static final int MODE_IO_INOUT = 3;
    public static SimpleDateFormat dateFormat;
    public static SimpleDateFormat timeFormat;
    public static DateTimeFormatter timestampFormat;
    public CobolVar hostVar;
    public int type;
    public int col;
    public short fSqlType;
    public NumericVar esqlInd;
    public boolean resultNull = false;
    public NumericVar esqlLen;
    public EsqlCursorHndl cursHndl;
    public int modeIO;
    private String name;
    private int specType;
    private short sqlType;
    static char[] HEX_ARRAY;

    public EsqlHostVar() {
    }

    public EsqlHostVar(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        this(cobolVar, n2, n3, numericVar, numericVar2, null);
    }

    public EsqlHostVar(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) {
        this(cobolVar, n2, n3, numericVar, numericVar2, string, -1);
    }

    public EsqlHostVar(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, short s2) {
        this.hostVar = cobolVar;
        this.type = n2;
        this.col = n3;
        this.type = n2;
        this.esqlInd = numericVar;
        this.esqlLen = numericVar2;
        this.modeIO = string == null ? -1 : ("IN".equals(string) ? 1 : ("OUT".equals(string) ? 2 : 3));
        this.fSqlType = cobolVar instanceof PicNativeFloat ? (short)7 : (cobolVar instanceof PicNativeDouble ? (short)8 : (cobolVar instanceof ObjectVar ? (short)-4 : (cobolVar instanceof NumericVar ? (short)2 : (short)1)));
        if (s2 != -1) {
            this.fSqlType = s2;
        }
    }

    private boolean toVar(int n2, ResultContainer resultContainer, int n3) throws SQLException {
        int n4 = 0;
        byte[] byArray = null;
        this.resultNull = false;
        if (this.hostVar instanceof PicNativeFloat) {
            ((PicNativeFloat)this.hostVar).set(resultContainer.getFloat(n2));
            n4 = 0;
        } else if (this.hostVar instanceof PicNativeDouble) {
            ((PicNativeDouble)this.hostVar).set(resultContainer.getDouble(n2));
            n4 = 0;
        } else if (this.hostVar instanceof ObjectVar) {
            Object object = null;
            if (this.hostVar.getName().startsWith("@")) {
                try {
                    object = resultContainer.getClob(n2);
                }
                catch (SQLException sQLException) {
                    object = resultContainer.getObject(n2);
                }
                ((ObjectVar)this.hostVar).setId(object);
            } else {
                ResultSetMetaData resultSetMetaData = resultContainer.getMetaData();
                if (resultSetMetaData != null) {
                    switch (resultSetMetaData.getColumnType(n2)) {
                        case 2004: {
                            Blob blob = resultContainer.getBlob(n2);
                            n4 = (int)blob.length();
                            object = blob.getBytes(1L, n4);
                            break;
                        }
                        default: {
                            object = resultContainer.getObject(n2);
                            break;
                        }
                    }
                } else {
                    object = null;
                }
                if (object != null) {
                    if (this.cursHndl != null) {
                        if (object instanceof ResultSet) {
                            this.cursHndl.setRs((ResultSet)object);
                        } else {
                            this.cursHndl.setRs(null);
                        }
                    } else {
                        ((ObjectVar)this.hostVar).setId(object);
                    }
                    n4 = 0;
                } else {
                    n4 = -1;
                }
            }
        } else if (this.hostVar instanceof NumericVar) {
            Object object = resultContainer.getObject(n2);
            if (object != null) {
                if (object instanceof BigDecimal) {
                    ((NumericVar)this.hostVar).set((BigDecimal)object);
                } else {
                    ((NumericVar)this.hostVar).set(object.toString());
                }
                n4 = 0;
            } else {
                ((NumericVar)this.hostVar).set(0);
                n4 = -1;
            }
        } else if (this.hostVar instanceof PicX && (this.hostVar.isSqlBinary() || EsqlRuntime.picXHandling == 1)) {
            byte[] byArray2 = resultContainer.getBytes(n2);
            this.hostVar.sqlSetBytes(byArray2);
            if (this.esqlLen != null) {
                this.esqlLen.set(byArray2.length);
            }
        } else {
            Object object;
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                object = resultContainer.getDb2Object(n2);
                if (object == objNoColToGet) {
                    return true;
                }
            } else {
                object = resultContainer.getObject(n2);
            }
            if (object != null) {
                String string;
                if (timeFormat != null && object instanceof Time) {
                    string = timeFormat.format(object);
                } else if (timestampFormat != null && object instanceof Timestamp) {
                    try {
                        string = timestampFormat.format(((Timestamp)object).toLocalDateTime());
                    }
                    catch (Exception exception) {
                        if (this.log != null) {
                            this.log.info("EsqlHostVar: Exception on TimeStamp formatting, TimeStamp converted to String " + this.hostVar.getName() + exception);
                        }
                        string = object.toString();
                    }
                } else if (dateFormat != null && object instanceof Date) {
                    string = dateFormat.format(object);
                } else if (object instanceof Clob) {
                    string = ((Clob)object).getSubString(1L, (int)((Clob)object).length());
                } else if (object instanceof Blob) {
                    string = new String(((Blob)object).getBytes(1L, (int)((Blob)object).length()));
                } else if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling != 1) {
                    byArray = resultContainer.getDataAsBytes(n2);
                    string = new String(byArray);
                    if (this.log != null) {
                        try {
                            resultContainer.getObject(n2);
                        }
                        catch (Exception exception) {
                            this.log.info("EsqlHostVar: Exception getObject on col " + n2 + " " + resultContainer.getMetaData().getTableName(n2) + "." + resultContainer.getMetaData().getColumnName(n2));
                        }
                    }
                } else if (EsqlRuntime.picXHandling == 2 && (resultContainer.getMetaData().getColumnType(n2) == -3 || resultContainer.getMetaData().getColumnType(n2) == -2)) {
                    byArray = resultContainer.getBytes(n2);
                    string = new String(byArray);
                } else if (EsqlRuntime.picXHandling == 1) {
                    byArray = resultContainer.getBytes(n2);
                    string = new String(byArray);
                } else {
                    string = object.toString();
                }
                if (this.esqlLen != null) {
                    this.esqlLen.set(string.length());
                }
                if (byArray != null) {
                    if (this.log != null) {
                        this.log.info("EsqlHostVar: before setBytes [" + EsqlHostVar.bytesToHex(byArray) + "]");
                    }
                    this.hostVar.sqlSetBytes(byArray);
                } else {
                    this.hostVar.set(string);
                }
                if (n3 == 2) {
                    int n5;
                    for (int i2 = n5 = string.length(); i2 > 0; --i2) {
                        if (string.charAt(i2 - 1) == ' ') {
                            --n5;
                            continue;
                        }
                        i2 = 0;
                    }
                    n4 = n5 > this.hostVar.getLength() ? n5 : 0;
                } else {
                    n4 = n3 == 3 ? 0 : (string.length() > this.hostVar.getLength() ? string.length() : 0);
                }
            } else {
                if (this.esqlInd != null) {
                    this.hostVar.set("");
                }
                n4 = -1;
            }
        }
        if (this.esqlInd != null) {
            if (resultContainer.wasNull(n2)) {
                this.esqlInd.set(-1);
            } else {
                this.esqlInd.set(n4);
            }
        } else if (resultContainer.wasNull(n2)) {
            this.resultNull = true;
        }
        return n4 > 0;
    }

    boolean toVar(int n2, ResultSet resultSet) throws SQLException {
        return this.toVar(n2, new ResultContainer(resultSet), 1);
    }

    boolean toVar(int n2, CallableStatement callableStatement, int n3) throws SQLException {
        if (this.modeIO != 1) {
            return this.toVar(n2, new ResultContainer(callableStatement), n3);
        }
        return false;
    }

    public static String rtrim(CobolVar cobolVar, int n2, int n3) {
        int n4;
        char[] cArray = cobolVar.toString().toCharArray();
        for (n4 = cArray.length - 1; n4 >= n2 && !(n3 == 2 ? cArray[n4] > ' ' : cArray[n4] > ' ' || cArray[n4] == '\u0000'); --n4) {
        }
        return new String(cArray, 0, n4 + 1);
    }

    void fromVar(int n2, PreparedStatement preparedStatement, int n3) {
        block3: {
            if (this.modeIO != 2) {
                try {
                    this._fromVar(n2, preparedStatement, n3);
                }
                catch (SQLException sQLException) {
                    if (this.log == null) break block3;
                    this.log.info("EsqlHostVar_n: excepition setting parameter " + this.hostVar.getName() + sQLException);
                }
            }
        }
    }

    private void _fromVar(int n2, PreparedStatement preparedStatement, int n3) throws SQLException {
        block59: {
            if (this.esqlInd.integer() < 0) {
                preparedStatement.setNull(n2, this.fSqlType);
            } else if (this.hostVar instanceof PicNativeFloat) {
                preparedStatement.setFloat(n2, ((PicNativeFloat)this.hostVar).tofloat());
            } else if (this.hostVar instanceof PicNativeDouble) {
                preparedStatement.setDouble(n2, ((PicNativeDouble)this.hostVar).todouble());
            } else if (this.hostVar instanceof ObjectVar) {
                Object object = ((ObjectVar)this.hostVar).getId();
                if (object != null) {
                    if (this.hostVar.getName().startsWith("@")) {
                        try {
                            if (object instanceof Clob) {
                                InputStream inputStream = ((Clob)object).getAsciiStream();
                                int n4 = inputStream.available();
                                byte[] byArray = new byte[n4];
                                inputStream.read(byArray);
                                preparedStatement.setString(n2, new String(byArray));
                                break block59;
                            }
                            if (object instanceof String) {
                                preparedStatement.setString(n2, (String)object);
                                break block59;
                            }
                            preparedStatement.setObject(n2, object);
                        }
                        catch (Exception exception) {}
                    } else if (object instanceof EsqlCursorHndl) {
                        this.cursHndl = (EsqlCursorHndl)object;
                    } else if (object instanceof byte[]) {
                        preparedStatement.setObject(n2, (byte[])object);
                    } else {
                        preparedStatement.setObject(n2, object);
                    }
                } else {
                    preparedStatement.setNull(n2, this.fSqlType);
                }
            } else if (this.hostVar instanceof NumericVar) {
                if (((NumericVar)this.hostVar).scale() > 0 || ((NumericVar)this.hostVar).intLength() > 18) {
                    preparedStatement.setBigDecimal(n2, ((NumericVar)this.hostVar).num().bigDecimalValue());
                } else {
                    preparedStatement.setLong(n2, ((NumericVar)this.hostVar).num().longValue());
                }
            } else if (this.hostVar instanceof PicX && this.hostVar.isSqlBinary()) {
                int n5 = this.hostVar.length();
                if (this.esqlLen != null && this.esqlLen.toint() < n5) {
                    n5 = this.esqlLen.toint();
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), n5), 0, n5);
                preparedStatement.setBinaryStream(n2, (InputStream)byteArrayInputStream, n5);
            } else if (this.fSqlType == 2005 && this.modeIO != -1) {
                SerialClob serialClob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialClob(this.hostVar.toString().substring(0, this.esqlLen.toint()).toCharArray()) : new SerialClob(this.hostVar.toString().toCharArray());
                preparedStatement.setClob(n2, serialClob);
            } else if (this.fSqlType == 2004 && this.modeIO != -1) {
                SerialBlob serialBlob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialBlob(this.hostVar.toString().substring(0, this.esqlLen.toint()).getBytes()) : new SerialBlob(this.hostVar.toString().getBytes());
                preparedStatement.setBlob(n2, serialBlob);
            } else if (this.fSqlType == 1 && (this.modeIO != -1 || EsqlRuntime.picXHandling != 0)) {
                switch (n3) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(preparedStatement, n2, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), this.esqlLen.toint()));
                                break;
                            }
                            preparedStatement.setString(n2, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                            this.paramSetString(preparedStatement, n2, this.hostVar.toString());
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), this.hostVar.toString().length()));
                            break;
                        }
                        preparedStatement.setString(n2, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, n3).length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(preparedStatement, n2, EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()).length()));
                                break;
                            }
                            preparedStatement.setString(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling != 1) {
                            this.paramSetString(preparedStatement, n2, EsqlHostVar.rtrim(this.hostVar, 0, n3));
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), EsqlHostVar.rtrim(this.hostVar, 0, n3).length()));
                            break;
                        }
                        preparedStatement.setString(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, n3).length()) {
                            if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                                this.paramSetString(preparedStatement, n2, EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()));
                                break;
                            }
                            if (EsqlRuntime.picXHandling == 1) {
                                preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()).length()));
                                break;
                            }
                            preparedStatement.setString(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        if (EsqlRuntime.db2DataRowAsByteThreshold > 0 || EsqlRuntime.picXHandling == 2) {
                            this.paramSetString(preparedStatement, n2, EsqlHostVar.rtrim(this.hostVar, 1, n3));
                            break;
                        }
                        if (EsqlRuntime.picXHandling == 1) {
                            preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), EsqlHostVar.rtrim(this.hostVar, 1, n3).length()));
                            break;
                        }
                        preparedStatement.setString(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3));
                        break;
                    }
                }
            } else {
                switch (n3) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            preparedStatement.setObject(n2, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        preparedStatement.setObject(n2, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, n3).length()) {
                            preparedStatement.setObject(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        preparedStatement.setObject(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, n3).length()) {
                            preparedStatement.setObject(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        preparedStatement.setObject(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3));
                    }
                }
            }
        }
    }

    int getCol() {
        return this.col;
    }

    CobolVar getVar() {
        return this.hostVar;
    }

    void regOutVar(int n2, CallableStatement callableStatement) {
        if (this.cursHndl == null) {
            this.regOutVar(n2, callableStatement, this.fSqlType);
        } else {
            this.regOutVar(n2, callableStatement, this.cursHndl.getCurSqlType());
        }
    }

    void regOutVar(int n2, CallableStatement callableStatement, int n3) {
        if (this.modeIO != 1) {
            try {
                callableStatement.registerOutParameter(n2, n3);
            }
            catch (SQLException sQLException) {
                this.modeIO = 1;
            }
        }
    }

    boolean isResultNull() {
        return this.resultNull;
    }

    public void setHostVar(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) {
        this.setHostVar(cobolVar, n2, n3, numericVar, numericVar2, string, (short)-1);
    }

    public void setHostVar(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, short s2) {
        this.hostVar = cobolVar;
        this.type = n2;
        this.col = n3;
        this.type = n2;
        this.sqlType = s2;
        this.esqlInd = numericVar;
        this.esqlLen = numericVar2;
        this.modeIO = string == null ? -1 : ("IN".equals(string) ? 1 : ("OUT".equals(string) ? 2 : 3));
        this.fSqlType = cobolVar instanceof PicNativeFloat ? (short)7 : (cobolVar instanceof PicNativeDouble ? (short)8 : (cobolVar instanceof ObjectVar ? (short)-4 : (cobolVar instanceof NumericVar ? (short)2 : (short)1)));
        if (s2 != -1) {
            this.fSqlType = s2;
        }
    }

    public void updateVar(int n2, ResultSet resultSet) throws SQLException {
        if (this.esqlInd.integer() < 0) {
            resultSet.updateNull(n2);
        } else {
            int n3 = Config.a(".jdbc.kept_spaces", 1);
            if (this.hostVar instanceof PicNativeFloat) {
                resultSet.updateFloat(n2, ((PicNativeFloat)this.hostVar).tofloat());
            } else if (this.hostVar instanceof PicNativeDouble) {
                resultSet.updateDouble(n2, ((PicNativeDouble)this.hostVar).todouble());
            } else if (this.hostVar instanceof ObjectVar) {
                Object object = ((ObjectVar)this.hostVar).getId();
                if (object != null) {
                    if (object instanceof EsqlCursorHndl) {
                        this.cursHndl = (EsqlCursorHndl)object;
                    } else if (object instanceof byte[]) {
                        resultSet.updateObject(n2, (Object)((byte[])object));
                    } else {
                        resultSet.updateObject(n2, object);
                    }
                } else {
                    resultSet.updateNull(n2);
                }
            } else if (this.hostVar instanceof NumericVar) {
                resultSet.updateBigDecimal(n2, ((NumericVar)this.hostVar).num().bigDecimalValue());
            } else if (this.hostVar instanceof PicX && this.hostVar.isSqlBinary()) {
                int n4 = this.hostVar.length();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), n4), 0, n4);
                resultSet.updateBinaryStream(n2, (InputStream)byteArrayInputStream, n4);
            } else if (this.fSqlType == 2005 && this.modeIO != -1) {
                SerialClob serialClob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialClob(this.hostVar.toString().substring(0, this.esqlLen.toint()).toCharArray()) : new SerialClob(this.hostVar.toString().toCharArray());
                resultSet.updateClob(n2, (Clob)serialClob);
            } else if (this.fSqlType == 2004 && this.modeIO != -1) {
                SerialBlob serialBlob = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? new SerialBlob(this.hostVar.toString().substring(0, this.esqlLen.toint()).getBytes()) : new SerialBlob(this.hostVar.toString().getBytes());
                resultSet.updateBlob(n2, (Blob)serialBlob);
            } else if (this.fSqlType == 1 && this.modeIO != -1) {
                switch (n3) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            resultSet.updateString(n2, this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateString(n2, this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, n3).length()) {
                            resultSet.updateString(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateString(n2, EsqlHostVar.rtrim(this.hostVar, 0, n3));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, n3).length()) {
                            resultSet.updateString(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateString(n2, EsqlHostVar.rtrim(this.hostVar, 1, n3));
                        break;
                    }
                }
            } else {
                switch (n3) {
                    case -1: {
                        if (this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length()) {
                            resultSet.updateObject(n2, (Object)this.hostVar.toString().substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateObject(n2, (Object)this.hostVar.toString());
                        break;
                    }
                    case 0: 
                    case 2: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 0, n3).length()) {
                            resultSet.updateObject(n2, (Object)EsqlHostVar.rtrim(this.hostVar, 0, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateObject(n2, (Object)EsqlHostVar.rtrim(this.hostVar, 0, n3));
                        break;
                    }
                    default: {
                        if (this.esqlLen != null && this.esqlLen.toint() < EsqlHostVar.rtrim(this.hostVar, 1, n3).length()) {
                            resultSet.updateObject(n2, (Object)EsqlHostVar.rtrim(this.hostVar, 1, n3).substring(0, this.esqlLen.toint()));
                            break;
                        }
                        resultSet.updateObject(n2, (Object)EsqlHostVar.rtrim(this.hostVar, 1, n3));
                    }
                }
            }
        }
    }

    public short getFSqlType() {
        return this.fSqlType;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setSpecType(int n2) {
        this.specType = n2;
    }

    public int getSpecType() {
        return this.specType;
    }

    private void paramSetString(PreparedStatement preparedStatement, int n2, String string) throws SQLException {
        try {
            int n3;
            int n4;
            int n5;
            block11: {
                n5 = -1;
                n4 = this.hostVar.getLength();
                n3 = -1;
                try {
                    if (n4 >= EsqlRuntime.db2DataRowAsByteThreshold || EsqlRuntime.picXHandling == 2) {
                        n5 = preparedStatement.getParameterMetaData().getParameterType(n2);
                        n3 = preparedStatement.getParameterMetaData().getPrecision(n2);
                    }
                }
                catch (Exception exception) {
                    if (this.log == null) break block11;
                    this.log.info("EsqlHostVar: exception on getType parameter (paramSetString) " + this.hostVar.getName() + exception);
                }
            }
            if ((n5 == 12 || n5 == 1) && n4 >= EsqlRuntime.db2DataRowAsByteThreshold && EsqlRuntime.db2DataRowAsByteThreshold > 0 || (n5 == -3 || n5 == -2) && EsqlRuntime.picXHandling == 2) {
                int n6 = 0;
                n6 = this.esqlLen != null && this.esqlLen.toint() < this.hostVar.toString().length() ? this.esqlLen.toint() : this.hostVar.toString().length();
                if (this.log != null) {
                    this.log.info("EsqlHostVar: paramSetParameter " + this.hostVar.getName() + " len=" + n4 + " setBytes " + preparedStatement.getParameterMetaData().getParameterType(n2) + ", " + string.getBytes().length + ", " + string.getBytes());
                    this.log.info("EsqlHostVar: paramSetParameter value   [" + EsqlHostVar.bytesToHex(string.getBytes()) + "]");
                    this.log.info("EsqlHostVar: paramSetParameter hostVar [" + EsqlHostVar.bytesToHex(this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), n6)) + "]" + n6);
                }
                if (n3 > 0 && n3 < n6) {
                    preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), n3));
                } else {
                    preparedStatement.setBytes(n2, this.hostVar.getMemory().toByteArray(this.hostVar.getOffset(), n6));
                }
            } else {
                preparedStatement.setString(n2, string);
            }
        }
        catch (Exception exception) {
            if (this.log != null) {
                this.log.info("EsqlHostVar: exception fromVar parameter (paramSetString) " + this.hostVar.getName() + exception);
            }
            throw exception;
        }
    }

    static String bytesToHex(byte[] byArray) {
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            int n2 = byArray[i2] & 0xFF;
            cArray[i2 * 2] = HEX_ARRAY[n2 >>> 4];
            cArray[i2 * 2 + 1] = HEX_ARRAY[n2 & 0xF];
        }
        return new String(cArray);
    }

    static {
        try {
            dateFormat = new SimpleDateFormat(Config.a(".jdbc.dateformat", null));
        }
        catch (NullPointerException nullPointerException) {
            dateFormat = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            dateFormat = null;
        }
        try {
            timeFormat = new SimpleDateFormat(Config.a(".jdbc.timeformat", null));
        }
        catch (NullPointerException nullPointerException) {
            timeFormat = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            timeFormat = null;
        }
        try {
            timestampFormat = DateTimeFormatter.ofPattern(Config.a(".jdbc.timestampformat", null));
        }
        catch (NullPointerException nullPointerException) {
            timestampFormat = null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            timestampFormat = null;
        }
        HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    }

    public static class ResultContainer {
        private static final Logger log = LoggerFactory.get(256);
        private final ResultSet rs;
        private final CallableStatement cs;
        private static Method getDBRowDataAsBytes;
        private static Method getDBRowDescriptor;
        private static Method exec;
        static Class[] nullParamClass;
        static Object[] nullParam;
        private Object[] rowObj = null;
        private byte[] rowData = null;
        private int[] rowOffs = null;
        private int[] rowInfo = null;

        ResultContainer(CallableStatement callableStatement) {
            this.rs = null;
            this.cs = callableStatement;
        }

        ResultContainer(ResultSet resultSet) {
            this.rs = resultSet;
            this.cs = null;
        }

        boolean wasNull(int n2) throws SQLException {
            return this.cs != null ? this.cs.wasNull() : this.intWasNull(n2);
        }

        Object getObject(int n2) throws SQLException {
            return this.cs != null ? this.cs.getObject(n2) : this.rs.getObject(n2);
        }

        Object getDb2Object(int n2) throws SQLException {
            return this.cs != null ? this.cs.getObject(n2) : this.getIntObject(n2);
        }

        float getFloat(int n2) throws SQLException {
            return this.cs != null ? this.cs.getFloat(n2) : this.rs.getFloat(n2);
        }

        double getDouble(int n2) throws SQLException {
            return this.cs != null ? this.cs.getDouble(n2) : this.rs.getDouble(n2);
        }

        Blob getBlob(int n2) throws SQLException {
            return this.cs != null ? this.cs.getBlob(n2) : this.rs.getBlob(n2);
        }

        Clob getClob(int n2) throws SQLException {
            return this.cs != null ? this.cs.getClob(n2) : this.rs.getClob(n2);
        }

        ResultSetMetaData getMetaData() throws SQLException {
            return this.cs != null ? this.cs.getMetaData() : this.rs.getMetaData();
        }

        byte[] getBytes(int n2) throws SQLException {
            return this.cs != null ? this.cs.getBytes(n2) : this.rs.getBytes(n2);
        }

        byte[] getDataAsBytes(int n2) throws SQLException {
            return this.cs != null ? this.cs.getString(n2).getBytes() : this.doDb2Bytes(n2);
        }

        Object getIntObject(int n2) throws SQLException {
            Object object = null;
            if (this.rs.getMetaData().getColumnCount() < n2) {
                return EsqlHostVar.objNoColToGet;
            }
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                int n3;
                block6: {
                    if (EsqlRuntime.picXHandling == 1) {
                        return "";
                    }
                    try {
                        this.rowInfo = (int[])getDBRowDescriptor.invoke((Object)this.rs, nullParam);
                    }
                    catch (Exception exception) {
                        if (log == null) break block6;
                        log.info("EsqlHostVar: exception invoke db2 " + exception);
                    }
                }
                int n4 = this.rowInfo != null ? this.rowInfo[4 * (n2 - 1) + 1] : 0;
                int n5 = n3 = this.rowInfo != null ? this.rowInfo[4 * (n2 - 1) + 3] : 0;
                object = n3 >= EsqlRuntime.db2DataRowAsByteThreshold && (n4 == 448 || n4 == 452 || n4 == 453 || n4 == 449) ? "" : this.rs.getObject(n2);
            } else {
                object = EsqlRuntime.picXHandling == 2 && (this.rs.getMetaData().getColumnType(n2) == -3 || this.rs.getMetaData().getColumnType(n2) == -2) ? "" : this.rs.getObject(n2);
            }
            return object;
        }

        boolean intWasNull(int n2) throws SQLException {
            int n3;
            boolean bl = false;
            bl = EsqlRuntime.db2DataRowAsByteThreshold > 0 && this.rowInfo != null && this.rowData != null && this.rowInfo[4 * (n2 - 1) + 3] >= EsqlRuntime.db2DataRowAsByteThreshold ? ((n3 = this.rowInfo[4 * (n2 - 1) + 1]) == 448 || n3 == 452 || n3 == 453 || n3 == 449 ? this.rowData[this.rowOffs[n2 - 1]] != 0 || this.rowData[this.rowOffs[n2 - 1] + 1] != 0 : this.rs.wasNull()) : this.rs.wasNull();
            return bl;
        }

        byte[] doDb2Bytes(int n2) throws SQLException {
            byte[] byArray = null;
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                int n3 = this.rowInfo[4 * (n2 - 1) + 1];
                if (n3 == 448 || n3 == 452 || n3 == 453 || n3 == 449) {
                    block11: {
                        try {
                            this.rowObj = (Object[])getDBRowDataAsBytes.invoke((Object)this.rs, nullParam);
                            this.rowData = (byte[])this.rowObj[0];
                            this.rowOffs = (int[])this.rowObj[1];
                        }
                        catch (Exception exception) {
                            if (log == null) break block11;
                            log.info("EsqlHostVar: exception invoke db2 " + exception);
                        }
                    }
                    byte[] byArray2 = new byte[2];
                    int n4 = 0;
                    int n5 = this.rowOffs[n2 - 1] + 2;
                    if (n3 == 448 || n3 == 449) {
                        System.arraycopy(this.rowData, this.rowOffs[n2 - 1] + 2, byArray2, 0, 2);
                        n4 = byArray2[0] << 8 & 0xFF00 | byArray2[1] << 0 & 0xFF;
                        n5 += 2;
                    } else {
                        n4 = this.rowInfo[4 * (n2 - 1) + 3];
                    }
                    byArray = new byte[n4];
                    if (log != null) {
                        log.info("EsqlHostVar: doDb2Bytes rowData[" + EsqlHostVar.bytesToHex(this.rowData) + ", " + this.rowData.length + "]" + this.rowOffs[n2 - 1] + ", " + this.rowInfo[4 * (n2 - 1) + 3] + ", " + n4);
                    }
                    if (this.rowData[this.rowOffs[n2 - 1]] == 0 && this.rowData[this.rowOffs[n2 - 1] + 1] == 0) {
                        System.arraycopy(this.rowData, n5, byArray, 0, byArray.length);
                    }
                    if (log != null) {
                        log.info("EsqlHostVar: doDb2Bytes Return[" + EsqlHostVar.bytesToHex(byArray) + "]");
                    }
                } else {
                    byArray = this.rs.getString(n2).getBytes();
                }
            } else {
                byArray = this.rs.getMetaData().getColumnType(n2) == -3 || this.rs.getMetaData().getColumnType(n2) == -2 ? this.rs.getBytes(n2) : this.rs.getString(n2).getBytes();
            }
            return byArray;
        }

        static {
            nullParamClass = new Class[0];
            nullParam = new Object[0];
            if (EsqlRuntime.db2DataRowAsByteThreshold > 0) {
                try {
                    Class<?> clazz = Class.forName("com.ibm.db2.jcc.DB2ResultSet");
                    getDBRowDataAsBytes = clazz.getMethod("getDBRowDataAsBytes", nullParamClass);
                    getDBRowDescriptor = clazz.getMethod("getDBRowDescriptor", nullParamClass);
                }
                catch (Exception exception) {
                    throw new IscobolRuntimeException(exception);
                }
            }
        }
    }
}

