/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts_n;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts_n.EsqlHostVar;
import com.iscobol.rts_n.EsqlRuntime;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Vector;

public class EsqlOraPrepStat {
    private String name;
    private boolean statNoData;
    private int rowCount;
    private Connection con;
    private int type;
    private int holdability;
    private String query;
    private final Logger log = LoggerFactory.get(2048);
    private Vector params = new Vector();
    private Vector bindCols = new Vector();
    int handle;
    private SQLWarning warnings;
    private boolean nullResult = false;
    private int lastCol = 0;
    private static Method registerReturnParameter;
    private static Method getReturnResultSet;
    private static Method exec;
    static Class[] mReturnOutPar;
    static Class[] nullParamClass;
    static Object[] nullParam;
    private PreparedStatement hstmt;

    public EsqlOraPrepStat(String string, int n2, int n3) {
        this.name = string;
        this.type = n2;
        this.holdability = n3;
        this.handle = UserHandles.ssetId(this);
        this.warnings = null;
    }

    public void setQuery(Connection connection, String string) throws SQLException {
        this.query = string;
        this.con = connection;
        this.statNoData = EsqlRuntime.isStatNoData(this.query);
        if (this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlOraPrepStat: before close PS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.hstmt = connection.prepareStatement(this.query);
        if (this.log != null) {
            this.log.info("Developers log: EsqlOraPrepStat: after open PS " + this.hstmt);
        }
    }

    public ResultSet exec() throws SQLException {
        int n2 = this.bindCols.size();
        Vector vector = new Vector();
        if (vector.size() == 0) {
            vector.add(null);
        }
        for (int i2 = 0; i2 < this.bindCols.size(); ++i2) {
            if (this.bindCols.get(i2) == null) continue;
            vector.add(this.bindCols.get(i2));
        }
        vector.add(null);
        this.rowCount = 0;
        if (this.hstmt != null) {
            try {
                exec.invoke((Object)this.hstmt, nullParam);
                ResultSet resultSet = (ResultSet)getReturnResultSet.invoke((Object)this.hstmt, nullParam);
                if (resultSet != null) {
                    resultSet.next();
                    EsqlRuntime.fillHostVars(resultSet, vector);
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.getCause().printStackTrace();
            }
            catch (Exception exception) {
                exception.getCause().printStackTrace();
            }
            this.nullResult = EsqlRuntime.searchNullWithoutInd(this.bindCols);
            this.rowCount = this.hstmt.getUpdateCount();
            this.warnings = this.hstmt.getWarnings();
            return null;
        }
        EsqlRuntime.esqlError(7, "/Syntax error");
        return null;
    }

    void setParams(EsqlOraPrepStat esqlOraPrepStat) throws SQLException {
        EsqlRuntime.setParams(this.hstmt, this.params);
    }

    public void close() throws SQLException {
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlOraPrepStat: before close PS " + this.hstmt);
            }
            this.hstmt.close();
        }
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public int getHandle() {
        return this.handle;
    }

    public boolean hasNullResult() {
        return this.nullResult;
    }

    public SQLWarning getWarnings() {
        return this.warnings;
    }

    public void bindCol(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        EsqlHostVar esqlHostVar = new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2);
        for (int i2 = this.bindCols.size(); i2 <= n3; ++i2) {
            this.bindCols.add(null);
        }
        this.bindCols.set(n3, esqlHostVar);
        try {
            registerReturnParameter.invoke((Object)this.hstmt, n3 + this.lastCol, esqlHostVar.getFSqlType());
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.getCause().printStackTrace();
        }
        catch (Exception exception) {
            exception.getCause().printStackTrace();
        }
    }

    public void setParam(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) throws SQLException {
        this.setParam(cobolVar, n2, n3, numericVar, numericVar2, (short)-1);
    }

    public void setParam(CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, short s2) throws SQLException {
        int n4 = Config.a(".jdbc.kept_spaces", 1);
        EsqlHostVar esqlHostVar = new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2, "I", s2);
        for (int i2 = this.params.size(); i2 <= n3; ++i2) {
            this.params.add(null);
        }
        this.params.set(n3, esqlHostVar);
        this.lastCol = this.params.size() - 1;
        esqlHostVar.fromVar(n3, this.hstmt, n4);
    }

    public String getQueryLog() {
        String string = this.query;
        if (this.params.size() > 0) {
            int n2 = Config.a(".jdbc.kept_spaces", 1);
            string = string + " trimType[" + n2 + "] using[";
            for (int i2 = 1; i2 < this.params.size(); ++i2) {
                if (i2 > 1) {
                    string = string + ", ";
                }
                if (this.params.get(i2) != null) {
                    if (n2 == -1) {
                        string = string + "'" + ((EsqlHostVar)this.params.get(i2)).getVar().toString() + "'";
                        continue;
                    }
                    string = string + "'" + EsqlHostVar.rtrim(((EsqlHostVar)this.params.get(i2)).getVar(), n2, n2) + "'";
                    continue;
                }
                string = string + "null";
            }
        }
        return string;
    }

    static {
        mReturnOutPar = new Class[]{Integer.TYPE, Integer.TYPE};
        nullParamClass = new Class[0];
        nullParam = new Object[0];
        try {
            Class<?> clazz = Class.forName("oracle.jdbc.OraclePreparedStatement");
            exec = clazz.getMethod("execute", nullParamClass);
            Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE};
            registerReturnParameter = clazz.getMethod("registerReturnParameter", classArray);
            getReturnResultSet = clazz.getMethod("getReturnResultSet", nullParamClass);
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(exception);
        }
    }
}

