/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.son;

import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.Pic9Comp_5;
import java.io.File;
import java.util.StringTokenizer;

public class DynamicCall
implements IscobolCall,
RuntimeErrorsNumbers {
    public static final int STDC_CALL_CONV = 0;
    public static final int PASCAL_CALL_CONV = 1;
    public static final int MAX_ARGS = 256;
    private static boolean loaded;
    private final int callConv;
    private final String name;
    private Pic9Comp_5 ret = new Pic9Comp_5(Memory.getMemory(8), 0, 8, true, 0, 0, null, null, null, false, true);

    private static native void init();

    private static native boolean peerOpen(String var0);

    private static native long peerCall(String var0, int var1, long[] var2);

    private static native String peerClose(String var0);

    public DynamicCall(String string, int n2) {
        this.name = string;
        this.callConv = n2;
    }

    @Override
    public Object call(Object[] objectArray) {
        long l2;
        if (!loaded) {
            throw new IscobolRuntimeException(2, this.name);
        }
        try {
            l2 = DynamicCall.call(this.name, this.callConv, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            if ((objectArray == null || objectArray.length == 0) && DynamicCall.open(this.name)) {
                l2 = 0L;
            }
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(l2);
        return this.ret;
    }

    @Override
    public void finalize() {
    }

    public static final boolean open(String string) {
        return loaded && DynamicCall.peerOpen(string);
    }

    public final Object openAndLoad(Object[] objectArray) {
        String string = System.mapLibraryName(this.name);
        if (!DynamicCall.open(string)) {
            throw new IscobolRuntimeException(2, this.name);
        }
        this.ret.set(DynamicCall.call(this.name, this.callConv, objectArray));
        return this.ret;
    }

    public static final long call(String string, int n2, Object[] objectArray) {
        long[] lArray;
        boolean bl = false;
        if (loaded) {
            if (objectArray == null) {
                lArray = null;
            } else {
                if (objectArray.length > 256) {
                    lArray = new long[256];
                    bl = true;
                } else {
                    lArray = new long[objectArray.length];
                }
                for (int i2 = 0; i2 < lArray.length; ++i2) {
                    try {
                        CobolVar cobolVar = (CobolVar)objectArray[i2];
                        if (cobolVar.isByVal()) {
                            if (cobolVar instanceof NumericVar) {
                                lArray[i2] = cobolVar.tolong();
                                continue;
                            }
                            lArray[i2] = cobolVar.intCopy().getAddressAsLong();
                            continue;
                        }
                        lArray[i2] = cobolVar.getAddressAsLong();
                        continue;
                    }
                    catch (Exception exception) {
                        lArray[i2] = 0L;
                    }
                }
            }
        } else {
            throw new RuntimeException("Native call not found");
        }
        long l2 = DynamicCall.peerCall(string, n2, lArray);
        if (bl) {
            throw new IllegalArgumentException("Too many arguments:" + objectArray.length + " (max allowed: " + 256 + ")");
        }
        return l2;
    }

    public static final String unload(String string) {
        if (loaded) {
            return DynamicCall.peerClose(string);
        }
        return "";
    }

    @Override
    public void perform(int n2, int n3) {
    }

    static {
        String string;
        block5: {
            try {
                System.loadLibrary("dyncall_n");
                loaded = true;
                DynamicCall.init();
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                if (Config.a("iscobol.runtime.native.ignore_errors", "iscobol.runtime.native.dynamic.ignore_errors", true)) break block5;
                throw new IscobolRuntimeException(32, (Throwable)unsatisfiedLinkError);
            }
        }
        if (Config.b("iscobol.shared_dlopen_null", true)) {
            DynamicCall.open(null);
        }
        if ((string = Config.a("iscobol.shared_library_list", null)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\n" + File.pathSeparatorChar);
            while (stringTokenizer.hasMoreTokens()) {
                DynamicCall.open(stringTokenizer.nextToken());
            }
        }
    }
}

