/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolVar;
import java.io.Serializable;

public class ArrayCache
implements RuntimeErrorsNumbers,
Serializable {
    private static final long serialVersionUID = 123L;
    private static final int SIZE = Config.a("iscobol.array_cache", 101);
    private static final int[] empty;
    final CobolVar[] cache;
    final int[] indexes;
    final int size;

    private ArrayCache(int n2) {
        this.size = n2 < SIZE ? n2 : SIZE;
        this.cache = new CobolVar[this.size];
        this.indexes = new int[this.size];
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public static ArrayCache getInstance(int n2) {
        return SIZE > 0 ? new ArrayCache(n2) : null;
    }

    public final void clear() {
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final CobolVar get(int n2) {
        int n3 = (n2 & Integer.MAX_VALUE) % this.size;
        if (this.indexes[n3] == n2) {
            return this.cache[n3];
        }
        return null;
    }

    public final void put(CobolVar cobolVar, int n2) {
        int n3 = (n2 & Integer.MAX_VALUE) % this.size;
        this.indexes[n3] = n2;
        this.cache[n3] = cobolVar;
    }

    static {
        if (SIZE > 0) {
            empty = new int[SIZE];
            for (int i2 = SIZE - 1; i2 >= 0; --i2) {
                ArrayCache.empty[i2] = -1;
            }
        } else {
            empty = null;
        }
    }
}

