/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CobolDouble
extends CobolNum {
    private double dbValue;
    private static boolean[] dummy = new boolean[1];

    CobolDouble(double d2) {
        super((byte)2);
        this.dbValue = d2;
    }

    @Override
    public float floatValue() {
        return (float)this.dbValue;
    }

    @Override
    public double doubleValue() {
        return this.dbValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
            return new BigDecimal("10000000000000000000000000000000");
        }
        return new BigDecimal(this.dbValue);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
            return OVERFLOW_BD;
        }
        return new BigCobolDec(this.dbValue);
    }

    @Override
    public CobolNum set(long l2, int n2, boolean bl) {
        this.dbValue = (double)l2 / factDouble[n2];
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bigCobolDec) {
        this.dbValue = bigCobolDec.doubleValue();
        return this;
    }

    @Override
    public CobolNum set(double d2) {
        return this.set(d2, false);
    }

    public CobolNum set(double d2, boolean bl) {
        this.dbValue = d2;
        return this;
    }

    @Override
    public CobolNum set(float f2) {
        this.dbValue = f2;
        return this;
    }

    @Override
    public CobolNum set(CobolNum cobolNum, boolean bl, boolean bl2) {
        return this.set(cobolNum.doubleValue());
    }

    @Override
    public CobolNum add(CobolNum cobolNum) {
        return new CobolDouble(this.dbValue + cobolNum.doubleValue());
    }

    @Override
    public void addToMe(short s2) {
        this.dbValue += (double)s2;
    }

    @Override
    public void subFromMe(short s2) {
        this.dbValue -= (double)s2;
    }

    @Override
    public void multiplyByMe(short s2) {
        this.dbValue *= (double)s2;
    }

    @Override
    public void divideIntoMe(boolean bl, short s2) {
        this.dbValue /= (double)s2;
    }

    @Override
    public void divideIntoMeByZero(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                if (this.dbValue < 0.0) {
                    this.dbValue = Double.NEGATIVE_INFINITY;
                    break;
                }
                this.dbValue = Double.POSITIVE_INFINITY;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.dbValue = 0.0;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                if (this.dbValue < 0.0) {
                    this.dbValue = Double.NEGATIVE_INFINITY;
                    break;
                }
                this.dbValue = Double.POSITIVE_INFINITY;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.dbValue = 0.0;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int n2) {
        this.dbValue += (double)n2;
    }

    @Override
    public void subFromMe(int n2) {
        this.dbValue -= (double)n2;
    }

    @Override
    public void multiplyByMe(int n2) {
        this.dbValue *= (double)n2;
    }

    @Override
    public void divideIntoMe(boolean bl, int n2) {
        this.dbValue /= (double)n2;
    }

    @Override
    public void addToMe(long l2) {
        this.dbValue += (double)l2;
    }

    @Override
    public void subFromMe(long l2) {
        this.dbValue -= (double)l2;
    }

    @Override
    public void multiplyByMe(long l2) {
        this.dbValue *= (double)l2;
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        this.dbValue /= (double)l2;
    }

    @Override
    public CobolNum add1() {
        return new CobolDouble(this.dbValue + 1.0);
    }

    @Override
    public CobolNum subtract(CobolNum cobolNum) {
        return new CobolDouble(this.dbValue - cobolNum.doubleValue());
    }

    @Override
    public CobolNum subtract1() {
        return new CobolDouble(this.dbValue - 1.0);
    }

    @Override
    public CobolNum multiply(CobolNum cobolNum) {
        return new CobolDouble(this.dbValue * cobolNum.doubleValue());
    }

    @Override
    public CobolNum multiply36(CobolNum cobolNum) {
        return this.multiply(cobolNum);
    }

    @Override
    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        return CobolDouble.divideDouble(bl, this.dbValue, cobolNum.doubleValue(), n2, bl2);
    }

    @Override
    public void toCobolByteArray(byte[] byArray, int n2, byte[] byArray2) {
        byte[] byArray3;
        String string = Double.toString(this.dbValue);
        try {
            byArray3 = string.getBytes(CobolVar.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string.getBytes();
        }
        if (byArray3.length >= n2) {
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        } else {
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            for (int i2 = byArray3.length; i2 < n2; ++i2) {
                byArray[i2] = EncBytes.C_SPACE;
            }
        }
    }

    @Override
    public int toByteArray(byte[] byArray) {
        return this.bigCobDecValue().toByteArray(byArray, NumericVar.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum cobolNum, int n2) {
        switch (cobolNum.type) {
            case 0: {
                if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
                    return true;
                }
                if (this.dbValue < 0.0) {
                    return this.dbValue < (double)factMin[n2];
                }
                return this.dbValue > (double)factMax[n2];
            }
            case 1: {
                if (Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue)) {
                    return true;
                }
                if (this.dbValue < 0.0) {
                    return this.dbValue < -factDouble[n2];
                }
                return this.dbValue > factDouble[n2];
            }
            case 3: {
                return this.dbValue > 3.4028234663852886E38 || this.dbValue < (double)1.4E-45f || Double.isNaN(this.dbValue);
            }
            case 2: {
                return Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue);
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum cobolNum, int n2, boolean bl) {
        return Double.isInfinite(this.dbValue) || Double.isNaN(this.dbValue);
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        return CobolDouble.evalCompare(this.dbValue - cobolNum.doubleValue());
    }

    @Override
    public int compareTo(long l2, int n2) {
        return CobolDouble.evalCompare(this.dbValue - CobolDouble.doubleValue(l2, n2));
    }

    @Override
    public long getUnscaledLong(boolean[] blArray) {
        long l2 = this.bigCobDecValue().setScale(0).unscaled18Digits(0);
        boolean bl = blArray[0] = this.bigCobDecValue().precision() > 18;
        if (!blArray[0]) {
            int n2 = this.bigCobDecValue().scale();
            l2 = this.bigCobDecValue().unscaled18Digits(n2);
            if (n2 < 0) {
                l2 *= fact[-n2];
            }
        }
        return l2;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory memory, int n2, int n3) {
        long l2 = Double.doubleToLongBits(this.dbValue);
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            memory.put(n2++, (byte)(l2 >>> (i2 << 3)));
        }
        memory.put(n2, (byte)(l2 & 0xFFL));
    }

    @Override
    public void toBinaryByteArray(byte[] byArray, int n2, int n3) {
        long l2 = Double.doubleToLongBits(this.dbValue);
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            byArray[n2++] = (byte)(l2 >>> (i2 << 3));
        }
        byArray[n2] = (byte)(l2 & 0xFFL);
    }

    @Override
    public void setSizeDigit(int n2, int n3) {
    }

    @Override
    public void setSizeByteUnsigned(int n2) {
    }

    @Override
    public void setSizeByteSigned(int n2) {
    }

    @Override
    public void setScale(int n2, boolean bl, boolean bl2) {
    }

    @Override
    public final void roundUpIfNeeded(int n2) {
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int signum() {
        return (int)Math.signum(this.dbValue);
    }

    @Override
    public void negateMe() {
        this.dbValue = -this.dbValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolDouble(-this.dbValue);
    }

    @Override
    public void shift(int n2) {
        this.dbValue = n2 < 0 ? (this.dbValue /= (double)fact[-n2]) : (this.dbValue *= (double)fact[n2]);
    }

    @Override
    public String toString() {
        return Double.toString(this.dbValue);
    }

    @Override
    public int shortValue() {
        return (short)this.dbValue;
    }

    @Override
    public int intValue() {
        return (int)this.dbValue;
    }

    @Override
    public long longValue() {
        return (long)this.dbValue;
    }

    @Override
    public int shortValue(boolean bl) {
        if (bl) {
            return (short)Math.round(this.dbValue);
        }
        return (short)this.dbValue;
    }

    @Override
    public int intValue(boolean bl) {
        if (bl) {
            return (int)Math.round(this.dbValue);
        }
        return (int)this.dbValue;
    }

    @Override
    public long longValue(boolean bl) {
        if (bl) {
            return Math.round(this.dbValue);
        }
        return (long)this.dbValue;
    }

    @Override
    public CobolNum integerFunc() {
        return new CobolDouble(Math.floor(this.dbValue));
    }

    @Override
    public CobolNum integerPart() {
        if (this.dbValue < 0.0) {
            return new CobolDouble(Math.ceil(this.dbValue));
        }
        return new CobolDouble(Math.floor(this.dbValue));
    }
}

