/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CobolFloat
extends CobolNum {
    private float flValue;
    private static boolean[] dummy = new boolean[1];

    CobolFloat(float f2) {
        super((byte)3);
        this.flValue = f2;
    }

    @Override
    public float floatValue() {
        return this.flValue;
    }

    @Override
    public double doubleValue() {
        return this.flValue;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
            return new BigDecimal("10000000000000000000000000000000");
        }
        return new BigDecimal(this.flValue);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
            return OVERFLOW_BD;
        }
        return new BigCobolDec(this.flValue);
    }

    @Override
    public CobolNum set(long l2, int n2, boolean bl) {
        this.flValue = (float)((double)l2 / factDouble[n2]);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bigCobolDec) {
        this.flValue = (float)bigCobolDec.doubleValue();
        return this;
    }

    @Override
    public CobolNum set(double d2) {
        this.flValue = (float)d2;
        return this;
    }

    @Override
    public CobolNum set(float f2) {
        this.flValue = f2;
        return this;
    }

    @Override
    public CobolNum set(CobolNum cobolNum, boolean bl, boolean bl2) {
        return this.set(cobolNum.floatValue());
    }

    @Override
    public CobolNum add(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 3: {
                return new CobolFloat(this.flValue + cobolNum.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue + cobolNum.doubleValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short s2) {
        this.flValue += (float)s2;
    }

    @Override
    public void subFromMe(short s2) {
        this.flValue -= (float)s2;
    }

    @Override
    public void multiplyByMe(short s2) {
        this.flValue *= (float)s2;
    }

    @Override
    public void divideIntoMe(boolean bl, short s2) {
        this.flValue /= (float)s2;
    }

    @Override
    public void divideIntoMeByZero(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                if (this.flValue < 0.0f) {
                    this.flValue = Float.NEGATIVE_INFINITY;
                    break;
                }
                this.flValue = Float.POSITIVE_INFINITY;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.flValue = 0.0f;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                if (this.flValue < 0.0f) {
                    this.flValue = Float.NEGATIVE_INFINITY;
                    break;
                }
                this.flValue = Float.POSITIVE_INFINITY;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.flValue = 0.0f;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int n2) {
        this.flValue += (float)n2;
    }

    @Override
    public void subFromMe(int n2) {
        this.flValue -= (float)n2;
    }

    @Override
    public void multiplyByMe(int n2) {
        this.flValue *= (float)n2;
    }

    @Override
    public void divideIntoMe(boolean bl, int n2) {
        this.flValue /= (float)n2;
    }

    @Override
    public void addToMe(long l2) {
        this.flValue += (float)l2;
    }

    @Override
    public void subFromMe(long l2) {
        this.flValue -= (float)l2;
    }

    @Override
    public void multiplyByMe(long l2) {
        this.flValue *= (float)l2;
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        this.flValue /= (float)l2;
    }

    @Override
    public CobolNum add1() {
        return new CobolFloat(this.flValue + 1.0f);
    }

    @Override
    public CobolNum subtract(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 3: {
                return new CobolFloat(this.flValue - cobolNum.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue - cobolNum.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return new CobolFloat(this.flValue - 1.0f);
    }

    @Override
    public CobolNum multiply(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 3: {
                return new CobolFloat(this.flValue * cobolNum.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return new CobolDouble((double)this.flValue * cobolNum.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum multiply36(CobolNum cobolNum) {
        return this.multiply(cobolNum);
    }

    @Override
    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        switch (cobolNum.type) {
            case 0: 
            case 3: {
                return CobolFloat.divideFloat(bl, this.flValue, cobolNum.floatValue(), n2, bl2);
            }
            case 1: 
            case 2: {
                return CobolFloat.divideDouble(bl, this.flValue, cobolNum.doubleValue(), n2, bl2);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] byArray, int n2, byte[] byArray2) {
        byte[] byArray3;
        String string = Float.toString(this.flValue);
        try {
            byArray3 = string.getBytes(CobolVar.encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            byArray3 = string.getBytes();
        }
        if (byArray3.length >= n2) {
            System.arraycopy(byArray3, 0, byArray, 0, n2);
        } else {
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            for (int i2 = byArray3.length; i2 < n2; ++i2) {
                byArray[i2] = EncBytes.C_SPACE;
            }
        }
    }

    @Override
    public int toByteArray(byte[] byArray) {
        return this.bigCobDecValue().toByteArray(byArray, NumericVar.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum cobolNum, int n2) {
        switch (cobolNum.type) {
            case 0: {
                if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
                    return true;
                }
                if (this.flValue < 0.0f) {
                    return this.flValue < (float)factMin[n2];
                }
                return this.flValue > (float)factMax[n2];
            }
            case 1: {
                if (Float.isInfinite(this.flValue) || Float.isNaN(this.flValue)) {
                    return true;
                }
                if (this.flValue < 0.0f) {
                    return (double)this.flValue < -factDouble[n2];
                }
                return (double)this.flValue > factDouble[n2];
            }
            case 2: 
            case 3: {
                return Float.isInfinite(this.flValue) || Float.isNaN(this.flValue);
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum cobolNum, int n2, boolean bl) {
        return Float.isInfinite(this.flValue) || Float.isNaN(this.flValue);
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 3: {
                return CobolFloat.evalCompare(this.flValue - cobolNum.floatValue());
            }
            case 0: 
            case 1: 
            case 2: {
                return CobolFloat.evalCompare(this.doubleValue() - cobolNum.doubleValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long l2, int n2) {
        return CobolFloat.evalCompare(this.flValue - CobolFloat.floatValue(l2, n2));
    }

    @Override
    public long getUnscaledLong(boolean[] blArray) {
        long l2 = this.bigCobDecValue().setScale(0).unscaled18Digits(0);
        boolean bl = blArray[0] = this.bigCobDecValue().precision() > 18;
        if (!blArray[0]) {
            int n2 = this.bigCobDecValue().scale();
            l2 = this.bigCobDecValue().unscaled18Digits(n2);
            if (n2 < 0) {
                l2 *= fact[-n2];
            }
        }
        return l2;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory memory, int n2, int n3) {
        int n4 = Float.floatToIntBits(this.flValue);
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            memory.put(n2++, (byte)(n4 >>> (i2 << 3)));
        }
        memory.put(n2, (byte)(n4 & 0xFF));
    }

    @Override
    public void toBinaryByteArray(byte[] byArray, int n2, int n3) {
        int n4 = Float.floatToIntBits(this.flValue);
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            byArray[n2++] = (byte)(n4 >>> (i2 << 3));
        }
        byArray[n2] = (byte)(n4 & 0xFF);
    }

    @Override
    public void setSizeDigit(int n2, int n3) {
    }

    @Override
    public void setSizeByteUnsigned(int n2) {
    }

    @Override
    public void setSizeByteSigned(int n2) {
    }

    @Override
    public void setScale(int n2, boolean bl, boolean bl2) {
    }

    @Override
    public final void roundUpIfNeeded(int n2) {
    }

    @Override
    public int scale() {
        return -1;
    }

    @Override
    public int precision() {
        return -1;
    }

    @Override
    public int signum() {
        return (int)Math.signum(this.flValue);
    }

    @Override
    public void negateMe() {
        this.flValue = -this.flValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolFloat(-this.flValue);
    }

    @Override
    public void shift(int n2) {
        this.flValue = n2 < 0 ? (this.flValue /= (float)fact[-n2]) : (this.flValue *= (float)fact[n2]);
    }

    @Override
    public String toString() {
        return Float.toString(this.flValue);
    }

    @Override
    public int shortValue() {
        return (short)this.flValue;
    }

    @Override
    public int intValue() {
        return (int)this.flValue;
    }

    @Override
    public long longValue() {
        return (long)this.flValue;
    }

    @Override
    public int shortValue(boolean bl) {
        if (bl) {
            return (short)Math.round(this.flValue);
        }
        return (short)this.flValue;
    }

    @Override
    public int intValue(boolean bl) {
        if (bl) {
            return Math.round(this.flValue);
        }
        return (int)this.flValue;
    }

    @Override
    public long longValue(boolean bl) {
        if (bl) {
            return Math.round(this.flValue);
        }
        return (long)this.flValue;
    }

    @Override
    public CobolNum integerFunc() {
        return new CobolFloat((float)Math.floor(this.flValue));
    }

    @Override
    public CobolNum integerPart() {
        if (this.flValue < 0.0f) {
            return new CobolFloat((float)Math.ceil(this.flValue));
        }
        return new CobolFloat((float)Math.floor(this.flValue));
    }
}

