/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVP18;
import java.math.BigDecimal;

public class CobolInt
extends CobolVP18 {
    public CobolInt(long l2) {
        super(l2, 0);
    }

    @Override
    public CobolNum set(long l2, int n2, boolean bl) {
        this.lnUnscValue = CobolInt.computeUnscValue(l2, n2, 0, bl, true);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bigCobolDec) {
        this.lnUnscValue = bigCobolDec.unscaled18Digits(0);
        return this;
    }

    @Override
    public CobolNum set(double d2) {
        this.lnUnscValue = (long)d2;
        return this;
    }

    @Override
    public CobolNum set(CobolNum cobolNum, boolean bl, boolean bl2) {
        switch (cobolNum.type) {
            case 0: {
                return this.set(cobolNum.lnUnscValue, cobolNum.scale(), bl);
            }
            case 3: {
                this.lnUnscValue = (long)cobolNum.floatValue();
                if (bl) {
                    if (cobolNum.floatValue() > 0.0f) {
                        if ((double)(cobolNum.floatValue() - (float)this.lnUnscValue) >= 0.5) {
                            ++this.lnUnscValue;
                        }
                    } else if ((double)(cobolNum.floatValue() - (float)this.lnUnscValue) <= -0.5) {
                        --this.lnUnscValue;
                    }
                }
                return this;
            }
            case 2: {
                this.lnUnscValue = (long)cobolNum.doubleValue();
                if (bl) {
                    if (cobolNum.doubleValue() > 0.0) {
                        if (cobolNum.doubleValue() - (double)this.lnUnscValue >= 0.5) {
                            ++this.lnUnscValue;
                        }
                    } else if (cobolNum.doubleValue() - (double)this.lnUnscValue <= -0.5) {
                        --this.lnUnscValue;
                    }
                }
                return this;
            }
            case 1: {
                this.lnUnscValue = bl2 ? (bl ? cobolNum.bigCobDecValue().setScale(0, 1).longValue() : cobolNum.bigCobDecValue().longValue()) : (bl ? cobolNum.bigCobDecValue().setScale(0, 1).unscaled18Digits(0) : cobolNum.bigCobDecValue().unscaled18Digits(0));
                return this;
            }
        }
        return this;
    }

    @Override
    public void divideIntoMeByZero(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.lnUnscValue = 0L;
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.lnUnscValue = 0L;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public CobolNum add(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.addLn(this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] + (double)cobolNum.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] + cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return this;
    }

    @Override
    public void addToMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue + s2;
    }

    @Override
    public void subFromMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue - s2;
    }

    @Override
    public void multiplyByMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue * s2;
    }

    @Override
    public void divideIntoMe(boolean bl, short s2) {
        if (s2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue = (short)this.lnUnscValue / s2;
        }
    }

    @Override
    public void addToMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue + n2;
    }

    @Override
    public void subFromMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue - n2;
    }

    @Override
    public void multiplyByMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue * n2;
    }

    @Override
    public void divideIntoMe(boolean bl, int n2) {
        if (n2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue = (int)this.lnUnscValue / n2;
        }
    }

    @Override
    public void addToMe(long l2) {
        this.lnUnscValue += l2;
    }

    @Override
    public void subFromMe(long l2) {
        this.lnUnscValue -= l2;
    }

    @Override
    public void multiplyByMe(long l2) {
        this.lnUnscValue *= l2;
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        if (l2 == 0L) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue /= l2;
        }
    }

    @Override
    public CobolNum add1() {
        return CobolInt.addLn(this.lnUnscValue, this.lnScale, 1L, 0);
    }

    @Override
    public CobolNum subtract(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.addLn(this.lnUnscValue, this.lnScale, -cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] - (double)cobolNum.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] - cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return CobolInt.addLn(this.lnUnscValue, this.lnScale, -1L, 0);
    }

    @Override
    public CobolNum multiply(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.multiplyLn(this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] * (double)cobolNum.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] * cobolNum.doubleValue());
            }
            case 1: {
                return this.multiplyBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.divideLn(bl, this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale(), n2, bl2);
            }
            case 3: {
                return CobolNum.noo((float)((double)this.lnUnscValue / factDouble[this.lnScale] / (double)cobolNum.floatValue()));
            }
            case 2: {
                return CobolNum.noo((double)this.lnUnscValue / factDouble[this.lnScale] / cobolNum.doubleValue());
            }
            case 1: {
                return CobolInt.divideBd(bl, new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue(), n2, bl2);
            }
        }
        return null;
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.compareLn(this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 1: 
            case 2: 
            case 3: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long l2, int n2) {
        return CobolInt.compareLn(this.lnUnscValue, this.lnScale, l2, n2);
    }

    @Override
    public CobolNum max(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolInt.compareLn(this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale()) < 0 ? cobolNum : this;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue()) < 0 ? cobolNum : this;
            }
        }
        return null;
    }

    @Override
    public long getUnscaledLong(boolean[] blArray) {
        blArray[0] = false;
        return this.lnUnscValue;
    }

    @Override
    public long getUnscaledLong() {
        return this.lnUnscValue;
    }

    @Override
    public void setSizeDigit(int n2, int n3) {
        this.lnUnscValue %= fact[n2 + n3];
    }

    @Override
    public void setSizeByteUnsigned(int n2) {
        this.lnUnscValue &= factBytes[n2][0];
    }

    @Override
    public void setSizeByteSigned(int n2) {
        if ((this.lnUnscValue & factBytes[n2][3]) != 0L) {
            this.lnUnscValue &= factBytes[n2][1];
            this.lnUnscValue |= factBytes[n2][2];
        } else {
            this.lnUnscValue &= factBytes[n2][1];
        }
    }

    public void setScale(int n2, boolean bl) {
        if (n2 != 0) {
            throw new IscobolRuntimeException(3, "CobolInt scale != 0: " + n2);
        }
    }

    @Override
    public int scale() {
        return 0;
    }

    @Override
    public int precision() {
        return CobolInt.getNumDigits(this.lnUnscValue);
    }

    @Override
    public int signum() {
        if (this.lnUnscValue > 0L) {
            return 1;
        }
        if (this.lnUnscValue == 0L) {
            return 0;
        }
        return -1;
    }

    @Override
    public void negateMe() {
        this.lnUnscValue = -this.lnUnscValue;
    }

    @Override
    public CobolNum negate() {
        return CobolNum.noo(-this.lnUnscValue, this.lnScale);
    }

    @Override
    public String toString() {
        return new StringBuffer().append(this.lnUnscValue).toString();
    }

    @Override
    public double doubleValue() {
        return this.lnUnscValue;
    }

    @Override
    public float floatValue() {
        return this.lnUnscValue;
    }

    @Override
    public int shortValue() {
        return (short)this.lnUnscValue;
    }

    @Override
    public int intValue() {
        return (int)this.lnUnscValue;
    }

    @Override
    public long longValue() {
        return this.lnUnscValue;
    }

    @Override
    public final int shortValue(boolean bl) {
        return (short)this.lnUnscValue;
    }

    @Override
    public final int intValue(boolean bl) {
        return (int)this.lnUnscValue;
    }

    @Override
    public final long longValue(boolean bl) {
        return this.lnUnscValue;
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return BigCobolDec.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public int toByteArray(byte[] byArray) {
        return CobolInt.toByteArray(this.lnUnscValue, this.lnScale, byArray);
    }

    @Override
    public boolean isOverflow(CobolNum cobolNum, int n2) {
        switch (cobolNum.type) {
            case 0: {
                int n3 = n2 + this.lnScale;
                if (n3 > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[n3];
                }
                return this.lnUnscValue > factMax[n3];
            }
            case 1: {
                int n4 = n2 + this.lnScale;
                if (n4 > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[n4];
                }
                return this.lnUnscValue > factMax[n4];
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum cobolNum, int n2, boolean bl) {
        switch (cobolNum.type) {
            case 0: 
            case 1: {
                if (n2 <= 8) {
                    if (this.lnUnscValue < 0L) {
                        if (bl) {
                            return this.lnUnscValue < -factBytes[n2][1];
                        }
                        return this.lnUnscValue < -factBytes[n2][0];
                    }
                    if (bl) {
                        return this.lnUnscValue > factBytes[n2][1];
                    }
                    return this.lnUnscValue > factBytes[n2][0];
                }
                return false;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.lnUnscValue, this.lnScale);
    }
}

