/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.math.BigCobolInt;
import com.iscobol.rts.Config;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolFloat;
import com.iscobol.types.CobolInt;
import com.iscobol.types.CobolVP18;
import com.iscobol.types.CobolVP31;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class CobolNum
implements RuntimeErrorsNumbers,
EncBytes,
Serializable,
Cloneable {
    public static final byte UNDEFINED_TYPE = -1;
    public static final byte LONG_TYPE = 0;
    public static final byte BIGDECIMAL_TYPE = 1;
    public static final byte DOUBLE_TYPE = 2;
    public static final byte FLOAT_TYPE = 3;
    public static final int MAX_LN_DIGITS = 18;
    public static final int MAX_BD_DIGITS = 31;
    private static final long serialVersionUID = 123L;
    protected static final long OVERFLOW_LN = Long.MAX_VALUE;
    protected static final int CHECKDIV_PROPERTY = Config.a("iscobol.checkdiv", 0);
    protected static final BigCobolDec OVERFLOW_BD = new BigCobolDec("10000000000000000000000000000000");
    public static final CobolNum INFINITY = new CobolDouble(Double.POSITIVE_INFINITY);
    static final boolean fpp36 = Config.b(".math.fpp36", false);
    protected final byte type;
    public long lnUnscValue;
    public static final long[][] factBytes = new long[][]{{0L, 0L, -1L, 0L}, {255L, 127L, -128L, 128L}, {65535L, 32767L, -32768L, 32768L}, {0xFFFFFFL, 0x7FFFFFL, -8388608L, 0x800000L}, {0xFFFFFFFFL, Integer.MAX_VALUE, Integer.MIN_VALUE, 0x80000000L}, {0xFFFFFFFFFFL, 0x7FFFFFFFFFL, -549755813888L, 0x8000000000L}, {0xFFFFFFFFFFFFL, 0x7FFFFFFFFFFFL, -140737488355328L, 0x800000000000L}, {0xFFFFFFFFFFFFFFL, 0x7FFFFFFFFFFFFFL, -36028797018963968L, 0x80000000000000L}, {-1L, Long.MAX_VALUE, Long.MIN_VALUE, Long.MIN_VALUE}};
    public static final BigCobolInt[][] factBytesBigInt = new BigCobolInt[][]{{new BigCobolInt("0"), new BigCobolInt("0")}, {new BigCobolInt("255"), new BigCobolInt("127")}, {new BigCobolInt("65535"), new BigCobolInt("32767")}, {new BigCobolInt("16777215"), new BigCobolInt("8388607")}, {new BigCobolInt("4294967295"), new BigCobolInt("2147483647")}, {new BigCobolInt("1099511627775"), new BigCobolInt("549755813887")}, {new BigCobolInt("281474976710655"), new BigCobolInt("140737488355327")}, {new BigCobolInt("4503599627370495"), new BigCobolInt("36028797018963967")}, {new BigCobolInt("18446744073709551615"), new BigCobolInt("9223372036854775807")}, {new BigCobolInt("4722366482869645213695"), new BigCobolInt("2361183241434822606847")}, {new BigCobolInt("1208925819614629174706175"), new BigCobolInt("604462909807314587353087")}, {new BigCobolInt("309485009821345068724781055"), new BigCobolInt("154742504910672534362390527")}, {new BigCobolInt("79228162514264337593543950335"), new BigCobolInt("39614081257132168796771975167")}, {new BigCobolInt("20282409603651670423947251286015"), new BigCobolInt("10141204801825835211973625643007")}, {new BigCobolInt("5192296858534827628530496329220095"), new BigCobolInt("2596148429267413814265248164610047")}, {new BigCobolInt("664613997892457936451903530140172287"), new BigCobolInt("664613997892457936451903530140172287")}, {new BigCobolInt("664613997892457936451903530140172287"), new BigCobolInt("664613997892457936451903530140172287")}};
    public static final long[] fact = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L, 10000000000000L, 100000000000000L, 1000000000000000L, 10000000000000000L, 100000000000000000L, 1000000000000000000L};
    public static final long[] factMax = new long[]{0L, 9L, 99L, 999L, 9999L, 99999L, 999999L, 9999999L, 99999999L, 999999999L, 9999999999L, 99999999999L, 999999999999L, 9999999999999L, 99999999999999L, 999999999999999L, 9999999999999999L, 99999999999999999L, 999999999999999999L};
    public static final long[] factMin = new long[]{0L, -9L, -99L, -999L, -9999L, -99999L, -999999L, -9999999L, -99999999L, -999999999L, -9999999999L, -99999999999L, -999999999999L, -9999999999999L, -99999999999999L, -999999999999999L, -9999999999999999L, -99999999999999999L, -999999999999999999L};
    public static final double[] factDouble = new double[]{1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0, 1000000.0, 1.0E7, 1.0E8, 1.0E9, 1.0E10, 1.0E11, 1.0E12, 1.0E13, 1.0E14, 1.0E15, 1.0E16, 1.0E17, 1.0E18, 1.0E19, 1.0E20, 1.0E21, 1.0E22, 1.0E23, 1.0E24, 1.0E25, 1.0E26, 1.0E27, 1.0E28, 1.0E29, 1.0E30, 1.0E31, 1.0E32};
    public static final int[][] maxDigits = new int[][]{{0, 0}, {3, 3}, {5, 5}, {7, 8}, {10, 10}, {12, 13}, {15, 15}, {17, 17}, {18, 18}, {22, 22}, {24, 25}, {27, 27}, {29, 29}, {31, 31}};
    private static final long max = 0xCCCCCCCCCCCCCCCL;
    private static final long min = -922337203685477580L;
    private static final long max18 = factMax[18];
    private static final long min18 = factMin[18];
    private static boolean[] dummyErr = new boolean[]{false};

    public static CobolNum get(int n2, int n3) {
        if (n2 < 0) {
            if (n3 == -3) {
                return new CobolFloat(0.0f);
            }
            return new CobolDouble(0.0);
        }
        if (n2 > 18) {
            return new CobolVP31(new BigCobolDec(0L, n3));
        }
        if (n3 == 0) {
            return new CobolInt(0L);
        }
        if (fpp36) {
            return new CobolVP31(new BigCobolDec(0L, n3));
        }
        return new CobolVP18(0L, n3);
    }

    public static CobolNum noo(long l2, int n2) {
        return new CobolVP18(l2, n2);
    }

    public static CobolNum noo(BigCobolDec bigCobolDec) {
        return new CobolVP31(bigCobolDec);
    }

    public static CobolNum noo(BigDecimal bigDecimal) {
        return new CobolVP31(bigDecimal);
    }

    public static CobolNum noo(BigInteger bigInteger) {
        return new CobolVP31(bigInteger);
    }

    public static CobolNum noo(double d2) {
        return new CobolDouble(d2);
    }

    public static CobolNum noo(float f2) {
        return new CobolFloat(f2);
    }

    public static CobolNum noo(String string) {
        CobolNum cobolNum;
        int n2 = string.length();
        if (n2 > 18) {
            BigCobolDec bigCobolDec = new BigCobolDec();
            try {
                BigCobolDec.parseInt(bigCobolDec, string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cobolNum = CobolNum.noo(bigCobolDec);
        } else {
            long l2 = 0L;
            try {
                l2 = Long.parseLong(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            cobolNum = CobolNum.noo(l2, 0);
        }
        return cobolNum;
    }

    public static CobolNum noo(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolNum.noo(cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 1: {
                return CobolNum.noo(cobolNum.bigCobDecValue());
            }
            case 2: {
                return CobolNum.noo(cobolNum.doubleValue());
            }
            case 3: {
                return CobolNum.noo(cobolNum.floatValue());
            }
        }
        throw new IscobolRuntimeException(3, "Unhandled type: " + cobolNum.type);
    }

    protected CobolNum(byte by) {
        this.type = by;
    }

    public static CobolNum get(String string, boolean bl) {
        return CobolNum.get(string, bl, dummyErr);
    }

    public static CobolNum valueOf(String string, boolean bl, boolean[] blArray) {
        CobolNum cobolNum = CobolNum.get(string, bl, blArray);
        return cobolNum;
    }

    public static CobolNum get(String string, boolean bl, boolean[] blArray) {
        CobolNum cobolNum;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        long l2 = 0L;
        int n2 = 0;
        char[] cArray = string.trim().toCharArray();
        int n3 = 0;
        char[] cArray2 = new char[cArray.length + 1];
        int n4 = 1;
        int n5 = -1;
        double d2 = 0.0;
        cArray2[0] = 45;
        block14: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (bl6) {
                        blArray[0] = true;
                    }
                    l2 = l2 * 10L + (long)(cArray[i2] - 48);
                    cArray2[n4++] = cArray[i2];
                    ++n3;
                    bl4 = true;
                    if (!bl3) continue block14;
                    ++n2;
                    continue block14;
                }
                case '+': {
                    if (bl5 || bl6) {
                        blArray[0] = true;
                        continue block14;
                    }
                    bl5 = true;
                    if (!bl4) continue block14;
                    bl6 = true;
                    continue block14;
                }
                case '-': {
                    if (bl5 || bl6) {
                        blArray[0] = true;
                        continue block14;
                    }
                    bl2 = true;
                    bl5 = true;
                    if (!bl4) continue block14;
                    bl6 = true;
                    continue block14;
                }
                case '.': {
                    if (!bl) {
                        if (bl3) {
                            blArray[0] = true;
                            continue block14;
                        }
                        bl3 = true;
                        cArray2[n4++] = 46;
                        continue block14;
                    }
                    if (!bl6) continue block14;
                    blArray[0] = true;
                    continue block14;
                }
                case ',': {
                    if (bl) {
                        if (bl3) {
                            blArray[0] = true;
                            continue block14;
                        }
                        bl3 = true;
                        cArray2[n4++] = 46;
                        continue block14;
                    }
                    if (!bl6) continue block14;
                    blArray[0] = true;
                    continue block14;
                }
                case ' ': {
                    continue block14;
                }
                case '$': 
                case '*': 
                case '/': {
                    if (!bl6) continue block14;
                    blArray[0] = true;
                    continue block14;
                }
                case 'C': 
                case 'c': {
                    if (i2 + 1 < cArray.length && (cArray[i2 + 1] == 'R' || cArray[i2 + 1] == 'r')) {
                        if (bl5) {
                            blArray[0] = true;
                        } else {
                            bl2 = true;
                            bl5 = true;
                        }
                        ++i2;
                        bl6 = true;
                        continue block14;
                    }
                    blArray[0] = true;
                    continue block14;
                }
                case 'D': 
                case 'd': {
                    if (i2 + 1 < cArray.length && (cArray[i2 + 1] == 'B' || cArray[i2 + 1] == 'b')) {
                        if (bl5) {
                            blArray[0] = true;
                        } else {
                            bl2 = true;
                            bl5 = true;
                        }
                        ++i2;
                        bl6 = true;
                        continue block14;
                    }
                    blArray[0] = true;
                    continue block14;
                }
                case 'E': 
                case 'e': {
                    if (bl) {
                        string = string.replace(',', '.');
                    }
                    try {
                        d2 = Double.parseDouble(string);
                        n5 = 2;
                        blArray[0] = false;
                        continue block14;
                    }
                    catch (NumberFormatException numberFormatException) {
                        d2 = 0.0;
                        blArray[0] = true;
                    }
                }
                default: {
                    blArray[0] = true;
                }
            }
        }
        if (n5 == 2) {
            cobolNum = new CobolDouble(d2);
        } else if (n3 > 31) {
            cobolNum = bl2 ? new CobolDouble(Double.parseDouble(new String(cArray2, 0, n4))) : new CobolDouble(Double.parseDouble(new String(cArray2, 1, --n4)));
        } else if (n3 > 18) {
            cobolNum = bl2 ? new CobolVP31(new BigCobolDec(new String(cArray2, 0, n4))) : new CobolVP31(new BigCobolDec(new String(cArray2, 1, --n4)));
        } else {
            if (bl2) {
                l2 = -l2;
            }
            cobolNum = new CobolVP18(l2, n2);
        }
        return cobolNum;
    }

    public static int test(String string, boolean bl, char c2, char c3) {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = -1;
        int n5 = 0;
        boolean bl6 = false;
        char[] cArray = string.toCharArray();
        int n6 = cArray.length - 1;
        for (n2 = 0; n2 < cArray.length && cArray[n2] == ' '; ++n2) {
        }
        while (n6 > n2 && cArray[n6] == ' ') {
            --n6;
        }
        if (n2 > n6) {
            return cArray.length;
        }
        block17: for (int i2 = n2; i2 <= n6; ++i2) {
            switch (cArray[i2]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    if (bl5 || n5 >= 4 || n4 >= 0 && !bl6) {
                        return i2 + 1;
                    }
                    int n7 = 0;
                    block18: for (int i3 = i2 - 1; i3 >= n2; --i3) {
                        switch (cArray[i3]) {
                            case ' ': {
                                ++n7;
                                continue block18;
                            }
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                if (n7 <= 0) continue block18;
                                return i2 + 1;
                            }
                        }
                    }
                    bl3 = true;
                    if (n4 < 0) continue block17;
                    ++n5;
                    continue block17;
                }
                case '+': {
                    if (n4 >= 0) {
                        if (bl6 || n5 > 0) {
                            return i2 + 1;
                        }
                        bl6 = true;
                        continue block17;
                    }
                    if (bl4 || bl5) {
                        return i2 + 1;
                    }
                    bl4 = true;
                    if (!bl3) continue block17;
                    bl5 = true;
                    if (c2 != 'F') continue block17;
                    return i2 + 1;
                }
                case '-': {
                    if (n4 >= 0) {
                        if (bl6 || n5 > 0) {
                            return i2 + 1;
                        }
                        bl6 = true;
                        continue block17;
                    }
                    if (bl4 || bl5) {
                        return i2 + 1;
                    }
                    bl4 = true;
                    if (!bl3) continue block17;
                    bl5 = true;
                    if (c2 != 'F') continue block17;
                    return i2 + 1;
                }
                case '.': {
                    if (n4 >= 0) {
                        return i2 + 1;
                    }
                    if (!bl) {
                        if (bl2) {
                            return i2 + 1;
                        }
                        bl2 = true;
                        continue block17;
                    }
                    if (!bl5 && c2 == 'C') continue block17;
                    return i2 + 1;
                }
                case ',': {
                    if (n4 >= 0) {
                        return i2 + 1;
                    }
                    if (bl) {
                        if (bl2) {
                            return i2 + 1;
                        }
                        bl2 = true;
                        continue block17;
                    }
                    if (!bl5 && c2 == 'C') continue block17;
                    return i2 + 1;
                }
                case ' ': {
                    continue block17;
                }
                case 'C': 
                case 'c': {
                    if (c2 == 'C' && i2 < n6 && (cArray[i2 + 1] == 'R' || cArray[i2 + 1] == 'r')) {
                        if (bl4) {
                            return i2 + 1;
                        }
                        bl4 = true;
                        ++i2;
                        bl5 = true;
                        continue block17;
                    }
                    return i2 + 1;
                }
                case 'D': 
                case 'd': {
                    if (c2 == 'C' && i2 < n6 && (cArray[i2 + 1] == 'B' || cArray[i2 + 1] == 'b')) {
                        if (bl4) {
                            return i2 + 1;
                        }
                        bl4 = true;
                        ++i2;
                        bl5 = true;
                        continue block17;
                    }
                    return i2 + 1;
                }
                case 'E': 
                case 'e': {
                    if (c2 != 'F' || n4 >= 0) {
                        return i2 + 1;
                    }
                    n4 = i2;
                    continue block17;
                }
                default: {
                    if (!bl5 && c2 == 'C' && cArray[i2] == c3) continue block17;
                    return i2 + 1;
                }
            }
        }
        if (n4 >= 0 && n5 == 0) {
            return n4 + 1;
        }
        return n3;
    }

    public static CobolNum get(String string, int n2) {
        CobolNum cobolNum;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        long l2 = 0L;
        char[] cArray = string.trim().toCharArray();
        int n3 = 0;
        char[] cArray2 = new char[cArray.length + 1];
        int n4 = 1;
        cArray2[0] = 45;
        block7: for (int i2 = 0; i2 < cArray.length; ++i2) {
            switch (cArray[i2]) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    l2 = l2 * 10L + (long)(cArray[i2] - 48);
                    cArray2[n4++] = cArray[i2];
                    ++n3;
                    bl2 = true;
                    continue block7;
                }
                case '+': {
                    if (bl3 || bl4) continue block7;
                    bl3 = true;
                    if (!bl2) continue block7;
                    bl4 = true;
                    continue block7;
                }
                case '-': {
                    if (bl3 || bl4) continue block7;
                    bl = true;
                    bl3 = true;
                    if (!bl2) continue block7;
                    bl4 = true;
                    continue block7;
                }
                case 'C': 
                case 'c': {
                    if (i2 + 1 >= cArray.length || cArray[i2 + 1] != 'R' && cArray[i2 + 1] != 'r') continue block7;
                    if (!bl3) {
                        bl = true;
                        bl3 = true;
                    }
                    ++i2;
                    bl4 = true;
                    continue block7;
                }
                case 'D': 
                case 'd': {
                    if (i2 + 1 >= cArray.length || cArray[i2 + 1] != 'B' && cArray[i2 + 1] != 'b') continue block7;
                    if (!bl3) {
                        bl = true;
                        bl3 = true;
                    }
                    ++i2;
                    bl4 = true;
                }
            }
        }
        if (n3 > 18) {
            cobolNum = bl ? new CobolVP31(new BigCobolDec(new BigCobolInt(new String(cArray2, 0, n4)), n2)) : new CobolVP31(new BigCobolDec(new BigCobolInt(new String(cArray2, 1, --n4)), n2));
        } else {
            if (bl) {
                l2 = -l2;
            }
            cobolNum = new CobolVP18(l2, n2);
        }
        return cobolNum;
    }

    public static final float floatValue(long l2, int n2) {
        if (n2 > 0) {
            return (float)((double)l2 / factDouble[n2]);
        }
        return l2;
    }

    public static final double doubleValue(long l2, int n2) {
        if (n2 > 0) {
            return (double)l2 / factDouble[n2];
        }
        return l2;
    }

    public static final int evalCompare(float f2) {
        return f2 > 0.0f ? 1 : (f2 == 0.0f ? 0 : -1);
    }

    public static final int evalCompare(double d2) {
        return d2 > 0.0 ? 1 : (d2 == 0.0 ? 0 : -1);
    }

    public CobolNum set(long l2, int n2) {
        return this.set(l2, n2, false);
    }

    public abstract CobolNum set(long var1, int var3, boolean var4);

    public abstract CobolNum set(BigCobolDec var1);

    public abstract CobolNum set(float var1);

    public abstract CobolNum set(double var1);

    public abstract CobolNum set(CobolNum var1, boolean var2, boolean var3);

    public int getType() {
        return this.type;
    }

    public abstract CobolNum add(CobolNum var1);

    public abstract void addToMe(short var1);

    public abstract void subFromMe(short var1);

    public abstract void multiplyByMe(short var1);

    public abstract void divideIntoMe(boolean var1, short var2);

    public void divideIntoMe(short s2) {
        this.divideIntoMe(false, s2);
    }

    public abstract void addToMe(int var1);

    public abstract void subFromMe(int var1);

    public abstract void multiplyByMe(int var1);

    public abstract void divideIntoMe(boolean var1, int var2);

    public void divideIntoMe(int n2) {
        this.divideIntoMe(false, n2);
    }

    public abstract void addToMe(long var1);

    public abstract void subFromMe(long var1);

    public abstract void multiplyByMe(long var1);

    public abstract void divideIntoMe(boolean var1, long var2);

    public void divideIntoMe(long l2) {
        this.divideIntoMe(false, l2);
    }

    public abstract CobolNum add1();

    public abstract CobolNum subtract(CobolNum var1);

    public abstract CobolNum subtract1();

    public CobolNum pow(CobolNum cobolNum) {
        boolean bl = false;
        if (cobolNum.scale() != 0) {
            return new CobolDouble(Math.pow(this.doubleValue(), cobolNum.doubleValue()));
        }
        int n2 = cobolNum.intValue();
        if (n2 == 0) {
            return new CobolVP18(1L, 0);
        }
        if (n2 < 0) {
            bl = true;
            n2 = -n2;
        }
        CobolNum cobolNum2 = this;
        for (int i2 = 1; i2 < n2; ++i2) {
            cobolNum2 = cobolNum2.multiply(this);
        }
        if (bl) {
            cobolNum2 = new CobolVP18(1L, 0).divide(cobolNum2);
        }
        return cobolNum2;
    }

    public abstract CobolNum multiply(CobolNum var1);

    public abstract CobolNum multiply36(CobolNum var1);

    public CobolNum divide(CobolNum cobolNum) {
        return this.divide(false, cobolNum, -1, false);
    }

    public CobolNum divide(CobolNum cobolNum, int n2) {
        return this.divide(false, cobolNum, n2, false);
    }

    public CobolNum divide(CobolNum cobolNum, int n2, boolean bl) {
        return this.divide(false, cobolNum, n2, bl);
    }

    public CobolNum divide(boolean bl, CobolNum cobolNum) {
        return this.divide(bl, cobolNum, -1, false);
    }

    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2) {
        return this.divide(bl, cobolNum, n2, false);
    }

    public abstract CobolNum divide(boolean var1, CobolNum var2, int var3, boolean var4);

    public CobolNum divide36(boolean bl, CobolNum cobolNum) {
        return this.divide36(bl, cobolNum, -1, false);
    }

    public final CobolNum divide36(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        if (this.type == 2 || cobolNum.type == 2 || this.type == 3 || cobolNum.type == 3) {
            return this.divide(bl, cobolNum, n2, bl2);
        }
        return CobolNum.divideBd(bl, this.bigCobDecValue(), cobolNum.bigCobDecValue(), n2, bl2);
    }

    public CobolNum divide36(boolean bl, CobolNum cobolNum, int n2) {
        return this.divide36(bl, cobolNum, n2, false);
    }

    protected static CobolNum divideLn(boolean bl, long l2, int n2, long l3, int n3, int n4, boolean bl2) {
        int n5;
        long l4;
        int n6;
        int n7 = n2 - n3;
        if (l3 == 0L) {
            CobolNum cobolNum = CobolNum.divideByZeroLn(bl);
            if (cobolNum == null) {
                cobolNum = new CobolVP18(l2, n2);
            }
            return cobolNum;
        }
        long l5 = l2 / l3;
        if ((l2 %= l3) > 0xCCCCCCCCCCCCCCCL || l2 < -922337203685477580L) {
            l3 /= 10L;
        } else {
            l2 *= 10L;
        }
        if (n4 == -1) {
            n4 = Integer.MAX_VALUE;
            n6 = 0;
            if (l5 < max18 && l5 > min18) {
                while (l2 != 0L && (l4 = l5 * 10L + l2 / l3) < max18 && l4 > min18) {
                    l5 = l4;
                    if ((l2 %= l3) > 0xCCCCCCCCCCCCCCCL || l2 < -922337203685477580L) {
                        l3 /= 10L;
                    } else {
                        l2 *= 10L;
                    }
                    ++n6;
                }
            }
        } else {
            n5 = n4 - n7;
            if (l5 < max18 && l5 > min18) {
                for (n6 = 0; n6 < n5 && (l4 = l5 * 10L + l2 / l3) < max18 && l4 > min18; ++n6) {
                    l5 = l4;
                    if ((l2 %= l3) > 0xCCCCCCCCCCCCCCCL || l2 < -922337203685477580L) {
                        l3 /= 10L;
                        continue;
                    }
                    l2 *= 10L;
                }
            }
        }
        if (n7 != 0) {
            if (n7 < 0) {
                for (n5 = -n7; n5 > 0; --n5) {
                    if (n6 > n4 || l5 > 0xCCCCCCCCCCCCCCCL || l5 < -922337203685477580L) {
                        --n6;
                        continue;
                    }
                    l5 *= 10L;
                }
            } else {
                n6 += n7;
            }
        }
        if (bl2 && l2 / l3 >= 5L) {
            ++l5;
        }
        CobolVP18 cobolVP18 = new CobolVP18(l5, n6);
        if (n4 < n6) {
            cobolVP18.setScale(n4);
        }
        return cobolVP18;
    }

    private static CobolNum divideByZeroBd(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                return INFINITY;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                return new CobolVP31(new BigCobolDec());
            }
            case 3: {
                return null;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                return INFINITY;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                return new CobolVP31(new BigCobolDec());
            }
            case -3: 
        }
        Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
        return null;
    }

    private static CobolNum divideByZeroLn(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                return INFINITY;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                return new CobolVP18(0L, 0);
            }
            case 3: {
                return null;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                return INFINITY;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                return new CobolVP18(0L, 0);
            }
            case -3: 
        }
        Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
        return null;
    }

    public abstract void divideIntoMeByZero(boolean var1) throws DivideByZeroException;

    protected static CobolNum divideBd(boolean bl, BigCobolDec bigCobolDec, BigCobolDec bigCobolDec2, int n2, boolean bl2) {
        if (bigCobolDec2.isZero()) {
            CobolNum cobolNum = CobolNum.divideByZeroBd(bl);
            if (cobolNum == null) {
                cobolNum = new CobolVP31(bigCobolDec);
            }
            return cobolNum;
        }
        if (n2 == -1) {
            return new CobolVP31(bigCobolDec.divide(bigCobolDec2, 31, bl2 ? 1 : 0));
        }
        return new CobolVP31(bigCobolDec.divide(bigCobolDec2, n2, bl2 ? 1 : 0));
    }

    static CobolNum divideFloat(boolean bl, float f2, float f3, int n2, boolean bl2) {
        if (f3 == 0.0f) {
            int n3 = bl ? CHECKDIV_PROPERTY : 0;
            switch (n3) {
                default: {
                    return INFINITY;
                }
                case 1: {
                    throw new DivideByZeroException();
                }
                case 2: {
                    return new CobolFloat(0.0f);
                }
                case 3: {
                    return new CobolFloat(f2);
                }
                case -1: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                    return INFINITY;
                }
                case -2: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                    return new CobolFloat(0.0f);
                }
                case -3: 
            }
            Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            return new CobolFloat(f2);
        }
        return new CobolFloat(f2 / f3);
    }

    static CobolNum divideDouble(boolean bl, double d2, double d3, int n2, boolean bl2) {
        if (d3 == 0.0) {
            int n3 = bl ? CHECKDIV_PROPERTY : 0;
            switch (n3) {
                default: {
                    return INFINITY;
                }
                case 1: {
                    throw new DivideByZeroException();
                }
                case 2: {
                    return new CobolDouble(0.0);
                }
                case 3: {
                    return new CobolDouble(d2);
                }
                case -1: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                    return INFINITY;
                }
                case -2: {
                    Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                    return new CobolDouble(0.0);
                }
                case -3: 
            }
            Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            return new CobolDouble(d2);
        }
        return new CobolDouble(d2 / d3);
    }

    public static int getNumIntDigits(double d2) {
        if (d2 < 0.0) {
            d2 = -d2;
        }
        if (d2 < factDouble[16]) {
            if (d2 < factDouble[8]) {
                if (d2 < factDouble[4]) {
                    if (d2 < factDouble[2]) {
                        if (d2 < factDouble[1]) {
                            return 1;
                        }
                        return 2;
                    }
                    if (d2 < factDouble[3]) {
                        return 3;
                    }
                    return 4;
                }
                if (d2 < factDouble[6]) {
                    if (d2 < factDouble[5]) {
                        return 5;
                    }
                    return 6;
                }
                if (d2 < factDouble[7]) {
                    return 7;
                }
                return 8;
            }
            if (d2 < factDouble[12]) {
                if (d2 < factDouble[10]) {
                    if (d2 < factDouble[9]) {
                        return 9;
                    }
                    return 10;
                }
                if (d2 < factDouble[11]) {
                    return 11;
                }
                return 12;
            }
            if (d2 < factDouble[14]) {
                if (d2 < factDouble[13]) {
                    return 13;
                }
                return 14;
            }
            if (d2 < factDouble[15]) {
                return 15;
            }
            return 16;
        }
        if (d2 < factDouble[24]) {
            if (d2 < factDouble[20]) {
                if (d2 < factDouble[18]) {
                    if (d2 < factDouble[17]) {
                        return 17;
                    }
                    return 18;
                }
                if (d2 < factDouble[19]) {
                    return 19;
                }
                return 20;
            }
            if (d2 < factDouble[22]) {
                if (d2 < factDouble[21]) {
                    return 21;
                }
                return 22;
            }
            if (d2 < factDouble[23]) {
                return 23;
            }
            return 24;
        }
        if (d2 < factDouble[28]) {
            if (d2 < factDouble[26]) {
                if (d2 < factDouble[25]) {
                    return 25;
                }
                return 26;
            }
            if (d2 < factDouble[27]) {
                return 27;
            }
            return 28;
        }
        if (d2 < factDouble[30]) {
            if (d2 < factDouble[29]) {
                return 29;
            }
            return 30;
        }
        if (d2 < factDouble[31]) {
            return 31;
        }
        return 32;
    }

    public static int getNumIntDigits(BigCobolDec bigCobolDec) {
        return bigCobolDec.precision();
    }

    public static int getNumDigits(long l2) {
        if (l2 < 0L) {
            l2 = -l2;
        }
        if (l2 < fact[16]) {
            if (l2 < fact[8]) {
                if (l2 < fact[4]) {
                    if (l2 < fact[2]) {
                        if (l2 < fact[1]) {
                            return 1;
                        }
                        return 2;
                    }
                    if (l2 < fact[3]) {
                        return 3;
                    }
                    return 4;
                }
                if (l2 < fact[6]) {
                    if (l2 < fact[5]) {
                        return 5;
                    }
                    return 6;
                }
                if (l2 < fact[7]) {
                    return 7;
                }
                return 8;
            }
            if (l2 < fact[12]) {
                if (l2 < fact[10]) {
                    if (l2 < fact[9]) {
                        return 9;
                    }
                    return 10;
                }
                if (l2 < fact[11]) {
                    return 11;
                }
                return 12;
            }
            if (l2 < fact[14]) {
                if (l2 < fact[13]) {
                    return 13;
                }
                return 14;
            }
            if (l2 < fact[15]) {
                return 15;
            }
            return 16;
        }
        if (l2 < fact[17]) {
            return 17;
        }
        if (l2 < fact[18]) {
            return 18;
        }
        return 19;
    }

    protected static CobolNum multiplyLn(long l2, int n2, long l3, int n3) {
        BigCobolInt bigCobolInt;
        int n4 = CobolNum.getNumDigits(l3) + CobolNum.getNumDigits(l2) - 18;
        CobolNum cobolNum = n4 <= 0 ? new CobolVP18(l2 * l3, n2 + n3) : ((bigCobolInt = new BigCobolInt(l2).multiplyInt(new BigCobolInt(l3))).precision() > 18 ? new CobolVP31(new BigCobolDec(bigCobolInt, n2 + n3)) : new CobolVP18(bigCobolInt.longValue(), n2 + n3));
        return cobolNum;
    }

    protected CobolNum multiplyBd(BigCobolDec bigCobolDec, BigCobolDec bigCobolDec2) {
        return new CobolVP31(bigCobolDec.multiply(bigCobolDec2));
    }

    public CobolNum remainder(CobolNum cobolNum) {
        return this.remainder(false, cobolNum, -1);
    }

    public CobolNum remainder(boolean bl, CobolNum cobolNum) {
        return this.remainder(bl, cobolNum, -1);
    }

    public CobolNum remainder(CobolNum cobolNum, int n2) {
        return this.remainder(false, cobolNum, n2);
    }

    public CobolNum remainder(boolean bl, CobolNum cobolNum, int n2) {
        return this.subtract(this.divide(bl, cobolNum, n2, false).multiply(cobolNum));
    }

    public int compareTo(ICobolVar iCobolVar) {
        return -iCobolVar.compareTo(this);
    }

    public int compareTo(CobolVar cobolVar) {
        return -cobolVar.compareTo(this);
    }

    public int compareTo(NumericVar numericVar) {
        return -numericVar.compareTo(this);
    }

    public abstract int compareTo(CobolNum var1);

    public abstract int compareTo(long var1, int var3);

    public CobolNum max(CobolNum cobolNum) {
        return this.compareTo(cobolNum) < 0 ? cobolNum : this;
    }

    public CobolNum min(CobolNum cobolNum) {
        return this.compareTo(cobolNum) > 0 ? cobolNum : this;
    }

    public abstract long getUnscaledLong(boolean[] var1);

    public abstract void toBinaryByteArray(Memory var1, int var2, int var3);

    public abstract void toBinaryByteArray(byte[] var1, int var2, int var3);

    public abstract long getUnscaledLong();

    public abstract void setSizeDigit(int var1, int var2);

    public abstract void setSizeByteUnsigned(int var1);

    public abstract void setSizeByteSigned(int var1);

    public abstract void setScale(int var1, boolean var2, boolean var3);

    public void setScale(int n2) {
        this.setScale(n2, false, false);
    }

    public abstract void roundUpIfNeeded(int var1);

    public static final long roundUpIfNeeded(long l2, int n2) {
        if (l2 < 0L) {
            long l3 = -l2 % fact[n2];
            if (l3 >= fact[n2] >> 1) {
                l2 += l3;
                l2 -= fact[n2];
            }
        } else {
            long l4 = l2 % fact[n2];
            if (l4 >= fact[n2] >> 1) {
                l2 -= l4;
                l2 += fact[n2];
            }
        }
        return l2;
    }

    static long computeUnscValue(long l2, int n2, int n3, boolean bl, boolean bl2) {
        if (l2 == 0L) {
            return 0L;
        }
        if (n3 != n2) {
            if (n3 > n2) {
                if (!bl2) {
                    l2 %= fact[18 - n3 + n2];
                }
                l2 *= fact[n3 - n2];
            } else {
                int n4 = n2 - n3;
                if (n4 >= fact.length) {
                    l2 = 0L;
                } else if (bl) {
                    int n5 = 0;
                    if (l2 < 0L) {
                        if (-l2 % fact[n4] >= fact[n4] >> 1) {
                            n5 = -1;
                        }
                    } else if (l2 % fact[n4] >= fact[n4] >> 1) {
                        n5 = 1;
                    }
                    l2 /= fact[n4];
                    l2 += (long)n5;
                } else {
                    l2 /= fact[n2 - n3];
                }
            }
        }
        return l2;
    }

    public abstract int scale();

    public abstract int precision();

    public CobolNum abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    public abstract int signum();

    public abstract void negateMe();

    public abstract CobolNum negate();

    protected static int compareLn(long l2, int n2, long l3, int n3) {
        long l4 = 0L;
        int n4 = n2 - n3;
        if (n4 == 0) {
            l4 = l2 - l3;
        } else if (n4 > 0) {
            if (n4 + CobolNum.getNumDigits(l3) - 18 > 0) {
                return BigCobolDec.valueOf(l2, n2).compareTo(BigCobolDec.valueOf(l3, n3));
            }
            l4 = l2 - fact[n4] * l3;
        } else {
            if ((n4 = -n4) + CobolNum.getNumDigits(l2) - 18 > 0) {
                return BigCobolDec.valueOf(l2, n2).compareTo(BigCobolDec.valueOf(l3, n3));
            }
            l4 = l2 * fact[n4] - l3;
        }
        if (l4 > 0L) {
            return 1;
        }
        if (l4 < 0L) {
            return -1;
        }
        return 0;
    }

    protected int compareBd(BigCobolDec bigCobolDec, BigCobolDec bigCobolDec2) {
        return bigCobolDec.compareTo(bigCobolDec2);
    }

    protected static CobolNum addLn(long l2, int n2, long l3, int n3) {
        int n4;
        int n5 = n2 - n3;
        if (n5 > 0) {
            int n6 = n5 + CobolNum.getNumDigits(l3) - 18;
            if (n6 > 0) {
                if (n5 < n6) {
                    l2 /= fact[n5];
                    n4 = n2 - n5;
                } else {
                    l2 /= fact[n6];
                    l3 *= fact[n5 - n6];
                    n4 = n2 - n6;
                }
            } else {
                n4 = n2;
                l3 *= fact[n5];
            }
        } else if (n5 < 0) {
            int n7 = (n5 = -n5) + CobolNum.getNumDigits(l2) - 18;
            if (n7 > 0) {
                if (n5 < n7) {
                    l3 /= fact[n5];
                    n4 = n3 - n5;
                } else {
                    l3 /= fact[n7];
                    l2 *= fact[n5 - n7];
                    n4 = n3 - n7;
                }
            } else {
                n4 = n3;
                l2 *= fact[n5];
            }
        } else {
            n4 = n2;
        }
        return new CobolVP18(l2 + l3, n4);
    }

    protected CobolNum addBd(BigCobolDec bigCobolDec, BigCobolDec bigCobolDec2) {
        return new CobolVP31(bigCobolDec.add(bigCobolDec2));
    }

    public abstract void shift(int var1);

    public abstract String toString();

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int shortValue();

    public abstract int intValue();

    public abstract long longValue();

    public abstract int shortValue(boolean var1);

    public abstract int intValue(boolean var1);

    public abstract long longValue(boolean var1);

    public abstract CobolNum integerFunc();

    public abstract CobolNum integerPart();

    public abstract BigDecimal bigDecimalValue();

    public abstract BigCobolDec bigCobDecValue();

    public boolean isPositive() {
        return this.signum() == 1;
    }

    public boolean isNegative() {
        return this.signum() == -1;
    }

    public final void toCobolByteArray(byte[] byArray, int n2) {
        this.toCobolByteArray(byArray, n2, NumericVar.encoded_digits);
    }

    public abstract void toCobolByteArray(byte[] var1, int var2, byte[] var3);

    public abstract int toByteArray(byte[] var1);

    public static int toByteArray(long l2, int n2, byte[] byArray) {
        int n3;
        int n4 = 0;
        int n5 = 0;
        if (l2 < 0L) {
            ++n5;
            l2 = -l2;
            byArray[n4++] = C_MINUS;
        }
        if (n2 > 0) {
            ++n5;
        }
        int n6 = CobolNum.getNumDigits(l2);
        n5 += n6;
        int n7 = n6 - n2;
        if (n7 <= 0) {
            n5 += -n7;
        }
        if (n7 <= 0) {
            byArray[n4++] = C_POINT;
            for (n3 = -n7 - 1; n3 >= 0; --n3) {
                byArray[n4++] = C_0;
            }
        }
        n3 = n6;
        int n8 = 1;
        while (n3 > 0) {
            byArray[n4++] = NumericVar.encoded_digits[(int)(l2 / fact[n3 - 1])];
            l2 %= fact[n3 - 1];
            if (n8 == n7 && n2 > 0) {
                byArray[n4++] = C_POINT;
            }
            --n3;
            ++n8;
        }
        return n5;
    }

    public static boolean isLongOverflowByte(long l2, int n2, boolean bl, int n3) {
        long l3;
        if (n2 == 8) {
            l3 = factBytes[n2][1];
        } else if (n2 < factBytes.length) {
            l3 = factBytes[n2][bl ? 1 : 0];
        } else {
            return false;
        }
        if (l2 < 0L) {
            ++l3;
        }
        if (n3 > 0) {
            l2 /= fact[n3];
        } else if (n3 < 0) {
            l3 /= fact[-n3];
        }
        if (l2 < 0L) {
            return l2 < -l3;
        }
        return l2 > l3;
    }

    public static boolean isLongOverflow(long l2, int n2, int n3) {
        int n4 = n3 + n2;
        if (n4 > 18) {
            return false;
        }
        if (l2 < 0L) {
            return l2 < factMin[n4];
        }
        return l2 > factMax[n4];
    }

    public abstract boolean isOverflow(CobolNum var1, int var2);

    public abstract boolean isOverflowByte(CobolNum var1, int var2, boolean var3);

    public static void main(String[] stringArray) {
        for (int i2 = 0; i2 < factBytesBigInt.length; ++i2) {
            System.out.println(new BigInteger(factBytesBigInt[i2][0].toString()).toString(16));
            System.out.println(new BigInteger(factBytesBigInt[i2][1].toString()).toString(16));
        }
    }
}

