/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolFloat;
import com.iscobol.types.CobolNum;
import com.iscobol.types.EncBytes;
import java.math.BigDecimal;

public class CobolVP18
extends CobolNum {
    protected int lnScale;
    static final char[] zeroes = new char[]{'0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0'};

    CobolVP18(long l2, int n2) {
        super((byte)0);
        if (n2 <= 0) {
            this.lnScale = 0;
        } else {
            while (n2 > 18) {
                l2 /= 10L;
                --n2;
            }
            this.lnScale = n2;
        }
        this.lnUnscValue = l2;
    }

    @Override
    public float floatValue() {
        return CobolVP18.floatValue(this.lnUnscValue, this.lnScale);
    }

    @Override
    public double doubleValue() {
        return CobolVP18.doubleValue(this.lnUnscValue, this.lnScale);
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return BigCobolDec.valueOf(this.lnUnscValue, this.lnScale);
    }

    @Override
    public CobolNum set(long l2, int n2, boolean bl) {
        this.lnUnscValue = l2;
        this.lnScale = n2;
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bigCobolDec) {
        if (bigCobolDec.scale() < 0) {
            this.lnUnscValue = bigCobolDec.unscaled18Digits(0);
            this.lnScale = 0;
        } else {
            this.lnUnscValue = bigCobolDec.unscaled18Digits(this.lnScale);
        }
        return this;
    }

    @Override
    public CobolNum set(double d2) {
        return this.set(d2, false);
    }

    public CobolNum set(double d2, boolean bl) {
        double d3 = d2 * (double)fact[this.lnScale];
        if (d3 >= (double)fact[18]) {
            d3 %= (double)fact[18];
        }
        this.lnUnscValue = (long)d3;
        if (bl) {
            if (this.lnUnscValue < 0L) {
                if (d3 - (double)this.lnUnscValue <= -0.5) {
                    --this.lnUnscValue;
                }
            } else if (d3 - (double)this.lnUnscValue >= 0.5) {
                ++this.lnUnscValue;
            }
        }
        return this;
    }

    @Override
    public CobolNum set(float f2) {
        return this.set(f2, false);
    }

    public static long floatToUnscaledLong(float f2, int n2) {
        long l2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer(Float.toString(f2));
        int n4 = stringBuffer.indexOf(".");
        int n5 = stringBuffer.indexOf("E");
        if (n5 > 0) {
            n3 = Integer.parseInt(stringBuffer.substring(n5 + 1));
            stringBuffer.setLength(n5);
        } else {
            n3 = 0;
        }
        if (n2 == 0 && n3 == 0) {
            l2 = Long.parseLong(stringBuffer.substring(0, n4));
        } else {
            if (n3 > 0) {
                stringBuffer.append(zeroes, 0, n3);
            }
            stringBuffer.deleteCharAt(n4);
            int n6 = stringBuffer.length();
            int n7 = (n4 += n3) + n2;
            if (n7 > n6) {
                stringBuffer.append(zeroes, 0, n7 - n6);
            }
            int n8 = n4 + n2 > 18 ? n4 + n2 - 18 : 0;
            l2 = Long.parseLong(stringBuffer.substring(n8, n4 + n2));
        }
        return l2;
    }

    public CobolNum set(float f2, boolean bl) {
        this.lnUnscValue = this.lnScale > 0 ? CobolVP18.floatToUnscaledLong(f2, this.lnScale) : (long)f2;
        if (bl) {
            double d2 = f2 * (float)fact[this.lnScale];
            if (d2 >= (double)fact[18]) {
                d2 %= (double)fact[18];
            }
            if (this.lnUnscValue < 0L) {
                if (d2 - (double)this.lnUnscValue <= -0.5) {
                    --this.lnUnscValue;
                }
            } else if (d2 - (double)this.lnUnscValue >= 0.5) {
                ++this.lnUnscValue;
            }
        }
        return this;
    }

    @Override
    public CobolNum set(CobolNum cobolNum, boolean bl, boolean bl2) {
        switch (cobolNum.type) {
            case 0: {
                return this.set(((CobolVP18)cobolNum).lnUnscValue, ((CobolVP18)cobolNum).lnScale, bl);
            }
            case 3: {
                return this.set(cobolNum.floatValue(), bl);
            }
            case 2: {
                return this.set(cobolNum.doubleValue(), bl);
            }
            case 1: {
                return this.set(cobolNum.bigCobDecValue().setScale(this.lnScale, bl ? 1 : 0));
            }
        }
        return null;
    }

    @Override
    public CobolNum add(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP18.addLn(this.lnUnscValue, this.lnScale, ((CobolVP18)cobolNum).lnUnscValue, ((CobolVP18)cobolNum).lnScale);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) + cobolNum.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] + cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue + s2;
    }

    @Override
    public void subFromMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue - s2;
    }

    @Override
    public void multiplyByMe(short s2) {
        this.lnUnscValue = (short)this.lnUnscValue * s2;
    }

    @Override
    public CobolNum multiply36(CobolNum cobolNum) {
        return this.multiply(cobolNum);
    }

    @Override
    public void divideIntoMe(boolean bl, short s2) {
        if (s2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue = (short)this.lnUnscValue / s2;
        }
    }

    @Override
    public void divideIntoMeByZero(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.lnUnscValue = 0L;
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.lnUnscValue = Long.MAX_VALUE;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.lnUnscValue = 0L;
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue + n2;
    }

    @Override
    public void subFromMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue - n2;
    }

    @Override
    public void multiplyByMe(int n2) {
        this.lnUnscValue = (int)this.lnUnscValue * n2;
    }

    @Override
    public void divideIntoMe(boolean bl, int n2) {
        if (n2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue = (int)this.lnUnscValue / n2;
        }
    }

    @Override
    public void addToMe(long l2) {
        this.lnUnscValue += l2;
    }

    @Override
    public void subFromMe(long l2) {
        this.lnUnscValue -= l2;
    }

    @Override
    public void multiplyByMe(long l2) {
        this.lnUnscValue *= l2;
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        if (l2 == 0L) {
            this.divideIntoMeByZero(bl);
        } else {
            this.lnUnscValue /= l2;
        }
    }

    @Override
    public CobolNum add1() {
        return CobolVP18.addLn(this.lnUnscValue, this.lnScale, 1L, 0);
    }

    @Override
    public CobolNum subtract(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP18.addLn(this.lnUnscValue, this.lnScale, -cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) - cobolNum.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] - cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return CobolVP18.addLn(this.lnUnscValue, this.lnScale, -1L, 0);
    }

    @Override
    public CobolNum multiply(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP18.multiplyLn(this.lnUnscValue, this.lnScale, ((CobolVP18)cobolNum).lnUnscValue, ((CobolVP18)cobolNum).lnScale);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) * cobolNum.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] * cobolNum.doubleValue());
            }
            case 1: {
                return this.multiplyBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP18.divideLn(bl, this.lnUnscValue, this.lnScale, ((CobolVP18)cobolNum).lnUnscValue, ((CobolVP18)cobolNum).lnScale, n2, bl2);
            }
            case 3: {
                return new CobolFloat((float)((double)this.lnUnscValue / factDouble[this.lnScale]) / cobolNum.floatValue());
            }
            case 2: {
                return new CobolDouble((double)this.lnUnscValue / factDouble[this.lnScale] / cobolNum.doubleValue());
            }
            case 1: {
                return CobolVP18.divideBd(bl, new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue(), n2, bl2);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] byArray, int n2, byte[] byArray2) {
        int n3;
        long l2 = this.lnUnscValue < 0L ? -this.lnUnscValue : this.lnUnscValue;
        int n4 = CobolVP18.getNumDigits(l2);
        int n5 = n2 - n4;
        for (n3 = 0; n3 < n5; ++n3) {
            byArray[n3] = EncBytes.C_0;
        }
        int n6 = n4 - 1;
        while (n5 < 0) {
            l2 %= fact[n6];
            ++n5;
            --n6;
        }
        while (n3 < n2) {
            byArray[n3++] = byArray2[(int)(l2 / fact[n6])];
            l2 %= fact[n6];
            --n6;
        }
    }

    @Override
    public int toByteArray(byte[] byArray) {
        return CobolVP18.toByteArray(this.lnUnscValue, this.lnScale, byArray);
    }

    @Override
    public boolean isOverflow(CobolNum cobolNum, int n2) {
        switch (cobolNum.type) {
            case 0: {
                int n3 = n2 + this.lnScale;
                if (n3 > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[n3];
                }
                return this.lnUnscValue > factMax[n3];
            }
            case 1: {
                int n4 = n2 + this.lnScale;
                if (n4 > 18) {
                    return false;
                }
                if (this.lnUnscValue < 0L) {
                    return this.lnUnscValue < factMin[n4];
                }
                return this.lnUnscValue > factMax[n4];
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum cobolNum, int n2, boolean bl) {
        switch (cobolNum.type) {
            case 0: {
                if (n2 <= 8) {
                    return CobolVP18.isLongOverflowByte(this.lnUnscValue, n2, bl, this.lnScale - cobolNum.scale());
                }
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP18.compareLn(this.lnUnscValue, this.lnScale, cobolNum.lnUnscValue, cobolNum.scale());
            }
            case 3: {
                float f2 = this.floatValue() - cobolNum.floatValue();
                if (f2 < 0.0f) {
                    return -1;
                }
                if (f2 > 0.0f) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                double d2 = this.doubleValue() - cobolNum.doubleValue();
                if (d2 < 0.0) {
                    return -1;
                }
                if (d2 > 0.0) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                return this.compareBd(new BigCobolDec(this.lnUnscValue, this.lnScale), cobolNum.bigCobDecValue());
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long l2, int n2) {
        return CobolVP18.compareLn(this.lnUnscValue, this.lnScale, l2, n2);
    }

    @Override
    public long getUnscaledLong(boolean[] blArray) {
        blArray[0] = false;
        return this.lnUnscValue;
    }

    @Override
    public long getUnscaledLong() {
        return this.lnUnscValue;
    }

    @Override
    public void toBinaryByteArray(Memory memory, int n2, int n3) {
        if (this.lnUnscValue >= 0L) {
            while (n3 > 8) {
                memory.put(n2++, (byte)0);
                --n3;
            }
        } else {
            while (n3 > 8) {
                memory.put(n2++, (byte)-1);
                --n3;
            }
        }
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            memory.put(n2++, (byte)(this.lnUnscValue >>> (i2 << 3)));
        }
        memory.put(n2, (byte)(this.lnUnscValue & 0xFFL));
    }

    @Override
    public void toBinaryByteArray(byte[] byArray, int n2, int n3) {
        if (this.lnUnscValue >= 0L) {
            while (n3 > 8) {
                byArray[n2++] = 0;
                --n3;
            }
        } else {
            while (n3 > 8) {
                byArray[n2++] = -1;
                --n3;
            }
        }
        for (int i2 = n3 - 1; i2 > 0; --i2) {
            byArray[n2++] = (byte)(this.lnUnscValue >>> (i2 << 3));
        }
        byArray[n2] = (byte)(this.lnUnscValue & 0xFFL);
    }

    @Override
    public void setSizeDigit(int n2, int n3) {
        this.lnUnscValue %= fact[n2 + n3];
    }

    @Override
    public void setSizeByteUnsigned(int n2) {
        this.lnUnscValue &= factBytes[n2][0];
    }

    @Override
    public void setSizeByteSigned(int n2) {
        if ((this.lnUnscValue & factBytes[n2][3]) != 0L) {
            this.lnUnscValue &= factBytes[n2][1];
            this.lnUnscValue |= factBytes[n2][2];
        } else {
            this.lnUnscValue &= factBytes[n2][1];
        }
    }

    @Override
    public void setScale(int n2, boolean bl, boolean bl2) {
        this.lnUnscValue = CobolVP18.computeUnscValue(this.lnUnscValue, this.lnScale, n2, bl, bl2);
        this.lnScale = n2;
    }

    @Override
    public final void roundUpIfNeeded(int n2) {
        this.lnUnscValue = CobolVP18.roundUpIfNeeded(this.lnUnscValue, n2);
    }

    @Override
    public int scale() {
        return this.lnScale;
    }

    @Override
    public int precision() {
        return CobolVP18.getNumDigits(this.lnUnscValue);
    }

    @Override
    public int signum() {
        if (this.lnUnscValue > 0L) {
            return 1;
        }
        if (this.lnUnscValue < 0L) {
            return -1;
        }
        return 0;
    }

    @Override
    public void negateMe() {
        this.lnUnscValue = -this.lnUnscValue;
    }

    @Override
    public CobolNum negate() {
        return new CobolVP18(-this.lnUnscValue, this.lnScale);
    }

    @Override
    public void shift(int n2) {
        this.lnUnscValue = n2 < 0 ? (this.lnUnscValue /= fact[-n2]) : (this.lnUnscValue *= fact[n2]);
    }

    @Override
    public String toString() {
        String string;
        if (this.lnScale == 0) {
            string = Long.toString(this.lnUnscValue);
        } else {
            boolean bl;
            if (this.lnUnscValue < 0L) {
                string = Long.toString(-this.lnUnscValue);
                bl = true;
            } else {
                string = Long.toString(this.lnUnscValue);
                bl = false;
            }
            int n2 = string.length() - this.lnScale;
            if (n2 > 0) {
                string = string.substring(0, n2) + "." + string.substring(n2);
            } else {
                while (string.length() < this.lnScale) {
                    string = "0" + string;
                }
                string = "0." + string;
            }
            if (bl) {
                string = "-" + string;
            }
        }
        return string;
    }

    @Override
    public int shortValue() {
        return (short)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public int intValue() {
        return (int)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public long longValue() {
        return this.lnUnscValue / fact[this.lnScale];
    }

    @Override
    public int shortValue(boolean bl) {
        if (bl && this.lnScale > 0) {
            return (short)(CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale]);
        }
        return (short)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public int intValue(boolean bl) {
        if (bl && this.lnScale > 0) {
            return (int)(CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale]);
        }
        return (int)(this.lnUnscValue / fact[this.lnScale]);
    }

    @Override
    public long longValue(boolean bl) {
        if (bl && this.lnScale > 0) {
            return CobolVP18.roundUpIfNeeded(this.lnUnscValue, this.lnScale) / fact[this.lnScale];
        }
        return this.lnUnscValue / fact[this.lnScale];
    }

    @Override
    public CobolNum integerFunc() {
        long l2 = this.lnUnscValue / fact[this.lnScale];
        if (this.lnUnscValue >= 0L || this.lnUnscValue % fact[this.lnScale] == 0L) {
            return new CobolVP18(l2, 0);
        }
        return new CobolVP18(--l2, 0);
    }

    @Override
    public CobolNum integerPart() {
        return new CobolVP18(this.lnUnscValue / fact[this.lnScale], 0);
    }
}

