/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.math.BigCobolInt;
import com.iscobol.rts.DivideByZeroException;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolDouble;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVP18;
import com.iscobol.types.PicDisplay;
import java.math.BigDecimal;
import java.math.BigInteger;

public class CobolVP31
extends CobolNum {
    private BigCobolDec bigDecValue;
    private static boolean[] dummy = new boolean[1];

    CobolVP31(BigCobolDec bigCobolDec) {
        super((byte)1);
        this.bigDecValue = bigCobolDec;
    }

    CobolVP31(BigDecimal bigDecimal) {
        super((byte)1);
        this.bigDecValue = new BigCobolDec(bigDecimal.unscaledValue().toByteArray(), true, bigDecimal.scale());
    }

    CobolVP31(BigInteger bigInteger) {
        super((byte)1);
        this.bigDecValue = new BigCobolDec(bigInteger.toByteArray(), true, 0);
    }

    @Override
    public float floatValue() {
        return this.bigDecValue.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.bigDecValue.doubleValue();
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return new BigDecimal(new BigInteger(this.bigDecValue.toByteArray()), this.bigDecValue.scale());
    }

    @Override
    public BigCobolDec bigCobDecValue() {
        return this.bigDecValue;
    }

    @Override
    public CobolNum set(long l2, int n2, boolean bl) {
        this.bigDecValue = new BigCobolDec(l2, n2);
        return this;
    }

    @Override
    public CobolNum set(BigCobolDec bigCobolDec) {
        this.bigDecValue = new BigCobolDec(bigCobolDec);
        return this;
    }

    @Override
    public CobolNum set(double d2) {
        this.bigDecValue = new BigCobolDec(d2);
        return this;
    }

    @Override
    public CobolNum set(float f2) {
        this.bigDecValue = new BigCobolDec(f2);
        return this;
    }

    @Override
    public CobolNum set(CobolNum cobolNum, boolean bl, boolean bl2) {
        if (bl) {
            this.bigDecValue = cobolNum.bigCobDecValue().setScale(this.bigDecValue.scale(), 1);
            return this;
        }
        return this.set(cobolNum.bigCobDecValue());
    }

    @Override
    public CobolNum add(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return this.addBd(this.bigDecValue, new BigCobolDec(cobolNum.lnUnscValue, cobolNum.scale()));
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() + cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(this.bigDecValue, cobolNum.bigCobDecValue());
            }
        }
        return null;
    }

    @Override
    public void addToMe(short s2) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(s2));
    }

    @Override
    public void subFromMe(short s2) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(s2));
    }

    @Override
    public void multiplyByMe(short s2) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(s2));
    }

    @Override
    public void divideIntoMe(boolean bl, short s2) {
        if (s2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(s2), 0);
        }
    }

    @Override
    public void divideIntoMeByZero(boolean bl) throws DivideByZeroException {
        int n2 = bl ? CHECKDIV_PROPERTY : 0;
        switch (n2) {
            default: {
                this.bigDecValue = OVERFLOW_BD;
                break;
            }
            case 1: {
                throw new DivideByZeroException();
            }
            case 2: {
                this.bigDecValue = new BigCobolDec();
                break;
            }
            case 3: {
                break;
            }
            case -1: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumend undefined result");
                this.bigDecValue = OVERFLOW_BD;
                break;
            }
            case -2: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed result is 0");
                this.bigDecValue = new BigCobolDec();
                break;
            }
            case -3: {
                Factory.log("CHECK DIVIDE: detected divide by 0 assumed divide by 1");
            }
        }
    }

    @Override
    public void addToMe(int n2) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(n2));
    }

    @Override
    public void subFromMe(int n2) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(n2));
    }

    @Override
    public void multiplyByMe(int n2) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(n2));
    }

    @Override
    public void divideIntoMe(boolean bl, int n2) {
        if (n2 == 0) {
            this.divideIntoMeByZero(bl);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(n2), 0);
        }
    }

    @Override
    public void addToMe(long l2) {
        this.bigDecValue = this.bigDecValue.add(BigCobolDec.valueOf(l2));
    }

    @Override
    public void subFromMe(long l2) {
        this.bigDecValue = this.bigDecValue.subtract(BigCobolDec.valueOf(l2));
    }

    @Override
    public void multiplyByMe(long l2) {
        this.bigDecValue = this.bigDecValue.multiply(BigCobolDec.valueOf(l2));
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        if (l2 == 0L) {
            this.divideIntoMeByZero(bl);
        } else {
            this.bigDecValue = this.bigDecValue.divide(BigCobolDec.valueOf(l2), 0);
        }
    }

    @Override
    public CobolNum add1() {
        return this.addBd(this.bigDecValue, BigCobolDec.valueOf(1L));
    }

    @Override
    public CobolNum subtract(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: {
                return this.addBd(this.bigDecValue, new BigCobolDec(-((CobolVP18)cobolNum).lnUnscValue, ((CobolVP18)cobolNum).scale()));
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() - cobolNum.doubleValue());
            }
            case 1: {
                return this.addBd(this.bigDecValue, cobolNum.bigCobDecValue().negate());
            }
        }
        return null;
    }

    @Override
    public CobolNum subtract1() {
        return this.addBd(this.bigDecValue, BigCobolDec.valueOf(-1L));
    }

    @Override
    public CobolNum multiply(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: 
            case 1: {
                return this.multiplyBd(this.bigDecValue, cobolNum.bigCobDecValue());
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() * cobolNum.doubleValue());
            }
        }
        return null;
    }

    @Override
    public CobolNum multiply36(CobolNum cobolNum) {
        return this.multiplyBd(this.bigCobDecValue(), cobolNum.bigCobDecValue());
    }

    @Override
    public CobolNum divide(boolean bl, CobolNum cobolNum, int n2, boolean bl2) {
        switch (cobolNum.type) {
            case 0: {
                return CobolVP31.divideBd(bl, this.bigDecValue, cobolNum.bigCobDecValue(), n2, bl2);
            }
            case 2: 
            case 3: {
                return new CobolDouble(this.bigDecValue.doubleValue() / cobolNum.doubleValue());
            }
            case 1: {
                return CobolVP31.divideBd(bl, this.bigDecValue, cobolNum.bigCobDecValue(), n2, bl2);
            }
        }
        return null;
    }

    @Override
    public void toCobolByteArray(byte[] byArray, int n2, byte[] byArray2) {
        this.bigDecValue.toCobolByteArray(byArray, n2, byArray2);
    }

    @Override
    public int toByteArray(byte[] byArray) {
        return this.bigDecValue.toByteArray(byArray, PicDisplay.encoded_digits);
    }

    @Override
    public boolean isOverflow(CobolNum cobolNum, int n2) {
        switch (cobolNum.type) {
            case 0: 
            case 1: {
                return this.bigDecValue.precision() - this.bigDecValue.scale() > n2;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isOverflowByte(CobolNum cobolNum, int n2, boolean bl) {
        switch (cobolNum.type) {
            case 0: 
            case 1: {
                BigCobolInt bigCobolInt = factBytesBigInt[n2][bl ? 1 : (n2 == 8 ? 1 : 0)];
                BigCobolInt bigCobolInt2 = this.bigDecValue;
                int n3 = this.scale() - cobolNum.scale();
                if (n3 > 0) {
                    bigCobolInt2 = new BigCobolInt(bigCobolInt2);
                    bigCobolInt2.shift(-n3);
                } else if (n3 < 0) {
                    bigCobolInt = new BigCobolInt(bigCobolInt);
                    bigCobolInt.shift(n3);
                }
                return bigCobolInt2.absCompareTo(bigCobolInt) > 0;
            }
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        switch (cobolNum.type) {
            case 0: 
            case 1: {
                return this.compareBd(this.bigDecValue, cobolNum.bigCobDecValue());
            }
            case 3: {
                float f2 = this.floatValue() - cobolNum.floatValue();
                if (f2 < 0.0f) {
                    return -1;
                }
                if (f2 > 0.0f) {
                    return 1;
                }
                return 0;
            }
            case 2: {
                double d2 = this.doubleValue() - cobolNum.doubleValue();
                if (d2 < 0.0) {
                    return -1;
                }
                if (d2 > 0.0) {
                    return 1;
                }
                return 0;
            }
        }
        return 0;
    }

    @Override
    public int compareTo(long l2, int n2) {
        return this.compareBd(this.bigDecValue, new BigCobolDec(l2, n2));
    }

    @Override
    public long getUnscaledLong(boolean[] blArray) {
        long l2 = this.bigDecValue.setScale(0).unscaled18Digits(0);
        boolean bl = blArray[0] = this.bigDecValue.precision() > 18;
        if (!blArray[0]) {
            int n2 = this.bigDecValue.scale();
            l2 = this.bigDecValue.unscaled18Digits(n2);
            if (n2 < 0) {
                l2 *= fact[-n2];
            }
        }
        return l2;
    }

    @Override
    public long getUnscaledLong() {
        return this.getUnscaledLong(dummy);
    }

    @Override
    public void toBinaryByteArray(Memory memory, int n2, int n3) {
        byte[] byArray = this.bigDecValue.toByteArray();
        switch (this.bigDecValue.signum()) {
            case -1: {
                while (n3 > byArray.length) {
                    memory.put(n2++, (byte)-1);
                    --n3;
                }
                break;
            }
            case 0: 
            case 1: {
                while (n3 > byArray.length) {
                    memory.put(n2++, (byte)0);
                    --n3;
                }
                break;
            }
        }
        for (int i2 = byArray.length - n3; i2 < byArray.length; ++i2) {
            memory.put(n2++, byArray[i2]);
        }
    }

    @Override
    public void toBinaryByteArray(byte[] byArray, int n2, int n3) {
        byte[] byArray2 = this.bigDecValue.toByteArray();
        switch (this.bigDecValue.signum()) {
            case -1: {
                while (n3 > byArray2.length) {
                    byArray[n2++] = -1;
                    --n3;
                }
                break;
            }
            case 0: 
            case 1: {
                while (n3 > byArray2.length) {
                    byArray[n2++] = 0;
                    --n3;
                }
                break;
            }
        }
        for (int i2 = byArray2.length - n3; i2 < byArray2.length; ++i2) {
            byArray[n2++] = byArray2[i2];
        }
    }

    @Override
    public void setSizeDigit(int n2, int n3) {
        this.bigDecValue.narrowMe(n2 + n3, n3);
    }

    @Override
    public void setSizeByteUnsigned(int n2) {
        this.bigDecValue.andMe(factBytesBigInt[n2][0]);
    }

    @Override
    public void setSizeByteSigned(int n2) {
        this.bigDecValue.andMe(factBytesBigInt[n2][1]);
    }

    @Override
    public void setScale(int n2, boolean bl, boolean bl2) {
        this.bigDecValue = this.bigDecValue.setScale(n2, bl ? 1 : 0);
    }

    @Override
    public final void roundUpIfNeeded(int n2) {
        this.bigDecValue.roundUpIfNeeded(n2);
    }

    @Override
    public int scale() {
        return this.bigDecValue.scale();
    }

    @Override
    public int precision() {
        return this.bigDecValue.precision();
    }

    @Override
    public int signum() {
        return this.bigDecValue.signum();
    }

    @Override
    public void negateMe() {
        this.bigDecValue = this.bigDecValue.negate();
    }

    @Override
    public CobolNum negate() {
        return new CobolVP31(this.bigDecValue.negate());
    }

    @Override
    public void shift(int n2) {
        this.bigDecValue.shift(n2);
    }

    @Override
    public String toString() {
        return this.bigDecValue.toString();
    }

    @Override
    public int shortValue() {
        return this.bigDecValue.shortValue();
    }

    @Override
    public int intValue() {
        return this.bigDecValue.intValue();
    }

    @Override
    public long longValue() {
        return this.bigDecValue.longValue();
    }

    @Override
    public int shortValue(boolean bl) {
        if (bl && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).shortValue();
        }
        return this.bigDecValue.shortValue();
    }

    @Override
    public int intValue(boolean bl) {
        if (bl && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).intValue();
        }
        return this.bigDecValue.intValue();
    }

    @Override
    public long longValue(boolean bl) {
        if (bl && this.bigDecValue.scale() > 0) {
            return this.bigDecValue.setScale(0, 1).longValue();
        }
        return this.bigDecValue.longValue();
    }

    @Override
    public CobolNum integerFunc() {
        BigCobolDec bigCobolDec = this.bigDecValue.setScale(0);
        if (this.bigDecValue.isNegative() && this.bigDecValue.hasFractionalPart()) {
            bigCobolDec.addToMe(BigCobolDec.valueOf(-1L));
        }
        return new CobolVP31(bigCobolDec);
    }

    @Override
    public CobolNum integerPart() {
        return new CobolVP31(this.bigDecValue.setScale(0));
    }
}

