/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;

public class FloatingPointConverter {
    public static final boolean ibmhfp = "ibm_hfp".equalsIgnoreCase(Config.a(".floating_point_format", "ieee_754"));

    public static int floatToIntBits(float f2) {
        if (ibmhfp) {
            return FloatingPointConverter.floatToIntBitsHFP(f2);
        }
        return Float.floatToIntBits(f2);
    }

    public static float intBitsToFloat(int n2) {
        if (ibmhfp) {
            return FloatingPointConverter.intBitsToFloatHFP(n2);
        }
        return Float.intBitsToFloat(n2);
    }

    public static long doubleToLongBits(double d2) {
        if (ibmhfp) {
            return FloatingPointConverter.doubleToLongBitsHFP(d2);
        }
        return Double.doubleToLongBits(d2);
    }

    public static double longBitsToDouble(long l2) {
        if (ibmhfp) {
            return FloatingPointConverter.longBitsToDoubleHFP(l2);
        }
        return Double.longBitsToDouble(l2);
    }

    private static double longBitsToDoubleHFP(long l2) {
        long l3 = l2 & Long.MIN_VALUE;
        if ((l2 & Long.MAX_VALUE) == 0L) {
            return Double.longBitsToDouble(l3);
        }
        long l4 = l2 & 0xFFFFFFFFFFFFFFL;
        long l5 = (l2 & 0x7F00000000000000L) >> 56;
        long l6 = (l5 - 64L << 2) + 1023L - 1L;
        if ((l4 >>= 3) == 0L) {
            return Double.longBitsToDouble(l3);
        }
        while ((l4 & 0x10000000000000L) == 0L) {
            --l6;
            l4 <<= 1;
        }
        if (l6 <= 0L) {
            l4 = l6 < -56L ? 0L : (l4 >>= (int)(-l6 + 1L));
            l6 = 0L;
        } else if (l6 >= 2047L) {
            l4 = 0L;
            l6 = 2047L;
        } else {
            l4 &= 0xFFFFFFFFFFFFFL;
        }
        return Double.longBitsToDouble(l3 | l6 << 52 | l4);
    }

    private static long doubleToLongBitsHFP(double d2) {
        long l2 = Double.doubleToLongBits(d2);
        long l3 = l2 & Long.MIN_VALUE;
        if ((l2 & Long.MAX_VALUE) == 0L) {
            return l3;
        }
        long l4 = l2 & 0xFFFFFFFFFFFFFL;
        int n2 = (int)((l2 & 0x7FF0000000000000L) >> 52);
        if (n2 == 2047) {
            return l3 | 0x7F00000000000000L | 0xFFFFFFFFFFFFFFL;
        }
        if (n2 > 0) {
            l4 |= 0x10000000000000L;
        }
        if (n2 == 0 && (l4 & 0xF0000000000000L) == 0L) {
            l4 <<= 4;
            n2 -= 3;
        }
        l4 <<= 3;
        long l5 = n2 - 766;
        l4 >>= (int)(-l5 & 3L);
        l5 += 3L;
        l5 /= 4L;
        while ((l4 & 0xF0000000000000L) == 0L) {
            --l5;
            l4 <<= 4;
        }
        if (l5 < 0L) {
            return l3;
        }
        if (l5 > 127L) {
            throw new IllegalArgumentException("Number too large");
        }
        return l3 | l5 << 56 | l4;
    }

    private static float intBitsToFloatHFP(int n2) {
        int n3 = n2 & Integer.MIN_VALUE;
        if ((n2 & Integer.MAX_VALUE) == 0) {
            return Float.intBitsToFloat(n3);
        }
        int n4 = n2 & 0xFFFFFF;
        int n5 = (n2 & 0x7F000000) >> 24;
        int n6 = (n5 - 64 << 2) + 127 - 1;
        if (n4 == 0) {
            return Float.intBitsToFloat(n3);
        }
        while ((n4 & 0x800000) == 0) {
            --n6;
            n4 <<= 1;
        }
        if (n6 <= 0) {
            n4 = n6 < -24 ? 0 : (n4 >>= -n6 + 1);
            n6 = 0;
        } else if (n6 >= 255) {
            n4 = 0;
            n6 = 255;
        } else {
            n4 &= 0x7FFFFF;
        }
        return Float.intBitsToFloat(n3 | n6 << 23 | n4);
    }

    private static int floatToIntBitsHFP(float f2) {
        int n2 = Float.floatToIntBits(f2);
        int n3 = n2 & Integer.MIN_VALUE;
        if ((n2 & Integer.MAX_VALUE) == 0) {
            return n3;
        }
        int n4 = n2 & 0x7FFFFF;
        int n5 = (n2 & 0x7F800000) >> 23;
        if (n5 == 255) {
            return n3 | 0x7F000000 | 0xFFFFFF;
        }
        if (n5 > 0) {
            n4 |= 0x800000;
        }
        if (n5 == 0 && (n4 & 0xF00000) == 0) {
            n4 <<= 4;
            n5 -= 3;
        }
        int n6 = n5 + 130;
        n4 >>= -n6 & 3;
        n6 += 3;
        n6 /= 4;
        while ((n4 & 0xF00000) == 0) {
            --n6;
            n4 <<= 4;
        }
        return n3 | n6 << 24 | n4;
    }
}

