/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolVar;
import java.io.Serializable;
import java.util.Vector;

class MemMan
implements Serializable {
    private static final long serialVersionUID = 1L;
    byte[] memory;
    private CobolVar lastUsed;
    private boolean isUnsync;
    private Vector dynAreas;

    MemMan() {
    }

    MemMan(byte[] byArray) {
        this.memory = byArray;
    }

    protected final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    void setUnsync(CobolVar cobolVar) {
        if (this.lastUsed != cobolVar) {
            if (this.isUnsync) {
                try {
                    this.lastUsed.updateMemory(this.memory);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw arrayIndexOutOfBoundsException;
                }
                catch (Exception exception) {
                    if (this.memory == null) {
                        throw new NullPointerException();
                    }
                    CobolVar cobolVar2 = cobolVar;
                    while (cobolVar.getParent() != null) {
                        cobolVar = cobolVar.getParent();
                    }
                    String string = "Concurrent access to '" + cobolVar.getName() + "'";
                    string = cobolVar != cobolVar2 ? string + " group-item" : string + " data-item";
                    throw new IscobolRuntimeException(3, string);
                }
            }
            this.lastUsed = cobolVar;
        }
        this.isUnsync = true;
    }

    boolean isLastUsed(CobolVar cobolVar) {
        return cobolVar == this.lastUsed;
    }

    public byte[] getMemory(CobolVar cobolVar) {
        byte[] byArray = this.getMemory();
        this.lastUsed = cobolVar;
        return byArray;
    }

    public byte[] getMemory() {
        if (this.isUnsync) {
            try {
                this.lastUsed.updateMemory(this.memory);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw arrayIndexOutOfBoundsException;
            }
            catch (Exception exception) {
                if (this.memory == null) {
                    throw new NullPointerException();
                }
                throw new IscobolRuntimeException(3, "Concurrent access to memory block");
            }
            this.isUnsync = false;
        }
        this.lastUsed = null;
        return this.memory;
    }

    MemMan(MemMan memMan) {
        this.memory = new byte[memMan.memory.length];
        this.init(memMan);
    }

    MemMan(MemMan memMan, int n2) {
        this.memory = new byte[n2];
        this.init(memMan);
    }

    private void init(MemMan memMan) {
        if (memMan.dynAreas != null) {
            this.dynAreas = new Vector();
            this.dynAreas.setSize(memMan.dynAreas.size());
        }
    }

    public final int addDynamic() {
        int n2;
        if (this.dynAreas == null) {
            this.dynAreas = new Vector();
            n2 = 0;
        } else {
            n2 = this.dynAreas.size();
        }
        this.dynAreas.setSize(n2 + 1);
        return n2;
    }

    public final void allocMemory(int n2, int n3) {
        if (n2 >= 0) {
            byte[] byArray = (byte[])this.dynAreas.elementAt(n2);
            if (byArray == null || n3 != byArray.length) {
                this.dynAreas.setElementAt(new byte[n3], n2);
            }
        } else {
            if (n3 != this.memory.length) {
                this.memory = new byte[n3];
            }
            this.isUnsync = false;
            this.lastUsed = null;
        }
    }

    public final byte[] getMemory(int n2) {
        if (n2 >= 0) {
            return (byte[])this.dynAreas.elementAt(n2);
        }
        return this.getMemory();
    }

    public final void copyFrom(MemMan memMan, boolean bl) {
        if (bl) {
            this.memory = (byte[])memMan.memory.clone();
        }
        this.isUnsync = false;
        this.lastUsed = null;
        if (memMan.dynAreas != null) {
            int n2 = memMan.dynAreas.size();
            this.dynAreas = new Vector(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                byte[] byArray = (byte[])memMan.dynAreas.elementAt(i2);
                if (byArray != null) {
                    this.dynAreas.addElement(byArray.clone());
                    continue;
                }
                this.dynAreas.addElement(null);
            }
        }
    }

    public final int compareTo(MemMan memMan) {
        if (memMan.dynAreas != null) {
            int n2 = this.dynAreas.size() - memMan.dynAreas.size();
            if (n2 != 0) {
                return n2;
            }
            int n3 = memMan.dynAreas.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                byte[] byArray = (byte[])this.dynAreas.elementAt(i2);
                byte[] byArray2 = (byte[])memMan.dynAreas.elementAt(i2);
                if (byArray != null) {
                    if (byArray2 != null) {
                        n2 = CobolVar.compareTo(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
                        if (n2 == 0) continue;
                        return n2;
                    }
                    return 1;
                }
                if (byArray2 == null) continue;
                return -1;
            }
        }
        return 0;
    }

    public final boolean isDynamic() {
        return this.dynAreas != null;
    }

    public final String toString() {
        return new String(this.memory);
    }
}

