/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.Literal;
import com.iscobol.types.NumericLiteralAll;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.Pic1;
import com.iscobol.types.PicN;
import com.iscobol.types.PicNumEdit;
import com.iscobol.types.PicX;
import java.math.BigDecimal;
import java.math.BigInteger;

public abstract class NumericVar
extends CobolVar
implements INumericVar,
EncBytes {
    public static final boolean showZeroes;
    public static final int checkNC;
    public static final String zeroFill = "00000000000000000000000000000000";
    static final byte[][] dca_encoded_sign;
    static final byte[][] dci_encoded_sign;
    static final byte[][] dcm_encoded_sign;
    static final byte[][] dcb_encoded_sign;
    static final byte[][] dcr_encoded_sign;
    static final byte[] encoded_digits;
    public static final NumericVar ZERO;
    final short intLen;
    final short decLen;
    final boolean signed;
    public CobolNum theValue;
    protected boolean lenInBytes;
    protected int len;
    protected int end;
    private static final long serialVersionUID = 123L;
    static final CobolNum zero;
    public static final int[] XLEN;

    abstract void updateCache(byte[] var1, CobolNum var2);

    abstract void updateMemory(byte[] var1, CobolNum var2);

    @Override
    public void setZero() {
        this.defaultInitialize();
    }

    @Override
    public void setAllZero() {
        this.defaultInitialize();
    }

    protected static int bDigits(int n2, int n3, int n4) {
        int n5 = n3 + n4;
        if (n5 == 0) {
            n5 = XLEN[n2];
        }
        return n5;
    }

    NumericVar(byte[] byArray, int n2, int n3, int n4, boolean bl, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(byArray, n2, n5, nArray, nArray2, string, bl2);
        this.intLen = (short)n3;
        this.decLen = (short)n4;
        this.signed = bl;
        this.theValue = CobolNum.get(this.intLen + this.decLen, (int)this.decLen);
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    NumericVar(CobolVar cobolVar, int n2, int n3, int n4, boolean bl, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(cobolVar, n2, n5, nArray, nArray2, string, bl2);
        this.intLen = (short)n3;
        this.decLen = (short)n4;
        this.signed = bl;
        this.theValue = CobolNum.get(this.intLen + this.decLen, (int)this.decLen);
        this.len = this.getLen();
        this.end = this.getEnd();
    }

    int getAlphaBuffSize() {
        int n2 = this.intLen + 1;
        if (this.signed) {
            ++n2;
        }
        if (this.decLen > 0) {
            n2 += this.decLen + 1;
        }
        return n2;
    }

    protected Object clone() {
        NumericVar numericVar;
        try {
            numericVar = (NumericVar)super.clone();
            numericVar.theValue = CobolNum.noo(this.theValue);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            numericVar = null;
        }
        return numericVar;
    }

    @Override
    protected void updateEnd() {
        this.end = this.getEnd();
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    public NumericVar set(CobolVar cobolVar) {
        cobolVar.moveTo(this);
        return this;
    }

    @Override
    void internalSet(CobolVar cobolVar) {
        cobolVar.moveTo(this);
    }

    long parseLong(byte[] byArray, int n2, int n3) throws NumberFormatException {
        long l2 = 0L;
        boolean bl = false;
        if (byArray[n2] == C_MINUS) {
            bl = true;
            ++n2;
        }
        for (int i2 = n2; i2 <= n3; ++i2) {
            if (byArray[i2] < C_0 || byArray[i2] > C_9) {
                throw new NumberFormatException("" + byArray[i2]);
            }
            l2 = l2 * 10L + (long)byArray[i2] - (long)C_0;
        }
        return bl ? -l2 : l2;
    }

    @Override
    void setBytes(byte[] byArray, int n2, int n3) {
        block16: {
            if (byArray != null) {
                int n4 = n2 + n3 - 1;
                while (n2 <= n4 && byArray[n2] == C_SPACE) {
                    ++n2;
                }
                while (n4 >= n2 && byArray[n4] == C_SPACE) {
                    --n4;
                }
                n3 = n4 + 1 - n2;
                if (n3 > 0) {
                    int n5;
                    byte by = C_POINT;
                    for (n5 = n2; n5 <= n4 && byArray[n5] != by; ++n5) {
                    }
                    if (n5 <= n4) {
                        int n6 = n4 - n5;
                        if (n6 > this.decLen) {
                            n6 = this.decLen;
                        }
                        try {
                            if (n6 > 0) {
                                long l2 = this.parseLong(byArray, n2, n5 - 1) * CobolNum.fact[n6];
                                if (l2 < 0L) {
                                    this.set(l2 - this.parseLong(byArray, n5 + 1, n5 + n6), n6, false, false);
                                } else {
                                    this.set(l2 + this.parseLong(byArray, n5 + 1, n5 + n6), n6, false, false);
                                }
                                break block16;
                            }
                            this.set(this.parseLong(byArray, n2, n5 - 1), n6, false, false);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.set(0L, 0, false, false);
                        }
                    } else {
                        try {
                            this.set(this.parseLong(byArray, n2, n4), 0, false, false);
                        }
                        catch (NumberFormatException numberFormatException) {
                            this.set(0L, 0, false, false);
                        }
                    }
                } else {
                    this.set(0L, 0, false, false);
                }
            }
        }
    }

    @Override
    public boolean set(String string) {
        return this.set(CobolNum.get(string, false));
    }

    @Override
    public boolean set(byte[] byArray, int n2, int n3, boolean bl) {
        boolean bl2 = super.set(byArray, n2, n3, this.getLen(), bl);
        this.updateCache(this.memory.getMemory(this), this.theValue);
        return bl2;
    }

    @Override
    public final boolean set(byte[] byArray, int n2, int n3, int n4, boolean bl) {
        boolean bl2 = super.set(byArray, n2, n3, n4, bl);
        this.updateCache(this.memory.getMemory(this), this.theValue);
        return bl2;
    }

    @Override
    public boolean set(CobolNum cobolNum) {
        return this.set(cobolNum, false, false);
    }

    @Override
    public boolean set(Object object) {
        if (object != null) {
            if (object instanceof CobolNum) {
                return this.set((CobolNum)object, false, false);
            }
            if (object instanceof NumericVar) {
                return this.set(((NumericVar)object).num(), false, false);
            }
            if (object instanceof BigDecimal) {
                return this.set((BigDecimal)object);
            }
            if (object instanceof Double) {
                return this.set((Double)object);
            }
            if (object instanceof Float) {
                return this.set(((Float)object).doubleValue());
            }
            return this.set(object.toString());
        }
        throw new NullPointerException();
    }

    @Override
    public boolean set(boolean bl) {
        return this.set(bl ? 1L : 0L, 0, false, false);
    }

    @Override
    public boolean set(byte by) {
        return this.set(by, 0, false, false);
    }

    @Override
    public boolean set(char c2) {
        return this.set(c2, 0, false, false);
    }

    @Override
    public boolean set(short s2) {
        return this.set(s2, 0, false, false);
    }

    @Override
    public boolean set(int n2) {
        return this.set(n2, 0, false, false);
    }

    @Override
    public boolean set(long l2) {
        return this.set(l2, 0, false, false);
    }

    @Override
    public boolean set(float f2) {
        return this.set(CobolNum.noo(f2), false, false);
    }

    @Override
    public boolean set(double d2) {
        return this.set(CobolNum.noo(d2), false, false);
    }

    public boolean set(BigCobolDec bigCobolDec) {
        if (bigCobolDec.precision() > 18) {
            return this.set(CobolNum.noo(bigCobolDec), false, false);
        }
        return this.set(CobolNum.noo(bigCobolDec.unscaled18Digits(bigCobolDec.scale()), bigCobolDec.scale()), false, false);
    }

    public boolean set(BigDecimal bigDecimal) {
        BigInteger bigInteger = bigDecimal.unscaledValue();
        if (bigInteger.bitLength() > 63) {
            return this.set(CobolNum.noo(bigDecimal), false, false);
        }
        return this.set(CobolNum.noo(bigInteger.longValue(), bigDecimal.scale()), false, false);
    }

    @Override
    public boolean set(byte[] byArray) {
        return this.set(byArray, 0, byArray.length, true);
    }

    @Override
    public boolean toboolean() {
        return this.num().signum() != 0;
    }

    @Override
    public byte tobyte() {
        return (byte)this.num().intValue();
    }

    @Override
    public char tochar() {
        return (char)this.num().intValue();
    }

    @Override
    public short toshort() {
        return (short)this.num().intValue();
    }

    @Override
    public int toint() {
        return this.num().intValue();
    }

    @Override
    public long tolong() {
        return this.num().longValue();
    }

    @Override
    public float tofloat() {
        return this.num().floatValue();
    }

    @Override
    public double todouble() {
        return this.num().doubleValue();
    }

    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        int n3 = n2 - this.decLen;
        if (bl && n3 > 0) {
            l2 = CobolNum.roundUpIfNeeded(l2, n3);
        }
        if (this.lenInBytes ? (bl3 = CobolNum.isLongOverflowByte(l2, this.len, this.signed, n3)) && bl2 : (bl3 = CobolNum.isLongOverflow(l2, n2, this.intLen)) && bl2) {
            return true;
        }
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        this.theValue.set(l2, n2);
        if (this.decLen != n2) {
            this.theValue.setScale(this.decLen, false, this.lenInBytes);
        }
        if (bl3) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.intLen, this.decLen);
            }
        }
        this.memory.setUnsync(this);
        if (this.inDynamicTable) {
            this.updateMemory(this.getMemory());
        }
        return false;
    }

    public void addToMe(long l2) {
        CobolNum cobolNum = this.num();
        cobolNum.addToMe(l2);
        this.set(cobolNum);
    }

    public void subFromMe(long l2) {
        CobolNum cobolNum = this.num();
        cobolNum.subFromMe(l2);
        this.set(cobolNum);
    }

    public void multiplyByMe(long l2) {
        CobolNum cobolNum = this.num();
        cobolNum.multiplyByMe(l2);
        this.set(cobolNum);
    }

    public void divideIntoMe(long l2) {
        this.divideIntoMe(false, l2);
    }

    public void divideIntoMe(boolean bl, long l2) {
        if (bl && l2 == 0L) {
            this.theValue.divideIntoMeByZero(bl);
            this.updateMemory(this.memory.getMemory(), this.theValue);
        } else {
            CobolNum cobolNum = this.num();
            cobolNum.divideIntoMe(l2);
            this.set(cobolNum);
        }
    }

    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        if (bl && this.decLen < cobolNum.scale()) {
            cobolNum = CobolNum.noo(cobolNum);
            cobolNum.setScale(this.decLen, bl, this.lenInBytes);
        }
        if (this.lenInBytes ? (bl3 = cobolNum.isOverflowByte(this.theValue, this.len, this.signed)) && bl2 : (bl3 = cobolNum.isOverflow(this.theValue, this.intLen)) && bl2) {
            return true;
        }
        this.theValue.set(cobolNum, bl, this.lenInBytes);
        if (!this.signed && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.decLen != cobolNum.scale()) {
            this.theValue.setScale(this.decLen, bl, this.lenInBytes);
        }
        if (bl3) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.intLen, this.decLen);
            }
        }
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public CobolNum num() {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        return this.theValue;
    }

    @Override
    public void updateCache() {
        this.updateCache(this.memory.getMemory(this), this.theValue);
    }

    long getLong() {
        return this.num().getUnscaledLong();
    }

    @Override
    int internalCompare(ICobolVar iCobolVar) {
        return -((CobolVar)iCobolVar).compareTo(this);
    }

    @Override
    public int compareTo(Pic1 pic1) {
        return -pic1.compareTo(this);
    }

    @Override
    public int compareTo(NumericVar numericVar) {
        return this.num().compareTo(numericVar.num());
    }

    @Override
    public int compareTo(CobolNum cobolNum) {
        return this.num().compareTo(cobolNum);
    }

    @Override
    public int compareTo(CobolVar cobolVar) {
        return -cobolVar.compareTo(this);
    }

    @Override
    public int compareTo(NumericLiteralAll numericLiteralAll) {
        return -numericLiteralAll.compareTo(this);
    }

    @Override
    public int compareTo(NumericVar numericVar, int[] nArray) {
        return this.num().compareTo(numericVar.num());
    }

    @Override
    public int compareTo(CobolVar cobolVar, int[] nArray) {
        return -cobolVar.compareTo(this, nArray);
    }

    @Override
    public int compareTo(NumericLiteralAll numericLiteralAll, int[] nArray) {
        return -numericLiteralAll.compareTo(this, nArray);
    }

    @Override
    public int integer() {
        return this.num().intValue();
    }

    @Override
    public int scale() {
        return this.decLen;
    }

    @Override
    public int intLength() {
        return this.intLen;
    }

    public static NumericVar literal(String string, boolean bl) {
        CobolNum cobolNum = CobolNum.get(string, bl);
        int n2 = cobolNum.scale();
        int n3 = cobolNum.precision();
        NumericVar numericVar = n3 < 0 ? Literal.get.num(cobolNum.doubleValue(), bl) : Literal.get.num(cobolNum, n3 - n2, n2, bl);
        return numericVar;
    }

    public static NumericVar literal(double d2, boolean bl) {
        return Literal.get.num(d2, bl);
    }

    public static NumericVar literal(CobolNum cobolNum, boolean bl) {
        if (cobolNum.getType() == 2) {
            return Literal.get.num(cobolNum.doubleValue(), bl);
        }
        if (cobolNum.getType() == 3) {
            return Literal.get.num(cobolNum.floatValue(), bl);
        }
        return Literal.get.num(cobolNum, cobolNum.precision(), cobolNum.scale(), bl);
    }

    public static NumericVar literal(CobolNum cobolNum, int n2, int n3, boolean bl) {
        return Literal.get.num(cobolNum, n2, n3, bl);
    }

    public static NumericVar literal(long l2, int n2, int n3, boolean bl) {
        return Literal.get.num(l2, n2, n3, bl);
    }

    @Override
    public CobolVar moveTo(NumericVar numericVar) {
        numericVar.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicNumEdit picNumEdit) {
        picNumEdit.set(this);
        return this;
    }

    @Override
    public CobolVar moveTo(PicN picN) {
        picN.set(this);
        return this;
    }

    public CobolVar moveTo(Pic1 pic1) {
        pic1.set(this.tolong());
        return this;
    }

    @Override
    public CobolVar moveTo(PicX picX) {
        picX.set(this);
        return this;
    }

    @Override
    public boolean isInteger() {
        if (!this.isNumeric()) {
            return false;
        }
        if (this.decLen == 0) {
            return true;
        }
        return this.getLong() % (long)(10 * this.decLen) == 0L;
    }

    @Override
    public boolean isPositive() {
        return this.isNumeric() && this.getLong() > 0L;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.getLong() < 0L;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public Object getId() {
        return ObjectVar.getId((int)this.getLong());
    }

    public NumericVar setId(Object object) {
        this.set(object instanceof CobolVar && ((CobolVar)object).isNull() ? 0L : (long)ObjectVar.ssetId(object), 0, false, false);
        return this;
    }

    @Override
    public INumericVar setIId(Object object) {
        return this.setId(object);
    }

    public NumericVar at(int[] nArray) {
        return (NumericVar)this.intAt(nArray);
    }

    public NumericVar at(int n2) {
        return (NumericVar)this.intAt(n2);
    }

    public NumericVar atNC(int[] nArray) {
        return (NumericVar)this.intAtNC(nArray);
    }

    public NumericVar atNC(int n2) {
        return (NumericVar)this.intAtNC(n2);
    }

    public NumericVar setDepending(CobolVar cobolVar) {
        return (NumericVar)this.intSetDepending(cobolVar);
    }

    public NumericVar byVal() {
        this.byValue = true;
        return this;
    }

    public NumericVar byRef() {
        this.byValue = false;
        return this;
    }

    public NumericVar copy() {
        return (NumericVar)this.intCopy();
    }

    @Override
    protected int getCategory() {
        return 4;
    }

    @Override
    public String toString() {
        return this.toString(this.isDecPointComma, false);
    }

    @Override
    public String toString(boolean bl) {
        return this.toString(bl, false);
    }

    @Override
    public String toStringNoGui() {
        return this.toString(this.isDecPointComma, true);
    }

    private String toString(boolean bl, boolean bl2) {
        String string;
        if (!bl2 && showZeroes) {
            int n2;
            String string2;
            CobolNum cobolNum = this.num();
            StringBuffer stringBuffer = new StringBuffer(cobolNum.toString());
            if (this.signed) {
                if (cobolNum.isNegative()) {
                    string2 = "-";
                    stringBuffer.deleteCharAt(0);
                } else {
                    string2 = "+";
                }
            } else {
                string2 = "";
            }
            if (this.decLen > 0) {
                n2 = stringBuffer.indexOf(".");
                if (n2 <= 0) {
                    n2 = stringBuffer.length();
                }
            } else {
                n2 = stringBuffer.length();
            }
            if ((n2 = this.intLen - n2) > 0) {
                stringBuffer.insert(0, zeroFill.substring(0, n2));
            }
            stringBuffer.insert(0, string2);
            string = stringBuffer.toString();
        } else {
            string = this.num().toString();
        }
        if (bl) {
            string = string.replace('.', ',');
        }
        return string;
    }

    public int hashCode() {
        return this.num().bigCobDecValue().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof NumericVar) {
            return this.compareTo((NumericVar)object) == 0;
        }
        return false;
    }

    static BigCobolDec getBD(char[] cArray, int n2, boolean bl, int n3) {
        int n4;
        if (n3 > 0) {
            int n5;
            n4 = cArray.length - 1;
            for (n5 = n3; n5 > 0; --n5) {
                if (cArray[n4] <= '\t') {
                    int n6 = n4;
                    cArray[n6] = (char)(cArray[n6] + 48);
                } else {
                    cArray[n4] = 48;
                }
                --n4;
            }
            for (n5 = n2; n5 <= n4; ++n5) {
                cArray[n5 - 1] = cArray[n5] <= '\t' ? (int)(cArray[n5] + 48) : 48;
            }
            cArray[n4] = 46;
            --n2;
        } else {
            for (n4 = cArray.length - 1; n4 >= n2; --n4) {
                if (cArray[n4] <= '\t') {
                    int n7 = n4;
                    cArray[n7] = (char)(cArray[n7] + 48);
                    continue;
                }
                cArray[n4] = 48;
            }
        }
        int n8 = cArray.length - 1;
        while (n2 < n8 && cArray[n2] == '0') {
            ++n2;
        }
        if (bl) {
            cArray[--n2] = 45;
        }
        return new BigCobolDec(new String(cArray, n2, cArray.length - n2));
    }

    protected final void checkNumericContent() {
        if (!this.isNumeric()) {
            if (checkNC == 1) {
                throw new IscobolRuntimeException(31, this.name == null ? "" : this.name);
            }
            if (checkNC == -1) {
                Factory.log("CHECK NUMERIC CONTENT: detected not numeric " + (this.name == null ? "" : this.name));
            }
        }
    }

    @Override
    CobolVar getDefaultValue() {
        return Factory.getFigurativeZero(this.isDecPointComma);
    }

    public NumericVar offs(int n2) {
        return (NumericVar)this.intOffs(n2);
    }

    public NumericVar offsNC(int n2) {
        return (NumericVar)this.intOffsNC(n2);
    }

    static {
        dca_encoded_sign = new byte[][]{{C_0, C_BC}, {C_1, C_J}, {C_2, C_K}, {C_3, C_L}, {C_4, C_M}, {C_5, C_N}, {C_6, C_O}, {C_7, C_P}, {C_8, C_Q}, {C_9, C_R}};
        dci_encoded_sign = new byte[][]{{C_BO, C_BC}, {C_A, C_J}, {C_B, C_K}, {C_C, C_L}, {C_D, C_M}, {C_E, C_N}, {C_F, C_O}, {C_G, C_P}, {C_H, C_Q}, {C_I, C_R}};
        dcm_encoded_sign = new byte[][]{{C_0, C_p}, {C_1, C_q}, {C_2, C_r}, {C_3, C_s}, {C_4, C_t}, {C_5, C_u}, {C_6, C_v}, {C_7, C_w}, {C_8, C_x}, {C_9, C_y}};
        dcb_encoded_sign = new byte[][]{{C_0, C_BB}, {C_1, C_A}, {C_2, C_B}, {C_3, C_C}, {C_4, C_D}, {C_5, C_E}, {C_6, C_F}, {C_7, C_G}, {C_8, C_H}, {C_9, C_I}};
        dcr_encoded_sign = new byte[][]{{C_0, C_SPACE}, {C_1, C_EXCL_MK}, {C_2, C_QUOT_MK}, {C_3, C_NUM_SN}, {C_4, C_DOLLAR}, {C_5, C_PERCENT}, {C_6, C_AMP}, {C_7, C_APOST}, {C_8, C_L_PAR}, {C_9, C_R_PAR}};
        encoded_digits = new byte[]{C_0, C_1, C_2, C_3, C_4, C_5, C_6, C_7, C_8, C_9, C_MINUS, C_POINT};
        ZERO = Literal.get.num(0L, 1, 0, false);
        zero = CobolNum.noo(0L, 0);
        char c2 = Config.a(".check.numeric_content", "N").charAt(0);
        checkNC = c2 == 'Y' || c2 == 'y' || c2 == 'S' || c2 == 's' || c2 == 'T' || c2 == 't' || c2 == '1' ? 1 : (c2 == 'N' || c2 == 'n' || c2 == 'F' || c2 == 'f' || c2 == '0' ? 0 : Config.a(".check.numeric_content", 0));
        showZeroes = Config.b(".gui.show_zeroes", false);
        XLEN = new int[]{0, 2, 4, 7, 9, 12, 14, 15, 18, 21, 24, 26, 28, 31, 31, 33, 35, 35, 38};
    }
}

