/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;

public abstract class PicBinary
extends NumericVar {
    private static final long serialVersionUID = 123L;
    CobolNum value;
    long u_max = Long.MAX_VALUE;

    public PicBinary(byte[] byArray, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(byArray, n2, n4, n5, bl, n3, nArray, nArray2, string, bl2);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i2 = 1; i2 < this.len * 8; ++i2) {
                this.u_max *= 2L;
            }
        }
        if (byArray != null) {
            this.updateCache(byArray, this.theValue);
        }
    }

    public PicBinary(CobolVar cobolVar, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(cobolVar, n2, n4, n5, bl, n3, nArray, nArray2, string, bl2);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i2 = 1; i2 < this.len * 8; ++i2) {
                this.u_max *= 2L;
            }
        }
    }

    public PicBinary(long l2, int n2, boolean bl, int n3, int n4, boolean bl2) {
        super((byte[])null, 0, n3, n4, bl, n2, null, null, "$literal", bl2);
        this.set(CobolNum.noo(l2, n4), false, false);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[this.getMaxLength()] + 2;
    }

    @Override
    void updateMemory(byte[] byArray, CobolNum cobolNum) {
        if (byArray != null) {
            cobolNum.toBinaryByteArray(byArray, this.curOffset, this.len);
        }
    }

    @Override
    void updateMemory(byte[] byArray) {
        if (byArray != null) {
            this.num().toBinaryByteArray(byArray, this.curOffset, this.len);
        }
    }

    @Override
    void updateCache(byte[] byArray, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            cobolNum.set(this.getLongFromMem(byArray), this.decLen);
        } else {
            cobolNum.set(new BigCobolDec(byArray, this.curOffset, this.len, this.signed, this.decLen));
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] byArray = this.getMemory();
        Factory.myFill(byArray, this.curOffset, this.end, (byte)0);
    }

    protected long getLongFromMem(byte[] byArray) {
        long l2;
        if (byArray != null) {
            int n2;
            int n3 = this.curOffset;
            l2 = 0L;
            if (this.signed && byArray[n3] < 0) {
                for (n2 = 7; n2 >= this.len; --n2) {
                    l2 |= 255L << n2 * 8;
                }
            } else {
                n2 = this.len - 1;
            }
            while (n2 > 0) {
                l2 |= (long)(byArray[n3++] & 0xFF) << n2 * 8;
                --n2;
            }
            l2 |= (long)(byArray[n3] & 0xFF);
        } else {
            l2 = this.value != null ? this.value.getUnscaledLong() : 0L;
        }
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        return l2;
    }
}

