/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Factory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicNumEdit;

public class PicDisplay
extends NumericVar
implements SignEncOpt,
EncBytes {
    private static final long serialVersionUID = 123L;
    private boolean signSeparated = false;
    private boolean signLeading = false;
    private final byte[][] encoded_sign;

    private byte[][] init(int n2, boolean bl, boolean bl2) {
        this.signSeparated = bl;
        this.signLeading = bl2;
        switch (n2) {
            default: {
                return dca_encoded_sign;
            }
            case 1: {
                return dci_encoded_sign;
            }
            case 2: {
                return dcm_encoded_sign;
            }
            case 3: {
                return dcb_encoded_sign;
            }
            case 4: 
        }
        return dcr_encoded_sign;
    }

    public PicDisplay(byte[] byArray, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4) {
        super(byArray, n2, n3, n4, bl, n3 + n4 + (bl2 && bl ? 1 : 0), nArray, nArray2, string, bl4);
        this.encoded_sign = this.init(n5, bl2, bl3);
    }

    public PicDisplay(CobolVar cobolVar, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4) {
        super(cobolVar, n2, n3, n4, bl, n3 + n4 + (bl2 && bl ? 1 : 0), nArray, nArray2, string, bl4);
        this.encoded_sign = this.init(n5, bl2, bl3);
    }

    private void putBDToMem(byte[] byArray, BigCobolDec bigCobolDec) {
        BigCobolDec bigCobolDec2 = new BigCobolDec(bigCobolDec);
        int n2 = this.end - 1;
        int n3 = this.curOffset;
        boolean bl = bigCobolDec2.isNegative() ? this.signed : false;
        byte by = encoded_digits[bigCobolDec2.getDecDigit(0)];
        bigCobolDec2.shift(-1);
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    ++n3;
                } else {
                    byArray[n2--] = bl ? C_MINUS : C_PLUS;
                }
                byArray[n2--] = by;
            } else {
                byArray[n2--] = this.signLeading ? by : this.encodeSign(bl, by);
            }
        } else {
            byArray[n2--] = by;
        }
        while (n2 >= n3) {
            by = encoded_digits[bigCobolDec2.getDecDigit(0)];
            bigCobolDec2.shift(-1);
            byArray[n2--] = by;
        }
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    byArray[this.curOffset] = bl ? C_MINUS : C_PLUS;
                }
            } else if (this.signLeading) {
                byArray[this.curOffset] = this.encodeSign(bl, by);
            }
        }
    }

    private void putLongToMem(byte[] byArray, long l2) {
        int n2 = this.curOffset;
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    int n3 = this.end - 1;
                    if (l2 < 0L) {
                        l2 = -l2;
                        byArray[n2++] = C_MINUS;
                    } else {
                        byArray[n2++] = C_PLUS;
                    }
                    while (l2 != 0L && n3 >= n2) {
                        byArray[n3] = encoded_digits[(int)(l2 % 10L)];
                        --n3;
                        l2 /= 10L;
                    }
                    while (n3 >= n2) {
                        byArray[n3] = encoded_digits[0];
                        --n3;
                    }
                } else {
                    int n4 = this.end - 1;
                    if (l2 < 0L) {
                        l2 = -l2;
                        byArray[n4--] = C_MINUS;
                    } else {
                        byArray[n4--] = C_PLUS;
                    }
                    while (l2 != 0L && n4 >= n2) {
                        byArray[n4] = encoded_digits[(int)(l2 % 10L)];
                        --n4;
                        l2 /= 10L;
                    }
                    while (n4 >= n2) {
                        byArray[n4] = encoded_digits[0];
                        --n4;
                    }
                }
            } else if (this.signLeading) {
                int n5;
                int n6 = this.end - 1;
                if (l2 < 0L) {
                    l2 = -l2;
                    n5 = 1;
                } else {
                    n5 = 0;
                }
                while (l2 != 0L && n6 > n2) {
                    byArray[n6] = encoded_digits[(int)(l2 % 10L)];
                    --n6;
                    l2 /= 10L;
                }
                while (n6 > n2) {
                    byArray[n6] = encoded_digits[0];
                    --n6;
                }
                byArray[n2] = this.encoded_sign[(int)(l2 % 10L)][n5];
            } else {
                int n7 = this.end - 1;
                if (l2 < 0L) {
                    l2 = -l2;
                    byArray[n7--] = this.encoded_sign[(int)(l2 % 10L)][1];
                } else {
                    byArray[n7--] = this.encoded_sign[(int)(l2 % 10L)][0];
                }
                l2 /= 10L;
                while (l2 != 0L && n7 >= n2) {
                    byArray[n7] = encoded_digits[(int)(l2 % 10L)];
                    --n7;
                    l2 /= 10L;
                }
                while (n7 >= n2) {
                    byArray[n7] = encoded_digits[0];
                    --n7;
                }
            }
        } else {
            int n8 = this.end - 1;
            if (l2 < 0L) {
                l2 = -l2;
            }
            while (l2 != 0L && n8 >= n2) {
                byArray[n8] = encoded_digits[(int)(l2 % 10L)];
                --n8;
                l2 /= 10L;
            }
            while (n8 >= n2) {
                byArray[n8] = encoded_digits[0];
                --n8;
            }
        }
    }

    @Override
    void updateMemory(byte[] byArray, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(byArray, cobolNum.getUnscaledLong());
        } else {
            this.putBDToMem(byArray, cobolNum.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(byte[] byArray) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(byArray, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(byArray, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] byArray = this.getMemory();
        Factory.myFill(byArray, this.curOffset, this.end, C_0);
        if (this.signed) {
            if (this.signLeading) {
                byArray[this.curOffset] = this.signSeparated ? C_PLUS : this.encoded_sign[0][0];
            } else {
                byArray[this.end - 1] = this.signSeparated ? C_PLUS : this.encoded_sign[0][0];
            }
        }
    }

    @Override
    public boolean isNumeric() {
        byte[] byArray = this.getMemory();
        for (int i2 = this.curOffset; i2 < this.end; ++i2) {
            byte by = byArray[i2];
            if (i2 == this.curOffset && this.signed && this.signLeading && !this.signSeparated) {
                by = (byte)(this.decodeSign(this.myIsNegative(byArray), by) + C_0);
            }
            if (i2 == this.end - 1 && this.signed && !this.signLeading && !this.signSeparated) {
                by = (byte)(this.decodeSign(this.myIsNegative(byArray), by) + C_0);
            }
            if (by >= C_0 && by <= C_9) continue;
            if (by == C_PLUS || by == C_MINUS) {
                if (this.signed) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.num().isNegative();
    }

    @Override
    void updateCache(byte[] byArray, CobolNum cobolNum) {
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        if (this.intLen + this.decLen <= 18) {
            cobolNum.set(this.getLongFromMem(byArray), this.decLen);
        } else {
            cobolNum.set(this.getBDFromMem(byArray));
        }
    }

    private long getLongFromMem(byte[] byArray) {
        long l2;
        block15: {
            block12: {
                block13: {
                    block14: {
                        l2 = 0L;
                        if (!this.signed) break block12;
                        if (!this.signSeparated) break block13;
                        if (!this.signLeading) break block14;
                        int n2 = this.end - 1;
                        int n3 = 0;
                        while (n2 > this.curOffset) {
                            l2 += (long)(byArray[n2] & 0xF) * CobolNum.fact[n3];
                            --n2;
                            ++n3;
                        }
                        if (byArray[this.curOffset] == C_MINUS) {
                            l2 = -l2;
                        }
                        break block15;
                    }
                    int n4 = this.end - 2;
                    int n5 = 0;
                    while (n4 >= this.curOffset) {
                        l2 += (long)(byArray[n4] & 0xF) * CobolNum.fact[n5];
                        --n4;
                        ++n5;
                    }
                    if (byArray[this.end - 1] != C_MINUS) break block15;
                    l2 = -l2;
                    break block15;
                }
                if (this.signLeading) {
                    int n6 = this.end - 1;
                    int n7 = 0;
                    while (n6 > this.curOffset) {
                        l2 += (long)(byArray[n6] & 0xF) * CobolNum.fact[n7];
                        --n6;
                        ++n7;
                    }
                    n6 = this.getInternalSignDigit(byArray[this.curOffset]);
                    if (n6 < 0) {
                        l2 = -l2;
                        l2 += (long)(++n6) * CobolNum.fact[n7];
                    } else {
                        l2 += (long)n6 * CobolNum.fact[n7];
                    }
                } else {
                    int n8 = this.end - 2;
                    int n9 = 1;
                    while (n8 >= this.curOffset) {
                        l2 += (long)(byArray[n8] & 0xF) * CobolNum.fact[n9];
                        --n8;
                        ++n9;
                    }
                    n8 = this.getInternalSignDigit(byArray[this.end - 1]);
                    if (n8 < 0) {
                        l2 = -l2;
                        l2 += (long)(++n8);
                    } else {
                        l2 += (long)n8;
                    }
                }
                break block15;
            }
            int n10 = this.end - 1;
            int n11 = 0;
            while (n10 >= this.curOffset) {
                l2 += (long)(byArray[n10] & 0xF) * CobolNum.fact[n11];
                --n10;
                ++n11;
            }
        }
        return l2;
    }

    private BigCobolDec getBDFromMem(byte[] byArray) {
        int n2 = this.end - 1;
        boolean bl = this.myIsNegative(byArray);
        char[] cArray = new char[this.intLen + this.decLen + 2];
        int n3 = cArray.length;
        if (this.signed) {
            if (this.signLeading) {
                cArray[--n3] = (char)(byArray[n2--] & 0xF);
            } else if (this.signSeparated) {
                int n4 = --n2;
                --n2;
                cArray[--n3] = (char)(byArray[n4] & 0xF);
            } else {
                cArray[--n3] = (char)this.decodeSign(bl, byArray[this.end - 1]);
                --n2;
            }
        } else {
            cArray[--n3] = (char)(byArray[n2--] & 0xF);
        }
        int n5 = 1;
        while (n2 > this.curOffset) {
            cArray[--n3] = (char)(byArray[n2] & 0xF);
            --n2;
            ++n5;
        }
        if (this.signed) {
            if (this.signLeading) {
                if (!this.signSeparated) {
                    cArray[--n3] = (char)this.decodeSign(bl, byArray[this.curOffset]);
                }
            } else {
                cArray[--n3] = (char)(byArray[n2] & 0xF);
            }
        } else {
            cArray[--n3] = (char)(byArray[n2] & 0xF);
        }
        return PicDisplay.getBD(cArray, n3, bl, this.decLen);
    }

    private byte encodeSign(boolean bl, byte by) {
        int n2 = bl ? 1 : 0;
        int n3 = by & 0xF;
        return this.encoded_sign[n3][n2];
    }

    private byte decodeSign(boolean bl, byte by) {
        int n2 = bl ? 1 : 0;
        for (int i2 = 0; i2 < this.encoded_sign.length; ++i2) {
            if (this.encoded_sign[i2][n2] != by) continue;
            return (byte)i2;
        }
        return (byte)(by & 0xF);
    }

    private boolean myIsNegative(byte[] byArray) {
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    return byArray[this.curOffset] == C_MINUS;
                }
                return byArray[this.end - 1] == C_MINUS;
            }
            if (this.signLeading) {
                return this.myIsNegative(byArray[this.curOffset]);
            }
            return this.myIsNegative(byArray[this.end - 1]);
        }
        return false;
    }

    private boolean myIsNegative(byte by) {
        return this.getInternalSignDigit(by) < 0;
    }

    private int getInternalSignDigit(byte by) {
        byte by2 = this.encoded_sign[0][1];
        byte by3 = this.encoded_sign[1][1];
        byte by4 = this.encoded_sign[9][1];
        byte by5 = this.encoded_sign[0][0];
        byte by6 = this.encoded_sign[1][0];
        byte by7 = this.encoded_sign[9][0];
        if (by >= by3 && by <= by4) {
            return -(by - by3 + 2);
        }
        if (by >= by6 && by <= by7) {
            return by - by6 + 1;
        }
        if (by == by2) {
            return -1;
        }
        if (by == by5) {
            return 0;
        }
        return by & 0xF;
    }

    public boolean isSignLeading() {
        return this.signLeading;
    }

    public boolean isSignSeparated() {
        return this.signSeparated;
    }

    @Override
    public CobolVar moveTo92UD(PicNumEdit picNumEdit) {
        if (!this.isNumeric()) {
            picNumEdit.setBytes(this.getMemory(), this.getOffset(), this.getLen());
        } else {
            picNumEdit.set(this);
        }
        return this;
    }
}

