/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Factory;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;

public class PicLong
extends NumericVar {
    CobolNum value;
    private static final long serialVersionUID = 123L;
    long u_max = Long.MAX_VALUE;

    public PicLong(byte[] byArray, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(byArray, n2, PicLong.bDigits(8, n3, 0), 0, true, 8, nArray, nArray2, string, bl);
        if (byArray != null) {
            this.updateCache(byArray, this.theValue);
        }
    }

    public PicLong(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(cobolVar, n2, PicLong.bDigits(8, n3, 0), 0, true, 8, nArray, nArray2, string, bl);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[8] + 1;
    }

    @Override
    void updateMemory(byte[] byArray, CobolNum cobolNum) {
        this.internalSet(byArray, cobolNum.getUnscaledLong());
    }

    @Override
    void updateMemory(byte[] byArray) {
        this.internalSet(byArray, this.num().getUnscaledLong());
    }

    protected void internalSet(byte[] byArray, long l2) {
        if (byArray != null) {
            int n2 = this.curOffset;
            byArray[n2++] = (byte)(l2 >>> 56);
            byArray[n2++] = (byte)(l2 >>> 48);
            byArray[n2++] = (byte)(l2 >>> 40);
            byArray[n2++] = (byte)(l2 >>> 32);
            byArray[n2++] = (byte)(l2 >>> 24);
            byArray[n2++] = (byte)(l2 >>> 16);
            byArray[n2++] = (byte)(l2 >>> 8);
            byArray[n2] = (byte)l2;
        }
    }

    @Override
    void updateCache(byte[] byArray, CobolNum cobolNum) {
        cobolNum.set(this.getLongFromMem(byArray), this.decLen);
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        byte[] byArray = this.getMemory();
        Factory.myFill(byArray, this.curOffset, this.end, (byte)0);
    }

    protected long getLongFromMem(byte[] byArray) {
        long l2;
        if (byArray != null) {
            int n2 = this.curOffset;
            l2 = (long)(byArray[n2++] & 0xFF) << 56;
            l2 |= (long)(byArray[n2++] & 0xFF) << 48;
            l2 |= (long)(byArray[n2++] & 0xFF) << 40;
            l2 |= (long)(byArray[n2++] & 0xFF) << 32;
            l2 |= (long)(byArray[n2++] & 0xFF) << 24;
            l2 |= (long)(byArray[n2++] & 0xFF) << 16;
            l2 |= (long)(byArray[n2++] & 0xFF) << 8;
            l2 |= (long)(byArray[n2] & 0xFF);
        } else {
            l2 = this.value != null ? this.value.getUnscaledLong() : 0L;
        }
        return l2;
    }

    @Override
    public boolean set(long l2) {
        this.theValue.lnUnscValue = l2;
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        if (bl2 && CobolNum.isLongOverflowByte(l2, this.len, this.signed, n2 - this.decLen)) {
            return true;
        }
        this.theValue.set(l2, n2);
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        if (bl2 && cobolNum.isOverflowByte(this.theValue, this.len, this.signed)) {
            return true;
        }
        this.theValue.set(cobolNum, bl, this.lenInBytes);
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    public void addToMe(long l2) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.addToMe(l2);
        this.memory.setUnsync(this);
    }

    @Override
    public void subFromMe(long l2) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.subFromMe(l2);
        this.memory.setUnsync(this);
    }

    @Override
    public void multiplyByMe(long l2) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.multiplyByMe(l2);
        this.memory.setUnsync(this);
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        this.theValue.divideIntoMe(bl, l2);
        this.memory.setUnsync(this);
    }
}

