/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.rts.Native;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicBinary;

public abstract class PicNativeBinary
extends PicBinary
implements Native {
    private boolean bigEndian = false;
    private static final long serialVersionUID = 123L;

    public PicNativeBinary(byte[] byArray, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(byArray, n2, n3, bl, n4, n5, nArray, nArray2, string, bl2);
        this.bigEndian = !Config.b("iscobol.little_endian", Config.e);
    }

    public PicNativeBinary(CobolVar cobolVar, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(cobolVar, n2, n3, bl, n4, n5, nArray, nArray2, string, bl2);
        this.bigEndian = !Config.b("iscobol.little_endian", Config.e);
    }

    public PicNativeBinary(long l2, int n2, boolean bl, int n3, int n4, boolean bl2) {
        super(l2, n2, bl, n3, n4, bl2);
    }

    @Override
    void updateMemory(byte[] byArray, CobolNum cobolNum) {
        this.internalSet(byArray, cobolNum.getUnscaledLong());
    }

    @Override
    void updateMemory(byte[] byArray) {
        this.internalSet(byArray, this.num().getUnscaledLong());
    }

    protected void internalSet(byte[] byArray, long l2) {
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        if (byArray != null) {
            int n2 = 8 - this.len + 1;
            if (this.bigEndian) {
                int n3 = this.curOffset;
                while (n3 < this.end - 1) {
                    int n4 = 64 - 8 * n2;
                    byArray[n3] = (byte)(l2 >>> n4);
                    ++n3;
                    ++n2;
                }
                byArray[n3] = (byte)l2;
            } else {
                int n5 = this.end - 1;
                while (n5 > this.curOffset) {
                    int n6 = 64 - 8 * n2;
                    byArray[n5] = (byte)(l2 >>> n6);
                    --n5;
                    ++n2;
                }
                byArray[n5] = (byte)l2;
            }
        }
    }

    @Override
    void updateCache(byte[] byArray, CobolNum cobolNum) {
        cobolNum.set(this.getLongFromMem(byArray), this.decLen);
    }

    @Override
    protected long getLongFromMem(byte[] byArray) {
        long l2;
        if (byArray != null) {
            int n2 = 8 - this.len + 1;
            l2 = 0L;
            if (this.bigEndian) {
                int n3;
                int n4 = this.curOffset;
                while (n4 < this.end - 1) {
                    n3 = 64 - 8 * n2;
                    l2 |= (long)(byArray[n4] & 0xFF) << n3;
                    ++n4;
                    ++n2;
                }
                l2 |= (long)(byArray[n4] & 0xFF);
                if (this.len < 8 && this.signed) {
                    int n5 = n3 = (byArray[this.curOffset] >>> 7 & 1) == 1 ? 1 : 0;
                    if (n3 != 0) {
                        l2 -= this.u_max;
                    }
                }
            } else {
                int n6;
                int n7 = this.end - 1;
                while (n7 > this.curOffset) {
                    n6 = 64 - 8 * n2;
                    l2 |= (long)(byArray[n7] & 0xFF) << n6;
                    --n7;
                    ++n2;
                }
                l2 |= (long)(byArray[n7] & 0xFF);
                if (this.len < 8 && this.signed) {
                    int n8 = n6 = (byArray[this.end - 1] >>> 7 & 1) == 1 ? 1 : 0;
                    if (n6 != 0) {
                        l2 -= this.u_max;
                    }
                }
            }
        } else {
            l2 = this.value.getUnscaledLong();
        }
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        return l2;
    }

    public boolean isBigEndian() {
        return this.bigEndian;
    }
}

