/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.EncBytes;
import com.iscobol.types.NumericVar;
import com.iscobol.types.PicX;
import com.iscobol.types.PictureAnalyzer;
import java.io.UnsupportedEncodingException;

public class PicNumEdit
extends PicX
implements IPicNumEdit,
EncBytes {
    private static final long serialVersionUID = 123L;
    private static final CobolNum zero = CobolNum.noo(0L, 0);
    protected static final int checkNC;
    private CobolNum theValue;
    protected final PictureAnalyzer format;
    private byte[] buffer;
    private final String picture;
    private final byte[] ccBytes;
    protected boolean blankWhenZero;
    private int end;

    public PicNumEdit(byte[] byArray, int n2, int n3, int[] nArray, int[] nArray2, String string, String string2, boolean bl, boolean bl2, char c2) {
        super(byArray, n2, n3, nArray, nArray2, string, bl, false);
        this.picture = string2;
        this.end = this.curOffset + this.getLength();
        this.format = new PictureAnalyzer(string2, bl, c2);
        this.ccBytes = new byte[]{this.format.currencyByte};
        this.blankWhenZero = bl2 || this.format.isBlankWhenZero();
        this.theValue = CobolNum.get(this.format.getTotLen(), this.format.getDecLen());
        this.buffer = new byte[n3 + 1];
    }

    public PicNumEdit(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, String string2, boolean bl, boolean bl2, char c2) {
        super(cobolVar, n2, n3, nArray, nArray2, string, bl, false);
        this.picture = string2;
        this.end = this.curOffset + this.getLength();
        this.format = new PictureAnalyzer(string2, bl, c2);
        this.ccBytes = new byte[]{this.format.currencyByte};
        this.blankWhenZero = bl2 || this.format.isBlankWhenZero();
        this.theValue = CobolNum.get(this.format.getTotLen(), this.format.getDecLen());
        this.buffer = new byte[n3 + 1];
    }

    public PicNumEdit(byte[] byArray, int n2, int n3, int[] nArray, int[] nArray2, String string, String string2, boolean bl) {
        this(byArray, n2, n3, nArray, nArray2, string, string2, bl, false, '$');
    }

    public PicNumEdit(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, String string2, boolean bl) {
        this(cobolVar, n2, n3, nArray, nArray2, string, string2, bl, false, '$');
    }

    protected Object clone() {
        PicNumEdit picNumEdit;
        try {
            picNumEdit = (PicNumEdit)super.clone();
            picNumEdit.theValue = CobolNum.noo(this.theValue);
            picNumEdit.buffer = new byte[this.buffer.length];
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            picNumEdit = null;
        }
        return picNumEdit;
    }

    @Override
    public char getCurrencyChar() {
        return this.format.getCurrencyChar();
    }

    public boolean isNumericCheckContent() {
        int n2;
        char[] cArray = this.toString().toCharArray();
        char[] cArray2 = this.format.getPicture();
        if (this.blankWhenZero) {
            for (n2 = 0; n2 < cArray.length && cArray[n2] == ' '; ++n2) {
            }
            if (n2 == cArray.length) {
                return true;
            }
        }
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray2[n2] == '9' && !Character.isDigit(cArray[n2])) {
                return false;
            }
            if (cArray2[n2] == '+' && cArray[n2] != '+' && cArray[n2] != '-' && !Character.isDigit(cArray[n2])) {
                return false;
            }
            if (cArray2[n2] == '-' && cArray[n2] != '-' && cArray[n2] != ' ' && !Character.isDigit(cArray[n2])) {
                return false;
            }
            if (cArray2[n2] != 'Z' || cArray[n2] == ' ' || Character.isDigit(cArray[n2])) continue;
            return false;
        }
        return true;
    }

    @Override
    public CobolVar moveTo(NumericVar numericVar) {
        numericVar.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicNumEdit picNumEdit) {
        picNumEdit.set(this.num(), false, false);
        return this;
    }

    @Override
    public CobolVar moveTo(PicX picX) {
        picX.set(this);
        return this;
    }

    void updateMemory(byte[] byArray, CobolNum cobolNum) {
        if (cobolNum.signum() == 0) {
            if (this.blankWhenZero) {
                for (int i2 = this.curOffset; i2 < this.end; ++i2) {
                    byArray[i2] = C_SPACE;
                }
                return;
            }
            if (this.format.isStarWhenZero()) {
                for (int i3 = this.curOffset; i3 < this.end; ++i3) {
                    byte by = this.format.getByte(i3 - this.curOffset);
                    byArray[i3] = by == 0 ? C_STAR : by;
                }
                return;
            }
        }
        if (this.format.getFoundP()) {
            cobolNum = this.P(cobolNum, true);
        }
        cobolNum.setScale(this.format.getDecLen(), false, false);
        int n2 = cobolNum.toByteArray(this.buffer);
        this.internalSet(this.buffer, 0, n2, false, byArray);
    }

    @Override
    void updateMemory(byte[] byArray) {
        this.updateMemory(byArray, this.num());
    }

    @Override
    public boolean set(CobolNum cobolNum) {
        return this.set(cobolNum, false, false);
    }

    @Override
    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        if (this.format.getFoundP()) {
            cobolNum = this.P(cobolNum, true);
        }
        if ((bl3 = cobolNum.isOverflow(this.theValue, this.format.getIntLen())) && bl2) {
            return true;
        }
        this.theValue.set(cobolNum, bl, false);
        if (!this.format.getSigned() && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.format.getDecLen() != cobolNum.scale()) {
            this.theValue.setScale(this.format.getDecLen(), bl, false);
        }
        if (bl3) {
            this.theValue.setSizeDigit(this.format.getIntLen(), this.format.getDecLen());
        }
        this.memory.setUnsync(this);
        return false;
    }

    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        if (this.format.getFoundP()) {
            l2 = this.P(l2, true);
        }
        int n3 = this.format.getDecLen();
        int n4 = this.format.getIntLen();
        boolean bl4 = this.format.getSigned();
        int n5 = n2 - n3;
        if (bl && n5 > 0) {
            l2 = CobolNum.roundUpIfNeeded(l2, n5);
        }
        if ((bl3 = CobolNum.isLongOverflow(l2, n2, n4)) && bl2) {
            return true;
        }
        if (!bl4 && l2 < 0L) {
            l2 = -l2;
        }
        this.theValue.set(l2, n2);
        if (n3 != n2) {
            this.theValue.setScale(n3, false, false);
        }
        if (bl3) {
            this.theValue.setSizeDigit(n4, n3);
        }
        this.memory.setUnsync(this);
        return false;
    }

    @Override
    void setBytes(byte[] byArray, int n2, int n3) {
        int n4 = n2 + n3;
        while (n2 < n4 && byArray[n2] == C_0) {
            ++n2;
        }
        this.internalSet(byArray, n2, n4, true, this.getMemory());
    }

    @Override
    public boolean set(String string) {
        int n2;
        byte[] byArray = string.getBytes();
        for (n2 = 0; n2 < byArray.length && byArray[n2] == C_0; ++n2) {
        }
        this.internalSet(byArray, n2, byArray.length, true, this.getMemory());
        return false;
    }

    @Override
    public boolean set(boolean bl) {
        return this.set(CobolNum.noo(bl ? 1L : 0L, 0), false, false);
    }

    @Override
    public boolean set(byte by) {
        return this.set(CobolNum.noo(by, 0), false, false);
    }

    @Override
    public boolean set(char c2) {
        return this.set(CobolNum.noo(c2, 0), false, false);
    }

    @Override
    public boolean set(short s2) {
        return this.set(CobolNum.noo(s2, 0), false, false);
    }

    @Override
    public boolean set(int n2) {
        return this.set(CobolNum.noo(n2, 0), false, false);
    }

    @Override
    public boolean set(long l2) {
        return this.set(CobolNum.noo(l2, 0), false, false);
    }

    @Override
    public boolean set(float f2) {
        return this.set(CobolNum.noo((double)f2), false, false);
    }

    @Override
    public boolean set(double d2) {
        return this.set(CobolNum.noo(d2), false, false);
    }

    @Override
    protected void set(NumericVar numericVar) {
        this.set(numericVar.num(), false, false);
    }

    @Override
    void internalSet(CobolVar cobolVar) {
        boolean bl = this.blankWhenZero;
        this.blankWhenZero = false;
        cobolVar.moveTo(this);
        this.getMemory();
        this.blankWhenZero = bl;
    }

    @Override
    protected void setInitialValue() {
        this.set(this.initialValue.getMemory(), this.initialValue.getOffset(), this.initialValue.getLen(), true);
    }

    @Override
    protected void set(PicX picX) {
        this.set(picX.toString());
    }

    @Override
    protected void set(PicNumEdit picNumEdit) {
        this.set(picNumEdit.num(), false, false);
    }

    @Override
    public boolean toboolean() {
        return this.num().signum() != 0;
    }

    @Override
    public byte tobyte() {
        return (byte)this.num().intValue();
    }

    @Override
    public char tochar() {
        return (char)this.num().intValue();
    }

    @Override
    public short toshort() {
        return (short)this.num().intValue();
    }

    @Override
    public int toint() {
        return this.num().intValue();
    }

    @Override
    public long tolong() {
        return this.num().longValue();
    }

    @Override
    public float tofloat() {
        return this.num().floatValue();
    }

    @Override
    public double todouble() {
        return this.num().doubleValue();
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        this.theValue.set(0L, this.format.getDecLen());
        this.memory.setUnsync(this);
    }

    @Override
    public void setZero() {
        this.defaultInitialize();
    }

    @Override
    public void setAllZero() {
        this.defaultInitialize();
    }

    public int scale() {
        return this.format.getDecLen();
    }

    @Override
    public CobolNum num() {
        if (!this.memory.isLastUsed(this)) {
            this.updateCache(this.memory.getMemory(this), this.theValue);
        }
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false);
        }
        return this.theValue;
    }

    protected void internalSet(byte[] byArray, int n2, int n3, boolean bl, byte[] byArray2) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        if (n3 - n2 <= 0) {
            this.internalSet(new byte[]{C_0}, 0, 1, false, byArray2);
            return;
        }
        boolean bl2 = false;
        int n13 = n2;
        if (!bl && byArray[n2] == C_MINUS) {
            ++n13;
            if (this.format.getSigned()) {
                bl2 = true;
            }
        }
        if (bl) {
            n12 = n3;
        } else {
            for (n12 = n2; n12 < n3 && byArray[n12] != C_POINT; ++n12) {
            }
        }
        int n14 = this.format.getIntLen() - n12 + n13;
        int n15 = n14 < 0 ? this.curOffset : this.curOffset + n14;
        int n16 = this.format.getCCStart();
        int n17 = n16 + this.ccBytes.length - 1;
        int n18 = this.format.getSignPosition();
        for (n11 = this.curOffset; n11 <= n15; ++n11) {
            if (this.format.getByte(n11 - this.curOffset) == 0 && this.curOffset + n18 != n11 && (n11 - this.curOffset < n16 || n11 - this.curOffset > n17)) continue;
            ++n15;
        }
        if (byArray[n13] == C_0 && !bl) {
            ++n13;
            ++n15;
        }
        if (n14 < 0) {
            n13 -= n14;
        }
        n11 = n18;
        int n19 = this.format.getDecimalPointPosition();
        if (this.format.getFoundSign() && this.format.getSignOnHead()) {
            n10 = n15 - this.curOffset;
            n9 = this.end - 1;
            if (n18 >= n10) {
                n11 = n10;
                n8 = ++n15;
                while (this.curOffset + n11 < n9 && this.format.getByte(n8 - this.curOffset) != 0 && n8++ - this.curOffset != n19) {
                    ++n11;
                }
            }
        }
        n10 = this.format.getCCStart();
        n9 = n10 + this.ccBytes.length - 1;
        if (this.format.getFoundCurrencyChar() && n17 >= (n8 = n15 - this.curOffset)) {
            n9 = n8;
            n10 = n9 - this.ccBytes.length + 1;
            n7 = n9 + 1;
            n6 = this.format.length();
            if (n7 < n6) {
                ++n15;
                while (n7 < n6 && this.curOffset + n9 < this.end && this.format.getByte(n7) != 0 && n7 != n19) {
                    ++n7;
                    ++n10;
                    ++n9;
                }
            } else {
                ++n10;
                ++n9;
            }
        }
        n8 = this.format.getReplacementPosition();
        n7 = this.format.getReplacementByte();
        for (n6 = this.curOffset; n6 < this.end; ++n6) {
            n5 = n6 - this.curOffset;
            n4 = this.format.getByte(n5);
            byArray2[n6] = n5 == 0 && n4 != 0 ? n4 : (n5 < n8 ? n7 : (n4 != 0 ? n4 : C_0));
        }
        while (n13 < n3 && n15 < this.end) {
            if (n13 == n12 && !bl) {
                ++n13;
                continue;
            }
            if (this.format.getByte(n15 - this.curOffset) == 0) {
                if (this.curOffset + n11 != n15 && (n15 - this.curOffset < n10 || n15 - this.curOffset > n9)) {
                    byArray2[n15] = byArray[n13++];
                }
            } else {
                byArray2[n15] = this.format.getByte(n15 - this.curOffset);
            }
            ++n15;
        }
        if (this.format.getFoundCurrencyChar()) {
            n6 = n10 != -1 ? this.curOffset + n10 : this.end - this.ccBytes.length;
            for (n5 = 0; n5 < this.ccBytes.length && n6 < byArray2.length; ++n5, ++n6) {
                byArray2[n6] = this.ccBytes[n5];
            }
        }
        if (this.format.getSigned()) {
            n6 = n11 != -1 ? this.curOffset + n11 : this.end - 1;
            switch (this.format.getSign()) {
                case 0: {
                    if (bl2) {
                        byArray2[n6] = C_MINUS;
                        break;
                    }
                    byArray2[n6] = C_PLUS;
                    break;
                }
                case 1: {
                    if (bl2) {
                        byArray2[n6] = C_MINUS;
                        break;
                    }
                    byArray2[n6] = C_SPACE;
                    break;
                }
                case 3: {
                    if (bl2) {
                        byArray2[this.end - 2] = C_D;
                        byArray2[this.end - 1] = C_B;
                        break;
                    }
                    byArray2[this.end - 2] = C_SPACE;
                    byArray2[this.end - 1] = C_SPACE;
                    break;
                }
                case 2: {
                    if (bl2) {
                        byArray2[this.end - 2] = C_C;
                        byArray2[this.end - 1] = C_R;
                        break;
                    }
                    byArray2[this.end - 2] = C_SPACE;
                    byArray2[this.end - 1] = C_SPACE;
                }
            }
        }
        if ((n6 = byArray2[this.curOffset]) < C_0 || n6 > C_9) {
            n5 = n19 >= 0 ? this.curOffset + n19 : this.end;
            for (n4 = this.curOffset + 1; n4 < n5 && ((n6 = byArray2[n4]) < C_0 || n6 > C_9); ++n4) {
                if (n6 != C_POINT && n6 != C_COMMA) continue;
                for (int i2 = n4; i2 > this.curOffset; --i2) {
                    byArray2[i2] = byArray2[i2 - 1];
                }
                if (byArray2[this.curOffset] == C_STAR) continue;
                byArray2[this.curOffset] = C_SPACE;
            }
        }
    }

    void updateCache(byte[] byArray, CobolNum cobolNum) {
        String string;
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        try {
            string = new String(byArray, this.getOffset(), this.getLen(), encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            string = new String(byArray, this.getOffset(), this.getLen());
        }
        cobolNum.set(CobolNum.get(string, this.format.getDecLen()), false, false);
    }

    @Override
    protected void updateEnd() {
        this.end = this.curOffset + this.getLength();
    }

    public PicNumEdit atEdit(int[] nArray) {
        return (PicNumEdit)this.intAt(nArray);
    }

    public PicNumEdit atEdit(int n2) {
        return (PicNumEdit)this.intAt(n2);
    }

    @Override
    protected int getCategory() {
        return 5;
    }

    private long P(long l2, boolean bl) {
        if (this.format.getPOnLeft() ^ bl) {
            return l2 / this.format.getPNum().lnUnscValue;
        }
        return l2 * this.format.getPNum().lnUnscValue;
    }

    private CobolNum P(CobolNum cobolNum, boolean bl) {
        if (this.format.getPOnLeft() ^ bl) {
            return cobolNum.divide(false, this.format.getPNum());
        }
        return cobolNum.multiply(this.format.getPNum());
    }

    private boolean myIsNegative() {
        byte[] byArray = this.getMemory();
        if (this.format.getSigned()) {
            switch (this.format.getSign()) {
                case 0: 
                case 1: {
                    for (int i2 = this.curOffset; i2 < this.end; ++i2) {
                        if (byArray[i2] != C_MINUS) continue;
                        return true;
                    }
                    break;
                }
                case 2: {
                    return byArray[this.end - 1] == C_R;
                }
                case 3: {
                    return byArray[this.end - 1] == C_B;
                }
            }
        }
        return false;
    }

    @Override
    public int compareTo(NumericVar numericVar) {
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false).compareTo(numericVar.num());
        }
        return super.compareTo(numericVar);
    }

    @Override
    public int compareTo(NumericVar numericVar, int[] nArray) {
        if (this.format.getFoundP()) {
            return this.P(this.theValue, false).compareTo(numericVar.num());
        }
        return super.compareTo(numericVar, nArray);
    }

    @Override
    int internalCompare(ICobolVar iCobolVar) {
        return -((CobolVar)iCobolVar).compareTo(this);
    }

    @Override
    public String getPicture() {
        return this.picture;
    }

    @Override
    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public void valueToTable(CobolVar cobolVar, int[] nArray, int[] nArray2, int n2) {
        if (nArray2 == null) {
            if (cobolVar.isAll() || cobolVar instanceof NumericVar) {
                super.internalSet(cobolVar);
            } else {
                this.set(cobolVar.getMemory(), cobolVar.getOffset(), cobolVar.getLen(), true);
            }
        } else {
            for (int i2 = 1; i2 <= nArray2[n2]; ++i2) {
                nArray[n2] = i2;
                if (n2 == nArray2.length - 1) {
                    ((PicNumEdit)this.atNoClone(nArray)).valueToTable(cobolVar, nArray, null, 0);
                    continue;
                }
                this.valueToTable(cobolVar, nArray, nArray2, n2 + 1);
            }
        }
    }

    protected final void checkNumericContent() {
        if (!this.isNumericCheckContent()) {
            if (checkNC == 1) {
                throw new IscobolRuntimeException(31, this.name == null ? "" : this.name);
            }
            if (checkNC == -1) {
                Factory.log("CHECK NUMERIC CONTENT: detected not numeric " + (this.name == null ? "" : this.name));
            }
        }
    }

    static {
        char c2 = Config.a(".check.numeric_content", "N").charAt(0);
        checkNC = c2 == 'Y' || c2 == 'y' || c2 == 'S' || c2 == 's' || c2 == 'T' || c2 == 't' || c2 == '1' ? 1 : (c2 == 'N' || c2 == 'n' || c2 == 'F' || c2 == 'f' || c2 == '0' ? 0 : Config.a(".check.numeric_content", 0));
    }
}

