/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types;

import com.iscobol.rts.Config;
import com.iscobol.types.CobolNum;
import com.iscobol.types.EncBytes;
import java.io.Serializable;

public class PictureAnalyzer
implements EncBytes,
Serializable {
    private static final long serialVersionUID = 123L;
    public static final int PLUS = 0;
    public static final int MINUS = 1;
    public static final int CR = 2;
    public static final int DB = 3;
    public static final byte defaultCurrencySign = 36;
    public static final boolean storeValueWithoutEdit = Config.b(".memory.alpha_edited", false);
    private final char[] picture;
    private final byte[] memoryMap;
    private final boolean isDecPointComma;
    public final char currencyChar;
    public final byte currencyByte;
    private int intLen;
    private int decLen;
    private boolean signed;
    private boolean pOnLeft;
    private long pDecFact = 1L;
    private CobolNum pNum;
    private int pNumCount;
    private int pNumPos;
    private int decimalPointPosition = -1;
    private boolean foundDigit;
    private boolean foundP;
    private boolean foundSign;
    private boolean signOnHead;
    private boolean foundNine;
    private boolean foundCurrencyChar;
    private int ccStart = -1;
    private int replacementPosition;
    private byte replacementChar;
    private int sign;
    private int signPosition = -1;
    private boolean blankWhenZero;

    public PictureAnalyzer(String string, boolean bl, char c2) {
        byte[] byArray;
        string = PictureAnalyzer.expandParenthesis(string);
        this.picture = string.toCharArray();
        this.memoryMap = new byte[this.picture.length];
        this.isDecPointComma = bl;
        this.currencyChar = c2;
        this.currencyByte = this.currencyChar > '\u007f' ? ((byArray = new String(new char[]{c2}).getBytes()).length == 1 && byArray[0] < 0 ? byArray[0] : (byte)36) : (byte)this.currencyChar;
        this.analyzePicture();
    }

    public static String expandParenthesis(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] == '(') {
                int n2 = string.indexOf(41, i2);
                if (n2 == -1) {
                    return string;
                }
                int n3 = 0;
                try {
                    n3 = Integer.parseInt(string.substring(i2 + 1, n2)) - 1;
                }
                catch (NumberFormatException numberFormatException) {
                    return string;
                }
                if (i2 > 0) {
                    for (int i3 = 0; i3 < n3; ++i3) {
                        stringBuffer.append(cArray[i2 - 1]);
                    }
                } else {
                    return string;
                }
                i2 = n2;
                continue;
            }
            stringBuffer.append(cArray[i2]);
        }
        return stringBuffer.toString();
    }

    private void analyzePicture() {
        int n2;
        this.intLen = 0;
        this.decLen = 0;
        int n3 = 0;
        int n4 = this.picture.length;
        block20: for (n2 = 0; n2 < n4; ++n2) {
            char c2 = this.picture[n2];
            switch (c2) {
                case '/': {
                    this.memoryMap[n2] = C_SLASH;
                    continue block20;
                }
                case '0': {
                    this.memoryMap[n2] = C_0;
                    continue block20;
                }
                case '&': {
                    this.memoryMap[n2] = this.isDecPointComma ? C_COMMA : C_POINT;
                    if (this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = n2;
                    continue block20;
                }
                case '^': {
                    if (this.isDecPointComma) {
                        this.memoryMap[n2] = C_POINT;
                        continue block20;
                    }
                    this.memoryMap[n2] = C_COMMA;
                    continue block20;
                }
                case '.': {
                    this.memoryMap[n2] = C_POINT;
                    if (this.isDecPointComma || this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = n2;
                    continue block20;
                }
                case ',': {
                    this.memoryMap[n2] = C_COMMA;
                    if (!this.isDecPointComma || this.decimalPointPosition != -1) continue block20;
                    this.decimalPointPosition = n2;
                    continue block20;
                }
                case 'V': {
                    if (!this.foundP) {
                        this.decimalPointPosition = n2;
                    }
                    for (int i2 = n2; i2 < n4 - 1; ++i2) {
                        this.picture[i2] = this.picture[i2 + 1];
                    }
                    --n2;
                    --n4;
                    continue block20;
                }
                case 'P': {
                    this.foundP = true;
                    this.decimalPointPosition = -1;
                    if (!this.foundDigit) {
                        this.pOnLeft = true;
                    }
                    this.pDecFact *= 10L;
                    ++this.pNumCount;
                    this.pNumPos = n2;
                    continue block20;
                }
                case 'Z': {
                    if (!this.foundNine) {
                        this.replacementChar = C_SPACE;
                        this.replacementPosition = n2 + 1;
                    }
                    this.digit();
                    n3 = n2;
                    continue block20;
                }
                case '*': {
                    if (!this.foundNine) {
                        this.replacementChar = C_STAR;
                        this.replacementPosition = n2 + 1;
                    }
                    this.digit();
                    n3 = n2;
                    continue block20;
                }
                case '+': {
                    if (this.signed) {
                        if (this.checkSign(n2)) continue block20;
                        n3 = n2;
                        continue block20;
                    }
                    if (this.checkSign(0, n2)) continue block20;
                    n3 = n2;
                    continue block20;
                }
                case '-': {
                    if (this.signed) {
                        if (this.checkSign(n2)) continue block20;
                        n3 = n2;
                        continue block20;
                    }
                    if (this.checkSign(1, n2)) continue block20;
                    n3 = n2;
                    continue block20;
                }
                case 'C': {
                    continue block20;
                }
                case 'R': {
                    this.signed = true;
                    this.sign = 2;
                    continue block20;
                }
                case 'D': {
                    continue block20;
                }
                case 'B': {
                    if (n2 > 0 && this.picture[n2 - 1] == 'D') {
                        this.signed = true;
                        this.sign = 3;
                        continue block20;
                    }
                    this.memoryMap[n2] = C_SPACE;
                    continue block20;
                }
                case '9': {
                    this.foundNine = true;
                    this.digit();
                    n3 = n2;
                    continue block20;
                }
                case '#': {
                    c2 = this.currencyChar;
                }
                default: {
                    if (c2 != this.currencyChar) continue block20;
                    if (this.foundCurrencyChar) {
                        this.replacementPosition = n2 + 1;
                        this.replacementChar = C_SPACE;
                        this.digit();
                        n3 = n2;
                    } else {
                        this.foundCurrencyChar = true;
                    }
                    this.ccStart = n2;
                }
            }
        }
        if (this.replacementPosition == n3 + 1 && this.replacementChar != C_STAR) {
            this.blankWhenZero = true;
        }
        if (this.decimalPointPosition != -1 && this.decimalPointPosition < this.replacementPosition) {
            this.replacementPosition = this.decimalPointPosition;
        } else if (!(this.decimalPointPosition != -1 || this.foundP || this.foundSign || this.foundCurrencyChar || this.replacementPosition <= 0 || this.replacementChar == C_STAR)) {
            n2 = this.memoryMap.length - 1;
            while (this.replacementPosition < n2 && this.memoryMap[this.replacementPosition] != 0) {
                ++this.replacementPosition;
            }
        }
        if (this.foundP) {
            this.pNum = CobolNum.noo(this.pDecFact, 0);
        }
    }

    private void digit() {
        if (!this.foundDigit) {
            this.foundDigit = true;
        }
        if (this.decimalPointPosition != -1) {
            ++this.decLen;
        } else {
            if (this.pOnLeft) {
                this.pDecFact *= 10L;
            }
            ++this.intLen;
        }
    }

    private boolean checkSign(int n2) {
        boolean bl = false;
        if (this.foundSign) {
            if (this.replacementPosition == n2 - 1) {
                this.signOnHead = true;
            }
            this.replacementPosition = n2 + 1;
            this.replacementChar = C_SPACE;
            this.digit();
        } else {
            int n3;
            block3: for (n3 = 0; n3 < this.picture.length; ++n3) {
                switch (this.picture[n3]) {
                    case '/': 
                    case '0': 
                    case 'B': {
                        continue block3;
                    }
                }
            }
            if (n2 == n3) {
                this.signOnHead = true;
            }
            this.foundSign = true;
            bl = true;
        }
        this.signPosition = n2;
        this.signed = true;
        return bl;
    }

    private final boolean checkSign(int n2, int n3) {
        boolean bl = this.checkSign(n3);
        this.sign = n2;
        return bl;
    }

    public final boolean getSigned() {
        return this.signed;
    }

    public final int getIntLen() {
        return this.intLen;
    }

    public final int getDecLen() {
        return this.decLen;
    }

    public final int getTotLen() {
        return this.intLen + this.decLen;
    }

    public final char getCurrencyChar() {
        return this.currencyChar;
    }

    public final int getCCStart() {
        return this.ccStart;
    }

    public final int length() {
        return this.memoryMap.length;
    }

    public final byte getByte(int n2) {
        return this.memoryMap[n2];
    }

    public final char getChar(int n2) {
        return (char)this.memoryMap[n2];
    }

    public final boolean getPOnLeft() {
        return this.pOnLeft;
    }

    public final boolean getFoundP() {
        return this.foundP;
    }

    public final boolean getFoundSign() {
        return this.foundSign;
    }

    public final boolean getSignOnHead() {
        return this.signOnHead;
    }

    public final boolean getFoundCurrencyChar() {
        return this.foundCurrencyChar;
    }

    public final int getDecimalPointPosition() {
        return this.decimalPointPosition;
    }

    public final int getReplacementPosition() {
        return this.replacementPosition;
    }

    public final byte getReplacementByte() {
        return this.replacementChar;
    }

    public final int getSign() {
        return this.sign;
    }

    public final int getSignPosition() {
        if (this.signPosition < this.pNumPos) {
            return this.signPosition;
        }
        return this.signPosition - this.pNumCount;
    }

    public final CobolNum getPNum() {
        return this.pNum;
    }

    public boolean isBlankWhenZero() {
        return this.blankWhenZero;
    }

    public boolean isStarWhenZero() {
        return this.replacementChar == C_STAR && !this.foundNine;
    }

    public char[] getPicture() {
        return this.picture;
    }

    public static void main(String[] stringArray) {
        PictureAnalyzer pictureAnalyzer = new PictureAnalyzer("Z9(4)", false, '$');
        System.out.println(pictureAnalyzer.picture);
    }
}

