/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Config;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.types_n.CobolVar;
import java.io.Serializable;

public class ArrayCache
implements RuntimeErrorsNumbers,
Serializable {
    private static final int SIZE = Config.a("iscobol.array_cache", 101);
    private static final long serialVersionUID = 123L;
    private static final int[] empty = new int[SIZE];
    final CobolVar[] cache;
    final int[] indexes;
    final int size;

    public ArrayCache(int n2) {
        this.size = n2 < SIZE ? n2 : SIZE;
        this.cache = new CobolVar[this.size];
        this.indexes = new int[this.size];
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final void clear() {
        System.arraycopy(empty, 0, this.indexes, 0, this.size);
    }

    public final CobolVar get(int n2) {
        int n3 = n2;
        n3 &= Integer.MAX_VALUE;
        if (this.indexes[n3 %= this.size] == n2) {
            return this.cache[n3];
        }
        return null;
    }

    public final void put(CobolVar cobolVar, int n2) {
        int n3 = n2;
        n3 &= Integer.MAX_VALUE;
        this.indexes[n3 %= this.size] = n2;
        this.cache[n3] = cobolVar;
    }

    static {
        for (int i2 = SIZE - 1; i2 >= 0; --i2) {
            ArrayCache.empty[i2] = -1;
        }
    }
}

