/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Factory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;

public class MemoryByteArray
extends Memory {
    private static final long serialVersionUID = 123L;
    private static HandlesManager memBlocks = new HandlesManager(128);
    private byte[] memory;
    private long address;
    private int displ;
    private boolean isAllocated;
    private boolean optimized;

    @Override
    public void init(long l2, int n2, boolean bl) {
        this.address = l2;
        this.memory = (byte[])memBlocks.getObject((int)(this.address >>> 32));
        if (this.memory == null) {
            throw new IscobolRuntimeException(133, "Invalid address: " + this.address);
        }
        this.displ = (int)(this.address & 0xFFFFFFFFL);
        this.length = n2;
        this.isAllocated = false;
        this.optimized = bl;
    }

    @Override
    public void init(int n2, boolean bl) {
        this.memory = new byte[n2];
        this.length = n2;
        this.address = (long)memBlocks.newHandle(this) << 32;
        this.displ = 0;
        this.isAllocated = true;
        this.optimized = bl;
    }

    @Override
    public void init(byte[] byArray, boolean bl) {
        this.init(byArray.length, bl);
        System.arraycopy(byArray, 0, this.memory, 0, this.length);
    }

    @Override
    public long getBaseAddress() {
        return this.address;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public byte get(int n2) {
        return this.memory[this.displ + n2];
    }

    @Override
    public void put(int n2, byte by) {
        this.memory[this.displ + n2] = by;
    }

    @Override
    public void fill(byte by) {
        for (int i2 = this.displ + this.length - 1; i2 >= this.displ; --i2) {
            this.memory[i2] = by;
        }
    }

    @Override
    public void fill(int n2, int n3, byte by) {
        int n4 = this.displ + n3;
        for (int i2 = this.displ + n2; i2 < n4; ++i2) {
            this.memory[i2] = by;
        }
    }

    @Override
    public void fill(int n2, int n3, byte[] byArray) {
        Factory.myFill(this.memory, n2, n3, byArray);
    }

    @Override
    public void set(int n2, byte[] byArray, int n3, int n4) {
        int n5 = this.displ + n2;
        int n6 = 0;
        while (n6 < n4) {
            this.memory[n5] = byArray[n3];
            ++n5;
            ++n6;
            ++n3;
        }
    }

    @Override
    public void copy(int n2, Memory memory, int n3, int n4) {
        memory.set(n3, this.memory, n2, n4);
    }

    @Override
    public void finalize() {
        if (this.isAllocated) {
            memBlocks.removeHandle((int)(this.address >>> 32));
            this.isAllocated = false;
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int n2, int n3) {
        if (this.displ == 0 && n3 == this.length) {
            return this.memory;
        }
        byte[] byArray = new byte[n3];
        int n4 = this.displ + n2;
        int n5 = 0;
        while (n5 < n3) {
            byArray[n5] = this.memory[n4];
            ++n5;
            ++n4;
        }
        return byArray;
    }
}

