/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Factory;
import com.iscobol.rts.Memory;
import com.iscobol.types_n.MemoryUnsafe;

public class MemoryFast
extends Memory {
    private static final long serialVersionUID = 123L;
    private byte[] memory;
    private MemoryUnsafe unsafe;

    public MemoryFast(int n2) {
        this.length = n2;
        this.memory = new byte[this.length];
    }

    public MemoryFast(byte[] byArray) {
        this.memory = byArray;
        this.length = byArray.length;
    }

    @Override
    public void init(long l2, int n2, boolean bl) {
        throw new UnsupportedOperationException("MemoryFast.init 1");
    }

    @Override
    public void init(int n2, boolean bl) {
        throw new UnsupportedOperationException("MemoryFast.init 2");
    }

    @Override
    public void init(byte[] byArray, boolean bl) {
        throw new UnsupportedOperationException("MemoryFast.init 3");
    }

    @Override
    public long getBaseAddress() {
        if (this.unsafe == null) {
            this.unsafe = new MemoryUnsafe();
            this.unsafe.init(this.memory, false);
        } else {
            for (int i2 = 0; i2 < this.memory.length; ++i2) {
                this.unsafe.put(i2, this.memory[i2]);
            }
        }
        return this.unsafe.getBaseAddress();
    }

    @Override
    public boolean isOptimized() {
        return true;
    }

    @Override
    public byte get(int n2) {
        return this.memory[n2];
    }

    @Override
    public void put(int n2, byte by) {
        this.memory[n2] = by;
    }

    @Override
    public void fill(byte by) {
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            this.memory[i2] = by;
        }
    }

    @Override
    public void fill(int n2, int n3, byte by) {
        for (int i2 = n2; i2 < n3; ++i2) {
            this.memory[i2] = by;
        }
    }

    @Override
    public void fill(int n2, int n3, byte[] byArray) {
        Factory.myFill(this.memory, n2, n3, byArray);
    }

    @Override
    public void set(int n2, byte[] byArray, int n3, int n4) {
        int n5 = n2;
        int n6 = 0;
        while (n6 < n4) {
            this.memory[n5] = byArray[n3];
            ++n5;
            ++n6;
            ++n3;
        }
    }

    @Override
    public void copy(int n2, Memory memory, int n3, int n4) {
        memory.set(n3, this.memory, n2, n4);
    }

    @Override
    public void finalize() {
        if (this.unsafe != null) {
            this.unsafe.finalize();
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int n2, int n3) {
        if (n2 == 0 && n3 == this.memory.length) {
            return this.memory;
        }
        byte[] byArray = new byte[n3];
        Factory.myArraycopy(this.memory, n2, byArray, 0, n3);
        return byArray;
    }
}

