/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class MemoryUnsafe
extends Memory {
    private static final long serialVersionUID = 123L;
    private static final Unsafe theUnsafe;
    private long address;
    private boolean isAllocated;
    private boolean optimized;

    @Override
    public void init(long l2, int n2, boolean bl) {
        this.address = l2;
        this.length = n2;
        this.isAllocated = false;
        this.optimized = bl;
    }

    @Override
    public void init(int n2, boolean bl) {
        this.length = n2;
        this.address = theUnsafe.allocateMemory(this.length);
        this.isAllocated = true;
        this.optimized = bl;
    }

    @Override
    public void init(byte[] byArray, boolean bl) {
        this.init(byArray.length, bl);
        for (int i2 = this.length - 1; i2 >= 0; --i2) {
            this.put(i2, byArray[i2]);
        }
    }

    @Override
    public long getBaseAddress() {
        return this.address;
    }

    @Override
    public boolean isOptimized() {
        return this.optimized;
    }

    @Override
    public byte get(int n2) {
        return theUnsafe.getByte(this.address + (long)n2);
    }

    @Override
    public void put(int n2, byte by) {
        theUnsafe.putByte(this.address + (long)n2, by);
    }

    @Override
    public void fill(byte by) {
        theUnsafe.setMemory(this.address, this.length, by);
    }

    @Override
    public void fill(int n2, int n3, byte by) {
        long l2 = this.address + (long)n2;
        long l3 = this.address + (long)n3 - l2;
        theUnsafe.setMemory(this.address + (long)n2, l3, by);
    }

    @Override
    public void fill(int n2, int n3, byte[] byArray) {
        long l2 = this.address + (long)n2;
        long l3 = this.address + (long)n3;
        if ((n3 - n2 & 1) == 1) {
            theUnsafe.putByte(l2++, byArray[1]);
        }
        while (l2 < l3) {
            theUnsafe.putByte(l2++, byArray[0]);
            theUnsafe.putByte(l2++, byArray[1]);
        }
    }

    @Override
    public void set(int n2, byte[] byArray, int n3, int n4) {
        long l2 = this.address + (long)n2;
        int n5 = 0;
        while (n5 < n4) {
            theUnsafe.putByte(l2, byArray[n3]);
            ++l2;
            ++n5;
            ++n3;
        }
    }

    @Override
    public void copy(int n2, Memory memory, int n3, int n4) {
        theUnsafe.copyMemory(this.address + (long)n2, memory.getBaseAddress() + (long)n3, n4);
    }

    @Override
    public void finalize() {
        if (this.isAllocated) {
            theUnsafe.freeMemory(this.address);
            this.isAllocated = false;
        }
    }

    @Override
    public String toString() {
        return new String(this.toByteArray(0, this.length));
    }

    @Override
    public byte[] toByteArray(int n2, int n3) {
        byte[] byArray = new byte[n3];
        long l2 = this.address + (long)n2;
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = theUnsafe.getByte(l2);
            ++n4;
            ++l2;
        }
        return byArray;
    }

    static {
        Unsafe unsafe = null;
        try {
            Class<Unsafe> clazz = Unsafe.class;
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i2 = 0; i2 < fieldArray.length; ++i2) {
                if (!fieldArray[i2].getName().equals("theUnsafe")) continue;
                fieldArray[i2].setAccessible(true);
                unsafe = (Unsafe)fieldArray[i2].get(clazz);
                break;
            }
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(exception);
        }
        theUnsafe = unsafe;
    }
}

