/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.LiteralAll;
import com.iscobol.types_n.MemoryFast;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicBinary;
import com.iscobol.types_n.PicN;
import com.iscobol.types_n.PicX;
import java.io.UnsupportedEncodingException;

public class NumericLiteralAll
extends PicBinary {
    private Memory pseudoBuffer;
    private int origLen = super.getLen();
    private boolean national;
    private static final long serialVersionUID = 123L;

    public NumericLiteralAll(long l2, int n2, int n3, boolean bl) {
        super(l2, 8, true, n2, n3, bl);
        this.resetAll();
    }

    public static NumericLiteralAll numericLiteralAll(long l2, int n2, int n3, boolean bl) {
        return new NumericLiteralAll(l2, n2, n3, bl);
    }

    @Override
    public Memory getMemory() {
        return this.pseudoBuffer;
    }

    private byte[] longToBytes(long l2) {
        byte[] byArray;
        String string = Long.toString(l2);
        if (this.national) {
            char[] cArray = string.toCharArray();
            byArray = new byte[cArray.length];
            for (int i2 = 0; i2 < byArray.length; ++i2) {
                byArray[i2] = (byte)cArray[i2];
            }
        } else {
            try {
                byArray = string.getBytes(encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                byArray = string.getBytes();
            }
        }
        return byArray;
    }

    private void setAll(PicN picN) {
        this.national = true;
        byte[] byArray = this.longToBytes(this.getLong());
        this.end = this.len = picN.getLen();
        this.pseudoBuffer = new MemoryFast(this.len);
        if (this.pseudoBuffer.length < byArray.length) {
            int n2 = 0;
            while (n2 < this.pseudoBuffer.length) {
                this.pseudoBuffer.put(n2++, (byte)0);
                this.pseudoBuffer.put(n2++, byArray[n2]);
            }
        } else {
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.pseudoBuffer.length) {
                this.pseudoBuffer.put(n3++, (byte)0);
                this.pseudoBuffer.put(n3++, byArray[n4 % byArray.length]);
                ++n4;
            }
        }
    }

    private void setAll(CobolVar cobolVar) {
        byte[] byArray = this.longToBytes(this.getLong());
        this.end = this.len = cobolVar.getLen();
        this.pseudoBuffer = Memory.getMemory(this.len);
        if (this.pseudoBuffer.length < byArray.length) {
            for (int i2 = 0; i2 < this.pseudoBuffer.length; ++i2) {
                this.pseudoBuffer.put(i2, byArray[i2]);
            }
        } else {
            for (int i3 = 0; i3 < this.pseudoBuffer.length; ++i3) {
                this.pseudoBuffer.put(i3, byArray[i3 % byArray.length]);
            }
        }
    }

    @Override
    int getLen() {
        return this.len;
    }

    @Override
    int getEnd() {
        return this.end;
    }

    private synchronized void resetAll() {
        this.len = this.origLen;
        this.national = false;
        byte[] byArray = this.longToBytes(this.num().longValue());
        this.end = this.len = byArray.length;
        this.pseudoBuffer = new MemoryFast(byArray);
    }

    @Override
    public synchronized CobolVar moveTo(PicN picN) {
        this.setAll(picN);
        picN.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveTo(PicX picX) {
        this.setAll(picX);
        picX.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveTo(NumericVar numericVar) {
        return super.moveTo(numericVar);
    }

    @Override
    public synchronized CobolVar moveTo(CobolVar cobolVar) {
        this.setAll(cobolVar);
        cobolVar.set(this.pseudoBuffer, 0, this.pseudoBuffer.length, true);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized CobolVar moveToDepOnGroupItem(CobolVar cobolVar) {
        this.setAll(cobolVar);
        super.moveToDepOnGroupItem(cobolVar);
        this.resetAll();
        return this;
    }

    @Override
    public synchronized int compareTo(PicN picN) {
        if (picN instanceof IPicAnyLength && picN.getLength() == 0) {
            return 1;
        }
        this.setAll(picN);
        int n2 = super.compareTo(picN);
        this.resetAll();
        return n2;
    }

    public synchronized int compareTo(PicX picX) {
        if (picX instanceof IPicAnyLength && picX.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, picX);
    }

    @Override
    public synchronized int compareTo(CobolVar cobolVar) {
        if (cobolVar instanceof IPicAnyLength && cobolVar.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cobolVar);
    }

    @Override
    public synchronized int compareTo(PicN picN, int[] nArray) {
        if (picN instanceof IPicAnyLength && picN.getLength() == 0) {
            return 1;
        }
        this.setAll(picN);
        int n2 = super.compareTo(picN, nArray);
        this.resetAll();
        return n2;
    }

    public synchronized int compareTo(PicX picX, int[] nArray) {
        if (picX instanceof IPicAnyLength && picX.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, picX, nArray);
    }

    @Override
    public synchronized int compareTo(CobolVar cobolVar, int[] nArray) {
        if (cobolVar instanceof IPicAnyLength && cobolVar.getLength() == 0) {
            return 1;
        }
        return LiteralAll.compareTo(this, cobolVar, nArray);
    }

    @Override
    public String toString() {
        return this.toString(this.isDecPointComma);
    }

    @Override
    public String toString(boolean bl) {
        String string;
        Memory memory = this.getMemory();
        if (this.national) {
            string = new String(PicN.byteToChar(memory, 0, memory.length));
            if (bl) {
                string = string.replace('.', ',');
            }
        } else {
            string = super.toString(bl);
        }
        return string;
    }

    @Override
    public byte[] getBytes() {
        byte[] byArray = new byte[this.pseudoBuffer.length];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = this.pseudoBuffer.get(i2);
        }
        return byArray;
    }

    @Override
    public CobolNum num() {
        return this.theValue;
    }

    @Override
    public boolean isAll() {
        return true;
    }
}

