/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.Memory;
import com.iscobol.rts_n.Factory;
import com.iscobol.types.FloatingPointConverter;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.MemMan;
import com.iscobol.types_n.Pic1;

public class Pic1Bit
extends Pic1 {
    private int bitOffset;
    private int currBitOffset;
    private int bitLength;

    public Pic1Bit(Memory memory, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl, int n4, int n5) {
        super(memory, n2, n3, nArray, nArray2, string, bl);
        this.bitOffset = n4;
        this.currBitOffset = n4;
        this.bitLength = n5;
    }

    public Pic1Bit(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl, int n4, int n5) {
        super(cobolVar, n2, n3, nArray, nArray2, string, bl);
        this.bitOffset = n4;
        this.currBitOffset = n4;
        this.bitLength = n5;
    }

    @Override
    public int getBitOffset() {
        return this.currBitOffset;
    }

    @Override
    public int getBitLength() {
        return this.bitLength;
    }

    @Override
    public boolean set(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = this.getBitValue(string, stringBuilder);
        this.setBits(stringBuilder);
        return bl;
    }

    private void setBits(StringBuilder stringBuilder) {
        Memory memory = this.getMemory();
        int n2 = this.getOffset();
        int n3 = this.currBitOffset;
        int n4 = 0;
        while (n4 < this.bitLength) {
            if (n3 == 8) {
                n3 = 0;
                ++n2;
            }
            if (stringBuilder.charAt(n4) == '1') {
                memory.put(n2, (byte)(memory.get(n2) | SET_BIT[n3]));
            } else {
                memory.put(n2, (byte)(memory.get(n2) & UNSET_BIT[n3]));
            }
            ++n4;
            ++n3;
        }
    }

    @Override
    public boolean set(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(bl, stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(byte by) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(by, stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(short s2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(s2, stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(n2, stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(long l2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(l2, stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(float f2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(FloatingPointConverter.floatToIntBits(f2), stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public boolean set(double d2) {
        StringBuilder stringBuilder = new StringBuilder();
        this.getBitValue(FloatingPointConverter.doubleToLongBits(d2), stringBuilder);
        this.setBits(stringBuilder);
        return false;
    }

    @Override
    public String toString() {
        Memory memory = this.getMemory();
        int n2 = this.getOffset();
        int n3 = this.currBitOffset;
        StringBuilder stringBuilder = new StringBuilder();
        int n4 = 0;
        while (n4 < this.bitLength) {
            if (n3 == 8) {
                n3 = 0;
                ++n2;
            }
            if ((memory.get(n2) & SET_BIT[n3]) == 0) {
                stringBuilder.append('0');
            } else {
                stringBuilder.append('1');
            }
            ++n4;
            ++n3;
        }
        return stringBuilder.toString();
    }

    @Override
    public long tolong() {
        Memory memory = this.getMemory();
        int n2 = this.getOffset();
        int n3 = this.currBitOffset;
        long l2 = 0L;
        int n4 = BIT_MASK.length - this.bitLength;
        while (n4 < BIT_MASK.length) {
            if (n3 == 8) {
                n3 = 0;
                ++n2;
            }
            if ((memory.get(n2) & SET_BIT[n3]) != 0) {
                l2 |= BIT_MASK[n4];
            }
            ++n4;
            ++n3;
        }
        return l2;
    }

    @Override
    public CobolVar intAt(int[] nArray) {
        Pic1Bit pic1Bit = (Pic1Bit)super.intAt(nArray);
        pic1Bit.currBitOffset = this.getBitOffsetIncr(nArray);
        return pic1Bit;
    }

    @Override
    public CobolVar intAt(int n2) {
        Pic1Bit pic1Bit = (Pic1Bit)super.intAt(n2);
        pic1Bit.currBitOffset = this.getBitOffsetIncr(n2 - 1, 0);
        return pic1Bit;
    }

    @Override
    protected int getOffsetIncr(int n2, int n3) {
        int n4 = n2 * this.dimensionsSize[n3] - 8 + this.bitOffset;
        if (n4 < 0) {
            return 0;
        }
        if (n4 == 0) {
            return 1;
        }
        return n4 / 8 + 1;
    }

    @Override
    protected int getOffsetIncr(int[] nArray) {
        int n2 = super.getOffsetIncr(nArray) - 8 + this.bitOffset;
        if (n2 < 0) {
            return 0;
        }
        if (n2 == 0) {
            return 1;
        }
        return n2 / 8 + 1;
    }

    private int getBitOffsetIncr(int n2, int n3) {
        int n4 = n2 * this.dimensionsSize[n3];
        int n5 = n4 - 8 + this.bitOffset;
        if (n5 < 0) {
            return n4 + this.bitOffset;
        }
        if (n5 == 0) {
            return 0;
        }
        return n5 % 8;
    }

    private int getBitOffsetIncr(int[] nArray) {
        int n2 = super.getOffsetIncr(nArray);
        int n3 = n2 - 8 + this.bitOffset;
        if (n3 < 0) {
            return n2 + this.bitOffset;
        }
        if (n3 == 0) {
            return 0;
        }
        return n3 % 8;
    }

    @Override
    public Pic1Bit subBit(int n2) {
        return this.subBit(n2, this.getBitLength() - n2 + 1);
    }

    @Override
    public Pic1Bit subBit(int n2, int n3) {
        Pic1Bit pic1Bit;
        int n4 = this.getBitLength();
        if (this.checkSubLen(n2, n3, n4) <= 0) {
            switch (substringCheck) {
                case 1: {
                    throw new IscobolRuntimeException(1, this.name + "(" + n2 + ":" + n3 + ") [" + n4 + "]");
                }
                case -1: {
                    Factory.log("CHECK SUBSTRING: detected index out of bound " + this.name + "(" + n2 + ":" + n3 + ") [" + n4 + "]");
                }
            }
        }
        if (n2 < 1) {
            n2 = 1;
        }
        if (!substr0lenAll && n3 <= 0) {
            pic1Bit = new Pic1Bit(Factory.getMem(0), 0, 0, null, null, "", false, 0, 0);
        } else {
            int n5;
            int n6;
            int n7;
            if (n3 <= 0) {
                n3 = n4 - n2 + 1;
            } else {
                n7 = com.iscobol.rts.Factory.substrUnbound ? (this.getMemory().length - this.getOffset()) / 2 : n4;
                n3 = Math.max(0, Math.min(n3, n7 - n2 + 1));
            }
            n7 = n2 - 1;
            int n8 = n7 - 8 + this.bitOffset;
            if (n8 < 0) {
                n6 = n7 + this.bitOffset;
                n5 = 0;
            } else if (n8 == 0) {
                n6 = 0;
                n5 = 1;
            } else {
                n6 = n8 % 8;
                n5 = n8 / 8 + 1;
            }
            pic1Bit = new Pic1Bit(this.getMemory(), this.getOffset() + n5, n3 / 8, null, null, this.name, this.isDecPointComma, n6, n3);
            if (this.memory.isDynamic()) {
                pic1Bit.memory = new MemMan(this.getMemory());
            }
        }
        return pic1Bit;
    }
}

