/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public final class Pic9Comp_3
extends NumericVar
implements SignEncOpt {
    private static final long serialVersionUID = 123L;
    private final byte positive;
    private final byte unsigned;
    private static final byte[] UNSIGNED = new byte[]{15, 12};
    private static final byte[] POSITIVES = new byte[]{15, 12, 12, 11, 12};
    private static final byte NEGATIVE = 13;

    private static byte getPositive(int n2) {
        switch (n2) {
            case 0: {
                return POSITIVES[0];
            }
            case 1: {
                return POSITIVES[1];
            }
            case 3: {
                return POSITIVES[3];
            }
            case 4: {
                return POSITIVES[4];
            }
        }
        return POSITIVES[2];
    }

    private static byte getUnsigned(int n2) {
        switch (n2) {
            case 5: {
                return UNSIGNED[1];
            }
        }
        return UNSIGNED[0];
    }

    public Pic9Comp_3(Memory memory, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2) {
        super(memory, n2, n3, n4, bl, (n3 + n4) / 2 + 1, nArray, nArray2, string, bl2);
        this.positive = Pic9Comp_3.getPositive(n5);
        this.unsigned = Pic9Comp_3.getUnsigned(n5);
        if (memory != null) {
            this.updateCache(memory, this.theValue);
        }
    }

    public Pic9Comp_3(CobolVar cobolVar, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2) {
        super(cobolVar, n2, n3, n4, bl, (n3 + n4) / 2 + 1, nArray, nArray2, string, bl2);
        this.positive = Pic9Comp_3.getPositive(n5);
        this.unsigned = Pic9Comp_3.getUnsigned(n5);
    }

    @Override
    int getAlphaBuffSize() {
        return super.getAlphaBuffSize() + 1;
    }

    private void putBDToMem(Memory memory, BigCobolDec bigCobolDec) {
        int n2 = this.end - 1;
        BigCobolDec bigCobolDec2 = new BigCobolDec(bigCobolDec);
        byte by = bigCobolDec2.isNegative() ? (byte)13 : (this.signed ? (byte)this.positive : (byte)this.unsigned);
        byte by2 = bigCobolDec2.getDecDigit(0);
        bigCobolDec2.shift(-1);
        by = (byte)(by | (byte)(by2 << 4));
        memory.put(n2--, by);
        while (n2 >= this.curOffset) {
            by2 = bigCobolDec2.getDecDigit(0);
            bigCobolDec2.shift(-1);
            by = by2;
            by2 = bigCobolDec2.getDecDigit(0);
            bigCobolDec2.shift(-1);
            by = (byte)(by | (byte)(by2 << 4));
            memory.put(n2--, by);
        }
    }

    private void putLongToMem(Memory memory, long l2) {
        byte by;
        int n2 = this.end - 1;
        if (l2 < 0L) {
            l2 = -l2;
            by = 13;
        } else {
            by = this.signed ? (byte)this.positive : (byte)this.unsigned;
        }
        byte by2 = (byte)(l2 % 10L);
        l2 /= 10L;
        by = (byte)(by | (byte)(by2 << 4));
        memory.put(n2--, by);
        while (n2 >= this.curOffset) {
            by2 = (byte)(l2 % 10L);
            by = by2;
            by2 = (byte)((l2 /= 10L) % 10L);
            l2 /= 10L;
            by = (byte)(by | (byte)(by2 << 4));
            memory.put(n2--, by);
        }
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(memory, cobolNum.getUnscaledLong());
        } else {
            this.putBDToMem(memory, cobolNum.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory memory) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(memory, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(memory, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory memory = this.getMemory();
        memory.fill(this.curOffset, this.end, (byte)0);
        if (this.signed) {
            memory.put(this.end - 1, this.positive);
        } else {
            memory.put(this.end - 1, this.unsigned);
        }
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            cobolNum.set(this.getLongFromMem(memory), this.decLen);
        } else {
            cobolNum.set(this.getBDFromMem(memory));
        }
    }

    private long getLongFromMem(Memory memory) {
        int n2 = this.end;
        long l2 = 0L;
        long l3 = 1L;
        boolean bl = this.myIsNegative();
        l2 = memory.get(--n2) >> 4 & 0xF;
        l3 = 10L;
        --n2;
        while (n2 >= this.curOffset) {
            l2 += (long)(memory.get(n2) & 0xF) * l3;
            l2 += (long)(memory.get(n2) >> 4 & 0xF) * (l3 *= 10L);
            l3 *= 10L;
            --n2;
        }
        if (bl) {
            return -l2;
        }
        return l2;
    }

    private BigCobolDec getBDFromMem(Memory memory) {
        int n2 = this.end;
        boolean bl = this.myIsNegative();
        char[] cArray = new char[this.intLen + this.decLen + 2];
        int n3 = cArray.length;
        cArray[--n3] = (char)(memory.get(--n2) >> 4 & 0xF);
        --n2;
        while (n2 >= this.curOffset) {
            cArray[--n3] = (char)(memory.get(n2) & 0xF);
            cArray[--n3] = (char)(memory.get(n2) >> 4 & 0xF);
            --n2;
        }
        return Pic9Comp_3.getBD(cArray, n3, bl, this.decLen);
    }

    @Override
    public boolean isNumeric() {
        Memory memory = this.getMemory();
        int n2 = this.intLen + this.decLen;
        int n3 = this.curOffset;
        for (int i2 = 0; n3 < this.end && i2 < n2; ++n3, ++i2) {
            byte by = (byte)(memory.get(n3) >> 4 & 0xF);
            if (by < 0 || by > 9) {
                return false;
            }
            if (++i2 >= n2 || (by = (byte)(memory.get(n3) & 0xF)) >= 0 && by <= 9) continue;
            return false;
        }
        n3 = (byte)(memory.get(this.end - 1) & 0xF);
        return n3 == this.positive || n3 == 13 || n3 == this.unsigned;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.myIsNegative();
    }

    private boolean myIsNegative() {
        return (this.getMemory().get(this.end - 1) & 0xF) == 13;
    }
}

