/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.MemoryFast;
import com.iscobol.types_n.NumericVar;

public abstract class PicBinary
extends NumericVar {
    private static final long serialVersionUID = 123L;
    CobolNum value;
    long u_max = Long.MAX_VALUE;

    public PicBinary(Memory memory, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(memory, n2, n4, n5, bl, n3, nArray, nArray2, string, bl2);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i2 = 1; i2 < this.len * 8; ++i2) {
                this.u_max *= 2L;
            }
        }
        if (memory != null) {
            this.updateCache(memory, this.theValue);
        }
    }

    public PicBinary(CobolVar cobolVar, int n2, int n3, boolean bl, int n4, int n5, int[] nArray, int[] nArray2, String string, boolean bl2) {
        super(cobolVar, n2, n4, n5, bl, n3, nArray, nArray2, string, bl2);
        if (this.len < 8) {
            this.u_max = 2L;
            for (int i2 = 1; i2 < this.len * 8; ++i2) {
                this.u_max *= 2L;
            }
        }
    }

    public PicBinary(long l2, int n2, boolean bl, int n3, int n4, boolean bl2) {
        super(new MemoryFast(n2), 0, n3, n4, bl, n2, null, null, "$literal", bl2);
        this.set(CobolNum.noo(l2, n4), false, false);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[this.getMaxLength()] + 2;
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        if (memory != null) {
            cobolNum.toBinaryByteArray(memory, this.curOffset, this.len);
        }
    }

    @Override
    void updateMemory(Memory memory) {
        if (memory != null) {
            this.num().toBinaryByteArray(memory, this.curOffset, this.len);
        }
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            cobolNum.set(this.getLongFromMem(memory), this.decLen);
        } else {
            cobolNum.set(new BigCobolDec(memory.toByteArray(this.curOffset, this.len), 0, this.len, this.signed, this.decLen));
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        this.getMemory().fill(this.curOffset, this.end, (byte)0);
    }

    protected long getLongFromMem(Memory memory) {
        long l2;
        if (memory != null) {
            int n2;
            int n3 = this.curOffset;
            l2 = 0L;
            if (this.signed && memory.get(n3) < 0) {
                for (n2 = 7; n2 >= this.len; --n2) {
                    l2 |= 255L << n2 * 8;
                }
            } else {
                n2 = this.len - 1;
            }
            while (n2 > 0) {
                l2 |= (long)(memory.get(n3++) & 0xFF) << n2 * 8;
                --n2;
            }
            l2 |= (long)(memory.get(n3) & 0xFF);
        } else {
            l2 = this.value != null ? this.value.getUnscaledLong() : 0L;
        }
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        return l2;
    }
}

