/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.math.BigCobolDec;
import com.iscobol.rts.Memory;
import com.iscobol.rts.SignEncOpt;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.EncBytes;
import com.iscobol.types_n.NumericVar;
import com.iscobol.types_n.PicNumEdit;

public class PicDisplay
extends NumericVar
implements SignEncOpt,
EncBytes {
    private static final long serialVersionUID = 123L;
    private boolean signSeparated = false;
    private boolean signLeading = false;
    private final byte[][] encoded_sign;

    private byte[][] init(int n2, boolean bl, boolean bl2) {
        this.signSeparated = bl;
        this.signLeading = bl2;
        switch (n2) {
            default: {
                return dca_encoded_sign;
            }
            case 1: {
                return dci_encoded_sign;
            }
            case 2: {
                return dcm_encoded_sign;
            }
            case 3: {
                return dcb_encoded_sign;
            }
            case 4: 
        }
        return dcr_encoded_sign;
    }

    public PicDisplay(Memory memory, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4) {
        super(memory, n2, n3, n4, bl, n3 + n4 + (bl2 && bl ? 1 : 0), nArray, nArray2, string, bl4);
        this.encoded_sign = this.init(n5, bl2, bl3);
    }

    public PicDisplay(CobolVar cobolVar, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4) {
        super(cobolVar, n2, n3, n4, bl, n3 + n4 + (bl2 && bl ? 1 : 0), nArray, nArray2, string, bl4);
        this.encoded_sign = this.init(n5, bl2, bl3);
    }

    private void putBDToMem(Memory memory, BigCobolDec bigCobolDec) {
        BigCobolDec bigCobolDec2 = new BigCobolDec(bigCobolDec);
        int n2 = this.end - 1;
        int n3 = this.curOffset;
        boolean bl = bigCobolDec2.isNegative() ? this.signed : false;
        byte by = encoded_digits[bigCobolDec2.getDecDigit(0)];
        bigCobolDec2.shift(-1);
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    ++n3;
                } else {
                    memory.put(n2--, bl ? C_MINUS : C_PLUS);
                }
                memory.put(n2--, by);
            } else if (this.signLeading) {
                memory.put(n2--, by);
            } else {
                memory.put(n2--, this.encodeSign(bl, by));
            }
        } else {
            memory.put(n2--, by);
        }
        while (n2 >= n3) {
            by = encoded_digits[bigCobolDec2.getDecDigit(0)];
            bigCobolDec2.shift(-1);
            memory.put(n2--, by);
        }
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    memory.put(this.curOffset, bl ? C_MINUS : C_PLUS);
                }
            } else if (this.signLeading) {
                memory.put(this.curOffset, this.encodeSign(bl, by));
            }
        }
    }

    private void putLongToMem(Memory memory, long l2) {
        int n2 = this.curOffset;
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    int n3 = this.end - 1;
                    if (l2 < 0L) {
                        l2 = -l2;
                        memory.put(n2++, C_MINUS);
                    } else {
                        memory.put(n2++, C_PLUS);
                    }
                    while (l2 != 0L && n3 >= n2) {
                        memory.put(n3, encoded_digits[(int)(l2 % 10L)]);
                        --n3;
                        l2 /= 10L;
                    }
                    while (n3 >= n2) {
                        memory.put(n3, encoded_digits[0]);
                        --n3;
                    }
                } else {
                    int n4 = this.end - 1;
                    if (l2 < 0L) {
                        l2 = -l2;
                        memory.put(n4--, C_MINUS);
                    } else {
                        memory.put(n4--, C_PLUS);
                    }
                    while (l2 != 0L && n4 >= n2) {
                        memory.put(n4, encoded_digits[(int)(l2 % 10L)]);
                        --n4;
                        l2 /= 10L;
                    }
                    while (n4 >= n2) {
                        memory.put(n4, encoded_digits[0]);
                        --n4;
                    }
                }
            } else if (this.signLeading) {
                int n5;
                int n6 = this.end - 1;
                if (l2 < 0L) {
                    l2 = -l2;
                    n5 = 1;
                } else {
                    n5 = 0;
                }
                while (l2 != 0L && n6 > n2) {
                    memory.put(n6, encoded_digits[(int)(l2 % 10L)]);
                    --n6;
                    l2 /= 10L;
                }
                while (n6 > n2) {
                    memory.put(n6, encoded_digits[0]);
                    --n6;
                }
                memory.put(n2, this.encoded_sign[(int)(l2 % 10L)][n5]);
            } else {
                int n7 = this.end - 1;
                if (l2 < 0L) {
                    l2 = -l2;
                    memory.put(n7--, this.encoded_sign[(int)(l2 % 10L)][1]);
                } else {
                    memory.put(n7--, this.encoded_sign[(int)(l2 % 10L)][0]);
                }
                l2 /= 10L;
                while (l2 != 0L && n7 >= n2) {
                    memory.put(n7, encoded_digits[(int)(l2 % 10L)]);
                    --n7;
                    l2 /= 10L;
                }
                while (n7 >= n2) {
                    memory.put(n7, encoded_digits[0]);
                    --n7;
                }
            }
        } else {
            int n8 = this.end - 1;
            if (l2 < 0L) {
                l2 = -l2;
            }
            while (l2 != 0L && n8 >= n2) {
                memory.put(n8, encoded_digits[(int)(l2 % 10L)]);
                --n8;
                l2 /= 10L;
            }
            while (n8 >= n2) {
                memory.put(n8, encoded_digits[0]);
                --n8;
            }
        }
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(memory, cobolNum.getUnscaledLong());
        } else {
            this.putBDToMem(memory, cobolNum.bigCobDecValue());
        }
    }

    @Override
    void updateMemory(Memory memory) {
        if (this.intLen + this.decLen <= 18) {
            this.putLongToMem(memory, this.num().getUnscaledLong());
        } else {
            this.putBDToMem(memory, this.num().bigCobDecValue());
        }
    }

    @Override
    public void defaultInitialize() {
        this.theValue.lnUnscValue = 0L;
        Memory memory = this.getMemory();
        memory.fill(this.curOffset, this.end, C_0);
        if (this.signed) {
            if (this.signLeading) {
                if (this.signSeparated) {
                    memory.put(this.curOffset, C_PLUS);
                } else {
                    memory.put(this.curOffset, this.encoded_sign[0][0]);
                }
            } else if (this.signSeparated) {
                memory.put(this.end - 1, C_PLUS);
            } else {
                memory.put(this.end - 1, this.encoded_sign[0][0]);
            }
        }
    }

    @Override
    public boolean isNumeric() {
        Memory memory = this.getMemory();
        for (int i2 = this.curOffset; i2 < this.end; ++i2) {
            byte by = memory.get(i2);
            if (i2 == this.curOffset && this.signed && this.signLeading && !this.signSeparated) {
                by = (byte)(this.decodeSign(this.myIsNegative(memory), by) + C_0);
            }
            if (i2 == this.end - 1 && this.signed && !this.signLeading && !this.signSeparated) {
                by = (byte)(this.decodeSign(this.myIsNegative(memory), by) + C_0);
            }
            if (by >= C_0 && by <= C_9) continue;
            if (by == C_PLUS || by == C_MINUS) {
                if (this.signed) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isNegative() {
        return this.isNumeric() && this.num().isNegative();
    }

    @Override
    public void subFromMe(long l2) {
        this.addToMe(-l2);
    }

    @Override
    public void addToMe(long l2) {
        if (this.signed || l2 > 9L || l2 < -9L || this.decLen > 0 || this.intLen > 18) {
            super.addToMe(l2);
        } else {
            int n2;
            if (this.isFinal) {
                return;
            }
            long l3 = 0L;
            Memory memory = this.memory.getMemory();
            byte by = 0;
            int n3 = 0;
            int n4 = (int)l2;
            int n5 = 0;
            for (n2 = this.end - 1; n2 >= this.curOffset; --n2) {
                by = memory.get(n2);
                n3 = (by & 0xF) + n4;
                by = C_0;
                if (n3 > 9) {
                    n4 = 1;
                    memory.put(n2, (byte)((n3 -= 10) | by));
                    l3 += (long)n3 * CobolNum.fact[n5];
                } else if (n3 < 0) {
                    n4 = -1;
                    memory.put(n2, (byte)((n3 += 10) | by));
                    l3 += (long)n3 * CobolNum.fact[n5];
                } else {
                    n4 = 0;
                    memory.put(n2, (byte)(n3 | by));
                    l3 += (long)n3 * CobolNum.fact[n5];
                    --n2;
                    break;
                }
                ++n5;
            }
            if (n4 < 0) {
                n2 = this.end - 1;
                by = memory.get(this.end - 1);
                n3 = by & 0xF;
                l3 = 10 - n3;
                by = (byte)(by & 0xF0);
                memory.put(n2, (byte)(l3 | (long)by));
                --n2;
                while (n2 >= this.curOffset) {
                    memory.put(n2, by);
                    --n2;
                }
            } else {
                ++n5;
                while (n2 >= this.curOffset) {
                    n3 = memory.get(n2) & 0xF;
                    l3 += (long)n3 * CobolNum.fact[n5];
                    memory.put(n2, (byte)(n3 | by));
                    ++n5;
                    --n2;
                }
            }
            this.theValue.set(l3, 0, false);
        }
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        if (checkNC != 0) {
            this.checkNumericContent();
        }
        if (this.intLen + this.decLen <= 18) {
            cobolNum.set(this.getLongFromMem(memory), this.decLen);
        } else {
            cobolNum.set(this.getBDFromMem(memory));
        }
    }

    private long getLongFromMem(Memory memory) {
        long l2;
        block15: {
            block12: {
                block13: {
                    block14: {
                        l2 = 0L;
                        if (!this.signed) break block12;
                        if (!this.signSeparated) break block13;
                        if (!this.signLeading) break block14;
                        int n2 = this.end - 1;
                        int n3 = 0;
                        while (n2 > this.curOffset) {
                            l2 += (long)(memory.get(n2) & 0xF) * CobolNum.fact[n3];
                            --n2;
                            ++n3;
                        }
                        if (memory.get(this.curOffset) == C_MINUS) {
                            l2 = -l2;
                        }
                        break block15;
                    }
                    int n4 = this.end - 2;
                    int n5 = 0;
                    while (n4 >= this.curOffset) {
                        l2 += (long)(memory.get(n4) & 0xF) * CobolNum.fact[n5];
                        --n4;
                        ++n5;
                    }
                    if (memory.get(this.end - 1) != C_MINUS) break block15;
                    l2 = -l2;
                    break block15;
                }
                if (this.signLeading) {
                    int n6 = this.end - 1;
                    int n7 = 0;
                    while (n6 > this.curOffset) {
                        l2 += (long)(memory.get(n6) & 0xF) * CobolNum.fact[n7];
                        --n6;
                        ++n7;
                    }
                    n6 = this.getInternalSignDigit(memory.get(this.curOffset));
                    if (n6 < 0) {
                        l2 = -l2;
                        l2 += (long)(++n6) * CobolNum.fact[n7];
                    } else {
                        l2 += (long)n6 * CobolNum.fact[n7];
                    }
                } else {
                    int n8 = this.end - 2;
                    int n9 = 1;
                    while (n8 >= this.curOffset) {
                        l2 += (long)(memory.get(n8) & 0xF) * CobolNum.fact[n9];
                        --n8;
                        ++n9;
                    }
                    n8 = this.getInternalSignDigit(memory.get(this.end - 1));
                    if (n8 < 0) {
                        l2 = -l2;
                        l2 += (long)(++n8);
                    } else {
                        l2 += (long)n8;
                    }
                }
                break block15;
            }
            int n10 = this.end - 1;
            int n11 = 0;
            while (n10 >= this.curOffset) {
                l2 += (long)(memory.get(n10) & 0xF) * CobolNum.fact[n11];
                --n10;
                ++n11;
            }
        }
        return l2;
    }

    private BigCobolDec getBDFromMem(Memory memory) {
        int n2 = this.end - 1;
        boolean bl = this.myIsNegative(memory);
        char[] cArray = new char[this.intLen + this.decLen + 2];
        int n3 = cArray.length;
        if (this.signed) {
            if (this.signLeading) {
                cArray[--n3] = (char)(memory.get(n2--) & 0xF);
            } else if (this.signSeparated) {
                int n4 = --n2;
                --n2;
                cArray[--n3] = (char)(memory.get(n4) & 0xF);
            } else {
                cArray[--n3] = (char)this.decodeSign(bl, memory.get(this.end - 1));
                --n2;
            }
        } else {
            cArray[--n3] = (char)(memory.get(n2--) & 0xF);
        }
        while (n2 > this.curOffset) {
            cArray[--n3] = (char)(memory.get(n2) & 0xF);
            --n2;
        }
        if (this.signed) {
            if (this.signLeading) {
                if (!this.signSeparated) {
                    cArray[--n3] = (char)this.decodeSign(bl, memory.get(this.curOffset));
                }
            } else {
                cArray[--n3] = (char)(memory.get(n2) & 0xF);
            }
        } else {
            cArray[--n3] = (char)(memory.get(n2) & 0xF);
        }
        return PicDisplay.getBD(cArray, n3, bl, this.decLen);
    }

    private byte encodeSign(boolean bl, byte by) {
        int n2 = bl ? 1 : 0;
        int n3 = by & 0xF;
        return this.encoded_sign[n3][n2];
    }

    private byte decodeSign(boolean bl, byte by) {
        int n2 = bl ? 1 : 0;
        for (int i2 = 0; i2 < this.encoded_sign.length; ++i2) {
            if (this.encoded_sign[i2][n2] != by) continue;
            return (byte)i2;
        }
        return (byte)(by & 0xF);
    }

    private boolean myIsNegative(Memory memory) {
        if (this.signed) {
            if (this.signSeparated) {
                if (this.signLeading) {
                    return memory.get(this.curOffset) == C_MINUS;
                }
                return memory.get(this.end - 1) == C_MINUS;
            }
            if (this.signLeading) {
                return this.myIsNegative(memory.get(this.curOffset));
            }
            return this.myIsNegative(memory.get(this.end - 1));
        }
        return false;
    }

    private boolean myIsNegative(byte by) {
        return this.getInternalSignDigit(by) < 0;
    }

    private int getInternalSignDigit(byte by) {
        byte by2 = this.encoded_sign[0][1];
        byte by3 = this.encoded_sign[1][1];
        byte by4 = this.encoded_sign[9][1];
        byte by5 = this.encoded_sign[0][0];
        byte by6 = this.encoded_sign[1][0];
        byte by7 = this.encoded_sign[9][0];
        if (by >= by3 && by <= by4) {
            return -(by - by3 + 2);
        }
        if (by >= by6 && by <= by7) {
            return by - by6 + 1;
        }
        if (by == by2) {
            return -1;
        }
        if (by == by5) {
            return 0;
        }
        return by & 0xF;
    }

    public boolean isSignLeading() {
        return this.signLeading;
    }

    public boolean isSignSeparated() {
        return this.signSeparated;
    }

    @Override
    public CobolVar moveTo92UD(PicNumEdit picNumEdit) {
        if (!this.isNumeric()) {
            picNumEdit.setBytes(this.getMemory(), this.getOffset(), this.getLen());
        } else {
            picNumEdit.set(this);
        }
        return this;
    }
}

