/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.PicDisplay;

public class PicDisplayWP
extends PicDisplay {
    private static final long serialVersionUID = 123L;
    private final short piLen;
    private final short myIntLen;
    private final short myDecLen;

    public PicDisplayWP(Memory memory, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4, int n6) {
        super(memory, n2, n3, n4, bl, nArray, nArray2, string, n5, bl2, bl3, bl4);
        this.piLen = (short)n6;
        if (this.piLen > 0) {
            this.myIntLen = (short)(this.intLen + this.piLen);
            this.myDecLen = 0;
        } else if (this.piLen < 0) {
            this.myIntLen = 0;
            this.myDecLen = (short)(this.decLen - this.piLen);
        } else {
            this.myIntLen = this.intLen;
            this.myDecLen = this.decLen;
        }
        this.theValue = CobolNum.get(this.myIntLen, (int)this.myDecLen);
    }

    public PicDisplayWP(CobolVar cobolVar, int n2, int n3, int n4, boolean bl, int[] nArray, int[] nArray2, String string, int n5, boolean bl2, boolean bl3, boolean bl4, int n6) {
        super(cobolVar, n2, n3, n4, bl, nArray, nArray2, string, n5, bl2, bl3, bl4);
        this.piLen = (short)n6;
        if (this.piLen > 0) {
            this.myIntLen = (short)(this.intLen + this.piLen);
            this.myDecLen = 0;
        } else if (this.piLen < 0) {
            this.myIntLen = 0;
            this.myDecLen = (short)(this.decLen - this.piLen);
        } else {
            this.myIntLen = this.intLen;
            this.myDecLen = this.decLen;
        }
        this.theValue = CobolNum.get(this.myIntLen, (int)this.myDecLen);
    }

    @Override
    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        if (this.piLen != 0) {
            if (this.piLen > 0) {
                l2 /= CobolNum.fact[this.piLen];
                l2 *= CobolNum.fact[this.piLen];
            } else {
                l2 *= CobolNum.fact[-this.piLen];
                l2 /= CobolNum.fact[-this.piLen];
            }
        }
        int n3 = n2 - this.myDecLen;
        if (bl && n3 > 0) {
            l2 = CobolNum.roundUpIfNeeded(l2, n3);
        }
        if ((bl3 = CobolNum.isLongOverflow(l2, n2, this.myIntLen)) && bl2) {
            return true;
        }
        if (!this.signed && l2 < 0L) {
            l2 = -l2;
        }
        this.theValue.set(l2, n2);
        if (this.myDecLen != n2) {
            this.theValue.setScale(this.myDecLen, false, this.lenInBytes);
        }
        if (bl3) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.myIntLen, this.myDecLen);
            }
        }
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }

    @Override
    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        boolean bl3;
        if (this.isFinal) {
            return true;
        }
        if (bl) {
            cobolNum = CobolNum.noo(cobolNum);
            if (this.piLen > 0) {
                cobolNum.roundUpIfNeeded(this.piLen);
            }
            if (this.myDecLen < cobolNum.scale()) {
                cobolNum.setScale(this.myDecLen, bl, this.lenInBytes);
            }
        }
        if ((bl3 = cobolNum.isOverflow(this.theValue, this.myIntLen)) && bl2) {
            return true;
        }
        this.theValue.set(cobolNum, bl, this.lenInBytes);
        this.theValue.shift(-this.piLen);
        this.theValue.shift(this.piLen);
        if (!this.signed && this.theValue.signum() < 0) {
            this.theValue.negateMe();
        }
        if (this.myDecLen != cobolNum.scale()) {
            this.theValue.setScale(this.myDecLen, bl, this.lenInBytes);
        }
        if (bl3) {
            if (this.lenInBytes) {
                if (this.signed) {
                    this.theValue.setSizeByteSigned(this.len);
                } else {
                    this.theValue.setSizeByteUnsigned(this.len);
                }
            } else {
                this.theValue.setSizeDigit(this.myIntLen, this.myDecLen);
            }
        }
        this.updateMemory(this.memory.getMemory(), this.theValue);
        return false;
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        cobolNum = CobolNum.noo(cobolNum);
        cobolNum.shift(-this.piLen);
        cobolNum.setScale(this.decLen);
        super.updateMemory(memory, cobolNum);
    }

    @Override
    void updateMemory(Memory memory) {
        this.updateMemory(memory, this.num());
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        super.updateCache(memory, cobolNum);
        cobolNum.setScale(this.myDecLen);
        cobolNum.shift(this.piLen);
    }

    @Override
    public String toString() {
        return new String(this.getMemory().toByteArray(this.getOffset(), this.getLen()));
    }

    @Override
    public int intLength() {
        return this.myIntLen;
    }

    @Override
    public int scale() {
        return this.myDecLen;
    }
}

