/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public class PicInt
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public PicInt(Memory memory, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(memory, n2, PicInt.bDigits(4, n3, 0), 0, true, 4, nArray, nArray2, string, bl);
        if (memory != null) {
            this.updateCache(memory, this.theValue);
        }
    }

    public PicInt(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(cobolVar, n2, PicInt.bDigits(4, n3, 0), 0, true, 4, nArray, nArray2, string, bl);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[4] + 1;
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        this.internalSet(memory, cobolNum.getUnscaledLong());
    }

    @Override
    void updateMemory(Memory memory) {
        this.internalSet(memory, this.num().getUnscaledLong());
    }

    protected void internalSet(Memory memory, long l2) {
        int n2 = this.curOffset;
        memory.put(n2++, (byte)(l2 >>> 24));
        memory.put(n2++, (byte)(l2 >>> 16));
        memory.put(n2++, (byte)(l2 >>> 8));
        memory.put(n2, (byte)l2);
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        cobolNum.set(this.getLongFromMem(memory), this.decLen);
    }

    @Override
    public void defaultInitialize() {
        Memory memory = this.getMemory();
        memory.fill(this.curOffset, this.end, (byte)0);
        this.theValue.lnUnscValue = 0L;
    }

    protected long getLongFromMem(Memory memory) {
        int n2 = this.curOffset;
        int n3 = (memory.get(n2++) & 0xFF) << 24;
        n3 |= (memory.get(n2++) & 0xFF) << 16;
        n3 |= (memory.get(n2++) & 0xFF) << 8;
        return n3 |= memory.get(n2) & 0xFF;
    }

    @Override
    public boolean set(long l2) {
        this.theValue.lnUnscValue = (int)l2;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        if (bl2 && CobolNum.isLongOverflowByte(l2, this.len, this.signed, n2 - this.decLen)) {
            return true;
        }
        if (n2 != 0) {
            l2 = bl ? CobolNum.roundUpIfNeeded(l2, n2) / CobolNum.fact[n2] : (l2 /= CobolNum.fact[n2]);
        }
        this.theValue.lnUnscValue = (int)l2;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        if (bl2 && cobolNum.isOverflowByte(this.theValue, this.len, this.signed)) {
            return true;
        }
        this.theValue.lnUnscValue = cobolNum.intValue(bl);
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public void addToMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (int)this.getLongFromMem(memory) + (int)l2;
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void subFromMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (int)this.getLongFromMem(memory) - (int)l2;
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void multiplyByMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (int)this.getLongFromMem(memory) * (int)l2;
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        Memory memory = this.memory.getMemory();
        if (l2 == 0L) {
            this.theValue.set((int)this.getLongFromMem(memory));
            this.theValue.divideIntoMe(bl, (int)l2);
            this.internalSet(memory, this.theValue.intValue());
        } else {
            int n2 = (int)this.getLongFromMem(memory) / (int)l2;
            this.internalSet(memory, n2);
        }
    }
}

