/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.types_n;

import com.iscobol.rts.Memory;
import com.iscobol.types.CobolNum;
import com.iscobol.types_n.CobolVar;
import com.iscobol.types_n.NumericVar;

public class PicShort
extends NumericVar {
    private static final long serialVersionUID = 123L;

    public PicShort(Memory memory, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(memory, n2, PicShort.bDigits(2, n3, 0), 0, true, 2, nArray, nArray2, string, bl);
        if (memory != null) {
            this.updateCache(memory, this.theValue);
        }
    }

    public PicShort(CobolVar cobolVar, int n2, int n3, int[] nArray, int[] nArray2, String string, boolean bl) {
        super(cobolVar, n2, PicShort.bDigits(2, n3, 0), 0, true, 2, nArray, nArray2, string, bl);
    }

    @Override
    int getAlphaBuffSize() {
        return XLEN[2] + 1;
    }

    @Override
    void updateMemory(Memory memory, CobolNum cobolNum) {
        this.internalSet(memory, cobolNum.getUnscaledLong());
    }

    @Override
    void updateMemory(Memory memory) {
        this.internalSet(memory, this.num().getUnscaledLong());
    }

    protected void internalSet(Memory memory, long l2) {
        int n2 = this.curOffset;
        memory.put(n2++, (byte)(l2 >>> 8));
        memory.put(n2, (byte)l2);
    }

    @Override
    void updateCache(Memory memory, CobolNum cobolNum) {
        cobolNum.set(this.getLongFromMem(memory), this.decLen);
    }

    @Override
    public void defaultInitialize() {
        Memory memory = this.getMemory();
        memory.fill(this.curOffset, this.end, (byte)0);
        this.theValue.lnUnscValue = 0L;
    }

    protected long getLongFromMem(Memory memory) {
        int n2 = this.curOffset;
        short s2 = (short)((memory.get(n2++) & 0xFF) << 8);
        s2 = (short)(s2 | (short)(memory.get(n2) & 0xFF));
        return s2;
    }

    @Override
    public boolean set(long l2) {
        this.theValue.lnUnscValue = (short)l2;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(long l2, int n2, boolean bl, boolean bl2) {
        if (n2 != 0) {
            l2 = bl ? CobolNum.roundUpIfNeeded(l2, n2) / CobolNum.fact[n2] : (l2 /= CobolNum.fact[n2]);
        }
        if (bl2 && CobolNum.isLongOverflowByte(l2, this.len, this.signed, n2 - this.decLen)) {
            return true;
        }
        this.theValue.lnUnscValue = (short)l2;
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public boolean set(CobolNum cobolNum, boolean bl, boolean bl2) {
        if (bl2 && cobolNum.isOverflowByte(this.theValue, this.len, this.signed)) {
            return true;
        }
        this.theValue.lnUnscValue = (short)cobolNum.shortValue(bl);
        this.internalSet(this.memory.getMemory(), this.theValue.lnUnscValue);
        return false;
    }

    @Override
    public void addToMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(memory) + l2);
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void subFromMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(memory) - l2);
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void multiplyByMe(long l2) {
        Memory memory = this.memory.getMemory();
        this.theValue.lnUnscValue = (short)(this.getLongFromMem(memory) * l2);
        this.internalSet(memory, this.theValue.lnUnscValue);
    }

    @Override
    public void divideIntoMe(boolean bl, long l2) {
        Memory memory = this.memory.getMemory();
        if (l2 == 0L) {
            this.theValue.set(this.getLongFromMem(memory));
            this.theValue.divideIntoMe(bl, (short)l2);
            this.internalSet(memory, this.theValue.intValue());
        } else {
            short s2 = (short)(this.getLongFromMem(memory) / l2);
            this.internalSet(memory, s2);
        }
    }
}

