/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.updater.server;

import com.iscobol.as.HttpServerIntf;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class HttpServer
implements HttpServerIntf {
    private Logger log;
    private Properties serverProps;
    private String baseDir;
    private long serverPropsLastLoad;

    private static void sendResponse(HttpExchange httpExchange, int n2, String string) throws IOException {
        byte[] byArray = string.getBytes();
        httpExchange.sendResponseHeaders(n2, byArray.length);
        OutputStream outputStream = httpExchange.getResponseBody();
        outputStream.write(byArray, 0, byArray.length);
        outputStream.close();
    }

    @Override
    public void start(int n2, String string) throws Exception {
        this.baseDir = string;
        this.loadServerProps();
        com.sun.net.httpserver.HttpServer httpServer = com.sun.net.httpserver.HttpServer.create(new InetSocketAddress(n2), 0);
        httpServer.createContext("/", new FileDownloadHandler(this.baseDir));
        httpServer.setExecutor(null);
        httpServer.start();
        this.info("HttpServer listening on port " + n2 + " ...");
    }

    private File getPropFileName() {
        String string = "swupdater.properties";
        if (this.baseDir != null && this.baseDir.length() > 0) {
            string = this.baseDir + "/" + string;
        }
        return new File(string);
    }

    private synchronized Properties getServerProps() {
        File file = this.getPropFileName();
        if (file.lastModified() > this.serverPropsLastLoad) {
            this.loadServerProps();
        }
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)this.serverProps);
        return properties;
    }

    private void loadServerProps() {
        this.serverProps = new Properties();
        try {
            File file = this.getPropFileName();
            RtsUtil.loadProperties(this.serverProps, file);
            String string = "swupdater.zipfile.";
            Enumeration<?> enumeration = this.serverProps.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                this.serverProps.setProperty("swupdater.lib." + string2.substring(string.length()), this.serverProps.getProperty(string2));
                this.serverProps.remove(string2);
            }
            this.serverPropsLastLoad = file.lastModified();
        }
        catch (IOException iOException) {
            this.error("error reading 'swupdater.properties' file");
        }
    }

    private void info(String string) {
        if (this.log != null) {
            this.log.info(string);
        }
        System.out.println(string);
    }

    private void error(String string) {
        if (this.log != null) {
            this.log.warning(string);
        }
        System.err.println(string);
    }

    @Override
    public void setLogger(Logger logger) {
        this.log = logger;
    }

    public static void main(String[] stringArray) throws Exception {
        int n2 = 10996;
        if (stringArray.length > 0) {
            try {
                n2 = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        String string = "";
        if (stringArray.length > 1) {
            string = stringArray[1];
        }
        new HttpServer().start(n2, string);
    }

    private class FileDownloadHandler
    implements HttpHandler {
        private final String baseDir;

        FileDownloadHandler(String string) {
            this.baseDir = string;
        }

        void addZipEntry(File file, String string, ZipOutputStream zipOutputStream, FilenameFilter filenameFilter) throws IOException {
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                if (fileArray.length > 0) {
                    for (File file2 : file.listFiles()) {
                        this.addZipEntry(file2, string + "/" + file2.getName(), zipOutputStream, filenameFilter);
                    }
                } else if (filenameFilter == null || filenameFilter.accept(null, string)) {
                    ZipEntry zipEntry = new ZipEntry(string + "/");
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.closeEntry();
                }
            } else if (filenameFilter == null || filenameFilter.accept(null, string)) {
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = new byte[fileInputStream.available()];
                fileInputStream.read(byArray);
                fileInputStream.close();
                zipOutputStream.write(byArray);
                zipOutputStream.closeEntry();
            }
        }

        @Override
        public void handle(final HttpExchange httpExchange) throws IOException {
            new Thread(){

                @Override
                public void run() {
                    try {
                        FileDownloadHandler.this.handleRequest(httpExchange);
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleRequest(HttpExchange httpExchange) throws IOException {
            Object object;
            String string = httpExchange.getRequestURI().getPath();
            if (string == null || string.isEmpty()) {
                HttpServer.sendResponse(httpExchange, 400, "No file specified");
                HttpServer.this.error("No file specified");
                return;
            }
            if (string.startsWith("/")) {
                string = string.substring(1);
            }
            Properties properties = HttpServer.this.getServerProps();
            String string2 = null;
            if (!string.equals("swupdater.properties")) {
                object = string;
                if ((string = properties.getProperty(string)) == null || string.isEmpty()) {
                    HttpServer.sendResponse(httpExchange, 404, "Not found: " + (String)object + "");
                    HttpServer.this.error("Not found: " + (String)object);
                    return;
                }
                string2 = ((String)object).substring(((String)object).lastIndexOf(46) + 1);
            }
            if (!((File)(object = new File(string))).isAbsolute() && this.baseDir != null && this.baseDir.length() > 0) {
                string = this.baseDir + "/" + string;
                object = new File(string);
            }
            if (!((File)object).exists()) {
                HttpServer.sendResponse(httpExchange, 404, "Not found: " + string + "");
                HttpServer.this.error("Not found: " + string);
                return;
            }
            OutputStream outputStream = httpExchange.getResponseBody();
            if (((File)object).isFile()) {
                if (((File)object).getName().equals("swupdater.properties")) {
                    httpExchange.sendResponseHeaders(200, 0L);
                    Properties properties2 = new Properties();
                    Enumeration<?> enumeration = properties.propertyNames();
                    while (enumeration.hasMoreElements()) {
                        String string3 = (String)enumeration.nextElement();
                        if (string3.startsWith("swupdater.lib.")) {
                            properties2.setProperty(string3, "");
                            continue;
                        }
                        properties2.setProperty(string3, properties.getProperty(string3));
                    }
                    properties2.store(outputStream, null);
                } else {
                    FileInputStream fileInputStream = null;
                    byte[] byArray = new byte[4096];
                    long l2 = ((File)object).length();
                    httpExchange.sendResponseHeaders(200, l2);
                    try {
                        fileInputStream = new FileInputStream((File)object);
                    }
                    catch (IOException iOException) {
                        HttpServer.sendResponse(httpExchange, 500, "Error reading file: " + string + "");
                        HttpServer.this.error("Error reading file: " + string);
                        return;
                    }
                    try {
                        int n2;
                        while ((n2 = fileInputStream.read(byArray)) != -1) {
                            outputStream.write(byArray, 0, n2);
                        }
                    }
                    catch (IOException iOException) {
                        HttpServer.sendResponse(httpExchange, 500, "Error writing file: " + string + "");
                        HttpServer.this.error("Error writing file: " + string);
                    }
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            } else {
                httpExchange.sendResponseHeaders(200, 0L);
                ZipOutputStream zipOutputStream = null;
                try {
                    String string4;
                    zipOutputStream = new ZipOutputStream(outputStream);
                    FilenameFilter filenameFilter = null;
                    String string5 = properties.getProperty("swupdater.exclude_items_list." + string2);
                    int n3 = "0".equals(string5) ? 0 : ("1".equals(string5) ? 1 : -1);
                    if (n3 >= 0 && (string4 = properties.getProperty("swupdater.items_list." + string2)) != null) {
                        Object[] objectArray = string4.split("\\,");
                        String[] stringArray = new String[objectArray.length];
                        int n4 = OSValidator.isWindows() ? 1 : 0;
                        for (int i2 = 0; i2 < objectArray.length; ++i2) {
                            String string6 = ((String)objectArray[i2]).trim();
                            if (n4) {
                                string6 = string6.toLowerCase();
                            }
                            StringBuilder stringBuilder = new StringBuilder();
                            StringBuilder stringBuilder2 = new StringBuilder();
                            block25: for (char c2 : string6.toCharArray()) {
                                switch (c2) {
                                    case '*': {
                                        if (stringBuilder2.length() > 0) {
                                            stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
                                        }
                                        stringBuilder.append(".*");
                                        stringBuilder2 = new StringBuilder();
                                        continue block25;
                                    }
                                    default: {
                                        stringBuilder2.append(c2);
                                    }
                                }
                            }
                            if (stringBuilder2.length() > 0) {
                                stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
                            }
                            stringArray[i2] = stringBuilder.toString();
                        }
                        filenameFilter = new FilenameFilter(n4 != 0, n3, stringArray){
                            final /* synthetic */ boolean val$caseInsensitive;
                            final /* synthetic */ int val$exclValue;
                            final /* synthetic */ String[] val$regex;
                            {
                                this.val$caseInsensitive = bl;
                                this.val$exclValue = n2;
                                this.val$regex = stringArray;
                            }

                            @Override
                            public boolean accept(File file, String string) {
                                if (this.val$caseInsensitive) {
                                    string = string.toLowerCase();
                                }
                                if (this.val$exclValue == 0) {
                                    for (String string2 : this.val$regex) {
                                        if (!string.matches(string2)) continue;
                                        return true;
                                    }
                                    return false;
                                }
                                for (String string3 : this.val$regex) {
                                    if (!string.matches(string3)) continue;
                                    return false;
                                }
                                return true;
                            }
                        };
                    }
                    for (File file : ((File)object).listFiles()) {
                        this.addZipEntry(file, file.getName(), zipOutputStream, filenameFilter);
                    }
                    zipOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                    HttpServer.sendResponse(httpExchange, 500, "Error writing file: " + string + "");
                    HttpServer.this.error("Error writing file: " + string);
                }
                finally {
                    if (zipOutputStream != null) {
                        try {
                            zipOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }
}

