/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.XMLStreamConstants;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

abstract class AbstractXml2Wrk {
    protected static final String eol = System.getProperty("line.separator", "\n");
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected Set<String> allCobolNames = new HashSet<String>();
    protected Map<QName, Type> allTypes = new LinkedHashMap<QName, Type>();
    protected final String uri;
    protected String headerString;
    protected String targetNamespace;

    AbstractXml2Wrk(String string) {
        this.uri = string;
    }

    protected abstract String getPrefix();

    protected boolean isGenerateEnum() {
        return false;
    }

    protected boolean isGenerateCount() {
        return false;
    }

    protected boolean isGenerateComments() {
        return true;
    }

    protected int getFixedLength() {
        return -1;
    }

    protected String getDataSuffix() {
        return "-data";
    }

    protected String getAttributeSuffix() {
        return "-attr";
    }

    protected String getEnumSuffix() {
        return "-enum";
    }

    protected String getCapacitySuffix() {
        return "-cap";
    }

    protected String getCountSuffix() {
        return "-count";
    }

    protected boolean isIgnoreUnbound() {
        return false;
    }

    protected boolean isDisambiguate() {
        return false;
    }

    protected abstract boolean mustAddGroupNames();

    protected String buildDataName(String string) {
        return this.getCobolName(string + this.getDataSuffix());
    }

    protected String buildCapacityName(String string) {
        return this.getCobolName(string + this.getCapacitySuffix());
    }

    protected String buildAttrName(String string) {
        return this.getCobolName(string + this.getAttributeSuffix());
    }

    protected String buildEnumName(String string, int n2) {
        return this.getCobolName(string + this.getEnumSuffix() + "-" + n2);
    }

    protected String getCobolName(String string) {
        String string2 = this.getPrefix() + string;
        if (this.isDisambiguate()) {
            String string3 = string2;
            int n2 = 1;
            while (this.allCobolNames.contains(string3)) {
                string3 = string2 + "-" + n2++;
            }
            string2 = string3;
            this.allCobolNames.add(string2);
        }
        return string2;
    }

    protected void scanComplexType(Element element, Type type) throws SAXException {
        if (type == null) {
            type = this.getType(element);
        }
        this.scanAttribute(element.getLocalName(), element, type.attrNames);
        ElementIterator elementIterator = new ElementIterator(element);
        Element element2 = elementIterator.next();
        while (element2 != null) {
            Element element3;
            ElementIterator elementIterator2;
            if ("sequence".equals(element2.getLocalName())) {
                elementIterator2 = new ElementIterator(element2);
                element3 = elementIterator2.next();
                while (element3 != null) {
                    Object object;
                    if ("element".equals(element3.getLocalName())) {
                        object = this.scanElement(element3, true);
                        if (object != null) {
                            type.components.put(((Type)object).name, (Type)object);
                        }
                    } else if ("choice".equals(element3.getLocalName())) {
                        object = new ElementIterator(element3);
                        Element element4 = ((ElementIterator)object).next();
                        while (element4 != null) {
                            Type type2;
                            if ("element".equals(element4.getLocalName()) && (type2 = this.scanElement(element4, true)) != null) {
                                type.components.put(type2.name, type2);
                            }
                            element4 = ((ElementIterator)object).next();
                        }
                    }
                    element3 = elementIterator2.next();
                }
            } else if ("complexContent".equals(element2.getLocalName())) {
                elementIterator2 = new ElementIterator(element2);
                element3 = elementIterator2.next();
                while (element3 != null) {
                    if ("extension".equals(element3.getLocalName())) {
                        this.scanExtension(element3, type);
                    } else if ("restriction".equals(element3.getLocalName())) {
                        this.scanRestriction(element3, type);
                    }
                    element3 = elementIterator2.next();
                }
            }
            element2 = elementIterator.next();
        }
    }

    protected void scanExtension(Element element, Type type) throws SAXException {
        QName qName = this.getAttribute(element, "base");
        if (qName == null) {
            throw new SAXException("extension base not found: '" + AbstractXml2Wrk.nodeToString(element) + "'");
        }
        Type type2 = this.allTypes.get(qName);
        if (type2 == null) {
            type2 = new Type(qName, this.isElementFormQualified());
            this.allTypes.put(type2.name, type2);
        }
        type.extension = type2;
        ElementIterator elementIterator = new ElementIterator(element);
        Element element2 = elementIterator.next();
        while (element2 != null) {
            if ("sequence".equals(element2.getLocalName())) {
                ElementIterator elementIterator2 = new ElementIterator(element2);
                Element element3 = elementIterator2.next();
                while (element3 != null) {
                    Type type3;
                    if ("element".equals(element3.getLocalName()) && (type3 = this.scanElement(element3, true)) != null) {
                        type.components.put(type3.name, type3);
                    }
                    element3 = elementIterator2.next();
                }
            }
            element2 = elementIterator.next();
        }
    }

    protected Type scanElement(Element element, boolean bl) throws SAXException {
        Type type;
        QName qName = this.getAttribute(element, "ref");
        if (qName != null) {
            type = this.allTypes.get(qName);
            if (type == null) {
                type = new Type(qName, this.isElementFormQualified());
                this.allTypes.put(qName, type);
            }
        } else {
            QName qName2 = this.getAttribute(element, "name");
            if (qName2 == null) {
                String string = "Type name not found: '" + AbstractXml2Wrk.nodeToString(element) + "'";
                if (bl) {
                    this.warning(string);
                    return null;
                }
                throw new SAXException(string);
            }
            QName qName3 = this.getAttribute(element, "type");
            if (qName3 != null) {
                type = new Type(qName2, this.isElementFormQualified());
                if (AbstractXml2Wrk.isSimpleType(qName3)) {
                    type.simpleType = qName3;
                } else {
                    Type type2 = this.allTypes.get(qName3);
                    if (type2 == null) {
                        type2 = new Type(qName3, this.isElementFormQualified());
                        this.allTypes.put(type2.name, type2);
                    }
                    type.refType = type2;
                }
            } else {
                type = this.allTypes.get(qName2);
                if (type == null) {
                    type = new Type(qName2, this.isElementFormQualified());
                    this.allTypes.put(type.name, type);
                }
                ElementIterator elementIterator = new ElementIterator(element);
                Element element2 = elementIterator.next();
                while (element2 != null) {
                    if ("complexType".equals(element2.getLocalName())) {
                        this.scanComplexType(element2, type);
                    } else if ("simpleType".equals(element2.getLocalName())) {
                        this.scanSimpleType(element2, type);
                    }
                    element2 = elementIterator.next();
                }
            }
        }
        if (type.minOccurs == null) {
            type.minOccurs = element.getAttribute("minOccurs");
        }
        if (type.maxOccurs == null) {
            type.maxOccurs = element.getAttribute("maxOccurs");
            if (this.isIgnoreUnbound() && "unbounded".equals(type.maxOccurs)) {
                type.maxOccurs = null;
            }
        }
        return type;
    }

    protected void scanSimpleType(Element element, Type type) throws SAXException {
        if (type == null) {
            type = this.getType(element);
        }
        ElementIterator elementIterator = new ElementIterator(element);
        Element element2 = elementIterator.next();
        while (element2 != null) {
            if ("restriction".equals(element2.getLocalName())) {
                this.scanRestriction(element2, type);
                break;
            }
            element2 = elementIterator.next();
        }
    }

    private void scanRestriction(Element element, Type type) throws SAXException {
        QName qName = this.getAttribute(element, "base");
        if (qName == null) {
            throw new SAXException("restriction base not found: '" + AbstractXml2Wrk.nodeToString(element) + "'");
        }
        this.scanRestrictionBase(element, qName, type);
    }

    protected void scanRestrictionBase(Element element, QName qName, Type type) throws SAXException {
        ElementIterator elementIterator = new ElementIterator(element);
        if (AbstractXml2Wrk.isSimpleType(qName)) {
            type.simpleType = qName;
            Element element2 = elementIterator.next();
            while (element2 != null) {
                this.scanRestrictionSubElement(element2, type);
                element2 = elementIterator.next();
            }
        } else {
            Type type2 = this.allTypes.get(qName);
            while (type2 != null && !AbstractXml2Wrk.isSimpleType(qName = type2.name)) {
                type2 = type2.restriction;
            }
            if (type2 != null) {
                type.simpleType = type2.name;
                Element element3 = elementIterator.next();
                while (element3 != null) {
                    this.scanRestrictionSubElement(element3, type);
                    element3 = elementIterator.next();
                }
            } else {
                type2 = new Type(qName, this.isElementFormQualified());
                Element element4 = elementIterator.next();
                while (element4 != null) {
                    if ("sequence".equals(element4.getLocalName()) || "all".equals(element4.getLocalName())) {
                        ElementIterator elementIterator2 = new ElementIterator(element4);
                        Element element5 = elementIterator2.next();
                        while (element5 != null) {
                            Type type3;
                            if ("element".equals(element5.getLocalName()) && (type3 = this.scanElement(element5, true)) != null) {
                                type.components.put(type3.name, type3);
                            }
                            element5 = elementIterator2.next();
                        }
                    } else {
                        this.scanRestrictionSubElement(element4, type);
                    }
                    element4 = elementIterator.next();
                }
                this.allTypes.put(type2.name, type2);
                type.restriction = type2;
            }
        }
    }

    protected void scanRestrictionSubElement(Element element, Type type) {
        QName qName;
        if ("maxLength".equals(element.getLocalName())) {
            QName qName2 = this.getAttribute(element, "value");
            if (qName2 != null) {
                type.length = Integer.parseInt(qName2.name);
            }
        } else if ("enumeration".equals(element.getLocalName()) && (qName = this.getAttribute(element, "value")) != null) {
            if (type.enumeration == null) {
                type.enumeration = new LinkedHashSet();
            }
            type.enumeration.add(qName.name);
        }
    }

    protected static boolean isSimpleType(QName qName) {
        return "http://www.w3.org/2001/XMLSchema".equals(qName.ns) && XMLStreamConstants.isSimpleType(qName.name);
    }

    protected Type getType(Element element) throws SAXException {
        return this.getType(element, "name");
    }

    protected Type getType(Element element, String string) throws SAXException {
        QName qName = this.getAttribute(element, string);
        if (qName == null) {
            return null;
        }
        Type type = this.allTypes.get(qName);
        if (type == null) {
            type = new Type(qName, this.isElementFormQualified());
            this.allTypes.put(type.name, type);
        }
        if (type.minOccurs == null) {
            type.minOccurs = element.getAttribute("minOccurs");
        }
        if (type.maxOccurs == null) {
            type.maxOccurs = element.getAttribute("maxOccurs");
            if (this.isIgnoreUnbound() && "unbounded".equals(type.maxOccurs)) {
                type.maxOccurs = null;
            }
        }
        return type;
    }

    protected QName getAttribute(Element element, String string) {
        return this.getAttribute(element, string, null);
    }

    protected QName getAttribute(Element element, String string, String string2) {
        String string3 = string2 != null ? element.getAttributeNS(string2, string) : element.getAttribute(string);
        if (string3.length() > 0) {
            QName qName = new QName();
            int n2 = string3.indexOf(58);
            if (n2 >= 0) {
                qName.name = string3.substring(n2 + 1);
                String string4 = string3.substring(0, n2);
                qName.ns = this.namespaces.get(string4);
                if (qName.ns == null) {
                    NamedNodeMap namedNodeMap = element.getAttributes();
                    for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                        Attr attr;
                        if (!(namedNodeMap.item(i2) instanceof Attr) || !(attr = (Attr)namedNodeMap.item(i2)).getName().startsWith("xmlns:") || !attr.getName().substring(6).equals(string4)) continue;
                        qName.ns = attr.getValue();
                        break;
                    }
                }
            } else {
                qName.name = string3;
                qName.ns = this.getTargetNamespace();
            }
            return qName;
        }
        return null;
    }

    protected final String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected void scanAttribute(String string, Element element, Map<String, QName> map) throws SAXException {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(element);
        while ((element2 = elementIterator.next()) != null) {
            if (!"attribute".equals(element2.getLocalName())) continue;
            QName qName = this.getAttribute(element2, "name");
            QName qName2 = this.getAttribute(element2, "type");
            if (qName == null || qName2 == null) continue;
            map.put(qName.name, qName2);
        }
    }

    static String nodeToString(Node node) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<");
        if (node instanceof Element) {
            Element element = (Element)node;
            stringBuilder.append(element.getTagName());
            NamedNodeMap namedNodeMap = element.getAttributes();
            for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
                Attr attr = (Attr)namedNodeMap.item(i2);
                stringBuilder.append(" ");
                stringBuilder.append(attr.getName());
                stringBuilder.append("=\"");
                stringBuilder.append(attr.getValue());
                stringBuilder.append("\"");
            }
        } else {
            stringBuilder.append(node.getNodeName());
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String string) {
        this.headerString = string;
    }

    protected abstract void getQualifiedName(Type var1, boolean var2, String var3, StringBuilder var4);

    protected final void getCode(Type type, int n2, String string, StringBuilder stringBuilder, Vector<Type> vector) {
        int n3;
        if (this.isGenerateComments() && "0".equals(type.minOccurs)) {
            AbstractXml2Wrk.getSpaces(n2, stringBuilder);
            stringBuilder.append("*> optional");
            stringBuilder.append(eol);
        }
        AbstractXml2Wrk.putLevel(stringBuilder, n2);
        String string2 = null;
        String string3 = type.name.name;
        if (this.mustAddGroupNames()) {
            stringBuilder.append(" ");
            string2 = this.getCobolName(string3);
            stringBuilder.append(string2);
        }
        stringBuilder.append(" identified by ");
        this.getQualifiedName(type, vector.isEmpty(), string, stringBuilder);
        if ("unbounded".equals(type.maxOccurs)) {
            stringBuilder.append(" occurs dynamic capacity " + this.buildCapacityName(string3));
        } else {
            n3 = 1;
            try {
                n3 = Integer.parseInt(type.maxOccurs);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n3 > 1) {
                stringBuilder.append(" occurs ");
                stringBuilder.append(n3);
            }
        }
        if (type.refType != null) {
            type = type.refType;
        } else if (type.restriction != null) {
            type = type.restriction;
        }
        if (type.simpleType != null && ("base64Binary".equals(type.simpleType.name) || "hexBinary".equals(type.simpleType.name))) {
            stringBuilder.append(" ");
            stringBuilder.append(type.simpleType.name);
        }
        if (this.mustAddGroupNames() && this.isGenerateCount()) {
            stringBuilder.append(" count in ");
            stringBuilder.append(string2 + this.getCountSuffix());
        }
        stringBuilder.append(".");
        stringBuilder.append(eol);
        if (this.isGenerateEnum() && type.enumeration != null) {
            this.getCodeEnum(type.enumeration, string3, n2 + 2, stringBuilder);
        }
        this.getCodeAttrs(type, n2 + 2, stringBuilder);
        n3 = 0;
        if (type.simpleType != null) {
            string2 = this.buildDataName(string3);
            this.getCodeSimpleType(n2 + 2, string2, this.getPicture(type.simpleType.name, type.length), stringBuilder);
            n3 = 1;
        } else if (!(vector.contains(type) || type.extension == null && type.components.isEmpty())) {
            Type type2 = type.extension;
            if (type2 != null) {
                n3 = this.getCodeExtension(type2, n2 + 2, type.name.ns, stringBuilder, vector) ? 1 : 0;
            }
            n3 = n3 != 0 || !type.components.isEmpty() ? 1 : 0;
            for (Type type3 : type.components.values()) {
                this.getCode(type3, n2 + 2, type.name.ns, stringBuilder, AbstractXml2Wrk.newStack(vector, type));
            }
        }
        if (n3 == 0) {
            string2 = this.buildDataName(string3);
            this.getCodeSimpleType(n2 + 2, string2, this.getPicture("", 0), stringBuilder);
        }
    }

    private static Vector<Type> newStack(Vector<Type> vector, Type type) {
        Vector<Type> vector2 = new Vector<Type>(vector);
        vector2.addElement(type);
        return vector2;
    }

    protected void getCodeAttrs(Type type, int n2, StringBuilder stringBuilder) {
        for (String string : type.attrNames.keySet()) {
            AbstractXml2Wrk.putLevel(stringBuilder, n2);
            String string2 = this.buildAttrName(string);
            stringBuilder.append(" " + string2);
            stringBuilder.append(" identified by '");
            stringBuilder.append(string);
            stringBuilder.append("' is attribute pic ");
            stringBuilder.append(this.getPicture(type.attrNames.get((Object)string).name, 0));
            if (this.isGenerateCount()) {
                stringBuilder.append(" count in ");
                stringBuilder.append(string2 + this.getCountSuffix());
            }
            stringBuilder.append(".");
            stringBuilder.append(eol);
        }
    }

    protected void getCodeEnum(Set<String> set, String string, int n2, StringBuilder stringBuilder) {
        int n3 = 0;
        for (String string2 : set) {
            AbstractXml2Wrk.getSpaces((n2 - 1) / 2 * 3, stringBuilder);
            stringBuilder.append("88 " + this.buildEnumName(string, n3));
            stringBuilder.append(" value '");
            stringBuilder.append(string2);
            stringBuilder.append("'.");
            stringBuilder.append(eol);
            ++n3;
        }
    }

    private boolean getCodeExtension(Type type, int n2, String string, StringBuilder stringBuilder, Vector<Type> vector) {
        boolean bl = false;
        if (type.extension != null) {
            bl = this.getCodeExtension(type.extension, n2, string, stringBuilder, vector);
        }
        if (type.refType != null) {
            type = type.refType;
        }
        this.getCodeAttrs(type, n2, stringBuilder);
        bl = bl || !type.components.isEmpty();
        for (Type type2 : type.components.values()) {
            this.getCode(type2, n2, string, stringBuilder, AbstractXml2Wrk.newStack(vector, type));
        }
        return bl;
    }

    private String getPicture(String string, int n2) {
        String string2 = XMLStreamConstants.xsdSimpleTypes.get(string);
        if (string2 == "I8") {
            return "x(1)";
        }
        if (string2 == "I16") {
            return "s9(5)";
        }
        if (string2 == "I32") {
            return "s9(10)";
        }
        if (string2 == "I64") {
            return "s9(18)";
        }
        if (string2 == "F") {
            return "s9(8)v99";
        }
        if (string2 == "D") {
            return "s9(16)v99";
        }
        int n3 = this.getFixedLength();
        if (n3 >= 0) {
            if (n3 == 0) {
                n3 = 80;
            }
            return "x(" + (n2 > 0 ? n2 : n3) + ")";
        }
        return "x any length";
    }

    private void getCodeSimpleType(int n2, String string, String string2, StringBuilder stringBuilder) {
        AbstractXml2Wrk.putLevel(stringBuilder, n2);
        stringBuilder.append(" ");
        stringBuilder.append(string);
        if (this.isGenerateCount()) {
            stringBuilder.append(" count in ");
            stringBuilder.append(string + this.getCountSuffix());
        }
        stringBuilder.append(" pic ");
        stringBuilder.append(string2);
        stringBuilder.append(".");
        stringBuilder.append(eol);
    }

    protected void addNamespaces(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i2 = 0; i2 < namedNodeMap.getLength(); ++i2) {
            Attr attr;
            if (!(namedNodeMap.item(i2) instanceof Attr) || !(attr = (Attr)namedNodeMap.item(i2)).getName().startsWith("xmlns:")) continue;
            this.namespaces.put(attr.getName().substring(6), attr.getValue());
        }
    }

    protected abstract boolean isElementFormQualified();

    static void putLevel(StringBuilder stringBuilder, int n2) {
        AbstractXml2Wrk.getSpaces((n2 - 1) / 2 * 3, stringBuilder);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
    }

    static void getSpaces(int n2, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
    }

    protected void warning(String string) {
        System.err.println("Warning: " + string);
    }
}

