/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SAJParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class Json2Wrk {
    private static final String eol = System.getProperty("line.separator", "\n");
    private String uri;
    private String prefix;
    private boolean disambiguate;
    private boolean escapeAnyCharacter;
    private String rootName;
    private Set<String> allCobolNames = new HashSet<String>();
    private Map<String, int[]> numericLengths = new HashMap<String, int[]>();
    private String headerString;

    public Json2Wrk(String string, String string2, boolean bl, String string3, boolean bl2) {
        this.uri = string;
        this.prefix = string2;
        if (this.prefix == null || "0".equals(this.prefix)) {
            this.prefix = "";
        }
        this.disambiguate = bl;
        this.rootName = string3;
        this.escapeAnyCharacter = bl2;
    }

    private int[] getNumericLength(Type type) {
        String string = type.name;
        Object object = type.par;
        while (object != null) {
            string = ((Type)object).name + "." + string;
            object = ((Type)object).par;
        }
        object = this.numericLengths.get(string);
        if (object == null) {
            object = new int[2];
            this.numericLengths.put(string, (int[])object);
        }
        return object;
    }

    private String getDefaultPrefix(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string.replace('.', '_').replace(' ', '_');
    }

    /*
     * Unable to fully structure code
     */
    public String generateCopyFile() throws IOException, SAXException {
        block7: {
            block6: {
                try {
                    var2_1 = new URL(this.uri);
                    var1_3 = var2_1.openStream();
                    if ("1".equals(this.prefix)) {
                        this.prefix = this.getDefaultPrefix(new File(var2_1.getPath()).getName());
                    }
                }
                catch (MalformedURLException var2_2) {
                    var1_3 = new FileInputStream(this.uri);
                    if (!"1".equals(this.prefix)) break block6;
                    this.prefix = this.getDefaultPrefix(new File(this.uri).getName());
                }
            }
            var2_1 = new Type[1];
            var3_4 = new SAJParser(this.escapeAnyCharacter, true);
            var3_4.parse(new InputStreamReader(var1_3), new SAJParser.Handler(){
                Stack<Type> stack = new Stack();
                String prevName;

                @Override
                public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                    Type type = new Type(string2);
                    if (this.stack.isEmpty()) {
                        var2_1[0] = type;
                        var2_1[0].name = Json2Wrk.this.rootName != null ? Json2Wrk.this.rootName : "json2wrk";
                    } else {
                        Type type2 = this.stack.peek();
                        Type type3 = type2.components.get(string2);
                        if (type3 != null) {
                            type = type3;
                            if (string2.equals(this.prevName)) {
                                type.occurs = true;
                            }
                        } else {
                            type.par = type2;
                            type2.components.put(string2, type);
                        }
                        if ("array".equals(string)) {
                            type.occurs = true;
                        }
                    }
                    this.stack.push(type);
                }

                @Override
                public void endElement(String string, String string2, String string3) throws SAXException {
                    this.stack.pop();
                    this.prevName = string2;
                }

                @Override
                public void characters(char[] cArray, int n2, int n3, SAJParser.ElementType elementType) throws SAXException {
                    if (!this.stack.isEmpty()) {
                        Type type = this.stack.peek();
                        type.et = elementType;
                        if (elementType == SAJParser.ElementType.NUMERIC) {
                            int n4;
                            int n5;
                            String string = new String(cArray, n2, n3);
                            int n6 = string.indexOf(46);
                            if (n6 >= 0) {
                                n5 = n6;
                                n4 = n3 - 1 - n6;
                            } else {
                                n5 = n3;
                                n4 = 0;
                            }
                            int[] nArray = Json2Wrk.this.getNumericLength(type);
                            nArray[0] = Math.max(nArray[0], n5);
                            nArray[1] = Math.max(nArray[1], n4);
                        }
                    }
                }
            }, this.uri);
            var1_3.close();
            var4_5 = new StringBuilder();
            Json2Wrk.getSpaces(12, var4_5);
            var4_5.append(">>SOURCE FORMAT FREE");
            var4_5.append(Json2Wrk.eol);
            if (this.headerString != null) {
                var4_5.append(RtsUtil.getCopyHeader("JSON", this.uri, this.headerString));
            }
            if (var2_1[0] == null) break block7;
            if (var2_1[0].components.size() != 1) ** GOTO lbl-1000
            var5_6 = var2_1[0].components.values().iterator().next();
            if (!var5_6.occurs) {
                this.getCode(var5_6, 1, var4_5);
            } else lbl-1000:
            // 2 sources

            {
                this.getCode(var2_1[0], 1, var4_5);
            }
        }
        var4_5.append(Json2Wrk.eol);
        Json2Wrk.getSpaces(12, var4_5);
        var4_5.append(">>SOURCE FORMAT PREVIOUS");
        var4_5.append(Json2Wrk.eol);
        return var4_5.toString();
    }

    private void putLevel(int n2, StringBuilder stringBuilder) {
        Json2Wrk.getSpaces(3 * ((n2 - 1) / 2), stringBuilder);
        if (n2 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n2);
        stringBuilder.append(' ');
    }

    private String getCobolName(String string) {
        String string2 = this.prefix + string.replace(' ', '_');
        if (this.disambiguate) {
            String string3 = string2;
            int n2 = 0;
            while (this.allCobolNames.contains(string3)) {
                string3 = string2 + "-" + n2++;
            }
            string2 = string3;
            this.allCobolNames.add(string2);
        }
        return string2;
    }

    private void getCode(Type type, int n2, StringBuilder stringBuilder) {
        this.putLevel(n2, stringBuilder);
        String string = this.getCobolName(type.name);
        stringBuilder.append(string);
        stringBuilder.append(" identified by '");
        if (!type.dummyRoot) {
            stringBuilder.append(type.name);
        }
        stringBuilder.append("'");
        if (type.components.isEmpty() && type.et == SAJParser.ElementType.BOOLEAN) {
            stringBuilder.append(" is boolean");
        }
        if (type.occurs) {
            stringBuilder.append(" occurs dynamic capacity " + this.getCobolName(type.name + "-count"));
        }
        stringBuilder.append(".");
        stringBuilder.append(eol);
        if (type.components.isEmpty()) {
            this.putLevel(n2 + 2, stringBuilder);
            stringBuilder.append(string);
            stringBuilder.append("-data pic ");
            switch (type.et) {
                default: {
                    stringBuilder.append("x any length.");
                    break;
                }
                case NUMERIC: {
                    stringBuilder.append("9(");
                    int[] nArray = this.getNumericLength(type);
                    stringBuilder.append(nArray[0]);
                    stringBuilder.append(")");
                    if (nArray[1] > 0) {
                        stringBuilder.append("v9(");
                        stringBuilder.append(nArray[1]);
                        stringBuilder.append(")");
                    }
                    stringBuilder.append(".");
                    break;
                }
                case BOOLEAN: {
                    stringBuilder.append("9.");
                }
            }
            stringBuilder.append(eol);
        } else {
            for (Type type2 : type.components.values()) {
                this.getCode(type2, n2 + 2, stringBuilder);
            }
        }
    }

    private static StringBuilder getSpaces(int n2, StringBuilder stringBuilder) {
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append(' ');
        }
        return stringBuilder;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String string) {
        this.headerString = string;
    }

    private static class Type {
        Type par;
        String name;
        boolean occurs;
        boolean dummyRoot;
        SAJParser.ElementType et;
        Map<String, Type> components = new LinkedHashMap<String, Type>();

        Type(String string) {
            this.name = string;
        }
    }
}

