/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.RuntimeProperties;
import com.iscobol.rts.XMLStreamConstants;
import com.iscobol.utility.AbstractXml2Wrk;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class WSDL2Wrk
extends AbstractXml2Wrk {
    private static final String SOAP_ENVELOPE_START = " 01 soap-";
    private static final String SOAP_NS_PFX = "soapenv";
    private static final String[] SOAP_ENVELOPE_NS = new String[]{"http://schemas.xmlsoap.org/soap/envelope/", "http://www.w3.org/2003/05/soap-envelope"};
    public static final int V1_1 = 0;
    public static final int V1_2 = 1;
    public static final String NS_WSDL = "http://schemas.xmlsoap.org/wsdl/";
    public static final String NS_SOAPENC = "http://schemas.xmlsoap.org/soap/encoding/";
    public static final String NS_SOAPHTTP = "http://schemas.xmlsoap.org/soap/http";
    private static final Map<String, String> soapTypes = new HashMap<String, String>();
    private boolean elementFormQualified;
    private final List<Message> messages = new ArrayList<Message>();
    private final List<PortType> portTypes = new ArrayList<PortType>();
    private final List<Binding> bindings = new ArrayList<Binding>();
    private final int version;
    private Set<String> wsdlImports = new HashSet<String>();
    private Map<String, String> nsPrefixes;
    private boolean encoded;
    public static final String usage;

    public WSDL2Wrk(String string, int n2) {
        super(string);
        this.version = n2;
    }

    public Map<String, StringBuilder> generateCopyfiles() throws ParserConfigurationException, IOException, SAXException {
        return this.generateCopyfiles(WSDL2Wrk.openXml(this.uri));
    }

    private static Element openXml(String string) throws IOException, SAXException, ParserConfigurationException {
        InputStream inputStream;
        Object object;
        DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        try {
            object = new URL(string);
            inputStream = ((URL)object).openStream();
        }
        catch (MalformedURLException malformedURLException) {
            inputStream = new FileInputStream(string);
        }
        object = documentBuilder.parse(inputStream);
        inputStream.close();
        object.getDocumentElement().normalize();
        return object.getDocumentElement();
    }

    public int getVersion() {
        return this.version;
    }

    public String getURI() {
        return this.uri;
    }

    private void scanTypesSchema(Element element) throws SAXException {
        if (element.hasChildNodes()) {
            Map map = this.namespaces;
            String string = this.targetNamespace;
            boolean bl = this.elementFormQualified;
            this.namespaces = new HashMap(this.namespaces);
            this.targetNamespace = element.getAttribute("targetNamespace");
            this.addNamespaces(element);
            this.elementFormQualified = "qualified".equals(element.getAttribute("elementFormDefault"));
            ElementIterator elementIterator = new ElementIterator(element);
            Element element2 = elementIterator.next();
            while (element2 != null) {
                if ("import".equals(element2.getLocalName())) {
                    String string2 = element2.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                    if (string2.length() > 0 || (string2 = element2.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")).length() > 0) {
                        try {
                            Object object;
                            File file = new File(string2);
                            if (!file.isAbsolute() && ((File)(object = new File(this.uri))).isFile() && ((File)object).getParent() != null) {
                                string2 = ((File)object).getParent() + File.separator + string2;
                            }
                            if ("schema".equalsIgnoreCase((object = WSDL2Wrk.openXml(string2)).getLocalName())) {
                                this.scanTypesSchema((Element)object);
                            }
                        }
                        catch (ParserConfigurationException parserConfigurationException) {
                            this.warning(parserConfigurationException.getMessage());
                        }
                        catch (IOException iOException) {
                            this.warning(iOException.getMessage());
                        }
                    }
                } else if ("element".equals(element2.getLocalName())) {
                    this.scanElement(element2, false);
                } else if ("complexType".equals(element2.getLocalName())) {
                    this.scanComplexType(element2, null);
                } else if ("simpleType".equals(element2.getLocalName())) {
                    this.scanSimpleType(element2, null);
                }
                element2 = elementIterator.next();
            }
            this.targetNamespace = string;
            this.namespaces = map;
            this.elementFormQualified = bl;
        }
    }

    private void scanTypes(Element element) throws SAXException {
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string = element2.getLocalName();
                if (!"schema".equalsIgnoreCase(string)) continue;
                this.scanTypesSchema(element2);
            }
        }
    }

    private void scanMessage(Element element) throws SAXException {
        String string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            this.warning("<message> without name: " + WSDL2Wrk.nodeToString(element));
        } else if (!element.hasChildNodes()) {
            this.warning("<message> without part(s): " + WSDL2Wrk.nodeToString(element));
        } else {
            Element element2;
            Message message = new Message(string);
            this.messages.add(message);
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                if (!"part".equalsIgnoreCase(element2.getLocalName())) continue;
                Type type = this.getType(element2, "type");
                if (type == null) {
                    type = this.getType(element2, "element");
                }
                if (type != null) {
                    if (WSDL2Wrk.isSimpleType(type.name)) {
                        QName qName = type.name;
                        QName qName2 = new QName();
                        qName2.name = element2.getAttribute("name");
                        type = new Type(qName2, this.isElementFormQualified());
                        type.simpleType = qName;
                    }
                    message.addPart(type);
                    continue;
                }
                this.warning("type undefined: '" + WSDL2Wrk.nodeToString(element2) + "'");
            }
        }
    }

    private QName scanAttribute(Element element, Type type) throws SAXException {
        Element element2;
        ElementIterator elementIterator = new ElementIterator(element);
        QName qName = null;
        while ((element2 = elementIterator.next()) != null) {
            if (!"attribute".equals(element2.getLocalName())) continue;
            QName qName2 = this.getAttribute(element2, "ref");
            if (qName2 != null) {
                if (!"arrayType".equals(qName2.name) || !NS_SOAPENC.equals(qName2.ns)) continue;
                qName = this.getAttribute(element2, "arrayType", NS_WSDL);
                continue;
            }
            QName qName3 = this.getAttribute(element2, "name");
            QName qName4 = this.getAttribute(element2, "type");
            if (qName3 == null || qName4 == null) continue;
            type.attrNames.put(qName3.name, qName4);
        }
        if (qName != null) {
            int n2 = 0;
            String string = qName.name;
            if ((n2 = string.indexOf(91, n2)) > 0) {
                int n3;
                qName.name = string.substring(0, n2);
                if ((n3 = string.indexOf(93, ++n2)) > n2) {
                    type.minOccurs = "1";
                    type.maxOccurs = string.substring(n2, n3);
                } else if (n3 == n2) {
                    type.minOccurs = "1";
                    type.maxOccurs = "unbounded";
                }
            }
            if (this.targetNamespace.equals(qName.ns)) {
                return qName;
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(qName.ns)) {
                if (!XMLStreamConstants.xsdSimpleTypes.containsKey(qName.name)) {
                    throw new SAXException("Invalid type " + qName.name);
                }
                return qName;
            }
            throw new SAXException("Unhandled type " + qName.ns + ":" + qName.name);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void scanRestrictionBase(Element element, QName qName, Type type) throws SAXException {
        if (NS_SOAPENC.equals(qName.ns)) {
            if (soapTypes.get(qName.name) == null) {
                throw new SAXException("Invalid type " + qName.name);
            }
            if ("Array".equals(qName.name)) {
                if (!element.hasChildNodes()) throw new SAXException("void array:" + qName.name);
                qName = this.scanAttribute(element, type);
                if (qName == null) {
                    ElementIterator elementIterator = new ElementIterator(element);
                    Element element2 = elementIterator.next();
                    while (element2 != null) {
                        if ("sequence".equals(element2.getLocalName())) {
                            ElementIterator elementIterator2 = new ElementIterator(element2);
                            Element element3 = elementIterator2.next();
                            while (element3 != null) {
                                Type type2;
                                if ("element".equals(element3.getLocalName()) && (type2 = this.scanElement(element3, true)) != null) {
                                    type.minOccurs = type2.minOccurs;
                                    type.maxOccurs = type2.maxOccurs;
                                    qName = type2.name;
                                    type.components.put(type2.name, type2);
                                }
                                element3 = elementIterator2.next();
                            }
                        }
                        element2 = elementIterator.next();
                    }
                }
            } else {
                this.scanComplexType(element, type);
                return;
            }
        }
        super.scanRestrictionBase(element, qName, type);
    }

    private Operation scanOperation(Element element) throws SAXException {
        QName qName = this.getAttribute(element, "name");
        if (qName == null) {
            throw new SAXException("<operation> without name");
        }
        Operation operation = new Operation(qName.ns, qName.name);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string = element2.getLocalName();
                QName qName2 = this.getAttribute(element2, "message");
                if (qName2 == null) continue;
                Message message = WSDL2Wrk.findMessage(this.messages, qName2.name);
                operation.addParams(string, message);
            }
        }
        return operation;
    }

    private void scanPortType(Element element) throws SAXException {
        String string = element.getAttribute("name");
        if (string == null || string.length() == 0) {
            throw new SAXException("<portType> without name");
        }
        PortType portType = new PortType(string);
        this.portTypes.add(portType);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string2 = element2.getLocalName();
                if (!"operation".equalsIgnoreCase(string2)) continue;
                portType.addOperation(this.scanOperation(element2));
            }
        }
    }

    private void scanBinding2(Element element, Binding binding) throws SAXException {
        String string = element.getAttribute("style");
        String string2 = element.getAttribute("transport");
        if (string2 == null || string2.length() == 0) {
            this.warning("Missing 'transport' attribute");
        } else if (!NS_SOAPHTTP.equals(string2)) {
            this.warning("Invalid 'transport' value: " + string2);
        }
        binding.setStyle(string);
        binding.setTransport(string2);
    }

    private void scanBinding(Element element) throws SAXException {
        String string = element.getAttribute("name");
        QName qName = this.getAttribute(element, "type");
        Binding binding = new Binding(string, qName, this.portTypes);
        this.bindings.add(binding);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string2 = element2.getLocalName();
                if ("binding".equalsIgnoreCase(string2)) {
                    this.scanBinding2(element2, binding);
                    continue;
                }
                if (!"operation".equalsIgnoreCase(string2)) continue;
                this.scanOperation2(element2, binding.portType, "rpc".equalsIgnoreCase(binding.style));
            }
        }
    }

    private void scanOperation2(Element element, PortType portType, boolean bl) throws SAXException {
        if (portType != null && element.hasChildNodes()) {
            String string = element.getAttribute("name");
            for (Operation operation : portType.operations) {
                Element element2;
                if (!operation.name.equals(string)) continue;
                ElementIterator elementIterator = new ElementIterator(element);
                block1: while ((element2 = elementIterator.next()) != null) {
                    String string2 = element2.getLocalName();
                    for (Operation.Param param : operation.params) {
                        Element element3;
                        if (!param.key.equals(string2)) continue;
                        if (!element2.hasChildNodes()) continue block1;
                        ElementIterator elementIterator2 = new ElementIterator(element2);
                        while ((element3 = elementIterator2.next()) != null) {
                            QName qName;
                            String string3 = element3.getLocalName();
                            if ("body".equals(string3)) {
                                if (NS_SOAPENC.equals(element3.getAttribute("encodingStyle")) && "encoded".equals(element3.getAttribute("use"))) {
                                    param.msg.encoded = true;
                                }
                                if (!bl) continue;
                                this.setRpcURI(param, element3);
                                continue;
                            }
                            if (!"header".equals(string3) || (qName = this.getAttribute(element3, "message")) == null) continue;
                            param.hdr = WSDL2Wrk.findMessage(this.messages, qName.name);
                            if (param.hdr == null) continue;
                            if (NS_SOAPENC.equals(element3.getAttribute("encodingStyle")) && "encoded".equals(element3.getAttribute("use"))) {
                                param.hdr.encoded = true;
                            }
                            param.uri = element3.getAttribute("namespace");
                            if (!bl) continue;
                            this.setRpcURI(param, element3);
                        }
                        continue block1;
                    }
                }
                break block0;
            }
        }
    }

    private void setRpcURI(Operation.Param param, Element element) {
        param.uri = element.getAttribute("namespace");
    }

    private Map<String, StringBuilder> generateCopyfiles(Element element) throws SAXException, IOException, ParserConfigurationException {
        this.scanRoot(element);
        LinkedHashMap<String, StringBuilder> linkedHashMap = new LinkedHashMap<String, StringBuilder>();
        for (Binding binding : this.bindings) {
            boolean bl;
            PortType portType = binding.portType;
            boolean bl2 = bl = binding.style != null && binding.style.equals("rpc");
            if (portType == null || !NS_SOAPHTTP.equals(binding.transport)) continue;
            for (Operation operation : portType.operations) {
                StringBuilder stringBuilder = new StringBuilder();
                operation.getCode(stringBuilder, portType.name, bl);
                if (stringBuilder.length() <= 0) continue;
                linkedHashMap.put(operation.name, stringBuilder);
            }
        }
        return linkedHashMap;
    }

    private void scanRoot(Element element) throws SAXException, IOException, ParserConfigurationException {
        if (element.getNodeType() != 1 || !"definitions".equalsIgnoreCase(element.getLocalName())) {
            throw new SAXException("Invalid root element: expected <definitions> found <" + element.getLocalName() + ">");
        }
        this.targetNamespace = element.getAttribute("targetNamespace");
        this.addNamespaces(element);
        if (element.hasChildNodes()) {
            Element element2;
            ElementIterator elementIterator = new ElementIterator(element);
            while ((element2 = elementIterator.next()) != null) {
                String string;
                String string2 = element2.getLocalName();
                if ("types".equalsIgnoreCase(string2)) {
                    this.scanTypes(element2);
                    continue;
                }
                if ("message".equalsIgnoreCase(string2)) {
                    this.scanMessage(element2);
                    continue;
                }
                if ("portType".equalsIgnoreCase(string2)) {
                    this.scanPortType(element2);
                    continue;
                }
                if ("binding".equalsIgnoreCase(string2)) {
                    this.scanBinding(element2);
                    continue;
                }
                if (!"import".equalsIgnoreCase(string2) || (string = element2.getAttribute("location")).length() <= 0 || this.wsdlImports.contains(string)) continue;
                this.wsdlImports.add(string);
                this.scanRoot(WSDL2Wrk.openXml(string));
            }
        }
    }

    public void debug() {
        for (Binding object : this.bindings) {
            System.out.println(object);
        }
        for (PortType portType : this.portTypes) {
            System.out.println(portType);
        }
        for (Message message : this.messages) {
            System.out.println(message);
        }
        for (Type type : this.allTypes.values()) {
            System.out.println(type);
        }
    }

    private static Message findMessage(List<Message> list, String string) {
        for (Message message : list) {
            if (!string.equals(message.name)) continue;
            return message;
        }
        return null;
    }

    @Override
    protected String getPrefix() {
        return "";
    }

    @Override
    protected boolean isDisambiguate() {
        return true;
    }

    @Override
    protected boolean mustAddGroupNames() {
        return false;
    }

    @Override
    protected void getCodeAttrs(Type type, int n2, StringBuilder stringBuilder) {
        if (this.encoded) {
            String string;
            if (type.simpleType != null) {
                string = "xsd:" + type.simpleType.name;
            } else {
                Type type2 = type.refType;
                if (type2 == null) {
                    type2 = type.restriction;
                }
                string = type2 != null ? (type2.name.ns != null ? this.nsPrefixes.get(type2.name.ns) + ":" + type2.name.name : type2.name.name) : null;
            }
            if (string != null) {
                WSDL2Wrk.putLevel(stringBuilder, n2);
                stringBuilder.append(" identified by 'xsi:type' is attribute.");
                stringBuilder.append(eol);
                WSDL2Wrk.putLevel(stringBuilder, n2 + 2);
                boolean bl = "unbounded".equals(type.maxOccurs);
                if (bl) {
                    stringBuilder.append(" " + this.getCobolName("t-" + type.name));
                } else {
                    stringBuilder.append(" filler");
                }
                stringBuilder.append(" pic x(" + string.length() + ")");
                stringBuilder.append(" value '" + string + "'");
                stringBuilder.append(".");
                stringBuilder.append(eol);
            }
        }
        super.getCodeAttrs(type, n2, stringBuilder);
    }

    @Override
    protected String buildDataName(String string) {
        return this.getCobolName("a-" + string);
    }

    @Override
    protected String buildCapacityName(String string) {
        return this.getCobolName("a-c-" + string);
    }

    @Override
    protected String buildAttrName(String string) {
        return this.getCobolName("attr-" + string);
    }

    @Override
    protected void getQualifiedName(Type type, boolean bl, String string, StringBuilder stringBuilder) {
        String string2;
        stringBuilder.append("'");
        if ((bl || type.elemFormQual) && type.name.ns != null && (string2 = this.nsPrefixes.get(type.name.ns)) != null) {
            stringBuilder.append(string2);
            stringBuilder.append(":");
        }
        stringBuilder.append(type.name.name);
        stringBuilder.append("'");
    }

    @Override
    protected boolean isElementFormQualified() {
        return this.elementFormQualified;
    }

    private void addNsPrefixes(Type type, Set<Type> set) {
        if (set.contains(type)) {
            return;
        }
        set.add(type);
        if (type.name.ns != null) {
            this.addNSPrefix(type.name.ns);
        }
        if (type.refType != null) {
            type = type.refType;
        } else if (type.restriction != null) {
            type = type.restriction;
        }
        if (type.extension != null || !type.components.isEmpty()) {
            Type type2 = type.extension;
            if (type2 != null) {
                this.addNsPrefixesExt(type2, set);
            }
            for (Type type3 : type.components.values()) {
                this.addNsPrefixes(type3, set);
            }
        }
    }

    private void addNSPrefix(String string) {
        String string2 = this.nsPrefixes.get(string);
        if (string2 == null) {
            string2 = "ns" + this.nsPrefixes.size();
            this.nsPrefixes.put(string, string2);
        }
    }

    private void addNsPrefixesExt(Type type, Set<Type> set) {
        if (type.extension != null) {
            this.addNsPrefixesExt(type.extension, set);
        }
        if (type.refType != null) {
            type = type.refType;
        }
        for (Type type2 : type.components.values()) {
            this.addNsPrefixes(type2, set);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] stringArray) throws Exception {
        Object object;
        String string;
        if (stringArray.length == 1 && "-v".equals(stringArray[0])) {
            string = RuntimeProperties.getFullVersionNumber();
            if (string.startsWith("isCOBOL")) {
                string = "isCOBOL-WSDL2Wrk" + string.substring(7);
            }
            System.out.println(string);
            System.exit(0);
        }
        if (stringArray.length == 0) {
            WSDL2Wrk.usage();
        }
        string = stringArray[0];
        String string2 = null;
        int n2 = 1;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("WSDL2Wrk options:");
        try {
            for (int i2 = 1; i2 < stringArray.length; ++i2) {
                if ("-o".equals(stringArray[i2])) {
                    stringBuilder.append(" ").append(stringArray[i2]);
                    string2 = stringArray[++i2];
                    stringBuilder.append(" ").append(stringArray[i2]);
                    continue;
                }
                if (!"-v1.1".equals(stringArray[i2])) continue;
                n2 = 0;
                stringBuilder.append(" ").append(stringArray[i2]);
            }
        }
        catch (Exception exception) {
            WSDL2Wrk.usage();
        }
        String[] stringArray2 = null;
        String[] stringArray3 = null;
        WSDL2Wrk wSDL2Wrk = new WSDL2Wrk(string, n2);
        wSDL2Wrk.setHeaderString(stringBuilder.toString());
        Map<String, StringBuilder> map = wSDL2Wrk.generateCopyfiles();
        stringArray2 = new String[map.size()];
        stringArray3 = new String[map.size()];
        int n3 = 0;
        for (String object22 : map.keySet()) {
            stringArray2[n3] = map.get(object22).toString();
            stringArray3[n3] = "-" + object22;
            ++n3;
        }
        if (string2 != null) {
            object = string2;
        } else {
            try {
                URL malformedURLException = new URL(string);
                object = new File(malformedURLException.getPath()).getName();
            }
            catch (MalformedURLException malformedURLException) {
                object = string;
            }
        }
        String string3 = ".wrk";
        int n4 = ((String)object).lastIndexOf(46);
        if (n4 >= 0) {
            if (string2 != null) {
                String string4 = ((String)object).substring(n4);
            }
            object = ((String)object).substring(0, n4);
        }
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            void var11_19;
            String string5 = (String)object + stringArray3[n3] + (String)var11_19;
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string5));
            printWriter.println(stringArray2[n3]);
            printWriter.close();
            System.out.println("Generated '" + string5 + "'.");
        }
    }

    private static void usage() {
        System.err.println(usage);
        System.exit(1);
    }

    static {
        soapTypes.put("string", "S");
        soapTypes.put("Array", "S");
        usage = "java " + WSDL2Wrk.class.getName() + " uri [-o outputfile] [-v1.1]\n-v print version number";
    }

    class Binding {
        private final String name;
        private final QName type;
        private final PortType portType;
        private String style;
        private String transport;

        Binding(String string, QName qName, List<PortType> list) throws SAXException {
            this.name = string;
            this.type = qName;
            int n2 = list.size();
            PortType portType = null;
            for (int i2 = 0; i2 < n2 && !(portType = list.get(i2)).name.equals(this.type.name); ++i2) {
                portType = null;
            }
            this.portType = portType;
            if (this.portType == null) {
                throw new SAXException("<binding>:portType " + this.type.name + " not found");
            }
        }

        void setStyle(String string) {
            this.style = string;
        }

        void setTransport(String string) {
            this.transport = string;
        }

        public String toString() {
            return "binding=" + this.name + ",style=" + this.style + ",transport=" + this.transport + ":" + this.portType;
        }
    }

    class PortType {
        private final String name;
        private final List<Operation> operations = new ArrayList<Operation>();

        PortType(String string) {
            this.name = string;
        }

        void addOperation(Operation operation) {
            this.operations.add(operation);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("PortType:");
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
            for (Operation operation : this.operations) {
                stringBuilder.append(operation);
            }
            return stringBuilder.toString();
        }
    }

    class Operation {
        private final String uri;
        private final String name;
        private final List<Param> params = new ArrayList<Param>();

        Operation(String string, String string2) {
            this.uri = string;
            this.name = string2;
        }

        void addParams(String string, Message message) {
            this.params.add(new Param(string, message));
        }

        public void getCode(StringBuilder stringBuilder, String string, boolean bl) {
            stringBuilder.append("       >>SOURCE FORMAT FREE");
            stringBuilder.append(AbstractXml2Wrk.eol);
            if (WSDL2Wrk.this.headerString != null) {
                stringBuilder.append(RtsUtil.getCopyHeader("WSDL", WSDL2Wrk.this.uri, WSDL2Wrk.this.headerString));
            }
            stringBuilder.append("*> binding name=");
            stringBuilder.append(this.name);
            stringBuilder.append(", style=");
            stringBuilder.append(bl ? "rpc" : "document");
            stringBuilder.append(AbstractXml2Wrk.eol);
            for (Param param : this.params) {
                WSDL2Wrk.this.nsPrefixes = new LinkedHashMap();
                int n2 = 5;
                boolean bl2 = param.key.equals("output");
                stringBuilder.append(WSDL2Wrk.SOAP_ENVELOPE_START);
                if (bl2) {
                    stringBuilder.append("out-");
                } else {
                    stringBuilder.append("in-");
                }
                if (this.uri != null) {
                    WSDL2Wrk.this.addNSPrefix(this.uri);
                }
                if (bl && param.uri != null) {
                    WSDL2Wrk.this.addNSPrefix(param.uri);
                }
                stringBuilder.append(this.name);
                stringBuilder.append(" identified by 'soapenv:Envelope'." + AbstractXml2Wrk.eol);
                AbstractXml2Wrk.putLevel(stringBuilder, 3);
                stringBuilder.append(" identified by 'xmlns:soapenv' is attribute." + AbstractXml2Wrk.eol);
                AbstractXml2Wrk.putLevel(stringBuilder, 5);
                stringBuilder.append(" filler pic x(" + SOAP_ENVELOPE_NS[WSDL2Wrk.this.version].length() + ") value '" + SOAP_ENVELOPE_NS[WSDL2Wrk.this.version] + "'." + AbstractXml2Wrk.eol);
                if (param.msg.encoded) {
                    AbstractXml2Wrk.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:xsd' is attribute.");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema".length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append("http://www.w3.org/2001/XMLSchema");
                    stringBuilder.append("\".");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:xsi' is attribute.");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + "http://www.w3.org/2001/XMLSchema-instance".length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append("http://www.w3.org/2001/XMLSchema-instance");
                    stringBuilder.append("\".");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:soapenc' is attribute.");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + WSDL2Wrk.NS_SOAPENC.length() + ")");
                    stringBuilder.append(" value \"");
                    stringBuilder.append(WSDL2Wrk.NS_SOAPENC);
                    stringBuilder.append("\".");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                }
                HashSet hashSet = new HashSet();
                if (param.hdr != null) {
                    for (Object object : param.hdr.parts) {
                        WSDL2Wrk.this.addNsPrefixes((Type)object, hashSet);
                    }
                }
                for (Object object : param.msg.parts) {
                    WSDL2Wrk.this.addNsPrefixes((Type)object, hashSet);
                }
                for (Object object : WSDL2Wrk.this.nsPrefixes.keySet()) {
                    String string2 = (String)WSDL2Wrk.this.nsPrefixes.get(object);
                    AbstractXml2Wrk.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'xmlns:" + string2 + "' is attribute." + AbstractXml2Wrk.eol);
                    AbstractXml2Wrk.putLevel(stringBuilder, 5);
                    stringBuilder.append(" filler pic x(" + ((String)object).length() + ") value '" + (String)object + "'." + AbstractXml2Wrk.eol);
                }
                if (param.hdr != null) {
                    AbstractXml2Wrk.putLevel(stringBuilder, 3);
                    stringBuilder.append(" identified by 'soapenv:Header'." + AbstractXml2Wrk.eol);
                    param.hdr.getCode(stringBuilder, n2, this.uri, bl2);
                }
                AbstractXml2Wrk.putLevel(stringBuilder, 3);
                stringBuilder.append(" identified by 'soapenv:Body'." + AbstractXml2Wrk.eol);
                if (bl) {
                    AbstractXml2Wrk.putLevel(stringBuilder, 5);
                    stringBuilder.append(" identified by '");
                    if (param.uri != null) {
                        stringBuilder.append((String)WSDL2Wrk.this.nsPrefixes.get(param.uri));
                        stringBuilder.append(":");
                    }
                    stringBuilder.append(this.name);
                    if (bl2) {
                        stringBuilder.append("Response");
                    }
                    stringBuilder.append("'.");
                    stringBuilder.append(AbstractXml2Wrk.eol);
                    if (param.msg.encoded) {
                        this.putEncodingStyle(stringBuilder, 7);
                    }
                    n2 += 2;
                }
                param.msg.getCode(stringBuilder, n2, this.uri, bl2);
                stringBuilder.append(AbstractXml2Wrk.eol);
            }
            stringBuilder.append("       >>SOURCE FORMAT PREVIOUS" + AbstractXml2Wrk.eol);
        }

        private void putEncodingStyle(StringBuilder stringBuilder, int n2) {
            AbstractXml2Wrk.putLevel(stringBuilder, n2);
            stringBuilder.append(" identified by 'soapenv:encodingStyle' is attribute.");
            stringBuilder.append(AbstractXml2Wrk.eol);
            AbstractXml2Wrk.putLevel(stringBuilder, n2 + 2);
            stringBuilder.append(" filler pic x(" + WSDL2Wrk.NS_SOAPENC.length() + ") value '" + WSDL2Wrk.NS_SOAPENC + "'.");
            stringBuilder.append(AbstractXml2Wrk.eol);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("Operation:");
            stringBuilder.append(this.name);
            stringBuilder.append('\n');
            if (this.params != null) {
                for (Param param : this.params) {
                    stringBuilder.append("<");
                    stringBuilder.append(param.key);
                    stringBuilder.append(">\n");
                    stringBuilder.append(param.msg);
                }
            }
            return stringBuilder.toString();
        }

        class Param {
            private final String key;
            private final Message msg;
            private Message hdr;
            private String uri;

            private Param(String string, Message message) {
                this.key = string;
                this.msg = message;
            }
        }
    }

    class Message {
        private final String name;
        private boolean encoded;
        private final List<Type> parts = new ArrayList<Type>();

        Message(String string) {
            this.name = string;
        }

        void addPart(Type type) {
            this.parts.add(type);
        }

        public void getCode(StringBuilder stringBuilder, int n2, String string, boolean bl) {
            WSDL2Wrk.this.allCobolNames = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return string.compareToIgnoreCase(string2);
                }
            });
            WSDL2Wrk.this.encoded = this.encoded;
            for (Type type : this.parts) {
                WSDL2Wrk.this.getCode(type, n2, null, stringBuilder, new Vector<Type>());
            }
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder("msg:");
            stringBuilder.append(this.name);
            for (int i2 = 0; i2 < this.parts.size(); ++i2) {
                stringBuilder.append("\n");
                stringBuilder.append(this.parts.get(i2));
            }
            return stringBuilder.toString();
        }
    }
}

