/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.utility;

import com.iscobol.rts.RtsUtil;
import com.iscobol.utility.AbstractXml2Wrk;
import com.iscobol.utility.ElementIterator;
import com.iscobol.utility.QName;
import com.iscobol.utility.Type;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class Xml2Wrk
extends AbstractXml2Wrk {
    private String prefix;
    private final boolean disambiguate;
    private final boolean generateEnum;
    private final boolean generateCount;
    private final int fixedLength;
    private final String dataSuffix;
    private final String attributeSuffix;
    private final String enumSuffix;
    private final String countSuffix;
    private final String capacitySuffix;
    private final boolean ignoreUnbound;
    private final boolean generateComments;
    private final boolean xsd;
    private Type xsdRoot;
    private Map<QName, Type> xsdAlternates = new LinkedHashMap<QName, Type>();

    public Xml2Wrk(String string, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n2, String string2, String string3, String string4, String string5, String string6, String string7, boolean bl5, boolean bl6) {
        super(string);
        this.xsd = bl;
        this.prefix = string2;
        if (this.prefix == null || "0".equals(this.prefix)) {
            this.prefix = "";
        }
        this.disambiguate = bl2;
        this.generateEnum = bl3;
        this.generateCount = bl4;
        this.fixedLength = n2;
        this.dataSuffix = string3 != null ? string3 : super.getDataSuffix();
        this.attributeSuffix = string4 != null ? string4 : super.getAttributeSuffix();
        this.enumSuffix = string5 != null ? string5 : super.getEnumSuffix();
        this.countSuffix = string6 != null ? string6 : super.getCountSuffix();
        this.capacitySuffix = string7 != null ? string7 : super.getCapacitySuffix();
        this.ignoreUnbound = bl5;
        this.generateComments = bl6;
    }

    @Override
    protected String getPrefix() {
        return this.prefix;
    }

    @Override
    protected boolean isDisambiguate() {
        return this.disambiguate;
    }

    @Override
    protected boolean isIgnoreUnbound() {
        return this.ignoreUnbound;
    }

    @Override
    protected boolean mustAddGroupNames() {
        return true;
    }

    public String generateCopyFile() throws IOException, SAXException, ParserConfigurationException {
        if (this.xsd) {
            this.scanXsd(this.uri);
            if (this.allTypes.size() > 0) {
                return this.generateCopyFile(null, null);
            }
            throw new IOException("Error reading '" + this.uri + "'");
        }
        Element element = this.openXml(this.uri, this.prefix);
        return this.generateCopyFile(element);
    }

    public String generateCopyFile(Element element) throws IOException, SAXException, ParserConfigurationException {
        String string = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        if (string.length() > 0 || (string = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation")).length() > 0) {
            this.scanXsd(string);
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        this.scanXml(element, arrayList, null);
        return this.generateCopyFile(element.getNamespaceURI(), element.getLocalName());
    }

    private String generateCopyFile(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        Xml2Wrk.getSpaces(12, stringBuilder);
        stringBuilder.append(">>SOURCE FORMAT FREE");
        stringBuilder.append(eol);
        if (this.headerString != null) {
            stringBuilder.append(RtsUtil.getCopyHeader(this.xsd ? "XSD" : "XML", this.uri, this.headerString));
        }
        Type type = null;
        if (this.xsd) {
            if (this.xsdRoot != null) {
                type = this.xsdRoot;
            }
        } else {
            QName qName = new QName(string, string2);
            type = (Type)this.allTypes.get(qName);
        }
        if (type != null) {
            this.getCode(type, 1, null, stringBuilder, new Vector<Type>());
            if (this.xsd) {
                this.xsdAlternates.remove(this.xsdRoot.name);
                for (Type type2 : this.xsdAlternates.values()) {
                    this.allCobolNames.clear();
                    this.getCode(type2, 1, null, stringBuilder, new Vector<Type>());
                }
            }
        }
        stringBuilder.append(eol);
        Xml2Wrk.getSpaces(12, stringBuilder);
        stringBuilder.append(">>SOURCE FORMAT PREVIOUS");
        stringBuilder.append(eol);
        return stringBuilder.toString();
    }

    private void scanXsd(String string) {
        String string2 = this.getAbsolutePath(string);
        try {
            this.scanXsd0(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.err.println("warning: failed to open '" + string2 + "' (" + exception + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scanXsd0(String string) throws IOException, SAXException, ParserConfigurationException {
        Element element = this.openXml(string, null);
        Object object = null;
        if ("schema".equals(element.getLocalName())) {
            this.targetNamespace = element.getAttribute("targetNamespace");
            if (this.targetNamespace == "") {
                this.targetNamespace = null;
            }
            this.addNamespaces(element);
            ElementIterator elementIterator = new ElementIterator(element);
            Element element2 = elementIterator.next();
            while (element2 != null) {
                Object object2;
                if ("import".equals(element2.getLocalName())) {
                    object2 = element2.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                    if (((String)object2).length() > 0 || ((String)(object2 = element2.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation"))).length() > 0) {
                        String string2 = this.targetNamespace;
                        try {
                            this.scanXsd((String)object2);
                        }
                        finally {
                            this.targetNamespace = string2;
                        }
                    }
                } else if ("include".equals(element2.getLocalName())) {
                    object2 = element2.getAttribute("schemaLocation");
                    if (((String)object2).length() > 0 || ((String)(object2 = element2.getAttribute("noNamespaceSchemaLocation"))).length() > 0) {
                        this.scanXsd((String)object2);
                    }
                } else if ("element".equals(element2.getLocalName())) {
                    object2 = this.scanElement(element2, false);
                    if (this.xsd) {
                        if (object == null) {
                            object = object2;
                        }
                        if (object2 != null) {
                            if (((Type)object2).refType != null && !Xml2Wrk.isSimpleType(((Type)object2).refType.name) && ((Type)object2).refType.simpleType == null) {
                                this.xsdAlternates.put(((Type)object2).name, (Type)object2);
                            }
                            if (!this.allTypes.containsKey(((Type)object2).name)) {
                                this.allTypes.put(((Type)object2).name, object2);
                            }
                        }
                    }
                } else if ("complexType".equals(element2.getLocalName())) {
                    this.scanComplexType(element2, null);
                } else if ("simpleType".equals(element2.getLocalName())) {
                    this.scanSimpleType(element2, null);
                }
                element2 = elementIterator.next();
            }
        } else {
            throw new SAXException("Invalid schema");
        }
        this.xsdRoot = object;
    }

    private String getAbsolutePath(String string) {
        File file;
        File file2 = new File(string);
        if (!file2.isAbsolute() && (file = new File(this.uri)).isFile() && file.getParent() != null) {
            string = file.getParent() + File.separator + string;
        }
        return string;
    }

    private void scanXml(Element element, List<Type> list, String string) {
        Object object;
        int n2;
        Object object2;
        Type type;
        QName qName = new QName(element.getNamespaceURI(), element.getLocalName());
        Object object3 = (Type)this.allTypes.get(qName);
        Type type2 = type = list.isEmpty() ? null : list.get(list.size() - 1);
        if (object3 == null) {
            object3 = new Type(qName, true);
            ((Type)object3).fromXml = true;
            if (type == null) {
                this.allTypes.put(qName, object3);
            }
        }
        if (type != null) {
            object2 = type.components.get(qName);
            if (object2 != null) {
                object3 = object2;
            } else {
                for (n2 = list.size() - 1; n2 >= 0; --n2) {
                    if (!list.get((int)n2).name.equals(((Type)object3).name)) continue;
                    object3 = new Type((Type)object3);
                    break;
                }
            }
            type.components.put(qName, (Type)object3);
        }
        if (((Type)object3).fromXml && element.getLocalName().equals(string)) {
            ((Type)object3).maxOccurs = "unbounded";
        }
        object2 = element.getAttributes();
        n2 = object2.getLength();
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = object2.item(i2);
            if (!(node instanceof Attr)) continue;
            object = (Attr)node;
            if (object.getName().startsWith("xmlns:")) {
                this.namespaces.put(object.getName().substring(6), object.getValue());
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(object.getNamespaceURI()) && ("noNamespaceSchemaLocation".equals(object.getLocalName()) || "schemaLocation".equals(object.getLocalName()))) continue;
            ((Type)object3).attrNames.put(object.getLocalName(), new QName(object.getNamespaceURI(), object.getLocalName()));
        }
        ElementIterator elementIterator = new ElementIterator(element);
        int n3 = 0;
        string = null;
        object = new ArrayList<Type>(list);
        object.add(object3);
        Element element2 = elementIterator.next();
        while (element2 != null) {
            this.scanXml(element2, (List<Type>)object, string);
            string = element2.getLocalName();
            element2 = elementIterator.next();
            ++n3;
        }
        if (n3 == 0 && ((Type)object3).fromXml) {
            ((Type)object3).simpleType = new QName("http://www.w3.org/2001/XMLSchema", "string");
        }
    }

    private String getDefaultPrefix(String string) {
        int n2 = string.lastIndexOf(46);
        if (n2 >= 0) {
            string = string.substring(0, n2);
        }
        return string.replace('.', '_').replace(' ', '_');
    }

    private Element openXml(String string, String string2) throws IOException, SAXException, ParserConfigurationException {
        InputStream inputStream;
        Object object;
        DocumentBuilder documentBuilder;
        block3: {
            DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
            try {
                object = new URL(string);
                inputStream = ((URL)object).openStream();
                if ("1".equals(string2)) {
                    this.prefix = this.getDefaultPrefix(new File(((URL)object).getPath()).getName());
                }
            }
            catch (MalformedURLException malformedURLException) {
                inputStream = new FileInputStream(string);
                if (!"1".equals(string2)) break block3;
                this.prefix = this.getDefaultPrefix(new File(string).getName());
            }
        }
        object = documentBuilder.parse(inputStream);
        inputStream.close();
        object.getDocumentElement().normalize();
        return object.getDocumentElement();
    }

    @Override
    protected void getQualifiedName(Type type, boolean bl, String string, StringBuilder stringBuilder) {
        boolean bl2;
        stringBuilder.append("'");
        stringBuilder.append(type.name.name);
        stringBuilder.append("'");
        if (type.name.ns != null) {
            bl2 = type.name.ns.equals(string);
        } else {
            boolean bl3 = bl2 = string == null;
        }
        if (!bl2) {
            if (type.name.ns != null) {
                stringBuilder.append(" namespace '");
                stringBuilder.append(type.name.ns);
                stringBuilder.append("'");
            } else if (string != null) {
                stringBuilder.append(" namespace ''");
            }
        }
    }

    @Override
    protected boolean isElementFormQualified() {
        return true;
    }

    @Override
    protected boolean isGenerateEnum() {
        return this.generateEnum;
    }

    @Override
    protected boolean isGenerateCount() {
        return this.generateCount;
    }

    @Override
    protected boolean isGenerateComments() {
        return this.generateComments;
    }

    @Override
    protected int getFixedLength() {
        return this.fixedLength;
    }

    @Override
    protected String getDataSuffix() {
        return this.dataSuffix;
    }

    @Override
    protected String getAttributeSuffix() {
        return this.attributeSuffix;
    }

    @Override
    protected String getEnumSuffix() {
        return this.enumSuffix;
    }

    @Override
    protected String getCapacitySuffix() {
        return this.capacitySuffix;
    }

    @Override
    protected String getCountSuffix() {
        return this.countSuffix;
    }
}

