/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.web;

import com.iscobol.web.MultipartRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Part {
    private MultipartRequest inp;
    private final String boundary;
    private String name;
    private String fileName;
    private String fullPathName;
    private String contentType;
    private String value;
    private String prefix;
    private File directory;
    private File tmpFile;
    private boolean inRam;
    private InputStream file;
    private byte[] fileBuffer;

    public Part(MultipartRequest multipartRequest, String string, String string2) throws IOException {
        this.inp = multipartRequest;
        this.boundary = null;
        this.name = string;
        this.fileName = null;
        this.fullPathName = null;
        this.contentType = "text/plain";
        this.value = string2;
        this.directory = null;
        this.tmpFile = null;
        this.inRam = true;
        this.fileBuffer = this.value.getBytes();
        this.file = new ByteArrayInputStream(this.fileBuffer);
    }

    public Part(MultipartRequest multipartRequest, String string, String string2, String string3, String string4, boolean bl, File file, String string5) throws IOException {
        this.inp = multipartRequest;
        this.name = string;
        this.fullPathName = string2;
        this.contentType = string3;
        this.boundary = string4;
        this.inRam = bl;
        this.directory = file;
        String string6 = this.prefix = string5 == null ? "" : string5;
        if (this.fullPathName == null || this.fullPathName.length() == 0) {
            this.readValue();
        } else {
            int n2 = string2.lastIndexOf(92);
            if (n2 < 0) {
                n2 = string2.lastIndexOf(47);
            }
            this.fileName = n2 == string2.length() - 1 ? "" : (n2 >= 0 ? string2.substring(n2 + 1) : string2);
            this.readFile();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullPathName() {
        return this.fullPathName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getValue() {
        return this.value;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isFile() {
        return this.fullPathName != null;
    }

    public File getFile() {
        return this.tmpFile;
    }

    public byte[] getBytes() {
        return this.fileBuffer;
    }

    public InputStream getInputStream() {
        return this.file;
    }

    private File createTmpFile() throws IOException {
        File file = null;
        long l2 = System.currentTimeMillis();
        while (!(file = new File(this.directory, this.prefix + Long.toHexString(l2++) + "_" + this.fileName)).createNewFile()) {
        }
        this.fullPathName = file.getCanonicalPath();
        return file;
    }

    private void readFile() throws IOException {
        int n2;
        OutputStream outputStream;
        int n3 = this.boundary.length();
        int n4 = n3 + 4;
        byte[] byArray = new byte[8192];
        int n5 = 0;
        if (this.inRam) {
            outputStream = new ByteArrayOutputStream();
        } else {
            try {
                this.tmpFile = this.createTmpFile();
                outputStream = new FileOutputStream(this.tmpFile);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage() + ": directory=" + this.directory.getPath());
            }
        }
        while (!((n2 = this.inp.readLine(byArray, n5, byArray.length - n5)) <= 0 || n2 >= n3 && n2 <= n4 && new String(byArray, n5, n2).startsWith(this.boundary))) {
            if (n5 == 0) {
                n5 = this.inp.getEolToSkip() + 1;
                n2 -= n5;
            }
            outputStream.write(byArray, 0, n2);
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[i2] = byArray[n2 + i2];
            }
        }
        outputStream.close();
        if (this.inRam) {
            this.fileBuffer = ((ByteArrayOutputStream)outputStream).toByteArray();
            this.file = new ByteArrayInputStream(this.fileBuffer);
        } else {
            this.file = new FileInputStream(this.tmpFile);
        }
    }

    private void readValue() throws IOException {
        int n2;
        byte[] byArray = new byte[8192];
        int n3 = this.boundary.length();
        int n4 = n3 + 4;
        int n5 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (!((n2 = this.inp.readLine(byArray, n5, byArray.length - n5)) <= 0 || n2 >= n3 && n2 <= n4 && new String(byArray, n5, n2).startsWith(this.boundary))) {
            if (n5 == 0) {
                n5 = this.inp.getEolToSkip() + 1;
                n2 -= n5;
            }
            String string = this.inp.getCharset();
            stringBuffer.append(new String(byArray, 0, n2, string));
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[i2] = byArray[n2 + i2];
            }
        }
        this.value = stringBuffer.toString();
        this.fileBuffer = this.value.getBytes();
        this.file = new ByteArrayInputStream(this.fileBuffer);
    }

    public String toString() {
        return "name=" + this.name + ",file=" + this.fileName + ",type=" + this.contentType + ",value=" + this.value;
    }

    protected void finalize() throws Throwable {
        try {
            this.file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

