/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.webjakarta;

import com.iscobol.io.BaseFile;
import com.iscobol.java.internal.IsCobol;
import com.iscobol.logger.ServletLogger;
import com.iscobol.rts.CallOverflowException;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPHandler;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeEnvironmentType;
import com.iscobol.rts.RuntimeInfo;
import com.iscobol.rts.SOAPEnvelopeParser;
import com.iscobol.rts.StopRunException;
import com.iscobol.webjakarta.MultipartRequest;
import com.iscobol.webjakarta.ServletSessionInfo;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.SessionTrackingMode;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IscobolServletCall
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doPatch(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doOptions(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doTrace(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    public void doHead(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.run(httpServletRequest, httpServletResponse);
    }

    private void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        HttpSession httpSession = httpServletRequest.getSession();
        String string = httpSession.getId();
        ServletContext servletContext = httpSession.getServletContext();
        Set set = servletContext.getEffectiveSessionTrackingModes();
        if (set.size() == 1 && set.iterator().next() == SessionTrackingMode.URL && (object = httpSession.getAttribute("iscobolServlet.sessionId")) == null) {
            httpSession.setAttribute("iscobolServlet.sessionId", (Object)string);
            String string2 = httpServletRequest.getRequestURL().append(";jsessionid=").append(string).toString();
            httpServletResponse.sendRedirect(string2);
            return;
        }
        IscobolSystem.set(HTTPSessionInfo.class, new ServletSessionInfo(string, httpServletResponse));
        object = httpServletRequest.getHeader("Content-Type");
        String string3 = httpServletRequest.getHeader("SOAPAction");
        if (object != null && (((String)object).startsWith("application/soap+xml") || ((String)object).startsWith("text/xml") && string3 != null)) {
            this.runSoap(httpServletRequest, httpServletResponse);
        } else {
            Charset charset;
            String string4 = httpServletRequest.getCharacterEncoding();
            if (string4 == null) {
                string4 = Config.a(".http.form.encoding", null);
            }
            if (string4 != null) {
                try {
                    charset = Charset.forName(string4);
                    httpServletRequest.setCharacterEncoding(string4);
                    httpServletResponse.setCharacterEncoding(string4);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    charset = null;
                }
            } else {
                charset = null;
            }
            this.runDefault(httpServletRequest, httpServletResponse, charset);
        }
    }

    private String getFaultEnvelope(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version='1.0' encoding='utf-8'?>");
        stringBuffer.append("<Envelope xmlns=\"http://www.w3.org/2003/05/soap-envelope\">");
        stringBuffer.append("<Header>");
        stringBuffer.append("<Action xmlns=\"http://www.w3.org/2005/08/addressing\">");
        stringBuffer.append("http://www.w3.org/2005/08/addressing/soap/fault");
        stringBuffer.append("</Action>");
        stringBuffer.append("</Header>");
        stringBuffer.append("<Body>");
        stringBuffer.append("<Fault>");
        stringBuffer.append("<Code>");
        stringBuffer.append("<Value>");
        stringBuffer.append(string);
        stringBuffer.append("</Value>");
        stringBuffer.append("</Code>");
        stringBuffer.append("<Reason>");
        stringBuffer.append("<Text>");
        stringBuffer.append(string2);
        stringBuffer.append("</Text>");
        stringBuffer.append("</Reason>");
        stringBuffer.append("<Detail/>");
        stringBuffer.append("</Fault>");
        stringBuffer.append("</Body>");
        stringBuffer.append("</Envelope>");
        return stringBuffer.toString();
    }

    private byte[] getInput(HttpServletRequest httpServletRequest) throws IOException {
        ServletInputStream servletInputStream = httpServletRequest.getInputStream();
        int n2 = httpServletRequest.getContentLength();
        byte[] byArray = null;
        if (n2 > 0) {
            int n3;
            byArray = new byte[n2];
            int n4 = 0;
            while ((n3 = servletInputStream.read(byArray, n4, byArray.length - n4)) > 0 && (n4 += n3) < n2) {
            }
        } else {
            int n5;
            byte[] byArray2 = new byte[1024];
            while ((n5 = servletInputStream.read(byArray2, 0, byArray2.length)) > 0) {
                if (byArray == null) {
                    if (n5 == byArray2.length) {
                        byArray = byArray2;
                        byArray2 = new byte[byArray2.length];
                        continue;
                    }
                    byArray = new byte[n5];
                    System.arraycopy(byArray2, 0, byArray, 0, n5);
                    continue;
                }
                byte[] byArray3 = new byte[byArray.length + n5];
                System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
                System.arraycopy(byArray2, 0, byArray3, byArray.length, n5);
                byArray = byArray3;
            }
        }
        return byArray;
    }

    private static void logRequest(ServletLogger servletLogger, byte[] byArray, HttpServletRequest httpServletRequest) {
        String string2;
        Object object;
        servletLogger.reportLog("===============================");
        servletLogger.reportLog("Request received at " + ServletLogger.reportTimestamp());
        servletLogger.reportLog("Begin request id: " + httpServletRequest.getSession().getId());
        servletLogger.reportLog("Request headers:");
        Object object2 = httpServletRequest.getHeaderNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string2 = httpServletRequest.getHeader((String)object);
            servletLogger.reportLog((String)object + "=" + string2);
        }
        object2 = httpServletRequest.getParameterMap();
        if (object2.isEmpty()) {
            servletLogger.reportLog("Request parameters: no parameters");
        } else {
            servletLogger.reportLog("Request parameters:");
            for (String string2 : object2.keySet()) {
                String[] stringArray = (String[])object2.get(string2);
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string2);
                stringBuilder.append("=");
                if (stringArray.length > 0) {
                    if (stringArray.length > 1) {
                        stringBuilder.append("{");
                        stringBuilder.append(stringArray[0]);
                        for (int i2 = 1; i2 < stringArray.length; ++i2) {
                            stringBuilder.append(",");
                            stringBuilder.append(stringArray[i2]);
                        }
                        stringBuilder.append("}");
                    } else {
                        stringBuilder.append(stringArray[0]);
                    }
                }
                servletLogger.reportLog(stringBuilder.toString());
            }
        }
        object = httpServletRequest.getContentType();
        servletLogger.reportLog("Request body: content-type " + (String)object);
        if (byArray != null) {
            string2 = new String(byArray);
            if (IscobolServletCall.isXmlContentType((String)object)) {
                string2 = ServletLogger.prettyPrint(string2);
            }
            servletLogger.reportLog(string2);
        }
        servletLogger.reportLog("");
    }

    private static boolean isXmlContentType(String string) {
        String[] stringArray;
        return string != null && (stringArray = string.split("\\/")).length > 1 && stringArray[1].startsWith("xml");
    }

    private static void logResponse(ServletLogger servletLogger, String string, boolean bl) {
        servletLogger.reportLog("Output Response generated at " + ServletLogger.reportTimestamp());
        if (bl) {
            string = ServletLogger.prettyPrint(string);
        }
        servletLogger.reportLog(string);
        servletLogger.reportLog("");
    }

    private void runSoap(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        String string;
        Object object;
        byte[] byArray = this.getInput(httpServletRequest);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            object = new SOAPEnvelopeParser(byteArrayInputStream);
            ((InputStream)byteArrayInputStream).reset();
            string = ((SOAPEnvelopeParser)object).getMethodName();
        }
        catch (Exception exception) {
            ServletLogger servletLogger = ServletLogger.getInstance("iscobol.soap.log", "iscobol.soap.log.folder", null, httpServletRequest.getSession().getId());
            if (servletLogger != null) {
                servletLogger.reportLog("======================================");
                servletLogger.reportLog(ServletLogger.reportTimestamp() + ": isCOBOL SOAP Exception: the SOAP envelope seems incorrect: " + exception.toString());
                String string2 = new String(byArray);
                servletLogger.reportLog("Input Request");
                servletLogger.reportLog("Request headers:");
                Enumeration enumeration = httpServletRequest.getHeaderNames();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = httpServletRequest.getHeader(string3);
                    servletLogger.reportLog(string3 + "=" + string4);
                }
                servletLogger.reportLog("Request body:");
                servletLogger.reportLog(ServletLogger.prettyPrint(string2));
                servletLogger.reportLog("======================================");
            }
            exception.printStackTrace();
            httpServletResponse.sendError(500, this.getFaultEnvelope("The SOAP envelope seems incorrect", exception.toString()));
            return;
        }
        object = ServletLogger.getInstance("iscobol.soap.log", "iscobol.soap.log.folder", string, httpServletRequest.getSession().getId());
        if (object != null) {
            IscobolServletCall.logRequest((ServletLogger)object, byArray, httpServletRequest);
        }
        String string5 = null;
        if (string != null && string.length() > 0) {
            try {
                string5 = this.go(string, byteArrayInputStream, httpServletRequest, httpServletResponse, null);
            }
            catch (Throwable throwable) {
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                throwable.printStackTrace(printWriter);
                printWriter.close();
                httpServletResponse.setStatus(500);
                string5 = this.getFaultEnvelope(throwable.getMessage(), stringWriter.toString());
                httpServletResponse.getWriter().println(string5);
            }
        } else {
            httpServletResponse.setStatus(500);
            string5 = this.getFaultEnvelope("Missing method to call", "The server wasn't able to find any method name in the SOAP envelope");
            httpServletResponse.getWriter().println(string5);
        }
        if (object != null && string5 != null) {
            IscobolServletCall.logResponse((ServletLogger)object, string5, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runDefault(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Charset charset) throws IOException, ServletException {
        int n2;
        int n3;
        int n4;
        String string;
        String string2;
        int n5;
        String string3 = httpServletRequest.getRequestURI();
        int n6 = string3.toLowerCase().indexOf(";jsessionid");
        if (n6 >= 0) {
            string3 = string3.substring(0, n6);
        }
        if ((n5 = (string2 = string3).lastIndexOf(47)) >= 0) {
            string2 = string2.substring(n5 + 1);
        }
        if ((string = (n4 = string2.indexOf(40) + 1) > 0 && string2.charAt(n3 = string2.length() - 1) == ')' ? string2.substring(n4, n3) : ((n2 = string2.indexOf(46)) > 0 ? string2.substring(0, n2) : string2)).length() > 0) {
            if (httpServletRequest.getParameter("wsdl") != null) {
                String string4 = Config.a("iscobol.soap.wsdl.location", null);
                if (string4 != null) {
                    if (new File(string4, string + ".wsdl").exists()) {
                        FileInputStream fileInputStream = new FileInputStream(string4 + File.separator + string + ".wsdl");
                        httpServletResponse.setHeader("Content-Disposition", "attachment; filename=" + string + ".wsdl");
                        try {
                            int n7;
                            while ((n7 = fileInputStream.read()) != -1) {
                                httpServletResponse.getWriter().write(n7);
                            }
                        }
                        finally {
                            if (fileInputStream != null) {
                                fileInputStream.close();
                            }
                            httpServletResponse.getWriter().close();
                        }
                    } else {
                        httpServletResponse.sendError(404, string + ".wsdl not found");
                    }
                }
            } else {
                Object object;
                ServletLogger servletLogger;
                block19: {
                    servletLogger = ServletLogger.getInstance("iscobol.rest.log", "iscobol.rest.log.folder", string, httpServletRequest.getSession().getId());
                    ByteArrayInputStream byteArrayInputStream = null;
                    if (servletLogger != null) {
                        object = this.getInput(httpServletRequest);
                        IscobolServletCall.logRequest(servletLogger, object, httpServletRequest);
                        if (object != null) {
                            byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                        }
                    }
                    object = null;
                    try {
                        object = this.go(string, byteArrayInputStream, httpServletRequest, httpServletResponse, charset);
                    }
                    catch (Throwable throwable) {
                        object = this.getError(throwable);
                        if (httpServletResponse.isCommitted()) break block19;
                        httpServletResponse.sendError(404, (String)object);
                    }
                }
                if (servletLogger != null && object != null) {
                    IscobolServletCall.logResponse(servletLogger, (String)object, false);
                }
            }
        } else {
            throw new IscobolRuntimeException(102, string3);
        }
    }

    private File getDir(String string) {
        int[] nArray = new int[1];
        File file = null;
        if (!(string == null || (file = new File(string = BaseFile.getFullPaths(string, nArray)[0])).isDirectory() && file.exists())) {
            file = null;
        }
        if (!(file != null || (string = System.getProperty("java.io.tmpdir")) == null || (file = new File(string)).isDirectory() && file.exists())) {
            file = null;
        }
        if (file == null) {
            file = new File(".");
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String go(String string, InputStream inputStream, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Charset charset) throws IOException, CallOverflowException, IscobolRuntimeException {
        Map map;
        String string2;
        Object object;
        Object object2;
        String string3 = null;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Object object3 = httpServletRequest.getHeaderNames();
        while (object3.hasMoreElements()) {
            object2 = (Cookie[])object3.nextElement();
            String string4 = httpServletRequest.getHeader((String)object2);
            hashMap.put(((String)object2).toLowerCase(), string4);
        }
        if (httpServletRequest.getMethod().equals("POST") || httpServletRequest.getMethod().equals("PUT")) {
            object2 = httpServletRequest.getContentType();
            if (((String)object2).startsWith("multipart/form-data")) {
                int n2 = Config.a(".http.upload.max_size", 0x100000);
                object = this.getDir(Config.a(".http.upload.directory", null));
                string2 = Config.a(".http.upload.prefix", null);
                MultipartRequest multipartRequest = new MultipartRequest(httpServletRequest, n2, (File)object, string2);
                object3 = multipartRequest.getParameterMap();
            } else {
                object3 = ((String)object2).startsWith("application/x-www-form-urlencoded") ? httpServletRequest.getParameterMap() : httpServletRequest.getParameterMap();
            }
        } else {
            object3 = new HashMap(httpServletRequest.getParameterMap());
            if (Config.b(".http.cookies_as_fields", false) && (object2 = httpServletRequest.getCookies()) != null) {
                for (int i2 = 0; i2 < ((Cookie[])object2).length; ++i2) {
                    object3.put(object2[i2].getName(), object2[i2].getValue());
                }
            }
        }
        boolean bl = Config.b(".http.stateless", false);
        if (inputStream == null) {
            inputStream = httpServletRequest.getInputStream();
        }
        object2 = new HTTPHandler((Map)object3, inputStream, hashMap, charset);
        ((HTTPHandler)object2).setMethod(httpServletRequest.getMethod());
        ((HTTPHandler)object2).setContentType(httpServletRequest.getContentType());
        ((HTTPHandler)object2).setRequest(httpServletRequest);
        ((HTTPHandler)object2).setResponse(httpServletResponse);
        ((HTTPHandler)object2).setSession(httpServletRequest.getSession());
        string2 = Config.a(".http.servlet.prefix", null);
        object = string2 == null ? new String(string) : string2.concat(string);
        boolean bl2 = false;
        try {
            RuntimeInfo.set(RuntimeEnvironmentType.J2EE);
            try {
                IsCobol._call((String)object, new Object[]{object2}, false, null, null);
            }
            catch (StopRunException stopRunException) {
                bl2 = true;
            }
            String string5 = ((HTTPHandler)object2).getOutputMimeType();
            int n3 = ((HTTPHandler)object2).getError();
            boolean bl3 = ((HTTPHandler)object2).isRedirect();
            if (bl3) {
                httpServletResponse.sendRedirect(((HTTPHandler)object2).getOutputMessage());
            } else if (n3 != 0) {
                httpServletResponse.sendError(n3, ((HTTPHandler)object2).getOutputMessage());
            } else {
                Object object4;
                Object object5;
                Object object6;
                httpServletResponse.setContentType(string5);
                map = ((HTTPHandler)object2).getOutHeader();
                if (map != null) {
                    object6 = map.entrySet();
                    object5 = object6.iterator();
                    while (object5.hasNext()) {
                        object4 = (Map.Entry)object5.next();
                        httpServletResponse.addHeader(object4.getKey().toString(), object4.getValue().toString());
                    }
                }
                if ((object6 = ((HTTPHandler)object2).getOutputBinaryFile()) != null) {
                    int n4;
                    object5 = httpServletResponse.getOutputStream();
                    object4 = new byte[1024];
                    while ((n4 = ((InputStream)object6).read((byte[])object4)) > 0) {
                        ((OutputStream)object5).write((byte[])object4, 0, n4);
                    }
                    ((InputStream)object6).close();
                } else {
                    object5 = httpServletResponse.getWriter();
                    object4 = ((HTTPHandler)object2).getOutputTextFile();
                    if (object4 != null) {
                        int n5;
                        char[] cArray = new char[512];
                        while ((n5 = ((Reader)object4).read(cArray)) > 0) {
                            ((PrintWriter)object5).write(cArray, 0, n5);
                        }
                        ((Reader)object4).close();
                    } else {
                        string3 = ((HTTPHandler)object2).getOutputMessage();
                        ((PrintWriter)object5).println(string3);
                    }
                }
            }
        }
        finally {
            HTTPHandler.remove();
            if (bl) {
                if (!bl2) {
                    com.iscobol.java.IsCobol.cancelAll();
                    Factory.stopRun(0, false);
                }
                IscobolSystem.destroyAndFinalizeEnv(Thread.currentThread());
            }
        }
        if (((HTTPHandler)object2).isSessionInvalidated()) {
            map = httpServletRequest.getSession();
            map.invalidate();
        }
        return string3;
    }

    private String getError(Throwable throwable) {
        if (throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        String string = throwable.getLocalizedMessage();
        if (string == null || string.length() == 0) {
            string = throwable.getClass().getName() + " caught!";
        }
        return string + "\n" + stringWriter.toString();
    }
}

