/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.webjakarta;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Factory;
import com.iscobol.rts.HTTPSessionInfo;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.webjakarta.IscobolFilter;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;

public class IscobolSessionListener
implements HttpSessionListener {
    private final Logger log;

    public IscobolSessionListener() {
        IscobolSystem.set(HTTPSessionInfo.class, new HTTPSessionInfo("IscobolSessionListener"));
        try {
            this.log = LoggerFactory.get(128);
        }
        finally {
            IscobolSystem.remove(HTTPSessionInfo.class);
        }
    }

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
        if (this.log != null) {
            HttpSession httpSession = httpSessionEvent.getSession();
            this.log.info("Session created: " + httpSession);
        }
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        HttpSession httpSession = httpSessionEvent.getSession();
        Object object = httpSession.getAttribute(IscobolFilter.attrName);
        IscobolSystem.setContext((IscobolSystem.Context)object);
        Factory.stopRun(0, false);
        if (this.log != null) {
            this.log.info("Session invalidated: " + httpSession);
        }
        IscobolSystem.unsetContext();
    }
}

