/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.webjakarta;

import com.iscobol.webjakarta.Part;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class MultipartRequest {
    private InputStream inp;
    private String boundary;
    private int eolToSkip;
    private int maxRead = 0x100000;
    private int readCnt = 0;
    private File directory;
    private String prefix;
    private boolean inRam = false;
    private String charset = "ISO-8859-1";
    Vector params = new Vector();
    byte[] buffer = new byte[65536];
    int bufPos = 0;
    int bufCnt = 0;

    public MultipartRequest(HttpServletRequest httpServletRequest, int n2, File file, String string) throws IOException {
        Part part;
        String string2 = httpServletRequest.getContentType();
        String string3 = httpServletRequest.getHeader("Content-Type");
        this.setCharset(httpServletRequest.getCharacterEncoding());
        this.maxRead = n2;
        this.directory = file;
        this.prefix = string;
        this.inRam = false;
        String string4 = string2 == null ? (string3 == null ? null : string3) : (string3 == null ? string2 : (string2.length() > string3.length() ? string2 : string3));
        if (!httpServletRequest.getMethod().equalsIgnoreCase("POST") || string4 != null && !string4.toLowerCase().startsWith("multipart/form-data")) {
            Enumeration enumeration = httpServletRequest.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String string5 = (String)enumeration.nextElement();
                String string6 = httpServletRequest.getParameter(string5);
                this.params.addElement(new Part(this, string5, string6));
            }
            return;
        }
        if (string4 == null) {
            throw new IOException("null content-type");
        }
        this.initFile((InputStream)httpServletRequest.getInputStream());
        int n3 = httpServletRequest.getContentLength();
        if (n3 > this.maxRead) {
            throw new IOException("Content length of " + n3 + " exceeds limit of " + this.maxRead);
        }
        int n4 = string4.lastIndexOf("boundary=");
        if (n4 == -1) {
            throw new IOException("Boundary not found");
        }
        this.boundary = string4.substring(n4 + 9);
        if (this.boundary.charAt(0) == '\"') {
            n4 = this.boundary.lastIndexOf(34);
            this.boundary = this.boundary.substring(1, n4);
        }
        this.boundary = "--" + this.boundary;
        String string7 = this.readLine();
        if (string7 == null) {
            throw new IOException("Corrupted form data: premature EOF");
        }
        if (!string7.startsWith(this.boundary)) {
            throw new IOException("Corrupted form data: missing boundary: " + string7 + " != " + this.boundary);
        }
        while ((part = this.nextPart()) != null) {
            this.params.addElement(part);
        }
    }

    public void setCharset(String string) {
        if (string != null) {
            try {
                "A".getBytes(string);
                this.charset = string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    public String getCharset() {
        return this.charset;
    }

    public Part getPart(String string) {
        Part part = null;
        if (string != null) {
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                Part part2 = (Part)enumeration.nextElement();
                if (!string.equals(part2.getName())) continue;
                part = part2;
                break;
            }
        }
        return part;
    }

    public Map getParameterMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        Enumeration enumeration = this.params.elements();
        while (enumeration.hasMoreElements()) {
            Part part = (Part)enumeration.nextElement();
            String string = part.getName();
            String string2 = part.getFileName() == null ? part.getValue() : part.getFullPathName();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public String getStringParameter(String string) {
        String string2 = null;
        if (string != null) {
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                Part part = (Part)enumeration.nextElement();
                if (!string.equals(part.getName()) || part.isFile()) continue;
                string2 = part.getValue();
                break;
            }
        }
        return string2;
    }

    public byte[] getBytesParameter(String string) {
        byte[] byArray = null;
        if (string != null) {
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                Part part = (Part)enumeration.nextElement();
                if (!string.equals(part.getName()) || !part.isFile()) continue;
                byArray = part.getBytes();
                if (byArray != null) break;
                InputStream inputStream = part.getInputStream();
                try {
                    inputStream.reset();
                    byArray = new byte[inputStream.available()];
                    inputStream.read(byArray);
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
                break;
            }
        }
        return byArray;
    }

    public Enumeration getParameterNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.params.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((Part)enumeration.nextElement()).getName());
        }
        return vector.elements();
    }

    private Part nextPart() throws IOException {
        Vector<String> vector = new Vector<String>();
        String string = this.readLine();
        if (string == null || string.length() == 0) {
            return null;
        }
        vector.addElement(string);
        while ((string = this.readLine()) != null && string.length() > 0) {
            vector.addElement(string);
        }
        if (string == null) {
            return null;
        }
        String string2 = null;
        String string3 = null;
        String string4 = "text/plain";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            String string5 = string.toLowerCase();
            if (string5.startsWith("content-disposition: ")) {
                if (!"form-data;".equals(string.substring(21, 31))) {
                    throw new IOException("Wrong Content-Disposition: " + string);
                }
                int n2 = string5.indexOf("name=\"", 31);
                int n3 = string5.indexOf("\"", n2 += 6);
                if (n2 < 6 || n3 < 0) {
                    throw new IOException("Wrong name in Content-Disposition:" + string);
                }
                string2 = string.substring(n2, n3);
                n2 = string5.indexOf("filename=\"", n3);
                n3 = string5.indexOf("\"", n2 += 10);
                if (n2 < 10 || n3 < 0) {
                    string3 = null;
                    continue;
                }
                string3 = string.substring(n2, n3);
                continue;
            }
            if (!string5.startsWith("content-type: ")) continue;
            if (string.length() > 14) {
                string4 = string.substring(14);
                continue;
            }
            throw new IOException("Wrong Content-Type:" + string);
        }
        return new Part(this, string2, string3, string4, this.boundary, this.inRam, this.directory, this.prefix);
    }

    private boolean read() throws IOException {
        boolean bl = false;
        this.bufCnt = this.inp.read(this.buffer);
        this.bufPos = 0;
        if (this.bufCnt > 0) {
            this.readCnt += this.bufCnt;
            bl = true;
        }
        if (this.readCnt > this.maxRead) {
            throw new IOException("real stream length > " + this.maxRead + " bytes");
        }
        return bl;
    }

    private void initFile(InputStream inputStream) throws IOException {
        this.inp = inputStream;
        if (!this.read()) {
            throw new IOException("void input stream");
        }
        int n2 = this.eol();
        if (n2 < 0) {
            throw new IOException("Corrupted input stream");
        }
        this.eolToSkip = this.buffer[n2 - 1] == 13 ? 1 : 0;
    }

    private int eol(int n2) {
        if ((n2 += this.bufPos) > this.bufCnt) {
            n2 = this.bufCnt;
        }
        for (int i2 = this.bufPos; i2 < n2; ++i2) {
            if (this.buffer[i2] != 10 || this.eolToSkip != 0 && (i2 <= 0 || this.buffer[i2 - 1] != 13)) continue;
            return i2;
        }
        return -1;
    }

    private int eol() {
        for (int i2 = this.bufPos; i2 < this.bufCnt; ++i2) {
            if (this.buffer[i2] != 10 || this.eolToSkip != 0 && (i2 <= 0 || this.buffer[i2 - 1] != 13)) continue;
            return i2;
        }
        return -1;
    }

    String readLine() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (this.bufCnt >= 0) {
            int n2 = this.eol();
            while (n2 < 0 && this.bufCnt >= 0) {
                if (this.bufCnt > this.bufPos) {
                    stringBuffer.append(new String(this.buffer, this.bufPos, this.bufCnt - this.bufPos));
                }
                this.read();
                n2 = this.eol();
            }
            if (n2 > this.bufPos + this.eolToSkip) {
                stringBuffer.append(new String(this.buffer, this.bufPos, n2 - this.bufPos - this.eolToSkip));
            }
            if (stringBuffer.length() > 0) {
                string = stringBuffer.toString();
            } else if (n2 == this.bufPos + this.eolToSkip) {
                string = "";
            }
            this.bufPos = n2 + 1;
        }
        return string;
    }

    int readLine(byte[] byArray, int n2, int n3) throws IOException {
        int n4 = 0;
        if (this.bufCnt >= 0) {
            int n5;
            int n6 = this.eol(n3);
            while (n3 > 0 && n6 < 0 && this.bufCnt >= 0) {
                n5 = this.bufCnt - this.bufPos;
                if (n5 > 0) {
                    if (n5 <= n3) {
                        System.arraycopy(this.buffer, this.bufPos, byArray, n2, n5);
                        this.read();
                        n4 += n5;
                        n2 += n5;
                        n3 -= n5;
                    } else {
                        System.arraycopy(this.buffer, this.bufPos, byArray, n2, n3);
                        n4 += n3;
                        n2 += n3;
                        this.bufPos += n3;
                        n3 = 0;
                    }
                } else {
                    this.read();
                }
                n6 = this.eol(n3);
            }
            n5 = n6 - this.bufPos + 1;
            if (n5 > 0) {
                if (n5 <= n3) {
                    System.arraycopy(this.buffer, this.bufPos, byArray, n2, n5);
                    n4 += n5;
                    this.bufPos += n5;
                } else {
                    System.arraycopy(this.buffer, this.bufPos, byArray, n2, n3);
                    n4 += n3;
                    this.bufPos += n3;
                }
            }
        }
        return n4;
    }

    int getEolToSkip() {
        return this.eolToSkip;
    }

    public void finalize() {
        if (this.params != null) {
            Enumeration enumeration = this.params.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    ((Part)enumeration.nextElement()).finalize();
                }
                catch (Throwable throwable) {}
            }
        }
        this.params = null;
    }
}

