/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import java.util.ArrayList;
import java.util.List;

public class BATree {
    private static final int ALIGN = 16;
    private static final int MASK = 65535;
    private final List<Node> btree = new ArrayList<Node>();

    private static int pack(int n2, int n3) {
        return n2 << 16 | n3 & 0xFFFF;
    }

    public static int unpackFrom(Node node) {
        return node.value >>> 16;
    }

    public static int unpackTo(Node node) {
        return node.value & 0xFFFF;
    }

    public void insert(int n2, int n3) {
        Node node;
        int n4 = BATree.pack(n2, n3);
        if (this.btree.size() == 0) {
            this.btree.add(new Node(n4));
            return;
        }
        int n5 = 0;
        while ((node = this.btree.get(n5)).value != n4) {
            if (node.value > n4) {
                if (node.left < 0) {
                    this.btree.add(new Node(n4));
                    node.left = this.btree.size() - 1;
                    break;
                }
                n5 = node.left;
                continue;
            }
            if (node.right < 0) {
                this.btree.add(new Node(n4));
                node.right = this.btree.size() - 1;
                break;
            }
            n5 = node.right;
        }
    }

    public Node get(int n2) {
        return this.btree.get(n2);
    }

    public int size() {
        return this.btree.size();
    }

    public static class Node {
        private final int value;
        private int left = -1;
        private int right = -1;

        public Node(int n2) {
            this.value = n2;
        }

        public int getLeft() {
            return this.left;
        }

        public int getRight() {
            return this.right;
        }
    }
}

