/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.BATree;
import com.veryant.cobol.compiler.EntryPoint;
import com.veryant.cobol.compiler.ErrorProcedures;
import com.veryant.cobol.compiler.Procedure;
import com.veryant.cobol.compiler.Section;
import com.veryant.cobol.compiler.Statements;
import com.veryant.cobol.compiler.stmts.AbstractStatement;
import com.veryant.cobol.compiler.stmts.CodeBlock;
import com.veryant.cobol.compiler.stmts.Exit;
import com.veryant.cobol.compiler.stmts.Go;
import com.veryant.cobol.compiler.stmts.Perform;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class Code {
    private static final int MAX_PROCEDURE_COUNT = 65535;
    private final LinkedList<CodeBlock> stack = new LinkedList();
    private CodeBlock code;
    private Section lastSection;
    private int proceduresCount = 0;
    private Procedure currentProcedure;
    private final List<Procedure> procedures = new ArrayList<Procedure>();
    private final List<EntryPoint> entryPoints = new ArrayList<EntryPoint>();
    private final ErrorProcedures errorProcedures = new ErrorProcedures();
    private final BATree declaratives = new BATree();
    private boolean goback;
    private int lastLongJumpId = 0;
    private LinkedRange[] linkedRanges;
    private int linkedRangesCount;

    private void clear() {
        this.stack.clear();
        this.code = null;
    }

    public void push(CodeBlock codeBlock) {
        this.stack.add(codeBlock);
        this.code = codeBlock;
    }

    public CodeBlock pop() {
        CodeBlock codeBlock = this.stack.removeLast();
        this.code = this.stack.getLast();
        return codeBlock;
    }

    public int size() {
        return this.stack.size();
    }

    public Section createSection() {
        this.lastSection = new Section();
        return this.lastSection;
    }

    public int getCurrentProcedureIndex() {
        return this.currentProcedure.getIndex();
    }

    public Procedure getProcedure(int n2) {
        return this.procedures.get(n2);
    }

    public Procedure createProcedure(CodeBlock codeBlock) {
        Procedure procedure = new Procedure(this.proceduresCount++, codeBlock);
        this.procedures.add(procedure);
        if (this.lastSection.getStart() < 0) {
            this.lastSection.setStart(procedure.getIndex());
        }
        this.lastSection.setEnd(procedure.getIndex());
        return procedure;
    }

    public void switchToProcedure(int n2) {
        this.currentProcedure = this.procedures.get(n2);
        this.clear();
        this.push(this.currentProcedure.getCode());
    }

    public void end(AbstractStatement abstractStatement) {
        this.createSection();
        Procedure procedure = this.createProcedure(new CodeBlock());
        this.switchToProcedure(procedure.getIndex());
        this.addStatement(abstractStatement);
    }

    public void addEntryPoint(EntryPoint entryPoint) {
        this.entryPoints.add(entryPoint);
    }

    public EntryPoint getEntryPoint(int n2) {
        return this.entryPoints.get(n2);
    }

    public int getEntryPointsCount() {
        return this.entryPoints.size();
    }

    public void addDeclaratives(int n2, int n3) {
        this.declaratives.insert(n2, n3);
        this.procedures.get(n3).setRetNeeded(true);
    }

    public boolean hasGoback() {
        return this.goback;
    }

    public Code addStatement(AbstractStatement abstractStatement) {
        if (abstractStatement.getStatement() == Statements.ENTRY) {
            System.out.println("--ENTRY--");
        } else if (this.code.isUnreachableState()) {
            this.code.addUnreachableStatement();
        } else {
            this.code.add(abstractStatement);
            switch (abstractStatement.getStatement()) {
                case PERFORM_JMP: {
                    Perform perform = (Perform)abstractStatement;
                    if (perform.getStart() < 0) break;
                    if (perform.getStart() <= perform.getEnd()) {
                        this.currentProcedure.addPerform(perform.getStart(), perform.getEnd());
                    } else {
                        this.currentProcedure.addPerform(perform.getStart(), 65535);
                    }
                    this.procedures.get(perform.getEnd()).setRetNeeded(true);
                    break;
                }
                case GO: {
                    Go go = (Go)abstractStatement;
                    for (int n2 : go.getTargets()) {
                        if (n2 < 0) continue;
                        this.currentProcedure.addGoto(n2);
                    }
                    if (go.hasDependingOn()) break;
                    this.code.setUnreachableState(true);
                    if (this.stack.size() != 1) break;
                    this.currentProcedure.setStopFlow(true);
                    go.setFallThroughEligible(true);
                    break;
                }
                case EXIT: {
                    Exit exit = (Exit)abstractStatement;
                    if (exit.getExitType() == Exit.ExitTypes.ExitParagraph) {
                        this.code.setUnreachableState(true);
                        if (this.stack.size() == 1) {
                            this.currentProcedure.setStopFlow(true);
                        }
                    }
                    if (exit.getExitType() != Exit.ExitTypes.ExitProgram) break;
                    this.goback = true;
                    break;
                }
                case GOBACK: {
                    this.goback = true;
                }
                case STOP: {
                    this.code.setUnreachableState(true);
                    if (this.stack.size() != 1) break;
                    this.currentProcedure.setStopFlow(true);
                }
            }
        }
        return this;
    }

    public int[] getJumpsMap() {
        int[] nArray = new int[this.proceduresCount];
        for (int i2 = 0; i2 < this.proceduresCount; ++i2) {
            nArray[i2] = this.procedures.get(i2).getRange();
        }
        return nArray;
    }

    public int[] getLongJumpsMap() {
        int[] nArray = new int[this.lastLongJumpId];
        if (this.lastLongJumpId > 0) {
            for (int i2 = 0; i2 < this.linkedRangesCount; ++i2) {
                int n2 = this.linkedRanges[i2].getLongJumpId();
                if (n2 <= 0) continue;
                nArray[n2 - 1] = i2;
            }
        }
        return nArray;
    }

    public void flowAnalysis() {
        BATree bATree = new BATree();
        BATree bATree2 = new BATree();
        this.collectRangesAndLinks(bATree, bATree2);
        this.linkedRangesCount = 0;
        ArrayList<LinkedRange> arrayList = new ArrayList<LinkedRange>();
        this.overlappingRangeAnalysis(bATree, arrayList, 0);
        if (bATree2.size() > 0) {
            this.crossJmpAnalysis(bATree2, arrayList, 0);
        }
        this.linkedRanges = arrayList.toArray(new LinkedRange[this.linkedRangesCount]);
    }

    private int checkStopFlow(int n2, int n3) {
        if (n3 >= this.proceduresCount) {
            n3 = this.proceduresCount - 1;
        }
        for (int i2 = n2; i2 < n3; ++i2) {
            Procedure procedure = this.procedures.get(i2);
            if (procedure.isStopFlow()) {
                return procedure.getIndex();
            }
            procedure.setSlideAllowed(true);
        }
        return n3;
    }

    private void addLink(BATree bATree, int n2, int n3) {
        bATree.insert(n2, n3);
    }

    private void addRange(BATree bATree, int n2, int n3) {
        bATree.insert(n2, n3);
        this.procedures.get(n2).setLabelNeeded(true);
    }

    private void collectRangesAndLinks(BATree bATree, BATree bATree2, int n2, int n3) {
        for (int i2 = n2; i2 <= n3; ++i2) {
            this.collectRangesAndLinks(bATree, bATree2, i2);
        }
    }

    private void collectRangesAndLinks(BATree bATree, BATree bATree2, int n2) {
        int n3;
        int n4;
        Procedure procedure = this.getProcedure(n2);
        if (procedure.isReached()) {
            return;
        }
        procedure.setReached(true);
        int n5 = procedure.getPerformsCount();
        for (n4 = 0; n4 < n5; ++n4) {
            BATree.Node node = procedure.getPerform(n4);
            int n6 = BATree.unpackFrom(node);
            n3 = this.checkStopFlow(n6, BATree.unpackTo(node));
            this.addRange(bATree, n6, n3);
            this.collectRangesAndLinks(bATree, bATree2, n6, n3);
        }
        n4 = procedure.getGotosCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            BATree.Node node = procedure.getGoto(i2);
            n3 = BATree.unpackFrom(node);
            int n7 = BATree.unpackTo(node);
            int n8 = this.checkStopFlow(n7, 65535);
            this.addRange(bATree, n7, n8);
            this.addLink(bATree2, n3, n7);
            this.collectRangesAndLinks(bATree, bATree2, n7, n8);
        }
    }

    private void collectRangesAndLinks(BATree bATree, BATree bATree2) {
        int n2;
        int n3 = this.getEntryPointsCount();
        for (n2 = 0; n2 < n3; ++n2) {
            int n4 = this.getEntryPoint(n2).getProcedureIndex();
            int n5 = this.checkStopFlow(n4, 65535);
            this.addRange(bATree, n4, n5);
            this.collectRangesAndLinks(bATree, bATree2, n4, n5);
        }
        n3 = this.declaratives.size();
        for (n2 = 0; n2 < n3; ++n2) {
            BATree.Node node = this.declaratives.get(n2);
            this.addRange(bATree, BATree.unpackFrom(node), BATree.unpackTo(node));
            this.collectRangesAndLinks(bATree, bATree2, BATree.unpackFrom(node), BATree.unpackTo(node));
        }
    }

    private void overlappingRangeAnalysis(BATree bATree, ArrayList<LinkedRange> arrayList, int n2) {
        if (n2 == -1) {
            return;
        }
        BATree.Node node = bATree.get(n2);
        this.overlappingRangeAnalysis(bATree, arrayList, node.getLeft());
        int n3 = BATree.unpackFrom(node);
        int n4 = BATree.unpackTo(node);
        if (this.linkedRangesCount == 0) {
            arrayList.add(new LinkedRange(n3, n4));
            this.assignRange(this.linkedRangesCount, n3, n4);
            ++this.linkedRangesCount;
        } else {
            LinkedRange linkedRange = arrayList.get(this.linkedRangesCount - 1);
            int n5 = linkedRange.from;
            int n6 = linkedRange.to;
            if (n3 > n6) {
                arrayList.add(new LinkedRange(n3, n4));
                this.assignRange(this.linkedRangesCount, n3, n4);
                ++this.linkedRangesCount;
            } else if (n4 > n6) {
                linkedRange.to = n4;
                this.assignRange(this.linkedRangesCount - 1, n6 + 1, n4);
            }
        }
        this.overlappingRangeAnalysis(bATree, arrayList, node.getRight());
    }

    private void crossJmpAnalysis(BATree bATree, ArrayList<LinkedRange> arrayList, int n2) {
        if (n2 == -1) {
            return;
        }
        BATree.Node node = bATree.get(n2);
        this.crossJmpAnalysis(bATree, arrayList, node.getLeft());
        Procedure procedure = this.procedures.get(BATree.unpackFrom(node));
        Procedure procedure2 = this.procedures.get(BATree.unpackTo(node));
        int n3 = procedure.getRange();
        int n4 = procedure2.getRange();
        if (n3 == n4) {
            arrayList.get(n3).setContainsShortJump(true);
        } else {
            arrayList.get(n3).addOutboundLink();
            arrayList.get(n4).addInboundLink();
        }
        this.crossJmpAnalysis(bATree, arrayList, node.getRight());
    }

    private void assignRange(int n2, int n3, int n4) {
        for (int i2 = n3; i2 <= n4; ++i2) {
            this.procedures.get(i2).setRange(n2);
        }
    }

    public int getProceduresCount() {
        return this.proceduresCount;
    }

    public ErrorProcedures getErrorProcedures() {
        return this.errorProcedures;
    }

    public int getLastLongJumpId() {
        return this.lastLongJumpId;
    }

    public LinkedRange[] getLinkedRanges() {
        return this.linkedRanges;
    }

    public int getLinkedRangesCount() {
        return this.linkedRangesCount;
    }

    public class LinkedRange {
        private final int from;
        private int to;
        private int inboundCount;
        private int outboundCount;
        private boolean containsShortJump;
        private boolean containsGoback;
        private int longJumpId;

        public LinkedRange(int n2, int n3) {
            this.from = n2;
            this.to = n3;
        }

        public boolean simpleProc() {
            return this.to - this.from == 0;
        }

        private void addInboundLink() {
            ++this.inboundCount;
            if (this.inboundCount == 1) {
                this.longJumpId = ++Code.this.lastLongJumpId;
            }
        }

        private void addOutboundLink() {
            ++this.outboundCount;
        }

        public int getFrom() {
            return this.from;
        }

        public int getTo() {
            return this.to;
        }

        public int getInboundCount() {
            return this.inboundCount;
        }

        public int getOutboundCount() {
            return this.outboundCount;
        }

        public boolean isContainsShortJump() {
            return this.containsShortJump;
        }

        public void setContainsShortJump(boolean bl) {
            this.containsShortJump = bl;
        }

        public boolean isContainsGoback() {
            return this.containsGoback;
        }

        public void setContainsGoback(boolean bl) {
            this.containsGoback = bl;
        }

        public int getLongJumpId() {
            return this.longJumpId;
        }
    }
}

