/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;

public class Codepage {
    private int ccsid;
    private Charset charset;
    private boolean ascii;

    public int getCcsid() {
        return this.ccsid;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public boolean isAscii() {
        return this.ascii;
    }

    public Codepage() {
        this(0);
    }

    public Codepage(int n2) {
        if (n2 > 0) {
            this.initCodepage(n2);
        } else {
            this.initCodepage(Charset.defaultCharset().name());
        }
    }

    private void initCodepage(int n2, String string, String[] stringArray, boolean bl) {
        this.ccsid = n2;
        this.ascii = bl;
        try {
            this.charset = Charset.forName(string);
        }
        catch (Exception exception) {
            for (String string2 : stringArray) {
                try {
                    this.charset = Charset.forName(string2);
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
        }
        if (this.charset == null) {
            throw new UnsupportedCharsetException(string);
        }
    }

    private void initCodepage(int n2) {
        int n3 = n2;
        switch (n2) {
            case 5348: {
                n3 = 1252;
                break;
            }
            case 4533: {
                n3 = 437;
                break;
            }
            case 8629: {
                n3 = 437;
                break;
            }
            case 12725: {
                n3 = 437;
                break;
            }
            case 16821: {
                n3 = 437;
                break;
            }
            case 20917: {
                n3 = 437;
                break;
            }
            case 4946: {
                n3 = 850;
                break;
            }
            case 33618: {
                n3 = 850;
                break;
            }
            case 61697: {
                n3 = 850;
                break;
            }
            case 61698: {
                n3 = 850;
                break;
            }
            case 4133: {
                n3 = 37;
                break;
            }
            case 8229: {
                n3 = 37;
                break;
            }
            case 12325: {
                n3 = 37;
                break;
            }
            case 16421: {
                n3 = 37;
                break;
            }
            case 20517: {
                n3 = 37;
                break;
            }
            case 24613: {
                n3 = 37;
                break;
            }
            case 32805: {
                n3 = 37;
                break;
            }
            case 4381: {
                n3 = 285;
                break;
            }
            case 4596: {
                n3 = 500;
                break;
            }
            case 8692: {
                n3 = 500;
                break;
            }
            case 12788: {
                n3 = 500;
                break;
            }
            case 16884: {
                n3 = 500;
                break;
            }
            case 20980: {
                n3 = 500;
                break;
            }
            case 25076: {
                n3 = 500;
                break;
            }
            case 29172: {
                n3 = 500;
                break;
            }
            case 33268: {
                n3 = 500;
                break;
            }
            case 37364: {
                n3 = 500;
                break;
            }
            case 41460: {
                n3 = 500;
                break;
            }
            case 45556: {
                n3 = 500;
                break;
            }
            case 49652: {
                n3 = 500;
                break;
            }
            case 53748: {
                n3 = 500;
                break;
            }
            case 61696: {
                n3 = 500;
                break;
            }
            case 61711: {
                n3 = 500;
                break;
            }
            case 61712: {
                n3 = 500;
                break;
            }
            case 4393: {
                n3 = 297;
                break;
            }
            case 8489: {
                n3 = 297;
                break;
            }
            case 4369: {
                n3 = 273;
                break;
            }
            case 4380: {
                n3 = 284;
                break;
            }
            case 8478: {
                n3 = 284;
                break;
            }
            case 4376: {
                n3 = 280;
                break;
            }
            case 4373: {
                n3 = 277;
                break;
            }
            case 4374: {
                n3 = 278;
                break;
            }
            case 4967: {
                n3 = 871;
                break;
            }
            case 954: {
                n3 = 5050;
                break;
            }
            case 9146: {
                n3 = 5050;
                break;
            }
            case 13242: {
                n3 = 5050;
                break;
            }
            case 33722: {
                n3 = 5050;
                break;
            }
            case 5028: {
                n3 = 932;
                break;
            }
            case 9124: {
                n3 = 932;
                break;
            }
            case 5137: {
                n3 = 1041;
                break;
            }
            case 5026: {
                n3 = 930;
                break;
            }
            case 9122: {
                n3 = 930;
                break;
            }
            case 13218: {
                n3 = 930;
                break;
            }
            case 17314: {
                n3 = 930;
                break;
            }
            case 33698: {
                n3 = 930;
                break;
            }
            case 5035: {
                n3 = 939;
                break;
            }
            case 9131: {
                n3 = 939;
                break;
            }
            case 5066: {
                n3 = 970;
                break;
            }
            case 5045: {
                n3 = 949;
                break;
            }
            case 5047: {
                n3 = 951;
                break;
            }
            case 5029: {
                n3 = 933;
                break;
            }
            case 9125: {
                n3 = 933;
                break;
            }
            case 13221: {
                n3 = 933;
                break;
            }
            case 5479: {
                n3 = 1383;
                break;
            }
            case 5211: {
                n3 = 1115;
                break;
            }
            case 5477: {
                n3 = 1381;
                break;
            }
            case 5482: {
                n3 = 1386;
                break;
            }
            case 5476: {
                n3 = 1380;
                break;
            }
            case 9572: {
                n3 = 1380;
                break;
            }
            case 5481: {
                n3 = 1385;
                break;
            }
            case 5031: {
                n3 = 935;
                break;
            }
            case 9127: {
                n3 = 935;
                break;
            }
            case 13223: {
                n3 = 935;
                break;
            }
            case 5484: {
                n3 = 1388;
                break;
            }
            case 1392: {
                n3 = 5488;
                break;
            }
            case 5060: {
                n3 = 964;
                break;
            }
            case 5046: {
                n3 = 950;
                break;
            }
            case 9142: {
                n3 = 950;
                break;
            }
            case 13238: {
                n3 = 950;
                break;
            }
            case 5033: {
                n3 = 937;
                break;
            }
            case 4948: {
                n3 = 852;
                break;
            }
            case 4966: {
                n3 = 870;
                break;
            }
            case 4951: {
                n3 = 855;
                break;
            }
            case 9047: {
                n3 = 855;
                break;
            }
            case 4965: {
                n3 = 869;
                break;
            }
            case 4960: {
                n3 = 864;
                break;
            }
            case 9056: {
                n3 = 864;
                break;
            }
            case 13152: {
                n3 = 864;
                break;
            }
            case 4516: {
                n3 = 420;
                break;
            }
            case 4953: {
                n3 = 857;
                break;
            }
            case 4520: {
                n3 = 424;
                break;
            }
            case 4964: {
                n3 = 868;
                break;
            }
            case 9060: {
                n3 = 868;
                break;
            }
            case 5014: {
                n3 = 918;
                break;
            }
            case 4970: {
                n3 = 874;
                break;
            }
            case 9066: {
                n3 = 874;
                break;
            }
            case 4934: {
                n3 = 838;
                break;
            }
            case 9030: {
                n3 = 838;
                break;
            }
            case 1258: {
                n3 = 1129;
                break;
            }
            case 13488: {
                n3 = 1200;
                break;
            }
            case 17584: {
                n3 = 1200;
                break;
            }
            case 61699: {
                n3 = 819;
                break;
            }
            case 61710: {
                n3 = 819;
                break;
            }
            case 5143: {
                n3 = 1047;
                break;
            }
            case 4397: {
                n3 = 301;
                break;
            }
            case 8493: {
                n3 = 301;
                break;
            }
            case 4993: {
                n3 = 897;
                break;
            }
            case 9089: {
                n3 = 897;
                break;
            }
            case 4386: {
                n3 = 290;
                break;
            }
            case 33058: {
                n3 = 290;
                break;
            }
            case 4396: {
                n3 = 300;
                break;
            }
            case 8492: {
                n3 = 300;
                break;
            }
            case 12588: {
                n3 = 300;
                break;
            }
            case 5123: {
                n3 = 1027;
                break;
            }
            case 8482: {
                n3 = 290;
                break;
            }
            case 16684: {
                n3 = 300;
                break;
            }
            case 4929: {
                n3 = 833;
                break;
            }
            case 9025: {
                n3 = 833;
                break;
            }
            case 9026: {
                n3 = 834;
                break;
            }
            case 4932: {
                n3 = 836;
                break;
            }
            case 9028: {
                n3 = 836;
                break;
            }
            case 837: {
                n3 = 4933;
                break;
            }
            case 927: {
                n3 = 5023;
                break;
            }
            case 4931: {
                n3 = 835;
                break;
            }
            case 9027: {
                n3 = 835;
                break;
            }
            case 5142: {
                n3 = 1046;
                break;
            }
            case 4952: {
                n3 = 856;
            }
        }
        switch (n2) {
            case 819: {
                this.initCodepage(n3, "ISO-8859-1", new String[]{"csisolatin1", "iso-ir-100", "iso8859-1", "ibm-819", "iso8859_1", "latin1", "8859-1", "ibm819", "iso-8859-1:1987", "Cp819", "l1"}, true);
                break;
            }
            case 923: {
                this.initCodepage(n3, "ISO-8859-15", new String[]{"l9", "ibm923", "csisolatin9", "iso8859-15", "ibm-923", "latin9", "iso8859_15", "Cp923", "iso8859_15_fdis", "latin0"}, true);
                break;
            }
            case 1051: {
                this.initCodepage(n3, "hp-roman8", new String[]{"Cp1051", "ibm-1051", "roman8", "r8"}, true);
                break;
            }
            case 1252: {
                this.initCodepage(n3, "windows-1252", new String[]{"Cp1252", "ibm-1252"}, true);
                break;
            }
            case 437: {
                this.initCodepage(n3, "IBM-437", new String[]{"Cp437", "cspc8codepage437", "ibm437"}, true);
                break;
            }
            case 850: {
                this.initCodepage(n3, "IBM-850", new String[]{"cspc850multilingual", "Cp850", "ibm850"}, true);
                break;
            }
            case 858: {
                this.initCodepage(n3, "IBM-858", new String[]{"Cp858", "ibm858"}, true);
                break;
            }
            case 37: {
                this.initCodepage(n3, "IBM-037", new String[]{"ibm-37"}, false);
                break;
            }
            case 1140: {
                this.initCodepage(n3, "IBM-1140", new String[]{"Cp1140", "ibm1140"}, false);
                break;
            }
            case 285: {
                this.initCodepage(n3, "IBM-285", new String[]{"Cp285", "ibm285"}, false);
                break;
            }
            case 1146: {
                this.initCodepage(n3, "IBM-1146", new String[]{"Cp1146", "ibm1146"}, false);
                break;
            }
            case 500: {
                this.initCodepage(n3, "IBM-500", new String[]{"ibm500", "Cp500"}, false);
                break;
            }
            case 924: {
                this.initCodepage(n3, "IBM-924", new String[]{"ibm924", "Cp924"}, false);
                break;
            }
            case 1148: {
                this.initCodepage(n3, "IBM-1148", new String[]{"Cp1148", "ibm1148"}, false);
                break;
            }
            case 297: {
                this.initCodepage(n3, "IBM-297", new String[]{"Cp297", "ibm297"}, false);
                break;
            }
            case 1147: {
                this.initCodepage(n3, "IBM-1147", new String[]{"Cp1147", "ibm1147"}, false);
                break;
            }
            case 273: {
                this.initCodepage(n3, "IBM-273", new String[]{"ibm273", "Cp273"}, false);
                break;
            }
            case 1141: {
                this.initCodepage(n3, "IBM-1141", new String[]{"Cp1141", "ibm1141"}, false);
                break;
            }
            case 284: {
                this.initCodepage(n3, "IBM-284", new String[]{"Cp284", "ibm284"}, false);
                break;
            }
            case 1145: {
                this.initCodepage(n3, "IBM-1145", new String[]{"ibm1145", "Cp1145"}, false);
                break;
            }
            case 280: {
                this.initCodepage(n3, "IBM-280", new String[]{"ibm280", "Cp280"}, false);
                break;
            }
            case 1144: {
                this.initCodepage(n3, "IBM-1144", new String[]{"Cp1144", "ibm1144"}, false);
                break;
            }
            case 277: {
                this.initCodepage(n3, "IBM-277", new String[]{"Cp277", "ibm277"}, false);
                break;
            }
            case 1142: {
                this.initCodepage(n3, "IBM-1142", new String[]{"Cp1142", "ibm1142"}, false);
                break;
            }
            case 278: {
                this.initCodepage(n3, "IBM-278", new String[]{"ibm278", "Cp278"}, false);
                break;
            }
            case 1143: {
                this.initCodepage(n3, "IBM-1143", new String[]{"ibm1143", "Cp1143"}, false);
                break;
            }
            case 871: {
                this.initCodepage(n3, "IBM-871", new String[]{"Cp871", "ibm871"}, false);
                break;
            }
            case 1149: {
                this.initCodepage(n3, "IBM-1149", new String[]{"Cp1149", "ibm1149"}, false);
                break;
            }
            case 5050: {
                this.initCodepage(n3, "IBM-33722", new String[]{"Cp5050", "5050"}, true);
                break;
            }
            case 932: {
                this.initCodepage(n3, "IBM-932", new String[]{"Cp932", "ibm932", "windows-31j", "MS932", "windows-932", "csWindows31J"}, true);
                break;
            }
            case 942: {
                this.initCodepage(n3, "IBM-942", new String[]{"ibm942", "Cp942"}, true);
                break;
            }
            case 943: {
                this.initCodepage(n3, "IBM-943", new String[]{"ibm943", "Cp943", "IBM-943C", "Cp943C"}, true);
                break;
            }
            case 1041: {
                this.initCodepage(n3, "IBM-1041", new String[]{"Cp1041", "ibm1041"}, true);
                break;
            }
            case 930: {
                this.initCodepage(n3, "IBM-930", new String[]{"Cp5026", "5026"}, false);
                break;
            }
            case 939: {
                this.initCodepage(n3, "IBM-939", new String[]{"5035", "Cp5035"}, false);
                break;
            }
            case 1390: {
                this.initCodepage(n3, "IBM-1390", new String[]{"Cp1390", "ibm1390"}, false);
                break;
            }
            case 1399: {
                this.initCodepage(n3, "IBM-1399", new String[]{"Cp1399", "ibm1399"}, false);
                break;
            }
            case 970: {
                this.initCodepage(n3, "EUC-KR", new String[]{"5601", "ksc5601_1987", "ksc_5601", "ibm-euckr", "ksc5601-1987", "ibm-970", "euc_kr", "Cp970", "ks_c_5601-1987", "euckr"}, true);
                break;
            }
            case 949: {
                this.initCodepage(n3, "IBM-949", new String[]{"Cp949", "ibm949"}, true);
                break;
            }
            case 951: {
                this.initCodepage(n3, "IBM-951", new String[]{"Cp951", "ibm951"}, true);
                break;
            }
            case 1088: {
                this.initCodepage(n3, "IBM-1088", new String[]{"Cp1088", "ibm1088"}, true);
                break;
            }
            case 933: {
                this.initCodepage(n3, "IBM-933", new String[]{"Cp933", "ibm933"}, false);
                break;
            }
            case 1363: {
                this.initCodepage(n3, "IBM-1363", new String[]{"Cp1363", "ibm1363"}, true);
                break;
            }
            case 1362: {
                this.initCodepage(n3, "IBM-1362", new String[]{"5458"}, true);
                break;
            }
            case 1364: {
                this.initCodepage(n3, "IBM-1364", new String[]{"ibm1364", "Cp1364"}, false);
                break;
            }
            case 1383: {
                this.initCodepage(n3, "IBM-1383", new String[]{"Cp1383", "ibm1383"}, true);
                break;
            }
            case 1114: {
                this.initCodepage(n3, "IBM-1114", new String[]{"Cp1114", "ibm1114"}, true);
                break;
            }
            case 1115: {
                this.initCodepage(n3, "IBM-1115", new String[]{"Cp1115", "ibm1115"}, true);
                break;
            }
            case 1381: {
                this.initCodepage(n3, "IBM-1381", new String[]{"Cp1381", "ibm1381"}, true);
                break;
            }
            case 1386: {
                this.initCodepage(n3, "GBK", new String[]{"GBK", "Cp1386", "ibm1386"}, true);
                break;
            }
            case 1380: {
                this.initCodepage(n3, "IBM-1380", new String[]{"ibm1380", "Cp1380"}, true);
                break;
            }
            case 1385: {
                this.initCodepage(n3, "IBM-1385", new String[]{"Cp1385", "ibm1385"}, true);
                break;
            }
            case 935: {
                this.initCodepage(n3, "IBM-935", new String[]{"Cp935", "ibm935"}, false);
                break;
            }
            case 1388: {
                this.initCodepage(n3, "IBM-1388", new String[]{"ibm1388", "Cp1388"}, false);
                break;
            }
            case 4933: {
                this.initCodepage(n3, "IBM-837", new String[]{"9029", "4933"}, false);
                break;
            }
            case 5488: {
                this.initCodepage(n3, "GB18030", new String[]{"windows-54936", "ibm-1392", "gb18030-2000"}, false);
                break;
            }
            case 964: {
                this.initCodepage(n3, "IBM-964", new String[]{"Cp964", "ibm-euctw"}, true);
                break;
            }
            case 947: {
                this.initCodepage(n3, "IBM-947", new String[]{"ibm947", "Cp947"}, true);
                break;
            }
            case 950: {
                this.initCodepage(n3, "windows-950", new String[]{"MS950", "x-windows-950", "MS950"}, true);
                break;
            }
            case 937: {
                this.initCodepage(n3, "IBM-937", new String[]{"Cp937", "ibm937"}, false);
                break;
            }
            case 912: {
                this.initCodepage(n3, "ISO-8859-2", new String[]{"ibm912", "l2", "ibm-912", "iso-ir-101", "csisolatin2", "iso-8859-2:1987", "latin2", "iso8859_2", "Cp912", "iso8859-2", "8859-2"}, true);
                break;
            }
            case 1250: {
                this.initCodepage(n3, "windows-1250", new String[]{"ibm-1250", "Cp1250"}, true);
                break;
            }
            case 852: {
                this.initCodepage(n3, "IBM-852", new String[]{"Cp852", "cspcp852", "ibm852"}, true);
                break;
            }
            case 870: {
                this.initCodepage(n3, "IBM-870", new String[]{"Cp870", "ibm870"}, false);
                break;
            }
            case 915: {
                this.initCodepage(n3, "ISO-8859-5", new String[]{"iso8859_5", "8859-5", "ibm915", "iso-8859-5:1988", "csisolatincyrillic", "cyrillic", "Cp915", "iso-ir-144", "iso8859-5", "ibm-915"}, true);
                break;
            }
            case 1251: {
                this.initCodepage(n3, "windows-1251", new String[]{"ibm-1251", "Cp1251"}, true);
                break;
            }
            case 855: {
                this.initCodepage(n3, "IBM-855", new String[]{"Cp855", "ibm855"}, true);
                break;
            }
            case 866: {
                this.initCodepage(n3, "IBM-866", new String[]{"Cp866", "ibm866"}, true);
                break;
            }
            case 1025: {
                this.initCodepage(n3, "IBM-1025", new String[]{"ibm1025", "Cp1025"}, false);
                break;
            }
            case 878: {
                this.initCodepage(n3, "KOI8-R", new String[]{"ibm-878", "cskoi8r", "koi8", "koi8_r"}, true);
                break;
            }
            case 813: {
                this.initCodepage(n3, "ISO-8859-7", new String[]{"iso-8859-7:1987", "Cp813", "8859-7", "iso-ir-126", "ibm-813", "iso8859_7", "ecma-118", "greek8", "ibm813", "elot-928", "csisolatingreek", "iso8859-7", "greek"}, true);
                break;
            }
            case 1253: {
                this.initCodepage(n3, "windows-1253", new String[]{"Cp1253", "ibm-1253"}, true);
                break;
            }
            case 869: {
                this.initCodepage(n3, "IBM-869", new String[]{"Cp869", "ibm869"}, true);
                break;
            }
            case 875: {
                this.initCodepage(n3, "IBM-875", new String[]{"Cp875", "ibm875"}, false);
                break;
            }
            case 1089: {
                this.initCodepage(n3, "ISO-8859-6", new String[]{"iso-ir-127", "csisolatinarabic", "iso8859-6", "ibm1089", "ecma-114", "asmo-708", "arabic", "ibm-1089", "iso8859_6", "8859-6", "Cp1089", "iso-8859-6:1987"}, true);
                break;
            }
            case 1256: {
                this.initCodepage(n3, "windows-1256", new String[]{"Cp1256", "ibm-1256"}, true);
                break;
            }
            case 864: {
                this.initCodepage(n3, "IBM-864", new String[]{"ibm864", "Cp864"}, true);
                break;
            }
            case 420: {
                this.initCodepage(n3, "IBM-420", new String[]{"Cp420", "ibm420"}, false);
                break;
            }
            case 720: {
                this.initCodepage(n3, "IBM-720", new String[]{"Cp720", "ibm720"}, true);
                break;
            }
            case 920: {
                this.initCodepage(n3, "ISO-8859-9", new String[]{"Cp920", "latin5", "iso-ir-148", "8859-9", "l5", "csisolatin5", "ibm-920", "ibm920", "iso8859_9", "iso8859-9"}, true);
                break;
            }
            case 1254: {
                this.initCodepage(n3, "windows-1254", new String[]{"Cp1254", "ibm-1254"}, true);
                break;
            }
            case 857: {
                this.initCodepage(n3, "IBM-857", new String[]{"csibm857", "ibm857", "Cp857"}, true);
                break;
            }
            case 1026: {
                this.initCodepage(n3, "IBM-1026", new String[]{"Cp1026", "ibm1026"}, false);
                break;
            }
            case 1098: {
                this.initCodepage(n3, "IBM-1098", new String[]{"Cp1098", "ibm1098"}, true);
                break;
            }
            case 1097: {
                this.initCodepage(n3, "IBM-1097", new String[]{"Cp1097", "ibm1097"}, false);
                break;
            }
            case 916: {
                this.initCodepage(n3, "ISO-8859-8", new String[]{"iso-ir-138", "iso8859-8", "ibm-916", "iso8859_8", "csisolatinhebrew", "hebrew", "iso-8859-8:1988", "ibm916", "Cp916", "8859-8"}, true);
                break;
            }
            case 1255: {
                this.initCodepage(n3, "windows-1255", new String[]{"Cp1255", "ibm-1255"}, true);
                break;
            }
            case 862: {
                this.initCodepage(n3, "IBM-862", new String[]{"Cp862", "ibm862"}, true);
                break;
            }
            case 867: {
                this.initCodepage(n3, "IBM-867", new String[]{"Cp867", "ibm867"}, true);
                break;
            }
            case 424: {
                this.initCodepage(n3, "IBM-424", new String[]{"ibm424", "Cp424"}, false);
                break;
            }
            case 921: {
                this.initCodepage(n3, "IBM-921", new String[]{"ibm921", "Cp921"}, true);
                break;
            }
            case 922: {
                this.initCodepage(n3, "IBM-922", new String[]{"Cp922", "ibm922"}, true);
                break;
            }
            case 1124: {
                this.initCodepage(n3, "IBM-1124", new String[]{"Cp1124", "ibm1124"}, true);
                break;
            }
            case 1257: {
                this.initCodepage(n3, "windows-1257", new String[]{"Cp1257", "ibm-1257"}, true);
                break;
            }
            case 1112: {
                this.initCodepage(n3, "IBM-1112", new String[]{"Cp1112", "ibm1112"}, false);
                break;
            }
            case 1122: {
                this.initCodepage(n3, "IBM-1122", new String[]{"Cp1122", "ibm1122"}, false);
                break;
            }
            case 1123: {
                this.initCodepage(n3, "IBM-1123", new String[]{"Cp1123", "ibm1123"}, false);
                break;
            }
            case 775: {
                this.initCodepage(n3, "IBM-775", new String[]{"ibm775", "Cp775"}, true);
                break;
            }
            case 1006: {
                this.initCodepage(n3, "IBM-1006", new String[]{"ibm1006", "Cp1006"}, true);
                break;
            }
            case 868: {
                this.initCodepage(n3, "IBM-868", new String[]{"Cp868", "ibm868"}, true);
                break;
            }
            case 918: {
                this.initCodepage(n3, "IBM-918", new String[]{"ibm918", "Cp918"}, false);
                break;
            }
            case 874: {
                this.initCodepage(n3, "IBM-874", new String[]{"ibm874", "Cp874"}, true);
                break;
            }
            case 838: {
                this.initCodepage(n3, "IBM-838", new String[]{"Cp838", "ibm838"}, false);
                break;
            }
            case 1129: {
                this.initCodepage(n3, "windows-1258", new String[]{"Cp1258", "ibm-1258", "ibm-1129", "ibm-1163"}, true);
                break;
            }
            case 806: {
                this.initCodepage(n3, "ISCII91", new String[]{"iscii"}, true);
                break;
            }
            case 1200: {
                this.initCodepage(n3, "UTF-16BE", new String[]{"Unicode", "UTF16", "UTF_16", "UCS-2"}, false);
                break;
            }
            case 1208: {
                this.initCodepage(n3, "UTF-8", new String[]{"UTF_8", "UTF8"}, true);
                break;
            }
            case 367: {
                this.initCodepage(n3, "US-ASCII", new String[]{"iso-646.irv:1983", "ISO646-US", "ASCII", "default", "ISO-646.irv:1991", "direct", "ascii7", "ANSI_X3.4-1986", "iso-ir-6", "us", "ibm-367", "646", "csASCII", "ANSI_X3.4-1968", "Cp367"}, true);
                break;
            }
            case 1275: {
                this.initCodepage(n3, "MacRoman", new String[]{"ibm-1275"}, true);
                break;
            }
            case 1047: {
                this.initCodepage(n3, "IBM-1047", new String[]{"Cp1047", "ibm1047"}, false);
                break;
            }
            case 913: {
                this.initCodepage(n3, "ISO-8859-3", new String[]{"iso-8859-3:1988", "csisolatin3", "iso8859_3", "8859-3", "iso8859-3", "Cp913", "iso-ir-109", "ibm-913", "l3", "latin3"}, true);
                break;
            }
            case 863: {
                this.initCodepage(n3, "IBM-863", new String[]{"ibm863", "Cp863"}, true);
                break;
            }
            case 861: {
                this.initCodepage(n3, "IBM-861", new String[]{"Cp861", "ibm861"}, true);
                break;
            }
            case 865: {
                this.initCodepage(n3, "IBM-865", new String[]{"Cp865", "ibm865"}, true);
                break;
            }
            case 860: {
                this.initCodepage(n3, "IBM-860", new String[]{"ibm860", "Cp860"}, true);
                break;
            }
            case 301: {
                this.initCodepage(n3, "IBM-301", new String[]{"8493", "4397", "24877"}, true);
                break;
            }
            case 897: {
                this.initCodepage(n3, "IBM-897", new String[]{"Cp897", "ibm897"}, true);
                break;
            }
            case 1351: {
                this.initCodepage(n3, "IBM-1351", new String[]{"Cp1351", "ibm1351"}, true);
                break;
            }
            case 290: {
                this.initCodepage(n3, "IBM-290", new String[]{"12578", "8482", "4386"}, false);
                break;
            }
            case 300: {
                this.initCodepage(n3, "IBM-300", new String[]{"4396", "12588", "8492", "16684"}, false);
                break;
            }
            case 1027: {
                this.initCodepage(n3, "IBM-1027", new String[]{"5123"}, false);
                break;
            }
            case 833: {
                this.initCodepage(n3, "IBM-833", new String[]{"13121", "9025", "4929"}, false);
                break;
            }
            case 834: {
                this.initCodepage(n3, "IBM-834", new String[]{"13122", "9026", "4930"}, false);
                break;
            }
            case 936: {
                this.initCodepage(n3, "windows-936", new String[]{"MS936", "936", "x-mswin-936"}, true);
                break;
            }
            case 836: {
                this.initCodepage(n3, "IBM-836", new String[]{"9028", "4932", "13124"}, false);
                break;
            }
            case 5023: {
                this.initCodepage(n3, "IBM-927", new String[]{"ibm927", "Cp927"}, true);
                break;
            }
            case 948: {
                this.initCodepage(n3, "IBM-948", new String[]{"ibm948", "Cp948"}, true);
                break;
            }
            case 1043: {
                this.initCodepage(n3, "IBM-1043", new String[]{"Cp1043", "ibm1043"}, true);
                break;
            }
            case 835: {
                this.initCodepage(n3, "IBM-835", new String[]{"4931", "9027"}, false);
                break;
            }
            case 1370: {
                this.initCodepage(n3, "IBM-1370", new String[]{"Cp1370", "ibm1370"}, true);
                break;
            }
            case 1371: {
                this.initCodepage(n3, "IBM-1371", new String[]{"Cp1371", "ibm1371"}, false);
                break;
            }
            case 1282: {
                this.initCodepage(n3, "MacCentralEurope", new String[]{"ibm-1282"}, true);
                break;
            }
            case 1284: {
                this.initCodepage(n3, "MacCroatian", new String[]{"ibm-1284"}, true);
                break;
            }
            case 1285: {
                this.initCodepage(n3, "MacRomania", new String[]{"ibm-1285"}, true);
                break;
            }
            case 1283: {
                this.initCodepage(n3, "MacCyrillic", new String[]{"ibm-1283"}, true);
                break;
            }
            case 1280: {
                this.initCodepage(n3, "MacGreek", new String[]{"ibm-1280"}, true);
                break;
            }
            case 737: {
                this.initCodepage(n3, "IBM-737", new String[]{"ibm737", "Cp737"}, true);
                break;
            }
            case 1046: {
                this.initCodepage(n3, "IBM-1046", new String[]{"ibm1046", "Cp1046"}, true);
                break;
            }
            case 1281: {
                this.initCodepage(n3, "MacTurkish", new String[]{"ibm-1281"}, true);
                break;
            }
            case 856: {
                this.initCodepage(n3, "IBM-856", new String[]{"Cp856", "ibm856"}, true);
                break;
            }
            default: {
                throw new UnsupportedCharsetException("" + n2);
            }
        }
    }

    private void initCodepage(String string) {
        switch (string) {
            case "ISO-8859-1": {
                this.initCodepage(819);
                break;
            }
            case "ISO-8859-15": {
                this.initCodepage(923);
                break;
            }
            case "hp-roman8": {
                this.initCodepage(1051);
                break;
            }
            case "windows-1252": {
                this.initCodepage(1252);
                break;
            }
            case "IBM-437": {
                this.initCodepage(437);
                break;
            }
            case "IBM-850": {
                this.initCodepage(850);
                break;
            }
            case "IBM-858": {
                this.initCodepage(858);
                break;
            }
            case "IBM-037": {
                this.initCodepage(37);
                break;
            }
            case "IBM-1140": {
                this.initCodepage(1140);
                break;
            }
            case "IBM-285": {
                this.initCodepage(285);
                break;
            }
            case "IBM-1146": {
                this.initCodepage(1146);
                break;
            }
            case "IBM-500": {
                this.initCodepage(500);
                break;
            }
            case "IBM-924": {
                this.initCodepage(924);
                break;
            }
            case "IBM-1148": {
                this.initCodepage(1148);
                break;
            }
            case "IBM-297": {
                this.initCodepage(297);
                break;
            }
            case "IBM-1147": {
                this.initCodepage(1147);
                break;
            }
            case "IBM-273": {
                this.initCodepage(273);
                break;
            }
            case "IBM-1141": {
                this.initCodepage(1141);
                break;
            }
            case "IBM-284": {
                this.initCodepage(284);
                break;
            }
            case "IBM-1145": {
                this.initCodepage(1145);
                break;
            }
            case "IBM-280": {
                this.initCodepage(280);
                break;
            }
            case "IBM-1144": {
                this.initCodepage(1144);
                break;
            }
            case "IBM-277": {
                this.initCodepage(277);
                break;
            }
            case "IBM-1142": {
                this.initCodepage(1142);
                break;
            }
            case "IBM-278": {
                this.initCodepage(278);
                break;
            }
            case "IBM-1143": {
                this.initCodepage(1143);
                break;
            }
            case "IBM-871": {
                this.initCodepage(871);
                break;
            }
            case "IBM-1149": {
                this.initCodepage(1149);
                break;
            }
            case "IBM-33722": {
                this.initCodepage(5050);
                break;
            }
            case "IBM-932": {
                this.initCodepage(932);
                break;
            }
            case "IBM-942": {
                this.initCodepage(942);
                break;
            }
            case "IBM-943": {
                this.initCodepage(943);
                break;
            }
            case "IBM-1041": {
                this.initCodepage(1041);
                break;
            }
            case "IBM-930": {
                this.initCodepage(930);
                break;
            }
            case "IBM-939": {
                this.initCodepage(939);
                break;
            }
            case "IBM-1390": {
                this.initCodepage(1390);
                break;
            }
            case "IBM-1399": {
                this.initCodepage(1399);
                break;
            }
            case "EUC-KR": {
                this.initCodepage(970);
                break;
            }
            case "IBM-949": {
                this.initCodepage(949);
                break;
            }
            case "IBM-951": {
                this.initCodepage(951);
                break;
            }
            case "IBM-1088": {
                this.initCodepage(1088);
                break;
            }
            case "IBM-933": {
                this.initCodepage(933);
                break;
            }
            case "IBM-1363": {
                this.initCodepage(1363);
                break;
            }
            case "IBM-1362": {
                this.initCodepage(1362);
                break;
            }
            case "IBM-1364": {
                this.initCodepage(1364);
                break;
            }
            case "IBM-1383": {
                this.initCodepage(1383);
                break;
            }
            case "IBM-1114": {
                this.initCodepage(1114);
                break;
            }
            case "IBM-1115": {
                this.initCodepage(1115);
                break;
            }
            case "IBM-1381": {
                this.initCodepage(1381);
                break;
            }
            case "GBK": {
                this.initCodepage(1386);
                break;
            }
            case "IBM-1380": {
                this.initCodepage(1380);
                break;
            }
            case "IBM-1385": {
                this.initCodepage(1385);
                break;
            }
            case "IBM-935": {
                this.initCodepage(935);
                break;
            }
            case "IBM-1388": {
                this.initCodepage(1388);
                break;
            }
            case "IBM-837": {
                this.initCodepage(4933);
                break;
            }
            case "GB18030": {
                this.initCodepage(5488);
                break;
            }
            case "IBM-964": {
                this.initCodepage(964);
                break;
            }
            case "IBM-947": {
                this.initCodepage(947);
                break;
            }
            case "windows-950": {
                this.initCodepage(950);
                break;
            }
            case "IBM-937": {
                this.initCodepage(937);
                break;
            }
            case "ISO-8859-2": {
                this.initCodepage(912);
                break;
            }
            case "windows-1250": {
                this.initCodepage(1250);
                break;
            }
            case "IBM-852": {
                this.initCodepage(852);
                break;
            }
            case "IBM-870": {
                this.initCodepage(870);
                break;
            }
            case "ISO-8859-5": {
                this.initCodepage(915);
                break;
            }
            case "windows-1251": {
                this.initCodepage(1251);
                break;
            }
            case "IBM-855": {
                this.initCodepage(855);
                break;
            }
            case "IBM-866": {
                this.initCodepage(866);
                break;
            }
            case "IBM-1025": {
                this.initCodepage(1025);
                break;
            }
            case "KOI8-R": {
                this.initCodepage(878);
                break;
            }
            case "ISO-8859-7": {
                this.initCodepage(813);
                break;
            }
            case "windows-1253": {
                this.initCodepage(1253);
                break;
            }
            case "IBM-869": {
                this.initCodepage(869);
                break;
            }
            case "IBM-875": {
                this.initCodepage(875);
                break;
            }
            case "ISO-8859-6": {
                this.initCodepage(1089);
                break;
            }
            case "windows-1256": {
                this.initCodepage(1256);
                break;
            }
            case "IBM-864": {
                this.initCodepage(864);
                break;
            }
            case "IBM-420": {
                this.initCodepage(420);
                break;
            }
            case "IBM-720": {
                this.initCodepage(720);
                break;
            }
            case "ISO-8859-9": {
                this.initCodepage(920);
                break;
            }
            case "windows-1254": {
                this.initCodepage(1254);
                break;
            }
            case "IBM-857": {
                this.initCodepage(857);
                break;
            }
            case "IBM-1026": {
                this.initCodepage(1026);
                break;
            }
            case "IBM-1098": {
                this.initCodepage(1098);
                break;
            }
            case "IBM-1097": {
                this.initCodepage(1097);
                break;
            }
            case "ISO-8859-8": {
                this.initCodepage(916);
                break;
            }
            case "windows-1255": {
                this.initCodepage(1255);
                break;
            }
            case "IBM-862": {
                this.initCodepage(862);
                break;
            }
            case "IBM-867": {
                this.initCodepage(867);
                break;
            }
            case "IBM-424": {
                this.initCodepage(424);
                break;
            }
            case "IBM-921": {
                this.initCodepage(921);
                break;
            }
            case "IBM-922": {
                this.initCodepage(922);
                break;
            }
            case "IBM-1124": {
                this.initCodepage(1124);
                break;
            }
            case "windows-1257": {
                this.initCodepage(1257);
                break;
            }
            case "IBM-1112": {
                this.initCodepage(1112);
                break;
            }
            case "IBM-1122": {
                this.initCodepage(1122);
                break;
            }
            case "IBM-1123": {
                this.initCodepage(1123);
                break;
            }
            case "IBM-775": {
                this.initCodepage(775);
                break;
            }
            case "IBM-1006": {
                this.initCodepage(1006);
                break;
            }
            case "IBM-868": {
                this.initCodepage(868);
                break;
            }
            case "IBM-918": {
                this.initCodepage(918);
                break;
            }
            case "IBM-874": {
                this.initCodepage(874);
                break;
            }
            case "IBM-838": {
                this.initCodepage(838);
                break;
            }
            case "windows-1258": {
                this.initCodepage(1129);
                break;
            }
            case "ISCII91": {
                this.initCodepage(806);
                break;
            }
            case "UTF-16": {
                this.initCodepage(1200);
                break;
            }
            case "UTF-8": {
                this.initCodepage(1208);
                break;
            }
            case "US-ASCII": {
                this.initCodepage(367);
                break;
            }
            case "MacRoman": {
                this.initCodepage(1275);
                break;
            }
            case "IBM-1047": {
                this.initCodepage(1047);
                break;
            }
            case "ISO-8859-3": {
                this.initCodepage(913);
                break;
            }
            case "IBM-863": {
                this.initCodepage(863);
                break;
            }
            case "IBM-861": {
                this.initCodepage(861);
                break;
            }
            case "IBM-865": {
                this.initCodepage(865);
                break;
            }
            case "IBM-860": {
                this.initCodepage(860);
                break;
            }
            case "IBM-301": {
                this.initCodepage(301);
                break;
            }
            case "IBM-897": {
                this.initCodepage(897);
                break;
            }
            case "IBM-1351": {
                this.initCodepage(1351);
                break;
            }
            case "IBM-290": {
                this.initCodepage(290);
                break;
            }
            case "IBM-300": {
                this.initCodepage(300);
                break;
            }
            case "IBM-1027": {
                this.initCodepage(1027);
                break;
            }
            case "IBM-833": {
                this.initCodepage(833);
                break;
            }
            case "IBM-834": {
                this.initCodepage(834);
                break;
            }
            case "windows-936": {
                this.initCodepage(936);
                break;
            }
            case "IBM-836": {
                this.initCodepage(836);
                break;
            }
            case "IBM-927": {
                this.initCodepage(5023);
                break;
            }
            case "IBM-948": {
                this.initCodepage(948);
                break;
            }
            case "IBM-1043": {
                this.initCodepage(1043);
                break;
            }
            case "IBM-835": {
                this.initCodepage(835);
                break;
            }
            case "IBM-1370": {
                this.initCodepage(1370);
                break;
            }
            case "IBM-1371": {
                this.initCodepage(1371);
                break;
            }
            case "MacCentralEurope": {
                this.initCodepage(1282);
                break;
            }
            case "MacCroatian": {
                this.initCodepage(1284);
                break;
            }
            case "MacRomania": {
                this.initCodepage(1285);
                break;
            }
            case "MacCyrillic": {
                this.initCodepage(1283);
                break;
            }
            case "MacGreek": {
                this.initCodepage(1280);
                break;
            }
            case "IBM-737": {
                this.initCodepage(737);
                break;
            }
            case "IBM-1046": {
                this.initCodepage(1046);
                break;
            }
            case "MacTurkish": {
                this.initCodepage(1281);
                break;
            }
            case "IBM-856": {
                this.initCodepage(856);
                break;
            }
            default: {
                this.initCodePageAlias(string);
            }
        }
    }

    private void initCodePageAlias(String string) {
        switch (string) {
            case "csisolatin1": {
                this.initCodepage(819);
                break;
            }
            case "iso-ir-100": {
                this.initCodepage(819);
                break;
            }
            case "iso8859-1": {
                this.initCodepage(819);
                break;
            }
            case "ibm-819": {
                this.initCodepage(819);
                break;
            }
            case "iso8859_1": {
                this.initCodepage(819);
                break;
            }
            case "latin1": {
                this.initCodepage(819);
                break;
            }
            case "8859-1": {
                this.initCodepage(819);
                break;
            }
            case "ibm819": {
                this.initCodepage(819);
                break;
            }
            case "iso-8859-1:1987": {
                this.initCodepage(819);
                break;
            }
            case "Cp819": {
                this.initCodepage(819);
                break;
            }
            case "l1": {
                this.initCodepage(819);
                break;
            }
            case "l9": {
                this.initCodepage(923);
                break;
            }
            case "ibm923": {
                this.initCodepage(923);
                break;
            }
            case "csisolatin9": {
                this.initCodepage(923);
                break;
            }
            case "iso8859-15": {
                this.initCodepage(923);
                break;
            }
            case "ibm-923": {
                this.initCodepage(923);
                break;
            }
            case "latin9": {
                this.initCodepage(923);
                break;
            }
            case "iso8859_15": {
                this.initCodepage(923);
                break;
            }
            case "Cp923": {
                this.initCodepage(923);
                break;
            }
            case "iso8859_15_fdis": {
                this.initCodepage(923);
                break;
            }
            case "latin0": {
                this.initCodepage(923);
                break;
            }
            case "Cp1051": {
                this.initCodepage(1051);
                break;
            }
            case "ibm-1051": {
                this.initCodepage(1051);
                break;
            }
            case "roman8": {
                this.initCodepage(1051);
                break;
            }
            case "r8": {
                this.initCodepage(1051);
                break;
            }
            case "Cp1252": {
                this.initCodepage(1252);
                break;
            }
            case "ibm-1252": {
                this.initCodepage(1252);
                break;
            }
            case "Cp437": {
                this.initCodepage(437);
                break;
            }
            case "cspc8codepage437": {
                this.initCodepage(437);
                break;
            }
            case "ibm437": {
                this.initCodepage(437);
                break;
            }
            case "cspc850multilingual": {
                this.initCodepage(850);
                break;
            }
            case "Cp850": {
                this.initCodepage(850);
                break;
            }
            case "ibm850": {
                this.initCodepage(850);
                break;
            }
            case "Cp858": {
                this.initCodepage(858);
                break;
            }
            case "ibm858": {
                this.initCodepage(858);
                break;
            }
            case "ibm-37": {
                this.initCodepage(37);
                break;
            }
            case "Cp1140": {
                this.initCodepage(1140);
                break;
            }
            case "ibm1140": {
                this.initCodepage(1140);
                break;
            }
            case "Cp285": {
                this.initCodepage(285);
                break;
            }
            case "ibm285": {
                this.initCodepage(285);
                break;
            }
            case "Cp1146": {
                this.initCodepage(1146);
                break;
            }
            case "ibm1146": {
                this.initCodepage(1146);
                break;
            }
            case "ibm500": {
                this.initCodepage(500);
                break;
            }
            case "Cp500": {
                this.initCodepage(500);
                break;
            }
            case "ibm924": {
                this.initCodepage(924);
                break;
            }
            case "Cp924": {
                this.initCodepage(924);
                break;
            }
            case "Cp1148": {
                this.initCodepage(1148);
                break;
            }
            case "ibm1148": {
                this.initCodepage(1148);
                break;
            }
            case "Cp297": {
                this.initCodepage(297);
                break;
            }
            case "ibm297": {
                this.initCodepage(297);
                break;
            }
            case "Cp1147": {
                this.initCodepage(1147);
                break;
            }
            case "ibm1147": {
                this.initCodepage(1147);
                break;
            }
            case "ibm273": {
                this.initCodepage(273);
                break;
            }
            case "Cp273": {
                this.initCodepage(273);
                break;
            }
            case "Cp1141": {
                this.initCodepage(1141);
                break;
            }
            case "ibm1141": {
                this.initCodepage(1141);
                break;
            }
            case "Cp284": {
                this.initCodepage(284);
                break;
            }
            case "ibm284": {
                this.initCodepage(284);
                break;
            }
            case "ibm1145": {
                this.initCodepage(1145);
                break;
            }
            case "Cp1145": {
                this.initCodepage(1145);
                break;
            }
            case "ibm280": {
                this.initCodepage(280);
                break;
            }
            case "Cp280": {
                this.initCodepage(280);
                break;
            }
            case "Cp1144": {
                this.initCodepage(1144);
                break;
            }
            case "ibm1144": {
                this.initCodepage(1144);
                break;
            }
            case "Cp277": {
                this.initCodepage(277);
                break;
            }
            case "ibm277": {
                this.initCodepage(277);
                break;
            }
            case "Cp1142": {
                this.initCodepage(1142);
                break;
            }
            case "ibm1142": {
                this.initCodepage(1142);
                break;
            }
            case "ibm278": {
                this.initCodepage(278);
                break;
            }
            case "Cp278": {
                this.initCodepage(278);
                break;
            }
            case "ibm1143": {
                this.initCodepage(1143);
                break;
            }
            case "Cp1143": {
                this.initCodepage(1143);
                break;
            }
            case "Cp871": {
                this.initCodepage(871);
                break;
            }
            case "ibm871": {
                this.initCodepage(871);
                break;
            }
            case "Cp1149": {
                this.initCodepage(1149);
                break;
            }
            case "ibm1149": {
                this.initCodepage(1149);
                break;
            }
            case "Cp5050": {
                this.initCodepage(5050);
                break;
            }
            case "5050": {
                this.initCodepage(5050);
                break;
            }
            case "Cp932": {
                this.initCodepage(932);
                break;
            }
            case "ibm932": {
                this.initCodepage(932);
                break;
            }
            case "windows-31j": {
                this.initCodepage(932);
                break;
            }
            case "MS932": {
                this.initCodepage(932);
                break;
            }
            case "windows-932": {
                this.initCodepage(932);
                break;
            }
            case "csWindows31J": {
                this.initCodepage(932);
                break;
            }
            case "ibm942": {
                this.initCodepage(942);
                break;
            }
            case "Cp942": {
                this.initCodepage(942);
                break;
            }
            case "ibm943": {
                this.initCodepage(943);
                break;
            }
            case "Cp943": {
                this.initCodepage(943);
                break;
            }
            case "IBM-943C": {
                this.initCodepage(943);
                break;
            }
            case "Cp943C": {
                this.initCodepage(943);
                break;
            }
            case "Cp1041": {
                this.initCodepage(1041);
                break;
            }
            case "ibm1041": {
                this.initCodepage(1041);
                break;
            }
            case "Cp5026": {
                this.initCodepage(930);
                break;
            }
            case "5026": {
                this.initCodepage(930);
                break;
            }
            case "5035": {
                this.initCodepage(939);
                break;
            }
            case "Cp5035": {
                this.initCodepage(939);
                break;
            }
            case "Cp1390": {
                this.initCodepage(1390);
                break;
            }
            case "ibm1390": {
                this.initCodepage(1390);
                break;
            }
            case "Cp1399": {
                this.initCodepage(1399);
                break;
            }
            case "ibm1399": {
                this.initCodepage(1399);
                break;
            }
            case "5601": {
                this.initCodepage(970);
                break;
            }
            case "ksc5601_1987": {
                this.initCodepage(970);
                break;
            }
            case "ksc_5601": {
                this.initCodepage(970);
                break;
            }
            case "ibm-euckr": {
                this.initCodepage(970);
                break;
            }
            case "ksc5601-1987": {
                this.initCodepage(970);
                break;
            }
            case "ibm-970": {
                this.initCodepage(970);
                break;
            }
            case "euc_kr": {
                this.initCodepage(970);
                break;
            }
            case "Cp970": {
                this.initCodepage(970);
                break;
            }
            case "ks_c_5601-1987": {
                this.initCodepage(970);
                break;
            }
            case "euckr": {
                this.initCodepage(970);
                break;
            }
            case "Cp949": {
                this.initCodepage(949);
                break;
            }
            case "ibm949": {
                this.initCodepage(949);
                break;
            }
            case "Cp951": {
                this.initCodepage(951);
                break;
            }
            case "ibm951": {
                this.initCodepage(951);
                break;
            }
            case "Cp1088": {
                this.initCodepage(1088);
                break;
            }
            case "ibm1088": {
                this.initCodepage(1088);
                break;
            }
            case "Cp933": {
                this.initCodepage(933);
                break;
            }
            case "ibm933": {
                this.initCodepage(933);
                break;
            }
            case "Cp1363": {
                this.initCodepage(1363);
                break;
            }
            case "ibm1363": {
                this.initCodepage(1363);
                break;
            }
            case "5458": {
                this.initCodepage(1362);
                break;
            }
            case "ibm1364": {
                this.initCodepage(1364);
                break;
            }
            case "Cp1364": {
                this.initCodepage(1364);
                break;
            }
            case "Cp1383": {
                this.initCodepage(1383);
                break;
            }
            case "ibm1383": {
                this.initCodepage(1383);
                break;
            }
            case "Cp1114": {
                this.initCodepage(1114);
                break;
            }
            case "ibm1114": {
                this.initCodepage(1114);
                break;
            }
            case "Cp1115": {
                this.initCodepage(1115);
                break;
            }
            case "ibm1115": {
                this.initCodepage(1115);
                break;
            }
            case "Cp1381": {
                this.initCodepage(1381);
                break;
            }
            case "ibm1381": {
                this.initCodepage(1381);
                break;
            }
            case "GBK": {
                this.initCodepage(1386);
                break;
            }
            case "Cp1386": {
                this.initCodepage(1386);
                break;
            }
            case "ibm1386": {
                this.initCodepage(1386);
                break;
            }
            case "ibm1380": {
                this.initCodepage(1380);
                break;
            }
            case "Cp1380": {
                this.initCodepage(1380);
                break;
            }
            case "Cp1385": {
                this.initCodepage(1385);
                break;
            }
            case "ibm1385": {
                this.initCodepage(1385);
                break;
            }
            case "Cp935": {
                this.initCodepage(935);
                break;
            }
            case "ibm935": {
                this.initCodepage(935);
                break;
            }
            case "ibm1388": {
                this.initCodepage(1388);
                break;
            }
            case "Cp1388": {
                this.initCodepage(1388);
                break;
            }
            case "9029": {
                this.initCodepage(4933);
                break;
            }
            case "4933": {
                this.initCodepage(4933);
                break;
            }
            case "windows-54936": {
                this.initCodepage(5488);
                break;
            }
            case "ibm-1392": {
                this.initCodepage(5488);
                break;
            }
            case "gb18030-2000": {
                this.initCodepage(5488);
                break;
            }
            case "Cp964": {
                this.initCodepage(964);
                break;
            }
            case "ibm-euctw": {
                this.initCodepage(964);
                break;
            }
            case "ibm947": {
                this.initCodepage(947);
                break;
            }
            case "Cp947": {
                this.initCodepage(947);
                break;
            }
            case "MS950": {
                this.initCodepage(950);
                break;
            }
            case "x-windows-950": {
                this.initCodepage(950);
                break;
            }
            case "Cp937": {
                this.initCodepage(937);
                break;
            }
            case "ibm937": {
                this.initCodepage(937);
                break;
            }
            case "ibm912": {
                this.initCodepage(912);
                break;
            }
            case "l2": {
                this.initCodepage(912);
                break;
            }
            case "ibm-912": {
                this.initCodepage(912);
                break;
            }
            case "iso-ir-101": {
                this.initCodepage(912);
                break;
            }
            case "csisolatin2": {
                this.initCodepage(912);
                break;
            }
            case "iso-8859-2:1987": {
                this.initCodepage(912);
                break;
            }
            case "latin2": {
                this.initCodepage(912);
                break;
            }
            case "iso8859_2": {
                this.initCodepage(912);
                break;
            }
            case "Cp912": {
                this.initCodepage(912);
                break;
            }
            case "iso8859-2": {
                this.initCodepage(912);
                break;
            }
            case "8859-2": {
                this.initCodepage(912);
                break;
            }
            case "ibm-1250": {
                this.initCodepage(1250);
                break;
            }
            case "Cp1250": {
                this.initCodepage(1250);
                break;
            }
            case "Cp852": {
                this.initCodepage(852);
                break;
            }
            case "cspcp852": {
                this.initCodepage(852);
                break;
            }
            case "ibm852": {
                this.initCodepage(852);
                break;
            }
            case "Cp870": {
                this.initCodepage(870);
                break;
            }
            case "ibm870": {
                this.initCodepage(870);
                break;
            }
            case "iso8859_5": {
                this.initCodepage(915);
                break;
            }
            case "8859-5": {
                this.initCodepage(915);
                break;
            }
            case "ibm915": {
                this.initCodepage(915);
                break;
            }
            case "iso-8859-5:1988": {
                this.initCodepage(915);
                break;
            }
            case "csisolatincyrillic": {
                this.initCodepage(915);
                break;
            }
            case "cyrillic": {
                this.initCodepage(915);
                break;
            }
            case "Cp915": {
                this.initCodepage(915);
                break;
            }
            case "iso-ir-144": {
                this.initCodepage(915);
                break;
            }
            case "iso8859-5": {
                this.initCodepage(915);
                break;
            }
            case "ibm-915": {
                this.initCodepage(915);
                break;
            }
            case "ibm-1251": {
                this.initCodepage(1251);
                break;
            }
            case "Cp1251": {
                this.initCodepage(1251);
                break;
            }
            case "Cp855": {
                this.initCodepage(855);
                break;
            }
            case "ibm855": {
                this.initCodepage(855);
                break;
            }
            case "Cp866": {
                this.initCodepage(866);
                break;
            }
            case "ibm866": {
                this.initCodepage(866);
                break;
            }
            case "ibm1025": {
                this.initCodepage(1025);
                break;
            }
            case "Cp1025": {
                this.initCodepage(1025);
                break;
            }
            case "ibm-878": {
                this.initCodepage(878);
                break;
            }
            case "cskoi8r": {
                this.initCodepage(878);
                break;
            }
            case "koi8": {
                this.initCodepage(878);
                break;
            }
            case "koi8_r": {
                this.initCodepage(878);
                break;
            }
            case "iso-8859-7:1987": {
                this.initCodepage(813);
                break;
            }
            case "Cp813": {
                this.initCodepage(813);
                break;
            }
            case "8859-7": {
                this.initCodepage(813);
                break;
            }
            case "iso-ir-126": {
                this.initCodepage(813);
                break;
            }
            case "ibm-813": {
                this.initCodepage(813);
                break;
            }
            case "iso8859_7": {
                this.initCodepage(813);
                break;
            }
            case "ecma-118": {
                this.initCodepage(813);
                break;
            }
            case "greek8": {
                this.initCodepage(813);
                break;
            }
            case "ibm813": {
                this.initCodepage(813);
                break;
            }
            case "elot-928": {
                this.initCodepage(813);
                break;
            }
            case "csisolatingreek": {
                this.initCodepage(813);
                break;
            }
            case "iso8859-7": {
                this.initCodepage(813);
                break;
            }
            case "greek": {
                this.initCodepage(813);
                break;
            }
            case "Cp1253": {
                this.initCodepage(1253);
                break;
            }
            case "ibm-1253": {
                this.initCodepage(1253);
                break;
            }
            case "Cp869": {
                this.initCodepage(869);
                break;
            }
            case "ibm869": {
                this.initCodepage(869);
                break;
            }
            case "Cp875": {
                this.initCodepage(875);
                break;
            }
            case "ibm875": {
                this.initCodepage(875);
                break;
            }
            case "iso-ir-127": {
                this.initCodepage(1089);
                break;
            }
            case "csisolatinarabic": {
                this.initCodepage(1089);
                break;
            }
            case "iso8859-6": {
                this.initCodepage(1089);
                break;
            }
            case "ibm1089": {
                this.initCodepage(1089);
                break;
            }
            case "ecma-114": {
                this.initCodepage(1089);
                break;
            }
            case "asmo-708": {
                this.initCodepage(1089);
                break;
            }
            case "arabic": {
                this.initCodepage(1089);
                break;
            }
            case "ibm-1089": {
                this.initCodepage(1089);
                break;
            }
            case "iso8859_6": {
                this.initCodepage(1089);
                break;
            }
            case "8859-6": {
                this.initCodepage(1089);
                break;
            }
            case "Cp1089": {
                this.initCodepage(1089);
                break;
            }
            case "iso-8859-6:1987": {
                this.initCodepage(1089);
                break;
            }
            case "Cp1256": {
                this.initCodepage(1256);
                break;
            }
            case "ibm-1256": {
                this.initCodepage(1256);
                break;
            }
            case "ibm864": {
                this.initCodepage(864);
                break;
            }
            case "Cp864": {
                this.initCodepage(864);
                break;
            }
            case "Cp420": {
                this.initCodepage(420);
                break;
            }
            case "ibm420": {
                this.initCodepage(420);
                break;
            }
            case "Cp720": {
                this.initCodepage(720);
                break;
            }
            case "ibm720": {
                this.initCodepage(720);
                break;
            }
            case "Cp920": {
                this.initCodepage(920);
                break;
            }
            case "latin5": {
                this.initCodepage(920);
                break;
            }
            case "iso-ir-148": {
                this.initCodepage(920);
                break;
            }
            case "8859-9": {
                this.initCodepage(920);
                break;
            }
            case "l5": {
                this.initCodepage(920);
                break;
            }
            case "csisolatin5": {
                this.initCodepage(920);
                break;
            }
            case "ibm-920": {
                this.initCodepage(920);
                break;
            }
            case "ibm920": {
                this.initCodepage(920);
                break;
            }
            case "iso8859_9": {
                this.initCodepage(920);
                break;
            }
            case "iso8859-9": {
                this.initCodepage(920);
                break;
            }
            case "Cp1254": {
                this.initCodepage(1254);
                break;
            }
            case "ibm-1254": {
                this.initCodepage(1254);
                break;
            }
            case "csibm857": {
                this.initCodepage(857);
                break;
            }
            case "ibm857": {
                this.initCodepage(857);
                break;
            }
            case "Cp857": {
                this.initCodepage(857);
                break;
            }
            case "Cp1026": {
                this.initCodepage(1026);
                break;
            }
            case "ibm1026": {
                this.initCodepage(1026);
                break;
            }
            case "Cp1098": {
                this.initCodepage(1098);
                break;
            }
            case "ibm1098": {
                this.initCodepage(1098);
                break;
            }
            case "Cp1097": {
                this.initCodepage(1097);
                break;
            }
            case "ibm1097": {
                this.initCodepage(1097);
                break;
            }
            case "iso-ir-138": {
                this.initCodepage(916);
                break;
            }
            case "iso8859-8": {
                this.initCodepage(916);
                break;
            }
            case "ibm-916": {
                this.initCodepage(916);
                break;
            }
            case "iso8859_8": {
                this.initCodepage(916);
                break;
            }
            case "csisolatinhebrew": {
                this.initCodepage(916);
                break;
            }
            case "hebrew": {
                this.initCodepage(916);
                break;
            }
            case "iso-8859-8:1988": {
                this.initCodepage(916);
                break;
            }
            case "ibm916": {
                this.initCodepage(916);
                break;
            }
            case "Cp916": {
                this.initCodepage(916);
                break;
            }
            case "8859-8": {
                this.initCodepage(916);
                break;
            }
            case "Cp1255": {
                this.initCodepage(1255);
                break;
            }
            case "ibm-1255": {
                this.initCodepage(1255);
                break;
            }
            case "Cp862": {
                this.initCodepage(862);
                break;
            }
            case "ibm862": {
                this.initCodepage(862);
                break;
            }
            case "Cp867": {
                this.initCodepage(867);
                break;
            }
            case "ibm867": {
                this.initCodepage(867);
                break;
            }
            case "ibm424": {
                this.initCodepage(424);
                break;
            }
            case "Cp424": {
                this.initCodepage(424);
                break;
            }
            case "ibm921": {
                this.initCodepage(921);
                break;
            }
            case "Cp921": {
                this.initCodepage(921);
                break;
            }
            case "Cp922": {
                this.initCodepage(922);
                break;
            }
            case "ibm922": {
                this.initCodepage(922);
                break;
            }
            case "Cp1124": {
                this.initCodepage(1124);
                break;
            }
            case "ibm1124": {
                this.initCodepage(1124);
                break;
            }
            case "Cp1257": {
                this.initCodepage(1257);
                break;
            }
            case "ibm-1257": {
                this.initCodepage(1257);
                break;
            }
            case "Cp1112": {
                this.initCodepage(1112);
                break;
            }
            case "ibm1112": {
                this.initCodepage(1112);
                break;
            }
            case "Cp1122": {
                this.initCodepage(1122);
                break;
            }
            case "ibm1122": {
                this.initCodepage(1122);
                break;
            }
            case "Cp1123": {
                this.initCodepage(1123);
                break;
            }
            case "ibm1123": {
                this.initCodepage(1123);
                break;
            }
            case "ibm775": {
                this.initCodepage(775);
                break;
            }
            case "Cp775": {
                this.initCodepage(775);
                break;
            }
            case "ibm1006": {
                this.initCodepage(1006);
                break;
            }
            case "Cp1006": {
                this.initCodepage(1006);
                break;
            }
            case "Cp868": {
                this.initCodepage(868);
                break;
            }
            case "ibm868": {
                this.initCodepage(868);
                break;
            }
            case "ibm918": {
                this.initCodepage(918);
                break;
            }
            case "Cp918": {
                this.initCodepage(918);
                break;
            }
            case "ibm874": {
                this.initCodepage(874);
                break;
            }
            case "Cp874": {
                this.initCodepage(874);
                break;
            }
            case "Cp838": {
                this.initCodepage(838);
                break;
            }
            case "ibm838": {
                this.initCodepage(838);
                break;
            }
            case "Cp1258": {
                this.initCodepage(1129);
                break;
            }
            case "ibm-1258": {
                this.initCodepage(1129);
                break;
            }
            case "ibm-1129": {
                this.initCodepage(1129);
                break;
            }
            case "ibm-1163": {
                this.initCodepage(1129);
                break;
            }
            case "iscii": {
                this.initCodepage(806);
                break;
            }
            case "Unicode": {
                this.initCodepage(1200);
                break;
            }
            case "UTF16": {
                this.initCodepage(1200);
                break;
            }
            case "UTF_16": {
                this.initCodepage(1200);
                break;
            }
            case "UCS-2": {
                this.initCodepage(1200);
                break;
            }
            case "UTF_8": {
                this.initCodepage(1208);
                break;
            }
            case "UTF8": {
                this.initCodepage(1208);
                break;
            }
            case "iso-646.irv:1983": {
                this.initCodepage(367);
                break;
            }
            case "ISO646-US": {
                this.initCodepage(367);
                break;
            }
            case "ASCII": {
                this.initCodepage(367);
                break;
            }
            case "default": {
                this.initCodepage(367);
                break;
            }
            case "ISO-646.irv:1991": {
                this.initCodepage(367);
                break;
            }
            case "direct": {
                this.initCodepage(367);
                break;
            }
            case "ascii7": {
                this.initCodepage(367);
                break;
            }
            case "ANSI_X3.4-1986": {
                this.initCodepage(367);
                break;
            }
            case "iso-ir-6": {
                this.initCodepage(367);
                break;
            }
            case "us": {
                this.initCodepage(367);
                break;
            }
            case "ibm-367": {
                this.initCodepage(367);
                break;
            }
            case "646": {
                this.initCodepage(367);
                break;
            }
            case "csASCII": {
                this.initCodepage(367);
                break;
            }
            case "ANSI_X3.4-1968": {
                this.initCodepage(367);
                break;
            }
            case "Cp367": {
                this.initCodepage(367);
                break;
            }
            case "ibm-1275": {
                this.initCodepage(1275);
                break;
            }
            case "Cp1047": {
                this.initCodepage(1047);
                break;
            }
            case "ibm1047": {
                this.initCodepage(1047);
                break;
            }
            case "iso-8859-3:1988": {
                this.initCodepage(913);
                break;
            }
            case "csisolatin3": {
                this.initCodepage(913);
                break;
            }
            case "iso8859_3": {
                this.initCodepage(913);
                break;
            }
            case "8859-3": {
                this.initCodepage(913);
                break;
            }
            case "iso8859-3": {
                this.initCodepage(913);
                break;
            }
            case "Cp913": {
                this.initCodepage(913);
                break;
            }
            case "iso-ir-109": {
                this.initCodepage(913);
                break;
            }
            case "ibm-913": {
                this.initCodepage(913);
                break;
            }
            case "l3": {
                this.initCodepage(913);
                break;
            }
            case "latin3": {
                this.initCodepage(913);
                break;
            }
            case "ibm863": {
                this.initCodepage(863);
                break;
            }
            case "Cp863": {
                this.initCodepage(863);
                break;
            }
            case "Cp861": {
                this.initCodepage(861);
                break;
            }
            case "ibm861": {
                this.initCodepage(861);
                break;
            }
            case "Cp865": {
                this.initCodepage(865);
                break;
            }
            case "ibm865": {
                this.initCodepage(865);
                break;
            }
            case "ibm860": {
                this.initCodepage(860);
                break;
            }
            case "Cp860": {
                this.initCodepage(860);
                break;
            }
            case "8493": {
                this.initCodepage(301);
                break;
            }
            case "4397": {
                this.initCodepage(301);
                break;
            }
            case "24877": {
                this.initCodepage(301);
                break;
            }
            case "Cp897": {
                this.initCodepage(897);
                break;
            }
            case "ibm897": {
                this.initCodepage(897);
                break;
            }
            case "Cp1351": {
                this.initCodepage(1351);
                break;
            }
            case "ibm1351": {
                this.initCodepage(1351);
                break;
            }
            case "12578": {
                this.initCodepage(290);
                break;
            }
            case "8482": {
                this.initCodepage(290);
                break;
            }
            case "4386": {
                this.initCodepage(290);
                break;
            }
            case "4396": {
                this.initCodepage(300);
                break;
            }
            case "12588": {
                this.initCodepage(300);
                break;
            }
            case "8492": {
                this.initCodepage(300);
                break;
            }
            case "16684": {
                this.initCodepage(300);
                break;
            }
            case "5123": {
                this.initCodepage(1027);
                break;
            }
            case "13121": {
                this.initCodepage(833);
                break;
            }
            case "9025": {
                this.initCodepage(833);
                break;
            }
            case "4929": {
                this.initCodepage(833);
                break;
            }
            case "13122": {
                this.initCodepage(834);
                break;
            }
            case "9026": {
                this.initCodepage(834);
                break;
            }
            case "4930": {
                this.initCodepage(834);
                break;
            }
            case "MS936": {
                this.initCodepage(936);
                break;
            }
            case "936": {
                this.initCodepage(936);
                break;
            }
            case "x-mswin-936": {
                this.initCodepage(936);
                break;
            }
            case "9028": {
                this.initCodepage(836);
                break;
            }
            case "4932": {
                this.initCodepage(836);
                break;
            }
            case "13124": {
                this.initCodepage(836);
                break;
            }
            case "ibm927": {
                this.initCodepage(5023);
                break;
            }
            case "Cp927": {
                this.initCodepage(5023);
                break;
            }
            case "ibm948": {
                this.initCodepage(948);
                break;
            }
            case "Cp948": {
                this.initCodepage(948);
                break;
            }
            case "Cp1043": {
                this.initCodepage(1043);
                break;
            }
            case "ibm1043": {
                this.initCodepage(1043);
                break;
            }
            case "4931": {
                this.initCodepage(835);
                break;
            }
            case "9027": {
                this.initCodepage(835);
                break;
            }
            case "Cp1370": {
                this.initCodepage(1370);
                break;
            }
            case "ibm1370": {
                this.initCodepage(1370);
                break;
            }
            case "Cp1371": {
                this.initCodepage(1371);
                break;
            }
            case "ibm1371": {
                this.initCodepage(1371);
                break;
            }
            case "ibm-1282": {
                this.initCodepage(1282);
                break;
            }
            case "ibm-1284": {
                this.initCodepage(1284);
                break;
            }
            case "ibm-1285": {
                this.initCodepage(1285);
                break;
            }
            case "ibm-1283": {
                this.initCodepage(1283);
                break;
            }
            case "ibm-1280": {
                this.initCodepage(1280);
                break;
            }
            case "ibm737": {
                this.initCodepage(737);
                break;
            }
            case "Cp737": {
                this.initCodepage(737);
                break;
            }
            case "ibm1046": {
                this.initCodepage(1046);
                break;
            }
            case "Cp1046": {
                this.initCodepage(1046);
                break;
            }
            case "ibm-1281": {
                this.initCodepage(1281);
                break;
            }
            case "Cp856": {
                this.initCodepage(856);
                break;
            }
            case "ibm856": {
                this.initCodepage(856);
                break;
            }
            default: {
                throw new UnsupportedCharsetException(string);
            }
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("[ DETECTED DEFAULT ]");
        Codepage codepage = new Codepage();
        System.out.println("> " + codepage.getCcsid() + " - " + codepage.getCharset().displayName() + " - " + codepage.isAscii());
        System.out.println("[ LOAD 1252 ]");
        codepage = new Codepage(1252);
        System.out.println("> " + codepage.getCcsid() + " - " + codepage.getCharset().displayName() + " - " + codepage.isAscii());
        System.out.println("[ LOAD 280 ]");
        codepage = new Codepage(280);
        System.out.println("> " + codepage.getCcsid() + " - " + codepage.getCharset().displayName() + " - " + codepage.isAscii());
    }
}

