/*
 * Decompiled with CFR 0.152.
 */
package com.veryant.cobol.compiler;

import com.veryant.cobol.compiler.BuiltIn;
import com.veryant.cobol.compiler.ClassFieldSet;
import com.veryant.cobol.compiler.Code;
import com.veryant.cobol.compiler.Context;
import com.veryant.cobol.compiler.EntryPointArguments;
import com.veryant.cobol.compiler.ISourceReference;
import com.veryant.cobol.compiler.LinkageParam;
import com.veryant.cobol.compiler.Magnitude;
import com.veryant.cobol.compiler.NameGenerator;
import com.veryant.cobol.compiler.memory.CobolData;
import com.veryant.cobol.compiler.memory.DynamicChunk;
import com.veryant.cobol.compiler.memory.Region;
import com.veryant.cobol.compiler.scope.DataItemDeclaration;
import com.veryant.cobol.compiler.scope.FileDeclaration;
import com.veryant.cobol.compiler.scope.RegisterDeclaration;
import com.veryant.cobol.compiler.scope.Scope;
import com.veryant.cobol.rununit.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Collector {
    private String packageName;
    private String moduleName;
    private String formalName;
    private final Context context;
    private final CobolData workingStorage;
    private final CobolData localStorage;
    private ArrayList<LinkageParam> linkage = new ArrayList();
    private EntryPointArguments defaultArguments;
    private final ClassFieldSet fields = new ClassFieldSet();
    private final NameGenerator nameGenerator = new NameGenerator();
    private final Scope scope = new Scope();
    private final Code code = new Code();
    private final List<DataItemDeclaration> initializationList = new ArrayList<DataItemDeclaration>();
    private final List<DataItemDeclaration> localInitializationList = new ArrayList<DataItemDeclaration>();

    public void setModuleName(String string) {
        this.moduleName = Environment.translateToValidJavaIdentifier(string);
    }

    public DataItemDeclaration[] getInitializationList() {
        int n2 = 0;
        DataItemDeclaration[] dataItemDeclarationArray = new DataItemDeclaration[this.initializationList.size()];
        for (DataItemDeclaration dataItemDeclaration : this.initializationList) {
            if (!dataItemDeclaration.isUsed() && !dataItemDeclaration.getDataItem().isChunkReferenced()) continue;
            dataItemDeclarationArray[n2++] = dataItemDeclaration;
        }
        return Arrays.copyOfRange(dataItemDeclarationArray, 0, n2);
    }

    public DataItemDeclaration[] getLocalInitializationList() {
        int n2 = 0;
        DataItemDeclaration[] dataItemDeclarationArray = new DataItemDeclaration[this.localInitializationList.size()];
        for (DataItemDeclaration dataItemDeclaration : this.localInitializationList) {
            if (!dataItemDeclaration.isUsed()) continue;
            dataItemDeclarationArray[n2++] = dataItemDeclaration;
        }
        return Arrays.copyOfRange(dataItemDeclarationArray, 0, n2);
    }

    public void addInitialization(DataItemDeclaration dataItemDeclaration) {
        if (((DynamicChunk)dataItemDeclaration.getDataItem().getChunk()).getRegion() == Region.LOCAL_STORAGE) {
            this.localInitializationList.add(dataItemDeclaration);
        } else {
            this.initializationList.add(dataItemDeclaration);
        }
    }

    public void relocateMemory() {
        this.workingStorage.relocate(this.context.getALIGN().getValue());
        this.localStorage.relocate(this.context.getALIGN().getValue());
        for (LinkageParam linkageParam : this.linkage) {
            linkageParam.getCobolData().relocate(1);
        }
    }

    private void addRegister(DataItemDeclaration dataItemDeclaration) {
        this.workingStorage.add(dataItemDeclaration.getDataItem());
        this.scope.add(dataItemDeclaration);
    }

    public Collector(String string, Context context) {
        int n2;
        this.setModuleName(string);
        this.context = context;
        if (context.isILOPTIMIZEDATASet()) {
            this.workingStorage = new CobolData(Region.WORKING_STORAGE, this.fields, this.nameGenerator);
            this.localStorage = new CobolData(Region.LOCAL_STORAGE, this.fields, this.nameGenerator);
        } else {
            this.workingStorage = new CobolData(Region.WORKING_STORAGE);
            this.localStorage = new CobolData(Region.LOCAL_STORAGE);
        }
        switch (context.getRTNCODESIZE().getValue()) {
            case 8: {
                n2 = 18;
                break;
            }
            case 4: {
                n2 = 9;
                break;
            }
            default: {
                n2 = 4;
            }
        }
        this.addRegister(new RegisterDeclaration("RETURN-CODE", BuiltIn.COMP_4_SIGNED, new Magnitude(true, n2, 0), BuiltIn.getSizeByDigits(n2, context.getIBMCOMP().isSet())));
        this.addRegister(new RegisterDeclaration("TALLY", BuiltIn.COMP_4_UNSIGNED_SIGN_DROP, new Magnitude(false, 5, 0), BuiltIn.getSizeByDigits(5, context.getIBMCOMP().isSet())));
    }

    public FileDeclaration declareFileSelect(ISourceReference iSourceReference, String string) {
        return this.scope.declareFileSelect(this.context, iSourceReference, string);
    }

    public FileDeclaration declareFileDescription(ISourceReference iSourceReference, String string) {
        return this.scope.declareFileDescription(this.context, iSourceReference, string);
    }

    public FileDeclaration getExistingFile(ISourceReference iSourceReference, String string) {
        return this.scope.getExistingFile(this.context, iSourceReference, string);
    }

    public FileDeclaration getExistingFileForStatement(ISourceReference iSourceReference, String string) {
        FileDeclaration fileDeclaration = this.scope.getExistingFile(this.context, iSourceReference, string);
        if (fileDeclaration.hasSelectAndFD() && fileDeclaration.isDeclaredOnly()) {
            fileDeclaration.setDeclaredOnly(false);
        }
        return fileDeclaration;
    }

    public FileDeclaration[] getFiles(boolean bl) {
        return this.scope.getFiles(bl);
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public String getFormalName() {
        return this.formalName;
    }

    public void setFormalName(String string) {
        this.formalName = string;
    }

    public Context getContext() {
        return this.context;
    }

    public CobolData getWorkingStorage() {
        return this.workingStorage;
    }

    public CobolData getLocalStorage() {
        return this.localStorage;
    }

    public ArrayList<LinkageParam> getLinkage() {
        return this.linkage;
    }

    public EntryPointArguments getDefaultArguments() {
        return this.defaultArguments;
    }

    public void setDefaultArguments(EntryPointArguments entryPointArguments) {
        this.defaultArguments = entryPointArguments;
    }

    public ClassFieldSet getFields() {
        return this.fields;
    }

    public NameGenerator getNameGenerator() {
        return this.nameGenerator;
    }

    public Scope getScope() {
        return this.scope;
    }

    public Code getCode() {
        return this.code;
    }
}

